<?php
namespace App\Test\Fixture;

use Cake\TestSuite\Fixture\TestFixture;

/**
 * MedicalOpinionRequestsFixture
 *
 */
class MedicalOpinionRequestsFixture extends TestFixture
{

    /**
     * Fields
     *
     * @var array
     */
    // @codingStandardsIgnoreStart
    public $fields = [
        'id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'autoIncrement' => true, 'precision' => null],
        'requested_specialty_id' => ['type' => 'string', 'length' => 45, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'motive' => ['type' => 'string', 'length' => 2156, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'fixed' => null],
        'created' => ['type' => 'datetime', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'modified' => ['type' => 'datetime', 'length' => null, 'null' => true, 'default' => null, 'comment' => '', 'precision' => null],
        'professional_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => 'é o cara que criou a soliticação
', 'precision' => null, 'autoIncrement' => null],
        'hospitalization_id' => ['type' => 'integer', 'length' => 11, 'unsigned' => false, 'null' => false, 'default' => null, 'comment' => '', 'precision' => null, 'autoIncrement' => null],
        '_indexes' => [
            'fk_medical_opinion_requests_hospitalizations1_idx' => ['type' => 'index', 'columns' => ['hospitalization_id'], 'length' => []],
        ],
        '_constraints' => [
            'primary' => ['type' => 'primary', 'columns' => ['id'], 'length' => []],
            'fk_medical_opinion_requests_hospitalizations1' => ['type' => 'foreign', 'columns' => ['hospitalization_id'], 'references' => ['hospitalizations', 'id'], 'update' => 'noAction', 'delete' => 'noAction', 'length' => []],
        ],
        '_options' => [
            'engine' => 'InnoDB',
            'collation' => 'utf8_general_ci'
        ],
    ];
    // @codingStandardsIgnoreEnd

    /**
     * Records
     *
     * @var array
     */
    public $records = [
        [
            'id' => 1,
            'requested_specialty_id' => 'Lorem ipsum dolor sit amet',
            'motive' => 'Lorem ipsum dolor sit amet',
            'created' => '2016-04-15 19:25:52',
            'modified' => '2016-04-15 19:25:52',
            'professional_id' => 1,
            'hospitalization_id' => 1
        ],
    ];
}
