<style type="text/css">
table {
	border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
	text-align: center;
}

tbody tr td:first-child {
	text-align: left;
}

/*table tr:last-child td {
    border-right: 0;
    border-left: 0;
}
table tr td:first-child,
table tr th:first-child {
    border-left: 0;
    border-right: 0
}*/

</style>
<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<?=$this->Html->css('pdf', ['fullBase' => true]);?>
		<?=$this->fetch('css')?>
	</head>
	<body>
		<?=$this->element('header-logo', ['report_title' => 'Relatório de Enfermagem']);?>
		<div class="container">

			<h3  style="font-weight: bold"  colspan="3" >  Relatório de Risco </h3>
			<br>
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr>
						<th class="title th-left">Item</th>
						<th class="title th-middle">Total</th>
						<th class="title th-middle">%</th>
					</tr>
				</thead>

				<tbody >
					<tr >
						<td >Total de pacientes com risco identificado </td>
						<td> <?=$data['risco']['tot_pacientes_com_risco']?> </td>
						<td> <?=$data['risco']['percen_paciente_com_risco']?>% </td>
					</tr>

					<tr >
						<td >Média de riscos por paciente </td>
						<td> <?=$data['risco']['media_risco_por_paciente']?> </td>
						<td> - </td>
					</tr>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" >  Média de riscos dos pacientes por setores </td>
					</tr>

					<?php foreach ($data['risco']['setores'] as $nome_do_setor => $setor): ?>
						<tr>
							<td> <?=$nome_do_setor?> </td>
							<td><?=$setor['media']?></td>
							<td> - </td>
						</tr>
					<?php endforeach;?>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" >  Média de riscos dos pacientes clínicos por setores </td>
					</tr>

					<?php foreach ($data['risco']['setores'] as $nome_do_setor => $setor): ?>
						<tr>
							<td> <?=$nome_do_setor?> </td>
							<td><?=$setor['clinico']['media']?></td>
							<td> - </td>
						</tr>
					<?php endforeach;?>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" >  Média de riscos dos pacientes cirúrgicos por setores </td>
					</tr>

					<?php foreach ($data['risco']['setores'] as $nome_do_setor => $setor): ?>
						<tr>
							<td> <?=$nome_do_setor?> </td>
							<td><?=$setor['cirurgico']['media']?></td>
							<td> - </td>
						</tr>
					<?php endforeach;?>


					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" > 10 principais riscos </td>
					</tr>

					<?php foreach ($data['risco']['principais_riscos'] as $risco): ?>
						<tr>
							<td> <?=$risco['name']?> </td>
							<td><?=$risco['tot']?> </td>
							<td><?=$risco['percen']?>% </td>
						</tr>
					<?php endforeach;?>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" > 10 principais riscos em pacientes cirúrgicos</td>
					</tr>

					<?php foreach ($data['risco']['principais_riscos_cirurgico'] as $risco): ?>
						<tr>
							<td> <?=$risco['name']?> </td>
							<td><?=$risco['tot_cirurgico']?> </td>
							<td><?=$risco['percen_cirurgico']?>% </td>
						</tr>
					<?php endforeach;?>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" > 10 principais riscos em pacientes clínicos</td>
					</tr>

					<?php foreach ($data['risco']['principais_riscos_clinico'] as $risco): ?>
						<tr>
							<td> <?=$risco['name']?> </td>
							<td><?=$risco['tot_clinico']?> </td>
							<td><?=$risco['percen_clinico']?>% </td>
						</tr>
					<?php endforeach;?>


				</tbody>
			</table>


			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="5" >  Média de riscos de pacientes clínicos e cirúrgicos por setores</td>
					</tr>
					<tr class="border">
						 <th rowspan="2"  class="title ">Item</th>
						 <th colspan="2" class="title ">Clínico</th>
						 <th colspan="2" class="title ">Cirúrgico</th>
				  	</tr>
				   	<tr class="border">
						<th class="title  ">VA</th>
						<th class="title ">Média</th>

						<th class="title ">VA</th>
						<th class="title ">Média</th>
					</tr>
				</thead>
				<tbody >
					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="5" >  Risco moderado: </td>
					</tr>
					<?php foreach ($data['braden']['sectors'] as  $sector) : ?>
						<tr class="tr-indent">
							<td>&#8226; <?= $sector['name'] ?> </td>
							<td> <?=$sector['clinica']['tot_pacientes_com_risco_moderado']?> </td>
							<td> <?=$sector['clinica']['total_de_riscos_moderado']?> </td>

							<td> <?=$sector['cirurgica']['tot_pacientes_com_risco_moderado']?> </td>
							<td> <?=$sector['cirurgica']['total_de_riscos_moderado']?> </td>
						</tr>
					<?php endforeach; ?>
				
					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="5" >  Risco alto: </td>
					</tr>
					<?php foreach ($data['braden']['sectors'] as  $sector) : ?>
						<tr class="tr-indent">
							<td>&#8226; <?= $sector['name'] ?> </td>
							<td> <?=$sector['clinica']['tot_pacientes_com_risco_alto']?> </td>
							<td> <?=$sector['clinica']['total_de_riscos_alto']?> </td>

							<td> <?=$sector['cirurgica']['tot_pacientes_com_risco_alto']?> </td>
							<td> <?=$sector['cirurgica']['total_de_riscos_alto']?> </td>
						</tr>
					<?php endforeach; ?>

				</tbody>
			</table> 

			<div style="page-break-after: always;"></div>
			<h3  style="font-weight: bold"  colspan="3" >  Relatório de Braden </h3>
			<br>

			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr class="border">
						 <th  class="title ">Item</th>
						 <th  class="title ">Total</th>
						 <th  class="title ">%</th>
				    </tr>
				</thead>
				<tbody >
					<tr>
						<td >Pacientes com risco moderado</td>
						<td><?=$data['braden']['tot_paciente_risco_moderado']?></td>
						<td><?=$data['braden']['percen_paciente_risco_moderado']?>%</td>
				  </tr>

				   <tr>
						<td >Pacientes com risco alto</td>
						<td><?=$data['braden']['tot_paciente_risco_alto']?></td>
						<td><?=$data['braden']['percen_paciente_risco_alto']?>%</td>
				  </tr>

				  <tr>
						<td >Pacientes com úlcera de pressão e risco baixo</td>
						<td><?=$data['braden']['tot_ulcera_pressao_risco_baixo']?></td>
						<td><?=$data['braden']['taxa_ulcera_pressao_risco_baixo']?>%</td>
				  </tr>

				  <tr>
						<td >Pacientes com úlcera de pressão e risco moderado</td>
						<td><?=$data['braden']['tot_ulcera_pressao_risco_moderado']?></td>
						<td><?=$data['braden']['taxa_ulcera_pressao_risco_moderado']?>%</td>
				  </tr>

				  <tr>
						<td >Pacientes com úlcera de pressão e risco alto</td>
						<td><?=$data['braden']['tot_ulcera_pressao_risco_alto']?></td>
						<td><?=$data['braden']['taxa_ulcera_pressao_risco_alto']?>%</td>
				  </tr>

				  <tr>
						<td >Taxa de pacientes com úlcera de pressão</td>
						<td><?=$data['braden']['tot_pacientes_ulcera_pressao']?></td>
						<td><?=$data['braden']['percen_pacientes_ulcera_pressao']?>%</td>
				  </tr>

				  <tr>
						<td >Taxa de risco moderado em pacientes clínicos</td>
						<td><?=$data['braden']['clinica']['tot_paciente_risco_moderado']?></td>
						<td><?=$data['braden']['clinica']['percen_paciente_risco_moderado']?>%</td>
				  </tr>

				  <tr>
						<td >Taxa de risco moderado em pacientes cirúrgicos</td>
						<td><?=$data['braden']['cirurgica']['tot_paciente_risco_moderado']?></td>
						<td><?=$data['braden']['cirurgica']['percen_paciente_risco_moderado']?>%</td>
				  </tr>

				  <tr>
						<td >Pacientes com mais de uma úlcera de pressão</td>
						<td><?=$data['braden']['tot_pacientes_varias_ulcera_pressao']?></td>
						<td><?=$data['braden']['percen_pacientes_varias_ulcera_pressao']?>%</td>
				  </tr>


				  <tr>
					<td > Total de pacientes com úlcera de pressão estágio 1 </td>
					<td><?=$data['braden']['tot_paciente_ulcera_estagio_1']?></td>
					<td><?=$data['braden']['percen_paciente_ulcera_estagio_1']?>%</td>
				  </tr>

				  <tr>
					<td > Total de pacientes com úlcera de pressão estágio 2 </td>
					<td><?=$data['braden']['tot_paciente_ulcera_estagio_2']?></td>
					<td><?=$data['braden']['percen_paciente_ulcera_estagio_2']?>%</td>
				  </tr>

				  <tr>
					<td > Total de pacientes com úlcera de pressão estágio 3 </td>
					<td><?=$data['braden']['tot_paciente_ulcera_estagio_3']?></td>
					<td><?=$data['braden']['percen_paciente_ulcera_estagio_3']?>%</td>
				  </tr>

				  <tr>
					<td > Total de pacientes com úlcera de pressão estágio 4 </td>
					<td><?=$data['braden']['tot_paciente_ulcera_estagio_4']?></td>
					<td><?=$data['braden']['percen_paciente_ulcera_estagio_4']?>%</td>
				  </tr>
				</tbody>
			</table>

			
			<div style="page-break-after: always;"></div>
			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr class="border">
						 <th rowspan="2"  class="title ">Item</th>
						 <th colspan="2" class="title ">Risco leve</th>
						 <th colspan="2" class="title ">Risco moderado</th>
						 <th colspan="2" class="title ">Risco alto</th>
				  </tr>
				   <tr class="border">
						<th class="title  ">VA</th>
						<th class="title ">%</th>

						<th class="title  ">VA</th>
						<th class="title ">%</th>

						<th class="title ">VA</th>
						<th class="title ">%</th>
					</tr>
				</thead>
				<tbody >
					<tr>
						 <td colspan="7" class="title" style="font-weight: bold" >  Pacientes com úlcera de pressão por risco </td>
					</tr>
					<tr>
						<td > Pacientes com úlcera estágio 1</td>
						<td><?=$data['braden']['risco_leve']['tot_pacientes_ulcera_1']?></td>
						<td><?=$data['braden']['risco_leve']['percen_pacientes_ulcera_1']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_pacientes_ulcera_1']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_pacientes_ulcera_1']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_pacientes_ulcera_1']?></td>
						<td><?=$data['braden']['risco_alto']['percen_pacientes_ulcera_1']?>%</td>
				  	</tr>

				  	<tr>
						<td > Pacientes com úlcera estágio 2</td>
						<td><?=$data['braden']['risco_leve']['tot_pacientes_ulcera_2']?></td>
						<td><?=$data['braden']['risco_leve']['percen_pacientes_ulcera_2']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_pacientes_ulcera_2']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_pacientes_ulcera_2']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_pacientes_ulcera_2']?></td>
						<td><?=$data['braden']['risco_alto']['percen_pacientes_ulcera_2']?>%</td>
				  	</tr>

				  	<tr>
						<td > Pacientes com úlcera estágio 3</td>
						<td><?=$data['braden']['risco_leve']['tot_pacientes_ulcera_3']?></td>
						<td><?=$data['braden']['risco_leve']['percen_pacientes_ulcera_3']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_pacientes_ulcera_3']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_pacientes_ulcera_3']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_pacientes_ulcera_3']?></td>
						<td><?=$data['braden']['risco_alto']['percen_pacientes_ulcera_3']?>%</td>
				  	</tr>

				  	<tr>
						 <td colspan="7" class="title" style="font-weight: bold" >  Pacientes com progressão da úlcera de pressão por risco</td>
					</tr>
				  	<tr>
						<td > Pacientes com progressão de úlcera de pressão estágio 1 para 2</td>
						<td><?=$data['braden']['risco_leve']['tot_paciente_progressao_ulcera_estagio_1_2']?></td>
						<td><?=$data['braden']['risco_leve']['percen_paciente_progressao_ulcera_estagio_1_2']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_paciente_progressao_ulcera_estagio_1_2']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_paciente_progressao_ulcera_estagio_1_2']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_paciente_progressao_ulcera_estagio_1_2']?></td>
						<td><?=$data['braden']['risco_alto']['percen_paciente_progressao_ulcera_estagio_1_2']?>%</td>
				  	</tr>

				  	<tr>
						<td > Pacientes com progressão de úlcera de pressão estágio 2 para 3</td>
						<td><?=$data['braden']['risco_leve']['tot_paciente_progressao_ulcera_estagio_2_3']?></td>
						<td><?=$data['braden']['risco_leve']['percen_paciente_progressao_ulcera_estagio_2_3']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_paciente_progressao_ulcera_estagio_2_3']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_paciente_progressao_ulcera_estagio_2_3']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_paciente_progressao_ulcera_estagio_2_3']?></td>
						<td><?=$data['braden']['risco_alto']['percen_paciente_progressao_ulcera_estagio_2_3']?>%</td>
				  	</tr>

				  	<tr>
						<td > Pacientes com progressão de úlcera de pressão estágio 3 para 4</td>
						<td><?=$data['braden']['risco_leve']['tot_paciente_progressao_ulcera_estagio_3_4']?></td>
						<td><?=$data['braden']['risco_leve']['percen_paciente_progressao_ulcera_estagio_3_4']?>%</td>

						<td><?=$data['braden']['risco_moderado']['tot_paciente_progressao_ulcera_estagio_3_4']?></td>
						<td><?=$data['braden']['risco_moderado']['percen_paciente_progressao_ulcera_estagio_3_4']?>%</td>

						<td><?=$data['braden']['risco_alto']['tot_paciente_progressao_ulcera_estagio_3_4']?></td>
						<td><?=$data['braden']['risco_alto']['percen_paciente_progressao_ulcera_estagio_3_4']?>%</td>
				  	</tr>


				</tbody>
			</table>



			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr class="border">
						 <th  class="title ">Item</th>
						 <th  class="title ">Total</th>
						 <th  class="title ">%</th>
				    </tr>
				</thead>
				<tbody >
				   <tr>
					<td > Total de pacientes com progressão de úlcera de pressão estágio 1 para 2</td>
					<td><?=$data['braden']['tot_paciente_progressao_ulcera_estagio_1_2']?></td>
					<td><?=$data['braden']['percen_paciente_progressao_ulcera_estagio_1_2']?>%</td>
				  </tr>

				   <tr>
					<td > Total de pacientes com progressão de úlcera de pressão estágio 2 para 3</td>
					<td><?=$data['braden']['tot_paciente_progressao_ulcera_estagio_2_3']?></td>
					<td><?=$data['braden']['percen_paciente_progressao_ulcera_estagio_2_3']?>%</td>
				  </tr>

				   <tr>
					<td > Total de pacientes com progressão de úlcera de pressão estágio 3 para 4</td>
					<td><?=$data['braden']['tot_paciente_progressao_ulcera_estagio_3_4']?></td>
					<td><?=$data['braden']['percen_paciente_progressao_ulcera_estagio_3_4']?>%</td>
				  </tr>

				<!-- <tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com mais de uma úlcera de pressão estágio 1 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com mais de uma úlcera de pressão estágio 2</td>
					<td></td>
					<td>%</td>
				</tr>

				  <tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com mais de uma úlcera de pressão estágio 2 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com mais de uma úlcera de pressão estágio 3</td>
					<td></td>
					<td>%</td>
				</tr>

				  <tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com mais de uma úlcera de pressão estágio 3 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com mais de uma úlcera de pressão estágio 4</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com mais de uma úlcera de pressão estágio 4 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com progressão de úlcera de pressão estágio 1 para 2</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com progressão de úlcera de pressão estágio 1 para 2 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com progressão de úlcera de pressão estágio 2 para 3</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com progressão de úlcera de pressão estágio 2 para 3 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Pacientes com progressão de úlcera de pressão estágio 3 para 4</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Pacientes com progressão de úlcera de pressão estágio 3 para 4 por risco de Braden</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr>
					<td >Taxa de infecção em pacientes com úlcera de pressão</td>
					<td></td>
					<td>%</td>
				</tr>
			-->
				<tr>
					<td >Taxa de óbito em pacientes com úlcera de pressão</td>
					<td> <?=$data['braden']['taxa_obito_paciente_ulcera']?> </td>
					<td>-</td>
				</tr>

				<tr>
					 <td colspan="3" class="title" style="font-weight: bold" >Taxa de óbito em pacientes com úlcera de pressão por estágio da lesão</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco baixo</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco moderado</td>
					<td></td>
					<td>%</td>
				</tr>

				<tr class="tr-indent">
					<td>&#8226; Risco alto</td>
					<td></td>
					<td>%</td>
				</tr>

				</tbody>
			</table>


			<div style="page-break-after: always;"></div>
			<h3 style="font-weight: bold"  colspan="3" >  Relatório de Fugulin </h3>
			<br>

			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr class="border">
						 <th  class="title ">Item</th>
						 <th  class="title ">Total</th>
						 <th  class="title ">%</th>
				  	</tr>
				</thead>
				<tbody >
					<!-- <tr >
						<th class="line-separator" style="font-weight: bold"  colspan="3" >  Média de riscos de pacientes clínicos e cirúrgicos por setores</th>
					</tr>

					<tr class="border">
						 <th class="title ">Item</th>
						 <th class="title ">Valor</th>
						 <th class="title ">%</th>
				    </tr> -->
					<tr>
						<td >Pacientes com fugulin intensivo</td>
						<td> <?=$data['fugulin']['tot_de_pacientes_fugulin_intensivo']?> </td>
						<td> <?=$data['fugulin']['percen_de_pacientes_fugulin_intensivo']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes com fugulin semi-intensivo</td>
						<td> <?=$data['fugulin']['tot_de_pacientes_fugulin_semi_intensivo']?> </td>
						<td> <?=$data['fugulin']['percen_de_pacientes_fugulin_semi_intensivo']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes com fugulin de alta dependência</td>
						<td> <?=$data['fugulin']['tot_de_pacientes_fugulin_21_a_26']?> </td>
						<td> <?=$data['fugulin']['percen_de_pacientes_fugulin_21_a_26']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes com fugulin intermediário</td>
						<td> <?=$data['fugulin']['tot_de_pacientes_fugulin_15_a_20']?> </td>
						<td> <?=$data['fugulin']['percen_de_pacientes_fugulin_15_a_20']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes com fugulin mínimo</td>
						<td> <?=$data['fugulin']['tot_de_pacientes_fugulin_9_a_11']?> </td>
						<td> <?=$data['fugulin']['percen_de_pacientes_fugulin_9_a_11']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de internação na UTI com fugulin intensivo</td>
						<td> <?=$data['fugulin']['setores_uti']['tot_de_pacientes_fugulin_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_uti']['percen_de_pacientes_fugulin_intensivo']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de internação na UTI  com fugulin semi-intensivo</td>
						<td> <?=$data['fugulin']['setores_uti']['tot_de_pacientes_fugulin_semi_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_uti']['percen_de_pacientes_fugulin_semi_intensivo']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de internação na UTI  com fugulin de alta dependência</td>
						<td> <?=$data['fugulin']['setores_uti']['tot_de_pacientes_fugulin_21_a_26']?> </td>
						<td> <?=$data['fugulin']['setores_uti']['percen_de_pacientes_fugulin_21_a_26']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de internação na UTI  com fugulin intermediário</td>
						<td> <?=$data['fugulin']['setores_uti']['tot_de_pacientes_fugulin_15_a_20']?> </td>
						<td> <?=$data['fugulin']['setores_uti']['percen_de_pacientes_fugulin_15_a_20']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de internação da UTI  com fugulin mínimo</td>
						<td> <?=$data['fugulin']['setores_uti']['tot_de_pacientes_fugulin_9_a_11']?> </td>
						<td> <?=$data['fugulin']['setores_uti']['percen_de_pacientes_fugulin_9_a_11']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de altas da UTI com fugulin intensivo</td>
						<td> <?=$data['fugulin']['setores_uti_alta']['tot_de_pacientes_fugulin_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_uti_alta']['percen_de_pacientes_fugulin_intensivo']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de altas da UTI  com fugulin semi-intensivo</td>
						<td> <?=$data['fugulin']['setores_uti_alta']['tot_de_pacientes_fugulin_semi_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_uti_alta']['percen_de_pacientes_fugulin_semi_intensivo']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de altas da UTI  com fugulin de alta dependência</td>
						<td> <?=$data['fugulin']['setores_uti_alta']['tot_de_pacientes_fugulin_21_a_26']?> </td>
						<td> <?=$data['fugulin']['setores_uti_alta']['percen_de_pacientes_fugulin_21_a_26']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de altas da UTI  com fugulin intermediário</td>
						<td> <?=$data['fugulin']['setores_uti_alta']['tot_de_pacientes_fugulin_15_a_20']?> </td>
						<td> <?=$data['fugulin']['setores_uti_alta']['percen_de_pacientes_fugulin_15_a_20']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de altas da UTI  com fugulin mínimo</td>
						<td> <?=$data['fugulin']['setores_uti_alta']['tot_de_pacientes_fugulin_9_a_11']?> </td>
						<td> <?=$data['fugulin']['setores_uti_alta']['percen_de_pacientes_fugulin_9_a_11']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de internação na UI com fugulin intensivo</td>
						<td> <?=$data['fugulin']['setores_ui']['tot_de_pacientes_fugulin_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_ui']['percen_de_pacientes_fugulin_intensivo']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de internação na UI  com fugulin semi-intensivo</td>
						<td> <?=$data['fugulin']['setores_ui']['tot_de_pacientes_fugulin_semi_intensivo']?> </td>
						<td> <?=$data['fugulin']['setores_ui']['percen_de_pacientes_fugulin_semi_intensivo']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de internação na UI  com fugulin de alta dependência</td>
						<td> <?=$data['fugulin']['setores_ui']['tot_de_pacientes_fugulin_21_a_26']?> </td>
						<td> <?=$data['fugulin']['setores_ui']['percen_de_pacientes_fugulin_21_a_26']?>% </td>
					</tr>

					 <tr>
						<td >Pacientes de internação na UI  com fugulin intermediário</td>
						<td> <?=$data['fugulin']['setores_ui']['tot_de_pacientes_fugulin_15_a_20']?> </td>
						<td> <?=$data['fugulin']['setores_ui']['percen_de_pacientes_fugulin_15_a_20']?>% </td>
					</tr>

					<tr>
						<td >Pacientes de internação da UI  com fugulin mínimo</td>
						<td> <?=$data['fugulin']['setores_ui']['tot_de_pacientes_fugulin_9_a_11']?> </td>
						<td> <?=$data['fugulin']['setores_ui']['percen_de_pacientes_fugulin_9_a_11']?>% </td>
					</tr>

					<tr>
						<td >Pacientes reinternados na UTI com fugulin intensivo</td>
						<td>0</td>
						<td>0%</td>
					</tr>

					<tr>
						<td >Pacientes reinternados na UTI  com fugulin semi-intensivo</td>
						<td>0</td>
						<td>0%</td>
					</tr>

					 <tr>
						<td >Pacientes reinternados na UTI  com fugulin de alta dependência</td>
						<td>0</td>
						<td>0%</td>
					</tr>

					 <tr>
						<td >Pacientes reinternadosna na UTI  com fugulin intermediário</td>
						<td>0</td>
						<td>0%</td>
					</tr>

					 <tr>
						<td >Pacientes reinternados na UTI  com fugulin mínimo</td>
						<td>0</td>
						<td>0%</td>
					</tr>

				</tbody>
			</table>


			<div style="page-break-after: always;"></div>
			<h3 style="font-weight: bold"  colspan="3" > Relatório de NAS </h3>
			<br>

			<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
				<thead>
					<tr>
						<th class="title th-left">Item</th>
						<th class="title th-middle">Total</th>
						<th class="title th-middle">%</th>
					</tr>
				</thead>

				<tbody >
					<tr >
						<td >Pacientes com NAS preenchido </td>
						<td> <?=$data['nas']['tot_pacientes_com_nas']?> </td>
						<td> <?=$data['nas']['percen_pacientes_com_nas']?>% </td>
					</tr>

					<tr >
						<td >Média de NAS</td>
						<td> <?=$data['nas']['media_pontuacao_nas']?>  </td>
						<td> - </td>
					</tr>

					<tr >
						<td >Realocação da equipe pelo NAS por dia</td>
						<td> <?= $data['nas']['media_realocacao_nas_por_dia'] ?>  </td>
						<td> - </td>
					</tr>

					<tr >
						<td class="line-separator" style="font-weight: bold"  colspan="3" > Realocação de equipo pelo NAS nos setores </td>
					</tr>

					<?php foreach ($data['nas']['setores'] as $nome_do_setor => $setor): ?>
						<tr>
							<td> <?=$setor['name']?> </td>
							<td> <?=$setor['tot_realocacao']?> </td>
							<td> <?=$setor['percen']?>% </td>
						</tr>
					<?php endforeach;?> 


				</tbody>
			</table>



		</div>
	</body>
</html>