<!DOCTYPE html>
<html>
    <head>
        <meta content="text/html; charset=utf-8" http-equiv="Content-Type"/>
        <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
    </head>
    <body>
        <?=$this->element('header-logo', ['report_title' => 'Relatório Geral']);?>
        <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">
                            Item
                        </th>
                        <th class="title th-middle" style="margin-left:100px;">
                            Valor
                        </th>
                        <th class="title th-right">
                            %
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <!-- <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="3">  Seção Geral</td>
                    </tr> -->
                    <tr>
                        <td class="title" style="font-weight: bold" colspan="3"> Retorno hospitalar </td>
                    </tr>

                    <?php foreach ($data['tempo_reinteracao'] as $tempo): ?>
                        <tr>
                            <td>&lt; <?= $tempo['nome'] ?></td>
                            <td> <?= $tempo['count']?> </td>
                            <td>-</td>
                        </tr>
                    <?php endforeach;?>
                    <?php foreach ($data['sectors'] as $sector): ?>
                        <tr>
                            <td class="title" style="font-weight: bold" colspan="7"> <?=$sector['name']?> </td>
                        </tr>
                        <tr>
                            <td>
                                Total de pacientes atendidos no período
                            </td>
                            <td>
                                <?=$sector['tot_pacientes_atendidos']?>
                            </td>
                            <td>
                               -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Total de internações
                            </td>
                            <td>
                                <?=$sector['tot_internacoes_no_periodo']?>
                            </td>
                            <td>
                               -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                 Total de altas
                            </td>
                            <td>
                                <?=$sector['tot_alta']?>
                            </td>
                            <td>
                               <?=$sector['percen_alta']?>%
                            </td>
                        </tr>

                        <tr>
                            <td>
                                 Total de óbitos
                            </td>
                            <td>
                                <?=$sector['tot_obito']?>
                            </td>
                            <td>
                               <?=$sector['percen_obito']?>%
                            </td>
                        </tr>

                        <tr>
                            <td class="title" style="font-weight: bold" colspan="3"> Faixa de internação </td>
                        </tr>
                        <?php foreach ($sector['faixa_internacao'] as $key_internacao => $internacao): ?>
                            <tr>
                                <?php if($key_internacao == "< 24h"): ?>
                                    <td>&lt; <?= $internacao['nome'] ?></td>
                                <?php elseif($key_internacao == "> 28 dias"): ?>
                                    <td>&gt; <?= $internacao['nome'] ?></td>
                                <?php else:  ?>
                                    <td><?= $internacao['nome'] ?></td>
                                <?php endif; ?>
                                <td> <?= $internacao['count'] ?> </td>
                                <td>-</td>
                            </tr>
                        <?php endforeach;?>

                        <tr>
                            <td>
                                Tempo médio de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_medio_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo médio de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_medio_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo máximo de permanência (dias)
                            </td>
                            <td>
                                <?=$sector['tempo_maximo_permanencia']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Tempo médio de permanência (dias) dos pacientes de óbito
                            </td>
                            <td>
                                <?=$sector['tempo_medio_permanencia_obito']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Taxa de ocupação
                            </td>
                            <td>
                                -
                            </td>
                            <td>
                                <?=$sector['taxa_ocupacao']?>%
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Intervalo de substituição
                            </td>
                            <td>
                                <?=$sector['intervalo_de_substituicao']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Idade média
                            </td>
                            <td>
                                <?=$sector['idade_media']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                                Sexo masculino
                            </td>
                            <td>
                                <?=$sector['tot_paciente_sexo_masculino']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                5 principais origens de internação + outros
                            </td>
                        </tr>

                        <?php foreach ($sector['5_principais_origin_internacao'] as $key_origem => $origem): ?>
                            <tr>
                                <td> <?= $origem['name'] ?></td>
                                <td> <?= $origem['count'] ?></td>
                                <td> <?= $origem['percentual'] ?></td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td colspan='3'>
                               Saúde complementar ( 5 principais planos + outros )
                            </td>
                        </tr>

                        <?php foreach ($sector['5_principais_saude_complementares'] as $saude_complementares): ?>
                            <tr>
                                <td> <?= $saude_complementares['name'] ?></td>
                                <td> <?= $saude_complementares['tot'] ?></td>
                                <td> <?= $saude_complementares['percen'] ?></td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td colspan='3'>
                              5 principais diagnósticos sistêmicos + outros
                            </td>
                            <?php $count_diagnostico_sistemico = 0; ?>
                            <?php foreach ($sector['principais_diagnosticos_sistemicos'] as $key_diagnostico => $total): ?>
                                <?php if( $key_diagnostico == "total" ) : ?>
                                    <?php krsort($total); ?>
                                    <?php foreach ($total as $key_total => $value): ?>
                                        <?php foreach ($value as $key_value => $diagonstico): ?>
                                            <?php if( $count_diagnostico_sistemico < 5 ) : ?>
                                                <tr>
                                                    <td> <?= $diagonstico['nome'] ?> </td>
                                                    <td> <?= $diagonstico['total'] ?> </td>
                                                    <td> <?= $diagonstico['percentual'] ?> </td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $count_diagnostico_sistemico++; ?>
                                        <?php endforeach;?>
                                    <?php endforeach;?>
                                <?php endif; ?>
                            <?php endforeach;?>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                5 principais diagnósticos + outros
                            </td>
                            <?php $count_diagnostico = 0; ?>
                            <?php foreach ($sector['principais_diagnosticos'] as $key_diagnostico => $total): ?>
                                <?php if( $key_diagnostico == "total" ) : ?>
                                    <?php krsort($total); ?>
                                    <?php foreach ($total as $key_total => $value): ?>
                                        <?php foreach ($value as $key_value => $diagonstico): ?>
                                            <?php if( $count_diagnostico < 5 ) : ?>
                                                <tr>
                                                    <td> <?= $diagonstico['nome'] ?> </td>
                                                    <td> <?= $diagonstico['total'] ?> </td>
                                                    <td> <?= $diagonstico['percentual'] ?> </td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $count_diagnostico++; ?>
                                        <?php endforeach;?>
                                    <?php endforeach;?>
                                <?php endif; ?>
                            <?php endforeach;?>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                5 principais comorbidades + outros
                            </td>
                            <?php $count_comorbidade = 0; ?>
                            <?php foreach ($sector['principais_comorbidades'] as $key_comorbidade => $total): ?>
                                <?php if( $key_comorbidade == "total" ) : ?>
                                    <?php krsort($total); ?>
                                    <?php foreach ($total as $key_total => $value): ?>
                                        <?php foreach ($value as $key_value => $comorbidade): ?>
                                            <?php if( $count_comorbidade < 5 ) : ?>
                                                <tr>
                                                    <td> <?= $comorbidade['nome'] ?> </td>
                                                    <td> <?= $comorbidade['total'] ?> </td>
                                                    <td> <?= $comorbidade['percentual'] ?> </td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $count_comorbidade++; ?>
                                        <?php endforeach;?>
                                    <?php endforeach;?>
                                <?php endif; ?>
                            <?php endforeach;?>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                5 principais destinos de alta + outros
                            </td>
                            <?php $count_destino = 0; ?>
                            <?php foreach ($data['principais_destinos'] as $key_destino => $total): ?>
                                <?php if( $key_destino == "total" ) : ?>
                                    <?php foreach ($total as $key_total => $value): ?>
                                        <?php foreach ($value as $key_value => $destino): ?>
                                            <?php if( $count_destino < 5 ) : ?>
                                                <tr>
                                                    <td> <?= $destino['name'] ?> </td>
                                                    <td> <?= $destino['total'] ?> </td>
                                                    <td> <?= $destino['percentual'] ?> </td>
                                                </tr>
                                            <?php endif; ?>
                                            <?php $count_destino++; ?>
                                        <?php endforeach;?>
                                    <?php endforeach;?>
                                <?php endif; ?>
                            <?php endforeach;?>
                        </tr>

                        <tr>
                            <td>
                            Tempo médio de duração da decisão de alta e alta efetiva
                            </td>
                            <td> <?=$sector['tempo_medio_duracao_alta_e_alta_efetiva']?> </td>
                            <td> - </td>
                        </tr>

                        <tr>
                            <td>
                           Tabela de retorno hospitalar: valor absoluto de pacientes que retornaram ao hospital em < 24h, < 72h, < 1 semana, < 1 mês e < 6 meses ** aplicar ao relatório da emergência como retorno de atendimento
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                            Gênero
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                            Tabela dos valores absolutos e percentuais frente ao total de internações com a distribuição das idades por faixa etária ( < 28 dias, 29 dias a 5 anos, 5 anos a 12, 12 a 18, 18 a 30, 31 a 40, 41 a 50, 51 a 60, 61 a 70, 71 a 80, 81 a 90 e > 90 anos
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>


                        <tr>
                            <td>
                            Idade mediana
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                            Idade média dos pacientes de óbito
                            </td>
                            <td>
                                <?=$sector['media_idade_obito']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                Idade média dos pacientes de óbito das 5 principais origens
                            </td>
                        </tr>

                        <?php foreach ($sector['arr_idade_obito_origem'] as $key_obito => $obito): ?>
                            <tr>
                                <td> <?= $obito['nome'] ?></td>
                                <td> <?= $obito['media'] ?></td>
                                <td> - </td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td>
                            Idade média dos pacientes de alta
                            </td>
                            <td>
                                <?=$sector['media_idade_alta']?>
                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td colspan='3'>
                                Idade média dos pacientes de alta das 5 principais origens
                            </td>
                        </tr>
                        <?php foreach ($sector['arr_idade_alta_origem'] as $key_obito => $obito): ?>
                            <tr>
                                <td> <?= $obito['nome'] ?></td>
                                <td> <?= $obito['media'] ?></td>
                                <td> - </td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td colspan='3'>
                            Origem de internação ( 10 principais + outros )
                            </td>
                        </tr>
                        <?php foreach ($sector['10_principais_origin_internacao'] as $key_origem => $origem): ?>
                            <tr>
                                <td> <?= $origem['name'] ?></td>
                                <td> <?= $origem['count'] ?></td>
                                <td> <?= $origem['percentual'] ?></td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td colspan='3'>
                                Saúde complementar: ( 20 principais + outros )
                            </td>
                        </tr>

                        <?php foreach ($sector['20_principais_saude_complementares'] as $saude_complementares): ?>
                            <tr>
                                <td> <?= $saude_complementares['name'] ?></td>
                                <td> <?= $saude_complementares['tot'] ?></td>
                                <td> <?= $saude_complementares['percen'] ?></td>
                            </tr>
                        <?php endforeach ?>

                        <tr>
                            <td>
                                Tabela de origem e saúde complementar
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>


                         <tr>
                            <td>
                                Grupos de diagnósticos: clinico, cirurgicos emergenciais, cirúrgicos rotina, obstétrico emergencial, obstrético rotina, terapeutica, paleativo -> valor absoluto e percentual frente ao total de internações
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                               Tabela origem e grupos de diagnósticos
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                               Diagnósticos sistêmicos: infecção/sepse, cardíaco*, respiratório*, neurológico*, pós pcr, gastrointestinal*, endócrino e metabólico, trauma, renal, hepatobiliar*, pancreático*, oncológico, hematológico, morte encefálica, obstétrico, osteomuscular, buxomaxilofacial, otológico*, oftalmológico*, dermatológico*, ginecológico*, urológico*
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                               Tabela diagnóstico sistêmico e origem
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                               15 principais diagnósticos em cada um acima + outros
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                               15 principais diagnósticos secundários em cada um acima + outros
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                              15 principais comorbidades em cada um acima + outros
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>

                        <tr>
                            <td>
                              Índice de comorbidade dos pacientes internados
                            </td>
                            <td>

                            </td>
                            <td>
                                -
                            </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </body>
</html>
