<style type="text/css">
table {
    border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
    text-align: center;
}

tbody tr td:first-child {
    text-align: left;
}

/*table tr:last-child td {
    border-right: 0;
    border-left: 0;
}
table tr td:first-child,
table tr th:first-child {
    border-left: 0;
    border-right: 0
}*/

</style>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
    </head>
    <body>
    <?=$this->element('header-logo', ['report_title' => 'Relatório de Emergência']);?>
       <div class="container">

            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Mínimo</th>
                        <th class="title th-right">Médio</th>
                        <th class="title th-right">Máximo</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- <tr>
                        <td> Tempo entre chegada e triagem </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr>
                        <td > Tempo entre chegada e 1º atendimento médico </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr>
                        <td > Tempo entre triagem e 1º atendimento médico </td>
                        <td> <?=$data['min_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['media_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['max_tempo_entre_triagem_atendimento']?> </td>
                    </tr>

                    <!-- <tr class="duvida">
                         <td colspan="4" class="title" style="font-weight: bold" > Tempo entre chegada e triagem pelas cores de classificação </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <!-- <tr class="duvida">
                         <td colspan="4" class="title" style="font-weight: bold" > Tempo entre chegada e 1º atendimento médico pelas cores de classificação </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> -   </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr class="duvida">
                         <td colspan="4" class="title" style="font-weight: bold" > Tempo entre triagem e 1 atendimento médico distribuído pelas cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?=$data['azul']['min_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['azul']['media_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['azul']['max_tempo_entre_triagem_atendimento']?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?=$data['verde']['min_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['verde']['media_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['verde']['max_tempo_entre_triagem_atendimento']?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> <?=$data['amarelo']['min_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['amarelo']['media_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['amarelo']['max_tempo_entre_triagem_atendimento']?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> <?=$data['vermelho']['min_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['vermelho']['media_tempo_entre_triagem_atendimento']?> </td>
                        <td> <?=$data['vermelho']['max_tempo_entre_triagem_atendimento']?> </td>
                    </tr>


                <tbody>
            </table>

            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Valor</th>
                        <th class="title th-right">%</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >  Atendimentos separados por cores de classificação no período</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?=$data['azul']['tot_atendimento']?> </td>
                        <td> <?=$data['azul']['percen_atendimento']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?=$data['verde']['tot_atendimento']?> </td>
                        <td> <?=$data['verde']['percen_atendimento']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> <?=$data['amarelo']['tot_atendimento']?> </td>
                        <td> <?=$data['amarelo']['percen_atendimento']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> <?=$data['vermelho']['tot_atendimento']?> </td>
                        <td> <?=$data['vermelho']['percen_atendimento']?>% </td>
                    </tr>

                    <tr>
                        <td colspan="3" class="title" style="font-weight: bold">
                           Atendimentos que tiveram mudança de cor durante a sequência de atendimento e distribuição pelas mudanças
                        </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul -> Verde</td>
                        <td> <?=$data['azul']['tot_mudaram_para_verde']?> </td>
                        <td> <?=$data['azul']['percen_mudaram_para_verde']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Azul -> Amarelo </td>
                        <td> <?=$data['azul']['tot_mudaram_para_amarelo']?> </td>
                        <td> <?=$data['azul']['percen_mudaram_para_amarelo']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Azul -> Vermelho </td>
                        <td> <?=$data['azul']['tot_mudaram_para_vermelho']?> </td>
                        <td> <?=$data['azul']['percen_mudaram_para_vermelho']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde -> Azul </td>
                        <td> <?=$data['verde']['tot_mudaram_para_azul']?> </td>
                        <td> <?=$data['verde']['percen_mudaram_para_azul']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde -> Amarelo </td>
                        <td> <?=$data['verde']['tot_mudaram_para_amarelo']?> </td>
                        <td> <?=$data['verde']['percen_mudaram_para_amarelo']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde -> Vermelho </td>
                        <td> <?=$data['verde']['tot_mudaram_para_vermelho']?> </td>
                        <td> <?=$data['verde']['percen_mudaram_para_vermelho']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo -> Azul </td>
                        <td> <?=$data['amarelo']['tot_mudaram_para_azul']?> </td>
                        <td> <?=$data['amarelo']['percen_mudaram_para_azul']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo -> Verde </td>
                        <td> <?=$data['amarelo']['tot_mudaram_para_verde']?> </td>
                        <td> <?=$data['amarelo']['percen_mudaram_para_verde']?>% </td>
                    </tr>

                     <tr class="tr-indent">
                        <td>&#8226; Amarelo -> Vermelho </td>
                        <td> <?=$data['amarelo']['tot_mudaram_para_vermelho']?> </td>
                        <td> <?=$data['amarelo']['percen_mudaram_para_vermelho']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho -> Azul </td>
                        <td> <?=$data['vermelho']['tot_mudaram_para_azul']?> </td>
                        <td> <?=$data['vermelho']['percen_mudaram_para_azul']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho -> Verde </td>
                        <td> <?=$data['vermelho']['tot_mudaram_para_verde']?> </td>
                        <td> <?=$data['vermelho']['percen_mudaram_para_verde']?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho -> Amarelo </td>
                        <td> <?=$data['vermelho']['tot_mudaram_para_amarelo']?> </td>
                        <td> <?=$data['vermelho']['percen_mudaram_para_amarelo']?>% </td>
                    </tr>
                    

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >  Atendimentos separados por saúde complementar dos pacientes na entrada da emergência </td>
                    </tr>

                    <?php foreach($data['convenios'] as $convenio) : ?>
                        <tr class="tr-indent">
                            <td>&#8226;   <?= $convenio['name'] ?> </td>
                            <td> <?= $convenio['tot'] ?>  </td>
                            <td> <?= $convenio['percen'] ?>%  </td>
                        </tr>
                    <?php endforeach; ?>
                    

                    <!-- <tr class="yolo">
                        <td> RELAÇÃO EM TABELA DE SAUDE COMPLEMENTAR E ORIGEM</td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr class="yolo">
                        <td> Média da idade dos pacientes atendidos</td>
                        <td> <?=$data['media_idade_dos_pacientes']?> </td>
                        <td> - </td>
                    </tr>
                    
                </tbody>
            </table>

            <div style="page-break-after: always;"></div>
             <h3  class="title" style="font-weight: 500; text-align: center; font-size: 1em;"> Relação entre saúde complementar e cores de triagem </h3>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                        <th rowspan="2"  class="title ">Saúde complementar</th>
                        <th colspan="2" class="title ">Azul</th>
                        <th colspan="2" class="title ">Verde</th>
                        <th colspan="2" class="title ">Amarelo</th>
                        <th colspan="2" class="title ">Vermelho</th>
                    </tr>
                    <tr class="border">
                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title  ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>

                        <th class="title ">VA</th>
                        <th class="title ">%</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($data['convenios'] as $convenio) : ?>
                        <tr class="tr-indent">
                            <td>&#8226;   <?= $convenio['name'] ?> </td>
                            <td> <?= $convenio['azul']['tot_atendimento'] ?>  </td>
                            <td> <?= $convenio['azul']['percen_atendimento'] ?>%  </td>

                            <td> <?= $convenio['verde']['tot_atendimento'] ?>  </td>
                            <td> <?= $convenio['verde']['percen_atendimento'] ?>%  </td>

                            <td> <?= $convenio['amarelo']['tot_atendimento'] ?>  </td>
                            <td> <?= $convenio['amarelo']['percen_atendimento'] ?>%  </td>

                            <td> <?= $convenio['vermelho']['tot_atendimento'] ?>  </td>
                            <td> <?= $convenio['vermelho']['percen_atendimento'] ?>%  </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
    

            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Valor</th>
                        <th class="title th-right">%</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >  Valor médio da idade separado por cores de triagem </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?= $data['azul']['media_idade_dos_pacientes'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?= $data['verde']['media_idade_dos_pacientes'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                       <td> <?= $data['amarelo']['media_idade_dos_pacientes'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                       <td> <?= $data['vermelho']['media_idade_dos_pacientes'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" > Valor médio da idade separado por saúde complementar </td>
                    </tr>

                    <?php foreach($data['convenios'] as $convenio) : ?>
                        <tr>
                            <td>  <?= $convenio['name'] ?> </td>
                            <td> <?= $convenio['media_idade_dos_pacientes'] ?>  </td>
                            <td> -  </td>
                        </tr>
                    <?php endforeach; ?>



                    <tr>
                        <td>Pacientes que tiveram a classificação de risco mudada (cor de triagem) </td>
                        <td> <?= $data['tot_emergencia_mudaram_de_cor'] ?> </td>
                        <td> <?= $data['percen_emergencia_mudaram_de_cor'] ?>% </td>
                    </tr>

                    <!-- <tr >
                        <td>Pacientes que não foram realizados os protocolos sugeridos na classificação de risco</td>
                        <td> </td>
                        <td> </td>
                    </tr> -->


                <tbody>
            </table>




            <div style="page-break-after: always;"></div>
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Mínimo</th>
                        <th class="title th-right">Médio</th>
                        <th class="title th-right">Máximo</th
                    </tr>
                </thead>
                <tbody>
                   <!--  <tr>
                        <td> Tempo entre chegada e  alta para os que só receberam 1 atendimento sem exames e sem medicação </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr>
                        <td> Tempo entre o 1º  e o 2º atendimento médico </td>
                        <td> <?= $data['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['tempo_entre_1_e_2_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <!-- <tr>
                        <td> Tempo entre chegada e  alta para os que receberam 2 atendimentos </td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr>
                        <td>Tempo dos atendimentos médicos</td>
                        <td> <?= $data['tempo_entre_todos_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['tempo_entre_todos_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['tempo_entre_todos_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                     <tr>
                        <td>Tempo  entre 1º e último atendimento médico</td>
                         <td> <?= $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                     <!-- <tr>
                        <td>Tempo de permanência na emergência</td>
                        <td> - </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >  Tempo de permanencia na emergência distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td>  </td>
                        <td> </td>
                        <td>  </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="4" class="title" style="font-weight: bold" > Tempo de permanencia na emergência distribuído pela idade média </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Mínimo</td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Médio </td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Máximo </td>
                        <td>  </td>
                        <td>  </td>
                        <td>  </td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >  Tempo entre chegada e  alta para os que só receberam 1 atendimento sem exames e sem medicação distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >  Tempo entre chegada e  alta para os que só receberam 1 atendimento sem exames e sem medicação distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->

                    <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >Tempo entre 1º e 2º atendimento  distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?= $data['azul']['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_1_e_2_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?= $data['verde']['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_1_e_2_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> <?= $data['amarelo']['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_1_e_2_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> <?= $data['vermelho']['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_1_e_2_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>



                    <tr>
                         <td colspan="4" class="title" style="font-weight: bold" > Tempo entre todos atendimento distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?= $data['azul']['tempo_entre_todos_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_todos_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_todos_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?= $data['verde']['tempo_entre_todos_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_todos_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_todos_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> <?= $data['amarelo']['tempo_entre_todos_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_todos_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_todos_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> <?= $data['vermelho']['tempo_entre_todos_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_todos_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_todos_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >Tempo entre 1º e último atendimento  distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> <?= $data['azul']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['azul']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> <?= $data['verde']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['verde']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> <?= $data['amarelo']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['amarelo']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> <?= $data['vermelho']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] ?> </td>
                        <td> <?= $data['vermelho']['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] ?> </td>
                    </tr>

                    <!-- <tr>
                         <td colspan="4" class="title" style="font-weight: bold" >Tempo mínimo médio máximo entre chegada e  alta para os que receberam 2 atendimentos  distribuído por cores </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> 0 </td>
                        <td> - </td>
                        <td> - </td>
                    </tr> -->                    
                <tbody>
            </table>

            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th class="title th-left">Item</th>
                        <th class="title th-right">Valor</th>
                        <th class="title th-right">%</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Valor absoluto e percentual de pacientes atendidos  na emergência separados pelos 10 principais diagnósticos</td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Valor absoluto e percentual de pacientes atendidos  na emergência separados pelos 10 principais diagnósticos sindrômicos</td>
                    </tr> -->

                    <tr>
                        <td>
                            Taxa de captação da emergência
                        </td>
                        <td> - </td>
                        <td> <?= $data['media_taxa_captacao_emergencia'] ?>% </td>
                        
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de captação da emergência por cor</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Azul</td>
                        <td> - </td>
                        <td> <?= $data['azul']['media_taxa_captacao_emergencia'] ?>% </td>
                        <!-- <td> <?= $data['azul']['percen_taxa_captacao_emergencia'] ?>% </td> -->
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Verde </td>
                        <td> - </td>
                        <td> <?= $data['verde']['media_taxa_captacao_emergencia'] ?>% </td>
                        <!-- <td> <?= $data['verde']['percen_taxa_captacao_emergencia'] ?>% </td> -->
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Amarelo </td>
                        <td> - </td>
                        <td> <?= $data['amarelo']['media_taxa_captacao_emergencia'] ?>% </td>
                        <!-- <td> <?= $data['amarelo']['percen_taxa_captacao_emergencia'] ?>% </td> -->
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> - </td>
                        <td> <?= $data['vermelho']['media_taxa_captacao_emergencia'] ?>% </td>
                        <!-- <td> <?= $data['vermelho']['percen_taxa_captacao_emergencia'] ?>% </td> -->
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de captação da emergência por saúde complementar</td>
                    </tr>

                    <?php foreach ($data['convenios'] as  $convenio) : ?>
                        <tr class="tr-indent">
                            <td>&#8226; <?= $convenio['name'] ?> </td>
                            <td> - </td>
                            <td> <?= $convenio['taxa_captacao_convenio'] ?>% </td>
                        </tr>
                    <?php endforeach; ?>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de captação da emergência por dia da semana</td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Segunda</td>
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][0]['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Terça</td>
                        <td> <?= $data['dia_da_semana_emergencia'][1]['taxa_captacao'] ?> </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quarta</td>                        
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][2]['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Quinta</td>
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][3]['taxa_captacao'] ?>% </td>                        
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sexta</td>                        
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][4]['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Sábado</td>                        
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][5]['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Domingo</td>                        
                        <td> - </td>
                        <td> <?= $data['dia_da_semana_emergencia'][6]['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de captação da emergência por turno</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Madrugada</td>                        
                        <td> - </td>
                        <td> <?= $data['turno_emergencia']['madrugada']['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Manhã</td>                        
                        <td> - </td>
                        <td> <?= $data['turno_emergencia']['manha']['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Tarde </td>                        
                        <td> - </td>
                        <td> <?= $data['turno_emergencia']['tarde']['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Noite </td>                        
                        <td> - </td>
                        <td> <?= $data['turno_emergencia']['noite']['taxa_captacao'] ?>% </td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de captação da emergência por médico</td>
                    </tr>
                    <?php foreach ($data['professionals'] as $professional) : ?> 
                        <tr class="tr-indent">
                            <td>&#8226; <?= $professional['name'] ?> </td>                            
                            <td> - </td>
                            <td> <?= $professional['taxa_de_captacao'] ?>% </td>
                        </tr>
                    <?php endforeach; ?>
                    

                    <!-- 
                    <tr>
                        <td>
                           Taxa de captação da emergência por médico
                        </td>
                        <td></td>
                        <td></td>
                    </tr> -->

                    <tr>
                        <td>  Taxa de internação na unidade intensiva </td>                        
                        <td> - </td>
                        <td> <?= $data['taxa_captacao_unidade_intensiva'] ?>% </td>
                    </tr>

                    <tr>
                        <td> Taxa de internação na unidade de internação </td>                        
                        <td> - </td>
                        <td> <?= $data['taxa_captacao_unidade_intensiva'] ?> </td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Desfecho dos pacientes com internação na emergência</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Centro cirúrgico </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['centro_cirurgico']['tot_pacientes_tranferidos'] ?> </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['centro_cirurgico']['percen_pacientes_tranferidos'] ?>% </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Unidade de internação </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['unidade_internacao']['tot_pacientes_tranferidos'] ?> </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['unidade_internacao']['percen_pacientes_tranferidos'] ?>% </td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Terapia intensiva </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['terapia_intensiva']['tot_pacientes_tranferidos'] ?> </td>
                        <td> <?= $data['desfecho_int_na_emergencia']['terapia_intensiva']['percen_pacientes_tranferidos'] ?>% </td>
                    </tr>

                    <tr>
                        <td>  Pacientes internados na emergência com ocupação superior a 24h </td>
                        <td> <?= $data['tot_pacientes_internados_na_emergencia_sup_24h'] ?> </td>
                        <td> <?= $data['percen_pacientes_internados_na_emergencia_sup_24h'] ?>% </td>
                    </tr>

                    <tr>
                        <td>  Tempo médio de de horas dos pacientes internados na emergência</td>
                        <td> <?= $data['media_horas_pacientes_internados_emergencia'] ?> </td>
                        <td> - </td>
                    </tr>

                    <!-- <tr>
                        <td>  Revisita a emergência em tempo inferior a 24h </td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                           Revisita a emergência em tempo inferior a 48h
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                           Revisita a emergência em tempo inferior a 72h
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                           Revisita a emergência em tempo inferior a 7 dias
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                           Taxa de captação da emergência por cada um das revisitas
                        </td>
                        <td></td>
                        <td></td>
                    </tr>
                     -->

                    <!-- < -->


                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" > Pacientes internados na emergência separados pelos 10 principais diagnósticos na emergência</td>
                    </tr> -->
                
                    <!-- <tr>
                        <td>
                           Pacientes transferidos para outra unidade hospitalar
                        </td>
                        <td></td>
                        <td></td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Pacientes transferidos para outra unidade hospitalar por saúde complementar</td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Pacientes transferidos para outra unidade hospitalar separados por cores</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Manhã</td>
                        <td>  </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Tarde </td>
                        <td>  </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Noite </td>
                        <td>  </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> </td>
                        <td> - </td>
                    </tr> -->

                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >10 principais motivos de transferência interhospitalar</td>
                    </tr>

                    <tr>
                        <td> Tempo médio de permanência para transferência hospitalar </td>
                        <td></td>
                        <td></td>
                    </tr> -->


                    <!-- <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de óbito na emergência separados por cores</td>
                    </tr>
                    <tr class="tr-indent">
                        <td>&#8226; Manhã</td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Tarde </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Noite </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Vermelho </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                     <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Taxa de óbito na emergência separados por origem</td>
                    </tr>

                    <tr>
                        <td>
                           Taxa de óbito na emergência separados por revistita
                        </td>
                        <td></td>
                        <td></td>
                    </tr>


                     <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Tempo mínimo médio e máximo de permanência dos pctes que evoluiram a óbito na emergência</td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Mínimo </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Médio </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr class="tr-indent">
                        <td>&#8226; Máximo </td>
                        <td> 0 </td>
                        <td> - </td>
                    </tr>

                    <tr>
                         <td colspan="3" class="title" style="font-weight: bold" >Pacientes que evoluiram a óbito na emergência separados pelos 10 principais diagnósticos na emergência</td>
                    </tr> -->

                </tbody>
            </table>
        </div>
    </body>
</html>

