<!DOCTYPE html>
<html>
<head>	
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>	
	<?=  $this->Html->css('pdf', ['fullBase' => true]); ?>
	<?= $this->fetch('css') ?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Parecer Médico'] ); ?> 

	<div class="container">			
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>
					 <th class="title th-right"> % </th>
	 
				</tr>
			</thead>						
			<tbody>
				<tr>
					<td >Total de pareceres solicitados</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td>Pareceres solicitados por internação</td>
					<td> <?=$data['pareceres_solicitados_por_internacoes']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td >Pareceres solicitados por dia</td>
					<td> <?=$data['pareceres_solicitados_por_dia']?> </td>
					<td> - </td>
				</tr>

				<tr>
					<td >Pareceres solicitados não respondidos</td>
					<td> <?=$data['tot_pareceres_nao_respondidos']?> </td>
					<td> <?=$data['percen_pareceres_nao_respondidos']?>% </td>
				</tr>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size"> Pareceres solicitados não respondidos por setor </h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-middle">VA</th>	 
					 <th class="title th-middle">%</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['setores'] as $setor): ?>
					<tr>
						<td ><?=$setor['name']?></td>
						<td> <?=$setor['tot_pareceres_nao_respondidos']?> </td>
						<td> <?=$setor['percen_pareceres_nao_respondidos']?>% </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Pareceres solicitados por especialidade de destino</h3>
		<table class="aileron_thin break" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Especialidade de destino</th>
					 <th class="title th-middle" >VA</th>	 
					 <th class="title th-middle" >%</th>	 
				</tr>
			</thead>				
		
			<tbody>
				<?php foreach ($data['especialidade_destino'] as $specialty): ?>
					<tr>
						<td ><?=$specialty['name']?></td>
						<td> <?=$specialty['tot_pareceres']?> </td>
						<td> <?=$specialty['percen_pareceres']?>% </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Pareceres solicitados não respondidos por especialidade de destino</h3>
		<table class="aileron_thin break" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Especialidade de destino</th>
					 <th class="title th-middle" >VA</th>	 
					 <th class="title th-middle" >%</th>	 
				</tr>
			</thead>				
		
			<tbody>
				<?php foreach ($data['especialidade_destino'] as $specialty): ?>
					<tr>
						<td ><?=$specialty['name']?></td>
						<td> <?=$specialty['tot_pareceres_nao_respondidos']?> </td>
						<td> <?=$specialty['percen_pareceres_nao_respondidos']?>% </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Pareceres solicitados por setor</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>

				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-right">VA</th>	 
					 <th class="title th-right">%</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['setores'] as $setor): ?>
					<tr>
						<td ><?=$setor['name']?></td>
						<td> <?=$setor['tot_pareceres']?> </td>
						<td> <?=$setor['percen_pareceres']?>% </td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Tempo de resposta do parecer (dias)</h3>
		<table class="aileron_thin yolo" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-middle" style="margin-left:100px;" >VA</th>	 
				</tr>
			</thead>						
			<tbody>
				<tr>
					<td >Tempo mínimo</td>
					<td> <?=$data['tot_tempo_resposta_parecer_minimo']?> d </td>
				</tr>
				<tr>
					<td >Tempo médio</td>
					<td> <?=$data['tot_tempo_resposta_parecer_medio']?> d</td>
				</tr>
				<tr>
					<td >Tempo máximo</td>
					<td> <?=$data['tot_tempo_resposta_parecer_maximo']?> d</td>
				</tr>

				<tr>
					<td >Tempo mediano</td>
					<td> <?=$data['tot_tempo_resposta_parecer_mediano']?> d</td>
				</tr>

				<tr>
					<td >Desvio padrão</td>
					<td> <?=$data['tot_tempo_resposta_parecer_desvio_padrao']?> d</td>
				</tr>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Tempo de resposta do parecer por setor solicitante (dias)</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Setor</th>
					 <th class="title th-middle" style="margin-left:100px;" >T. mínimo</th>	 
					 <th class="title th-right">T. médio</th>	 
					 <th class="title th-right">T. máximo</th>	 
					 <th class="title th-right">T. mediano</th>	 
					 <th class="title th-right">Desvio padrão </th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['setores'] as $setor): ?>
					<tr>
						<td ><?=$setor['name']?></td>
						<td ><?=$setor['tot_tempo_resposta_parecer_minimo']?> d</td>
						<td ><?=$setor['tot_tempo_resposta_parecer_medio']?> d</td>
						<td ><?=$setor['tot_tempo_resposta_parecer_maximo']?> d</td>
						<td ><?=$setor['tot_tempo_resposta_parecer_mediano']?> d</td>
						<td ><?=$setor['tot_tempo_resposta_parecer_desvio_padrao']?> d</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

		<h3 class="OK title-dark t-center sub-size" >Tempo de resposta do parecer por especialidade de destino</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					 <th class="title th-left">Especialidade</th>
					 <th class="title th-middle" style="margin-left:100px;" >T. mínimo</th>	 
					 <th class="title th-right">T. médio</th>	 
					 <th class="title th-right">T. máximo</th>	 
					 <th class="title th-right">T. mediano</th>	 
					 <th class="title th-right">Desvio padrão </th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['especialidade_destino'] as $specialty): ?>
					<tr>
						<td ><?=$specialty['name']?></td>
						<td ><?=$specialty['tot_tempo_resposta_parecer_minimo']?> d</td>
						<td ><?=$specialty['tot_tempo_resposta_parecer_medio']?> d</td>
						<td ><?=$specialty['tot_tempo_resposta_parecer_maximo']?> d</td>
						<td ><?=$specialty['tot_tempo_resposta_parecer_mediano']?> d</td>
						<td ><?=$specialty['tot_tempo_resposta_parecer_desvio_padrao']?> d</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>


		<h3 class="OK title-dark t-center sub-size" >Tabela entre os 5 principais setores e as 5 principais especialidades</h3>
		<table class="aileron_thin" style="width:100%;   border-collapse: collapse;" >
			<thead>
				<tr>
					<th class="title th-left">Item</th>		
					<th class="title th-right">VA</th>	 
					<th class="title th-right">%</th>	 
				</tr>
			</thead>
				
		
			<tbody>
				<?php foreach ($data['principais_setores'] as $setor): ?>			
					<tr>
						 <td colspan="3" class="title" style="font-weight: bold" > <?=$setor['name']?> </td>
				    </tr>								
						<?php foreach ($setor['especialidade_destino'] as $specialty): ?>
							<tr class="tr-indent">
								<td>&#8226; <?=$specialty['name']?> </td>
								<td> <?=$specialty['tot_pareceres']?> </td>
								<td> <?=$specialty['percen_pareceres']?>% </td>
							</tr>
						<?php endforeach; ?>					
				<?php endforeach; ?>
			</tbody>
		</table>

	</div> 
</body>
</html>

<style type="text/css">
	table {
		margin-bottom: 100px
	}
</style>	