<style type="text/css">
table {
    border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
    text-align: center;
}

tbody tr td:first-child {
    text-align: left;
}
</style>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
    </head>
    <body>
        <?=$this->element('header-logo', ['report_title' => 'Relatório de Farmácia']);?>
        <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                         <th rowspan="2" class="title  th-left">Item</th>
                         <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                         <?php endforeach;?>
                    </tr>                 
                </thead>
                <tbody>
                    <tr>
                        <td> Internações no Setor Durante o Período </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['geral']['total'] ?>
                            </td>
                            <td> - </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>">Profilaxias</td>
                    </tr>

                    <tr>
                        <td> Cabeceira do leito elevada </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['cabeceira_de_leito_elevado']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['cabeceira_de_leito_elevado']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Protocolo de higiene oral com clorexidina </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['protocolo_higienico_oral']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['protocolo_higienico_oral']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Aspiração da secreção subglótica </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['aspiracao_da_secrecao']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['aspiracao_da_secrecao']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Necessita de profilaxia lesão aguda de mucosa gástrica </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['necessidade_de_profilaxia']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['necessidade_de_profilaxia']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Bloqueador de H2 </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['bloq_bloqueador']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['bloq_bloqueador']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Protetor de H2 </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['incluir_outro_item_protetor']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['incluir_outro_item_protetor']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>">Profilaxia para TEV</td>
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Heparina Baixo Peso Molecular  </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][0]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][0]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Heparina Não Fracionada </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][1]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][1]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Compressor Pneumático Intermitente </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][2]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][2]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Fondaparinux </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][3]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][3]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Rivaroxaban </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][4]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][4]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td> &#8226; Não </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['profilaxia_tev'][5]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['profilaxia_tev'][5]['percen'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>" > Suporte Nutricional </td>
                    </tr>
                    <tr>
                        <td> Atingiu VET pleno </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['atingiu_vet_pleno']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['atingiu_vet_pleno']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>" > Via de nutrição </td>
                    </tr>
                    <tr class="td-indent">
                        <td >&#8226; Oral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][0]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][0]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td >&#8226; Enteral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][1]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][1]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td >&#8226; Parenteral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][2]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][2]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td >&#8226; Conjugada Oral e Enteral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][3]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][3]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td >&#8226; Conjugada Enteral e Parenteral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][4]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][4]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr class="td-indent">
                        <td >&#8226; Zero </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['via_de_nutricao'][5]['tot'] ?>
                            </td>
                            <td>
                                <?=  $month['via_de_nutricao'][5]['percen'] ?>%
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>" > Dispositivos Invasivos</td>
                    </tr>
                    <tr>
                        <td> Uso de cateter venoso central </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['cateter_venoso_central']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['cateter_venoso_central']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Uso de cateter arterial </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['cateter_arterial']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['cateter_arterial']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Uso de cateter vesical de demora </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['cateter_vesical_de_demora']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['cateter_vesical_de_demora']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>" > Uso de medicações </td>
                    </tr>
                    <tr>
                        <td> Antibióticos </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['antibioticos']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['antibioticos']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Corticoesteroides </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['corticoesteroides']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['corticoesteroides']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>" > Controle Glicêmico: Protocolo glicêmico </td>
                    </tr>
                    <tr>
                        <td> Protocolo glicêmico </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['protocolo_glicemico']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['protocolo_glicemico']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Fez uso de insulina nas 24 horas </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['fez_insulina_ultimas_24_h']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['fez_insulina_ultimas_24_h']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>


                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>"> Sedação Analgesia Delirium: </td>
                    </tr>
                    <tr>
                        <td> Uso de sedação </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['sedacao']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['sedacao']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Sob analgesia </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['sob_analgesia']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['sob_analgesia']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr>
                        <td> Avaliação de delirium pelo CAM-ICU </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['avaliacao_delirium_pelo_camicu']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['avaliacao_delirium_pelo_camicu']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>

                    <tr >
                        <td class="line-separator title t-center" style="font-weight: bold" colspan="<?= 1+(count($data['dates'])*2) ?>"> Ventilação Mecânica: </td>
                    </tr>

                    <tr>
                        <td> Uso de ventilação mecânica invasiva </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>     
                            <td>
                                <?=  $month['ventilacao_mecanica_invasiva']['total'] ?>
                            </td>
                            <td>
                                <?=  $month['ventilacao_mecanica_invasiva']['percentual'] ?>% 
                            </td>
                        <?php endforeach;?>     
                    </tr>
                </tbody>                
            </table>
        </div>
    </body>
</html>