<style type="text/css">
table {
    border-collapse: collapse;
}


tbody tr td, .border th {
  border-right: solid 1px #ccc;
  border-left: solid 1px #ccc;
}

 .border th {
  border-top: solid 1px #ccc;
}

tbody tr td {
    text-align: center;
}

tbody tr td:first-child {
    text-align: left;
}
</style>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <?=$this->Html->css('pdf', ['fullBase' => true]);?>
        <?=$this->fetch('css')?>
    </head>
    <body>
        <?=$this->element('header-logo', ['report_title' => 'Relatório de Cateter Vascular']);?>
        <div class="container">
            <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
                <thead>
                    <tr class="border">
                         <th rowspan="2" class="title  th-left">Item</th>
                         <?php foreach ($data['dates'] as $key => $month): ?>
                             <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                         <?php endforeach;?>
                    </tr>
                    <tr class="border">
                        <?php foreach ($data['dates'] as $key => $month): ?>
                            <th class="title  th-left">VA</th>
                            <th class="title  th-left">%</th>
                         <?php endforeach;?>
                    </tr>                 
                </thead>

                <tbody>
                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3>  Seção Geral</td>
                    </tr>
                    <tr>
                        <td>Total de bundles de passagem de cateter vascular </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['total_de_bundles'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Bundles de cateter vascular por paciente</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_bundle_vascular_por_pacientes'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>Pacientes com bundle de cateter vascular / Pacientes com cateter arterial</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_internacao_vascular_por_arterial'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Pacientes com bundle de cateter vascular / Pacientes  venoso</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_internacao_vascular_por_venoso'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Pacientes com bundle de cateter vascular / Pacientes com hemodiálise</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_internacao_vascular_por_hemodialise'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr >

                    <tr >
                        <td>Pacientes com bundle de cateter vascular / Pacientes com picc marcados em procedimentos</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_internacao_vascular_por_picc'] ?> </td>
                            <td> - </td> 
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Cateter venoso no período em relação ao total de bundles</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_bundle_venoso'] ?> </td>
                            <td> <?= $month['tot_cateter_venoso_por_bundle'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>Cateter arterial no período em relação ao total de bundles</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_bundle_arterial'] ?> </td>
                            <td> <?= $month['tot_cateter_arterial_por_bundle'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>Procedimentos realizados de forma emergencial</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['emergency']['total'] ?> </td>
                            <td> <?= $month['emergency']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>Número de lúmens</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['numero_lumen']['media'] ?> </td>
                            <td>-</td>
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Procedimentos realizados com picc</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_procedimentos_utilizando_picc'] ?> </td>
                            <td> <?= $month['percen_procedimentos_utilizando_picc'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Procedimentos realizados com hemodiálise</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_procedimentos_utilizando_hemodialise'] ?> </td>
                            <td> <?= $month['percen_procedimentos_utilizando_hemodialise'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3>  Checklist pré procedimento</td>
                    </tr>


                    <tr>
                        <td>Foi verificado o risco de sangramento</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['is_risk_of_bleeding_verified']['total'] ?> </td>
                            <td> <?= $month['is_risk_of_bleeding_verified']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>O TCI foi preenchido</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tci_preenchido']['total'] ?> </td>
                            <td> <?= $month['tci_preenchido']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>O procedimento foi prescrito</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['is_the_procedure_prescribed']['total'] ?> </td>
                            <td> <?= $month['is_the_procedure_prescribed']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3>  Checklist durante o procedimento</td>
                    </tr>

                    <tr>
                        <td>Realizado higienização adequada das mãos</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['proper_handwashing']['total'] ?> </td>
                            <td> <?= $month['proper_handwashing']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>Uso de paramentação: gorro, máscara e luvas estéreis</td>
                         <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['use_of_paramentation']['total'] ?> </td>
                            <td> <?= $month['use_of_paramentation']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>

                <!--    <tr >
                        <td>Uso de degermação da pele</td>
                        <td> <?=$data['use_of_antisepsis']['total']?> </td>
                        <td> <?=$data['use_of_antisepsis']['percentual']?>% </td>
                        </tr> -->

                    <tr>
                        <td>Uso de anti-sepsia da pele</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['use_of_antisepsis']['total'] ?> </td>
                            <td> <?= $month['use_of_antisepsis']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>
                    <tr>
                        <td>Uso de técnica asséptica durante o procedimento</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tecnica_asseptica']['total'] ?> </td>
                            <td> <?= $month['tecnica_asseptica']['percentual'] ?>% </td>
                         <?php endforeach;?>
                    </tr>
                    <!-- <tr>
                        <td>Uso de campo barreira máxima</td>
                        <td></td>
                        <td> % </td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>

                    </tr> -->
                    <tr>
                        <td>Confirmação da posição com ultrassom</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['ultrasom_durante_procedimento']['total'] ?> </td>
                            <td> <?= $month['ultrasom_durante_procedimento']['percentual'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <!-- <tr >
                        <td>Uso de gel estéril </td>
                        <td></td>
                        <td> % </td>
                    </tr> -->

                    <!-- <tr >
                        <td>Progressão adequada de cateter</td>
                        <td> </td>
                        <td> % </td>
                    </tr> -->

                    <!-- <tr >
                        <td>Fixação adequada de cateter</td>
                        <td> </td>
                        <td> % </td>
                    </tr> -->

                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3> Checklist após procedimento</td>
                    </tr>

                    <!-- <tr >
                        <td>Curativo realizado com técnica estéril</td>
                        <td> </td>
                        <td> % </td>
                    </tr> -->

                    <!-- <tr >
                        <td>Uso de conectores nas saídas do cateter</td>
                        <td> </td>
                        <td> % </td>
                    </tr> -->

                    <tr >
                        <td>Solicitado radiografia de controle</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['radiografia_de_controle']['total'] ?> </td>
                            <td> <?= $month['radiografia_de_controle']['percentual'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3> Descrição orientada</td>
                    </tr>

                    <tr >
                        <td style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Local de inserção:</td>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria axilar</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_axilar'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_axilar'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria braquial</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_braquial'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_braquial'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria femoral </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_femoral'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_femoral'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria pediosa </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_pediosa'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_pediosa'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226;  Artéria radial</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_radial'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_radial'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria ulnar</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_ulnar'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_ulnar'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Artéria umeral</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_arteria_umeral'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_arteria_umeral'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia jugular interna</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_jugular_inter'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_jugular_inter'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia jugular externa</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_jugular_exter'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_jugular_exter'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia radial</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_radial'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_radial'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia subclávia</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_subclavia'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_subclavia'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia basílica</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_basilica'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_basilica'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia pediosa</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_pediosa'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_pediosa'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia cefálica</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_cefalica'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_cefalica'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia axilar</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_axilar'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_axilar'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia femoral</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_femoral'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_femoral'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia mediana</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_mediana'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_mediana'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia subclávia infraclavicular</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_subclavia_infra'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_subclavia_infra'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia subclávia supraclavicular</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_subclavia_supra'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_subclavia_supra'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia temporal</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_temporal'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_temporal'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Veia umbilical</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_veia_umbilical'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_veia_umbilical'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr class="td-indent" >
                        <td>&#8226; Outra</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['local_insercao']['tot_outra'] ?> </td>
                            <td> <?= $month['local_insercao']['percen_outra'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Tentativas:</td>
                    </tr>

                    <tr >
                        <td>&#8226; Média</td>                        
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_retries']['media'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>&#8226; Mediana</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_retries']['mediana'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>&#8226; Desvio padrão</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_retries']['desvio_padrao'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Procedimentos com uma única tentativa </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_tentativa_unica'] ?> </td>
                            <td> <?= $month['percen_tentativa_unica'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Sucesso na inserção</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['sucesso_na_insercao']['total'] ?> </td>
                            <td> <?= $month['sucesso_na_insercao']['percentual'] ?>% </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td  style="font-weight: bold; text-align: left; padding-left: 10px;" colspan=3>Profissionais participantes:</td>
                    </tr>

                    <tr >
                        <td>&#8226; Média</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_professionals']['media'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>&#8226; Mediana</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_professionals']['mediana'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>&#8226; Desvio padrão</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['number_of_professionals']['desvio_padrao'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Procedimentos com controle radiológico</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['radiografia_de_controle']['total'] ?> </td>
                            <td> <?=$data['radiografia_de_controle']['percentual']?>%</td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>Procedimentos em que houve complicação imediata</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_houve_complicacao_imediata'] ?> </td>
                            <td> <?=$data['percen_houve_complicacao_imediata']?>%</td>
                        <?php endforeach;?>
                    </tr>

                    <tr>
                        <td>Total de das complicações imediatas</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['tot_qtd_complicacao_imediata'] ?> </td>
                            <td> <?=$data['percen_qtd_complicacao_imediata']?>%</td>
                        <?php endforeach;?>
                    </tr>

                    <!-- <tr class="yolo">
                        <td>VALOR TOTAL E PERCENTUAL DAS COMPLICAÇÕES NO PERÍODO</td>
                    </tr> -->

                    <tr >
                        <td class="line-separator title" style="font-weight: bold" colspan=3>  Retirada do cateter vesival ou citostomia</td>
                    </tr>

                    <!-- <tr >
                        <td>Uso do dispositivo </td>
                        <td>-</td>
                        <td>-</td>
                                            </tr> -->

                    <tr>
                        <!-- Sandro falou pra desonsiderr tempo de uso nesse momento-->
                        <td class="line-separator title" style="font-weight: bold" colspan=3> Pacientes com tempo de uso do dispositivo:</td>
                    </tr>

                    <tr >
                        <td>&#8226; Média</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['media_dias_retirada'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>
                    <tr >
                        <td>&#8226; Mediana</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['mediana_dias_retirada'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>

                    <tr >
                        <td>&#8226; Desvio padrão</td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?= $month['desvio_padrao_dias_retirada'] ?> </td>
                            <td>- </td>
                        <?php endforeach;?>
                    </tr>                   

                    <tr >
                        <td>Pacientes com retirada acidental </td>
                        <?php foreach ($data['dates'] as $key => $month): ?>                        
                            <td> <?=$month['accidental_removal']['total']?> </td>
                            <td> <?=$month['accidental_removal']['percentual']?>%</td>
                        <?php endforeach;?>
                    </tr>

                    <!--<tr >
                        <td>Pacientes com retirada acidental sepradados por motivo </td>
                        <td>-</td>
                        <td>-</td>
                                            </tr> -->
                </tbody>
            </table>
        </div>
    </body>
</html>