<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?=$this->Html->css('pdf', ['fullBase' => true]);?>
    <?=$this->fetch('css')?>
</head>
<body>
<?=$this->element('header-logo', ['report_title' => 'Relatório de TEV Clinico']);?>
    <div class="container">
        <table class="aileron_thin" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                     <th class="title  th-left">Item</th>
                     <th class="title  th-left">VA</th>
                     <th class="title  th-left">%</th>
              </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        Taxa de adesão ao protocolo de TEV
                    </td>
                    <td>-</td>
                    <td><?=$data['consolidado']['taxa_adesao_protocolo_tev']?></td>
                </tr>

                <tr>
                    <td>
                        Pacientes com risco nos setores: unidade de internação
                    </td>
                    <td><?=$data['consolidado']['totalSetorUnidadeInternacao']?></td>
                    <td><?=$data['consolidado']['setorUnidadeInternacaoPercentual']?></td>
                </tr>
                <tr>
                    <td>
                        Pacientes com risco nos setores: unidades intensivas
                    </td>
                    <td><?=$data['consolidado']['totalSetorUnidadeIntensiva']?></td>
                    <td><?=$data['consolidado']['setorUnidadeIntensivaPercentual']?></td>
                </tr>

                <tr>
                    <td>
                        Pacientes com risco para tev
                    </td>
                    <td><?=$data['consolidado']['totalRiscoTev']?></td>
                    <td><?=$data['consolidado']['riscoTevPercentual']?></td>
                </tr>

                <!--tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">% de contra indicação para profilaxia de TEV</td>
                </tr-->

                <tr>
                    <td>
                        Contra indicação para profilaxia de TEV
                    </td>
                    <td><?=$data['consolidado']['countContraIndicacaoParaProfilaxiaTev']?></td>
                    <td><?=$data['consolidado']['percentualContraIndicacaoParaProfilaxiaTev']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia medicamentosa
                    </td>
                    <td><?=$data['consolidado']['paciente_profi_medi']['tot']?></td>
                    <td><?=$data['consolidado']['paciente_profi_medi']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de uso de profilaxia mecânica
                    </td>
                    <td> <?= $data['consolidado']['paciente_profi_meca']['tot']?></td>
                    <td> <?= $data['consolidado']['paciente_profi_meca']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Taxa de não uso de profilaxia em pacientes com risco
                    </td>
                    <td><?=$data['consolidado']['paciente_nao_usou_profilaxia']['tot']?></td>
                    <td><?=$data['consolidado']['paciente_nao_usou_profilaxia']['percen']?></td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia
                    </td>
                    <td><?=$data['consolidado']['temp_prof']['tot']?> dias</td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia medicamentosa
                    </td>
                    <td><?=$data['consolidado']['temp_prof_medi']['tot']?> dias</td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Tempo médio de uso de profilaxia mecânica
                    </td>
                    <td><?=$data['consolidado']['temp_prof_meca']['tot']?> dias</td>
                    <td>-</td>
                </tr>

                <tr>
                    <td>
                        Taxa de mortalidade nos pacientes que não receberam profilaxia
                    </td>
                    <td><?=$data['consolidado']['tot_paciente_risco_obito']?> </td>
                    <td><?=$data['consolidado']['percen_paciente_risco_obito']?> </td>
                </tr>

                <tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">05 principais contra indicações para profilaxia de tev</td>
                </tr>
                <?php
                    $count = 0;
                    foreach ($data['consolidado']['data_principais'] as $key => $principal) {
                        foreach ($principal as $key_2 => $value) {
                            if($count < 5){
                                echo "<tr>";
                                    echo "<td>" . $value['nome'] . "</td>";
                                    echo "<td>" .$value['total'] . "</td>";
                                    echo "<td>" .$value['percentual'] . "</td>";
                                echo "</tr>";
                            }
                            $count++;
                        }
                    }
                ?>

                <tr>
                    <td colspan="3" style="font-weight: bold; text-align: center;">10 principais fatores de risco identificados para tev</td>
                </tr>

                <?php
                    $count = 0;
                    foreach ($data['consolidado']['fator_risco'] as $key => $fator_risco) {
                        echo "<tr>";
                            echo "<td>" . $fator_risco['nome'] . "</td>";
                            echo "<td>" .$fator_risco['count'] . "</td>";
                            echo "<td>" .$fator_risco['percentual'] . "</td>";
                        echo "</tr>";
                    }


                ?>
            </tbody>
        </table>
    </div>
</body>
</html>