<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Checklist de Segurança'] ); ?>	
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title  th-left">Item</th>
					 <th class="title th-middle">Valor</th>
					 <th class="title th-middle">%</th>
			  </tr>
			</thead>		 
			<tbody>
				<tr>
					<td >Total de pacientes internados na unidade</td>
					<td><?=$data['tot_pacientes_internados']?></td>
					<td>-</td>
			    </tr>
			    
			 	<tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3"> Total de pacientes por Tipo de Internação</td>
                </tr>

			  <tr>
					 <td>Clínica</td>
					 <td><?=$data['clinica']['total']?></td>
					 <td><?=$data['clinica']['percentual']?>% </td>
			  </tr>

			  <tr>
					<td>Cirurgia eletiva</td>
					<td> <?=$data['eletiva']['total']?> </td>
					<td> <?=$data['eletiva']['percentual']?>% </td>
			  </tr>

			  <tr>
					<td>Cirurgia de urgência (emergêncial)</td>
					<td> <?=$data['cirurgica_emergencial']['total']?> </td>
					<td> <?=$data['cirurgica_emergencial']['percentual']?>% </td>
			  </tr> 
			   <tr>
					<td>Total de avaliações do Checklist</td>
					<td> <?=$data['total_de_registros']?> </td>
					<td> - </td>
			  </tr> 
			  <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan="3"> Total de avaliações por tipo de internação</td>
                </tr>

			  <tr class="td-indent">
					 <td >&#8226; Clínica</td>
					 <td><?=$data['clinica']['total_avaliacao']?></td>
					 <td><?=$data['clinica']['percentual_avaliacao']?>% </td>
			  </tr>

			  <tr class="td-indent">
					<td >&#8226; Cirurgia eletiva</td>
					<td> <?=$data['eletiva']['total_avaliacao']?> </td>
					<td> <?=$data['eletiva']['percentual_avaliacao']?>% </td>
			  </tr>

			  <tr class="td-indent">
					<td >&#8226; Cirurgia de urgência / emergência</td>
					<td> <?=$data['emergencia']['total_avaliacao']?> </td>
					<td> <?=$data['emergencia']['percentual_avaliacao']?>% </td>
			  </tr> 
			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Profilaxias</td>
                </tr>

			  <tr>
					<td>Cabeceira do leito elevada</td>
					<td> <?=$data['cabeceira_de_leito_elevado']['total']?> </td>
					<td> <?=$data['cabeceira_de_leito_elevado']['percentual']?>% </td>
			  </tr>

			  <tr>
					<td>Protocolo de higiene oral com clorexidina</td>
					<td> <?=$data['protocolo_higienico_oral']['total']?> </td>
					<td> <?=$data['protocolo_higienico_oral']['percentual']?>% </td>
			  </tr>

			  <tr>
					<td>Aspiração da secreção subglótica</td>
					<td> <?=$data['aspiracao_da_secrecao']['total']?> </td>
					<td> <?=$data['aspiracao_da_secrecao']['percentual']?>% </td>
			  </tr>

			  <tr>
					<td>Necessita de profilaxia lesão aguda de mucosa gástrica</td>
					<td> <?=$data['necessidade_de_profilaxia']['total']?> </td>
					<td> <?=$data['necessidade_de_profilaxia']['percentual']?>% </td>
			  </tr>
			  
			    <tr>
					<td> Bloqueador de H2 </td>
					<td> <?=$data['bloq_bloqueador']['total']?> </td>
					<td> <?=$data['bloq_bloqueador']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> Inibidor de H2 </td>
					<td> <?=$data['incluir_outro_item_protetor']['total']?> </td>
					<td> <?=$data['incluir_outro_item_protetor']['percentual']?>% </td>
			    </tr>

			     <tr >
                    <td class="line-separator title " style="font-weight: bold" colspan="3">Profilaxia para TEV</td>
                </tr>

			    <tr class="td-indent">
                    <td >&#8226; Heparina Baixo Peso Molecular </td>
                    <td> <?=$data['profilaxia_tev']['0']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['0']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Heparina Não Fracionada</td>
                    <td> <?=$data['profilaxia_tev']['1']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['1']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Compressor Pneumático Intermitente</td>
                    <td> <?=$data['profilaxia_tev']['2']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['2']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Fondaparinux</td>
                    <td> <?=$data['profilaxia_tev']['3']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['3']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Rivaroxaban</td>
                    <td> <?=$data['profilaxia_tev']['4']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['4']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Não</td>
                    <td> <?=$data['profilaxia_tev']['5']['tot']?> </td>
					<td> <?=$data['profilaxia_tev']['5']['percen']?>% </td>
                </tr>

                 <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Suporte Nutricional</td>
                </tr>

                <tr>
					<td> Atingiu VET pleno</td>
					<td> <?=$data['atingiu_vet_pleno']['total']?> </td>
					<td> <?=$data['atingiu_vet_pleno']['percentual']?>% </td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan="3">Via de nutrição</td>
                </tr>

			    <tr class="td-indent">
                    <td >&#8226; Oral </td>
                    <td> <?=$data['via_de_nutricao']['0']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['0']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Enteral</td>
                    <td> <?=$data['via_de_nutricao']['1']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['1']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Parenteral</td>
                    <td> <?=$data['via_de_nutricao']['2']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['2']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Conjugada Oral e Enteral</td>
                    <td> <?=$data['via_de_nutricao']['3']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['3']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Conjugada Enteral e Parenteral</td>
                    <td> <?=$data['via_de_nutricao']['4']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['4']['percen']?>% </td>
                </tr>

                <tr class="td-indent">
                    <td >&#8226; Zero</td>
                    <td> <?=$data['via_de_nutricao']['5']['tot']?> </td>
					<td> <?=$data['via_de_nutricao']['5']['percen']?>% </td>
                </tr>

                <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Dispositivos Invasivos</td>
                </tr>

                <tr>
					<td> Uso de cateter venoso central  </td>
					<td> <?=$data['cateter_venoso_central']['total']?> </td>
					<td> <?=$data['cateter_venoso_central']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>O cateter venoso central pode ser removido</td>
					<td> <?=$data['cateter_venoso_central_can_be_removed']['total']?> </td>
					<td> <?=$data['cateter_venoso_central_can_be_removed']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Uso de cateter arterial </td>
					<td> <?=$data['cateter_arterial']['total']?> </td>
					<td> <?=$data['cateter_arterial']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>O cateter arterial pode ser removido</td>
					<td> <?=$data['cateter_arterial_can_be_removed']['total']?> </td>
					<td> <?=$data['cateter_arterial_can_be_removed']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> Uso de cateter vesical de demora  </td>
					<td> <?=$data['cateter_vesical_de_demora']['total']?> </td>
					<td> <?=$data['cateter_vesical_de_demora']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> Cateter vesical de demora pode ser removido</td>
					<td> <?=$data['cateter_vesical_de_demora_can_be_removed']['total']?> </td>
					<td> <?=$data['cateter_vesical_de_demora_can_be_removed']['percentual']?>% </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Uso de medicações</td>
                </tr>

			    <tr>
					<td> Antibióticos  </td>
					<td> <?=$data['antibioticos']['total']?> </td>
					<td> <?=$data['antibioticos']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> O tratamento pode ser suspenso  </td>
					<td> <?=$data['antibioticos_can_be_removed']['total']?> </td>
					<td> <?=$data['antibioticos_can_be_removed']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> Corticoesteroides</td>
					<td> <?=$data['corticoesteroides']['total']?> </td>
					<td> <?=$data['corticoesteroides']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td> O uso de  corticoesteróides pode ser suspenso</td>
					<td> <?=$data['corticoesteroides_can_be_removed']['total']?> </td>
					<td> <?=$data['corticoesteroides_can_be_removed']['percentual']?>% </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Controle Glicêmico: Protocolo glicêmico</td>
                </tr>

			    <tr>
					<td>Protocolo glicêmico</td>
					<td> <?=$data['protocolo_glicemico']['total']?> </td>
					<td> <?=$data['protocolo_glicemico']['percentual']?>% </td>
			    </tr>			     

			     <tr>
					<td>Média de dose de insulina em 24hs</td>
					<td> <?=$data['total_insulina_ultimas_24_h']['media']?> </td>
					<td> -</td>
			    </tr>

			     <tr>
					<td>Mediana de dose de insulina  em 24hs</td>
					<td> <?=$data['total_insulina_ultimas_24_h']['mediana']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Média de dose de insulina regular subcutânea em 24hs</td>
					<td> <?=$data['insulina_sub_cutanea_em_24h']['media']?> </td>
					<td> -</td>
			    </tr>

			     <tr>
					<td>Mediana de dose de insulina regular subcutânea em 24hs</td>
					<td> <?=$data['insulina_sub_cutanea_em_24h']['mediana']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Valor total de aferições de glicemias no período </td>
					<td> <?=$data['total_afericoes_glicemicas_por_periodo']['soma']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Valor total de aferições de glicemias no período  com glicemias < 60 mg/dl</td>
					<td> <?=$data['total_glicemias_menor_que_60']['soma']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Valor total de aferições de glicemias no período com glicemias < 180 mg/dl</td>
					<td> <?=$data['total_glicemias_maior_que_180']['soma']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Fez uso de insulina nas 24 horas</td>
					<td> <?=$data['fez_insulina_ultimas_24_h']['total']?> </td>
					<td> <?=$data['fez_insulina_ultimas_24_h']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Média de dose total de insulina em 24h</td>
					<td> <?=$data['total_insulina_ultimas_24_h']['media']?> </td>
					<td> - </td>
			    </tr>

			    <tr>
					<td>Mediana de insulina sub cutânea em 24h</td>
					<td> <?=$data['total_insulina_ultimas_24_h']['mediana']?> </td>
					<td> </td>
			    </tr>

			    <tr>
					<td>Média de insulina sub cutânea em 24h</td>
					<td> <?=$data['insulina_sub_cutanea_em_24h']['media']?> </td>
					<td> </td>
			    </tr>

			    <tr>
					<td>Mediana de insulina sub cutânea em 24h</td>
					<td> <?=$data['insulina_sub_cutanea_em_24h']['mediana']?> </td>
					<td> </td>
			    </tr>			    

			    <tr>
					<td>Média de insulina venosa em 24h </td>
					<td> <?=$data['insulina_sub_venosa_em_24h']['media']?> </td>
					<td> </td>
			    </tr>

			    <tr>
					<td>Mediana de insulina venosa em 24h </td>
					<td> <?=$data['insulina_sub_venosa_em_24h']['mediana']?> </td>
					<td> </td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Sedação Analgesia Delirium:</td>
                </tr>

			     <tr>
					<td>Uso de sedação</td>
					<td> <?=$data['sedacao']['total']?> </td>
					<td> <?=$data['sedacao']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Nível de sedação dentro da meta esperada</td>
					<td> <?=$data['sedacao_dentro_da_meta']['total']?> </td>
					<td> <?=$data['sedacao_dentro_da_meta']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Interrupção da sedação</td>
					<td> <?=$data['interrupcao_sedacao']['total']?> </td>
					<td> <?=$data['interrupcao_sedacao']['percentual']?>% </td>
			    </tr>

			     <tr>
					<td>Sob analgesia</td>
					<td> <?=$data['sob_analgesia']['total']?> </td>
					<td> <?=$data['sob_analgesia']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Presença de dor</td>
					<td> <?=$data['apresentou_dor']['total']?> </td>
					<td> <?=$data['apresentou_dor']['percentual']?>% </td>
			    </tr>

			     <tr>
					<td>Avaliação de delirium pelo CAM-ICU</td>
					<td> <?=$data['avaliacao_delirium_pelo_camicu']['total']?> </td>
					<td> <?=$data['avaliacao_delirium_pelo_camicu']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Presença de delirium</td>
					<td> <?=$data['delirium']['total']?> </td>
					<td> <?=$data['delirium']['percentual']?>% </td>
			    </tr>

			  	 <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan="3">Ventilação Mecânica:</td>
                </tr>

                <tr>
					<td>Uso de ventilação mecânica invasiva</td>
					<td> <?=$data['ventilacao_mecanica_invasiva']['total']?> </td>
					<td> <?=$data['ventilacao_mecanica_invasiva']['percentual']?>% </td>
			    </tr>			 

			    <tr>
					<td>PaO2/FiO2  < 300</td>
					<td> <?=$data['pa2_fio2_menor_que_300']['total']?> </td>
					<td> <?=$data['pa2_fio2_menor_que_300']['percentual']?>% </td>
			    </tr>

			     <tr>
					<td>Volume corrente < 8ml/Kg</td>
					<td> <?=$data['volume_corrente_menor_que_8']['total']?> </td>
					<td> <?=$data['volume_corrente_menor_que_8']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Pressão de plateau < 30 cmH2O</td>
					<td> <?=$data['pressao_de_plato_menor_que_30']['total']?> </td>
					<td> <?=$data['pressao_de_plato_menor_que_30']['percentual']?>% </td>
			    </tr>

			     <tr>
					<td>Pode iniciar desmame de ventilação mecânica</td>
					<td> <?=$data['iniciar_desmane']['total']?> </td>
					<td> <?=$data['iniciar_desmane']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Paciente sob ventilação espontânea</td>
					<td> <?=$data['paciente_sob_ventilacao_espontanea']['total']?> </td>
					<td> <?=$data['paciente_sob_ventilacao_espontanea']['percentual']?>% </td>
			    </tr>

			    <tr>
					<td>Pode iniciar teste de respiração espontânea em peça T ou similar</td>
					<td> <?=$data['iniciar_peca_t']['total']?> </td>
					<td> <?=$data['iniciar_peca_t']['percentual']?>% </td>
			    </tr>



			</tbody>		  
		</table>
	</div>
</body>
</html>