<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Neonatal'] ); ?>
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr>
					 <th class="title th-left">Item</th>
					 <th class="title th-right">VA</th>
					 <th class="title th-right">%</th>
					 <th class="title th-right">Média</th>
					 <th class="title th-right">Mediana</th>
					 <th class="title th-right">Desvio padrão</th>
			  </tr>
			</thead>		 
			<tbody>
				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>  Histórico materno</td>
                </tr>

				<tr>
					<td >Paridade</td>
					<td> <?=$data['paridade']['total']?> </td>
					<td> <?=$data['paridade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			  	<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Histórico familiar </td>
                </tr>

			  <tr>
					<td >Enfermidades atuais e significantes em membros da família, consangüinidade.</td>
					<td> <?=$data['enfermidades_atuais']['total']?> </td>
					<td> <?=$data['enfermidades_atuais']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			  </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Histórico neonatal </td>
                </tr>

                <tr>
					<td >Intercorrências no pré-parto e sala de parto</td>
					<td> <?=$data['intercorren_pre_parto']['total']?> </td>
					<td> <?=$data['intercorren_pre_parto']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Boletim de Apgar</td>
					<td> <?=$data['boletim_apgar']['total']?> </td>
					<td> <?=$data['boletim_apgar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Necessidade de reanimação</td>
					<td> <?=$data['necessidade_reanimacao']['total']?> </td>
					<td> <?=$data['necessidade_reanimacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Apto para amamentação</td>
					<td> <?=$data['apto_amamentacao']['total']?> </td>
					<td> <?=$data['apto_amamentacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>




			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Placenta </td>
                </tr>

                <tr>
					<td >Peso</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['placenta_peso']['media']?> </td>
					<td> <?=$data['placenta_peso']['mediana']?> </td>
					<td> <?=$data['placenta_peso']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Coloração e odor alterados</td>
					<td> <?=$data['coloracao_odor_alterado']['total']?> </td>
					<td> <?=$data['coloracao_odor_alterado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
			    	<td >A relação do peso da placenta com peso do RN está adequada</td>
			    	<td> <?=$data['relacao_do_peso_placenta']['total']?> </td>
					<td> <?=$data['relacao_do_peso_placenta']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
			    	<td >Cordão umbilical presente com três vasos</td>
			    	<td> <?=$data['cordao_umbilical_presente']['total']?> </td>
					<td> <?=$data['cordao_umbilical_presente']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
                    <td class="line-separator title" style="font-weight: bold" colspan=6> Medidas e condição ao Nascer </td>
                </tr>

                <tr>
					<td >Peso</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_peso']['media']?> </td>
					<td> <?=$data['ao_nascer_peso']['mediana']?> </td>
					<td> <?=$data['ao_nascer_peso']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Comprimento</td>
					<td>-</td>
					<td>-</td>
					<td> <?=$data['ao_nascer_comprimento']['media']?> </td>
					<td> <?=$data['ao_nascer_comprimento']['mediana']?> </td>
					<td> <?=$data['ao_nascer_comprimento']['desvio_padrao']?> </td>
			    </tr>

			    <tr>
					<td >Classificação do RN</td>
					<td> <?=$data['ao_nascer_classificacao_rn']['total']?> </td>
					<td> <?=$data['ao_nascer_classificacao_rn']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Iluminação e aquecimentos estão adequados</td>
					<td> <?=$data['iluminacao_aquecimento_adequado']['total']?> </td>
					<td> <?=$data['iluminacao_aquecimento_adequado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Pele </td>
                </tr>

			    <tr>
					<td >Icterícia (Zonas de Krammer)</td>
					<td> <?=$data['ictericia']['total']?> </td>
					<td> <?=$data['ictericia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Palidez</td>
					<td> <?=$data['palidez']['total']?> </td>
					<td> <?=$data['palidez']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Descamação fisiológica em pós maturos (pés e mãos) e escamas endurecidas na ictiose congênita</td>
					<td> <?=$data['descamacao_fisiologica']['total']?> </td>
					<td> <?=$data['descamacao_fisiologica']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Nevos pigmentosus (mancha mongólica)</td>
					<td> <?=$data['nevos_pgmentosus']['total']?> </td>
					<td> <?=$data['nevos_pgmentosus']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Linfomas císticos: presentes em qualquer parte do corpo</td>
					<td> <?=$data['linfomas_cisticos']['total']?> </td>
					<td> <?=$data['linfomas_cisticos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Escleredema</td>
					<td> <?=$data['escleredema']['total']?> </td>
					<td> <?=$data['escleredema']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Petéquias e púrpuras</td>
					<td> <?=$data['petequias_e_purpuras']['total']?> </td>
					<td> <?=$data['petequias_e_purpuras']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Hemangioma</td>
					<td> <?=$data['hemangioma']['total']?> </td>
					<td> <?=$data['hemangioma']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Pele espessa, opaca e queratinizada</td>
					<td> <?=$data['pele_espessa']['total']?> </td>
					<td> <?=$data['pele_espessa']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Visibilidade dos vasos e sulcos</td>
					<td> <?=$data['visibilidade_vasos_sulcos']['total']?> </td>
					<td> <?=$data['visibilidade_vasos_sulcos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Lanugem</td>
					<td> <?=$data['lanugem']['total']?> </td>
					<td> <?=$data['lanugem']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Superfície plantar com rugas que se dirigem dos dedos para o calcanhar</td>
					<td> <?=$data['superficie_plantar']['total']?> </td>
					<td> <?=$data['superficie_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Crânio</td>
                </tr>

                <tr>
                	<td>Distância antero-posterior (DAP)</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['distancia_antero_posterior']['media']?> </td>
					<td> <?=$data['distancia_antero_posterior']['mediana']?> </td>
					<td> <?=$data['distancia_antero_posterior']['desvio_padrao']?> </td>
                </tr>

                <tr>
                	<td>Distância biauricular (DBA)</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['distancia_biauricular']['media']?> </td>
					<td> <?=$data['distancia_biauricular']['mediana']?> </td>
					<td> <?=$data['distancia_biauricular']['desvio_padrao']?> </td>
                </tr>

                <tr>
                	<td>Perímetro cefálico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['perimetro_cefalico']['media']?> </td>
					<td> <?=$data['perimetro_cefalico']['mediana']?> </td>
					<td> <?=$data['perimetro_cefalico']['desvio_padrao']?> </td>
                </tr>

                <tr>
                	<td>Índice cefálico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['indice_cefalico']['media']?> </td>
					<td> <?=$data['indice_cefalico']['mediana']?> </td>
					<td> <?=$data['indice_cefalico']['desvio_padrao']?> </td>
                </tr>

                <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Classificação</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226;  Microcefalia</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>
                <tr class="tr-indent">
					<td >&#8226;  Macrocefalia</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>
				<tr class="tr-indent">
					<td >&#8226;  Hidrocefalia</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>
				<tr class="tr-indent">
					<td >&#8226;  Hidranencefalia</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>

                <tr>
					<td >Craniossinostose</td>
					<td> <?=$data['craniossinostose']['total']?> </td>
					<td> <?=$data['craniossinostose']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Céfalo-hematoma</td>
					<td> <?=$data['cefalo_hematoma']['total']?> </td>
					<td> <?=$data['cefalo_hematoma']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Bossa serossanguínea </td>
					<td> <?=$data['bossa_serossanguinea']['total']?> </td>
					<td> <?=$data['bossa_serossanguinea']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Fontanelas adequadas</td>
					<td> <?=$data['fontanelas_adequadas']['total']?> </td>
					<td> <?=$data['fontanelas_adequadas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Ruídos intracranianos</td>
					<td> <?=$data['ruidos_intracranianos']['total']?> </td>
					<td> <?=$data['ruidos_intracranianos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Superfície plantar com rugas que se dirigem dos dedos para o calcanhar </td>
					<td> <?=$data['superficie_plantar']['total']?> </td>
					<td> <?=$data['superficie_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Encefalocele</td>
					<td> <?=$data['encefalocele']['total']?> </td>
					<td> <?=$data['encefalocele']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Cartilagem da orelha e pálpebras com localização e formato adequado  </td>
					<td> <?=$data['cartilagem_da_orelha']['total']?> </td>
					<td> <?=$data['cartilagem_da_orelha']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Crânio- tabes </td>
					<td> <?=$data['cranio_tabes']['total']?> </td>
					<td> <?=$data['cranio_tabes']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Face</td>
                </tr>

                <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Distância entre os olhos</td>
                </tr>
               <tr class="tr-indent">
					<td >&#8226; Cianose</td>
					<td> <?=$data['inspecao_cianose']['total']?> </td>
					<td> <?=$data['inspecao_cianose']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Taquipnéia</td>
					<td> <?=$data['inspecao_taquipneia']['total']?> </td>
					<td> <?=$data['inspecao_taquipneia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Dispnéia</td>
					<td> <?=$data['inspecao_dispneia']['total']?> </td>
					<td> <?=$data['inspecao_dispneia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Alteração da amplitude respiratória</td>
					<td> <?=$data['inspecao_alteracao_amplitudade']['total']?> </td>
					<td> <?=$data['inspecao_alteracao_amplitudade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Abaulamento precordial</td>
					<td> <?=$data['inspecao_abaulamento']['total']?> </td>
					<td> <?=$data['inspecao_abaulamento']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Turgência jugular</td>
					<td> <?=$data['inspecao_turgencia']['total']?> </td>
					<td> <?=$data['inspecao_turgencia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Ictus propulsivo</td>
					<td> <?=$data['inspecao_ictus_propulsivo']['total']?> </td>
					<td> <?=$data['inspecao_ictus_propulsivo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

                <tr>
					<td >Simetria</td>
					<td> <?=$data['face_simetria']['total']?> </td>
					<td> <?=$data['face_simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Aparência sindrômica</td>
					<td> <?=$data['aparencia_sindromica']['total']?> </td>
					<td> <?=$data['aparencia_sindromica']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Implantação das orelhas com localização e formato adequado</td>
					<td> <?=$data['implantacao_das_orelhas']['total']?> </td>
					<td> <?=$data['implantacao_das_orelhas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <!-- <tr>
					<td >Distância entre os olhos (LISTA SUSPENSA: normal, hipetelorismo ou hipotelorismo)</td>
					<td> <?=$data['simetria']['total']?> </td>
					<td> <?=$data['simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr> -->

			    <tr>
					<td >Tamanho do queixo, nariz e língua adequados</td>
					<td> <?=$data['tamanho_do_queixo']['total']?> </td>
					<td> <?=$data['tamanho_do_queixo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Olhos</td>
                </tr>

                <tr>
					<td >Reflexo da lux vermelha</td>
					<td> <?=$data['reflexo_luz_vermelha']['total']?> </td>
					<td> <?=$data['reflexo_luz_vermelha']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Hemorragia subconjuntival</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Estrabismo </td>
					<td> <?=$data['estrabismo']['total']?> </td>
					<td> <?=$data['estrabismo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Pupila branca </td>
					<td> <?=$data['pupila_branca']['total']?> </td>
					<td> <?=$data['pupila_branca']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Opacificação da córnea </td>
					<td> <?=$data['opacificacao_cornea']['total']?> </td>
					<td> <?=$data['opacificacao_cornea']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Secreção ocular presente </td>
					<td> <?=$data['secrecao_ocular_presente']['total']?> </td>
					<td> <?=$data['secrecao_ocular_presente']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Ouvidos</td>
                </tr>

                <tr>
					<td > Forma, tamanho, implantação das orelhas adequadas </td>
					<td> <?=$data['forma_tamanho_implantacao']['total']?> </td>
					<td> <?=$data['forma_tamanho_implantacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Suspeita de alteração na audição </td>
					<td> <?=$data['suspeita_alteracao_audicao']['total']?> </td>
					<td> <?=$data['suspeita_alteracao_audicao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Apêndices pré-auriculares presentes </td>
					<td> <?=$data['apendices_pre_auriculares']['total']?> </td>
					<td> <?=$data['apendices_pre_auriculares']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>



			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Distância entre os olhos</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226;  Normal</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td >&#8226;  Hipetelorismo</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>

				<tr class="tr-indent">
					<td >&#8226;  Hipotelorismo</td>
					<td> <?=$data['hemorragia_subconjuntival']['total']?> </td>
					<td> <?=$data['hemorragia_subconjuntival']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
				</tr>





			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Nariz</td>
                </tr>

                <tr>
					<td > Forma e tamanho adequados</td>
					<td> <?=$data['forma_tamanho_adequados']['total']?> </td>
					<td> <?=$data['forma_tamanho_adequados']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Permeabilidade nasal</td>
					<td> <?=$data['permeabilidade_nasal']['total']?> </td>
					<td> <?=$data['permeabilidade_nasal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Canal nasolacrimal patente</td>
					<td> <?=$data['canal_nasolacrimal']['total']?> </td>
					<td> <?=$data['canal_nasolacrimal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Secreção nasal serossanguinolenta </td>
					<td> <?=$data['secrecao_nasal']['total']?> </td>
					<td> <?=$data['secrecao_nasal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Boca</td>
                </tr>

                <tr>
					<td > Coloração dos lábios alterada  </td>
					<td> <?=$data['coloracao_dos_labios']['total']?> </td>
					<td> <?=$data['coloracao_dos_labios']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Alteração na integridade - lábio leporino</td>
					<td> <?=$data['alteracao_integridade']['total']?> </td>
					<td> <?=$data['alteracao_integridade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Fenda palatina </td>
					<td> <?=$data['fenda_palatina']['total']?> </td>
					<td> <?=$data['fenda_palatina']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Língua com tamanho e mobilização adequada </td>
					<td> <?=$data['lingua_com_tamanho']['total']?> </td>
					<td> <?=$data['lingua_com_tamanho']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Dentes congênitos  </td>
					<td> <?=$data['dentes_congenitos']['total']?> </td>
					<td> <?=$data['dentes_congenitos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >  Rânula </td>
					<td> <?=$data['ranula']['total']?> </td>
					<td> <?=$data['ranula']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Pérolas de Epstein</td>
					<td> <?=$data['perolas_de_epstein']['total']?> </td>
					<td> <?=$data['perolas_de_epstein']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Úvula bífida </td>
					<td> <?=$data['uvula_bifida']['total']?> </td>
					<td> <?=$data['uvula_bifida']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Língua com tamanho e mobilização adequada </td>
					<td> <?=$data['lingua_com_tamanho']['total']?> </td>
					<td> <?=$data['lingua_com_tamanho']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Retrognatia </td>
					<td> <?=$data['retrognatia']['total']?> </td>
					<td> <?=$data['retrognatia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Arqueamento do palato (ogival) </td>
					<td> <?=$data['arqueamento_do_palato']['total']?> </td>
					<td> <?=$data['arqueamento_do_palato']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Pescoço</td>
                </tr>

                <tr>
					<td > Ausência de massas, fístulas e excesso de pele </td>
					<td> <?=$data['ausencia_de_massas']['total']?> </td>
					<td> <?=$data['ausencia_de_massas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Torcicolo congênito </td>
					<td> <?=$data['torcicolo_congenito']['total']?> </td>
					<td> <?=$data['torcicolo_congenito']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Teratoma cervical </td>
					<td> <?=$data['teratoma_cervical']['total']?> </td>
					<td> <?=$data['teratoma_cervical']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Higroma cístico </td>
					<td> <?=$data['higroma_cistico']['total']?> </td>
					<td> <?=$data['higroma_cistico']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Bócio congênito </td>
					<td> <?=$data['bocio_congenito']['total']?> </td>
					<td> <?=$data['bocio_congenito']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Tórax</td>
                </tr>

                <tr>
                	<td>Perímetro torácico</td>
                	<td>-</td>
					<td>-</td>
					<td> <?=$data['perimetro_toracico']['media']?> </td>
					<td> <?=$data['perimetro_toracico']['mediana']?> </td>
					<td> <?=$data['perimetro_toracico']['desvio_padrao']?> </td>
                </tr>

                <tr>
					<td > Simetria </td>
					<td> <?=$data['torax_simetria']['total']?> </td>
					<td> <?=$data['torax_simetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Retrações sub e intercostais </td>
					<td> <?=$data['retracoes_sub_intercostais']['total']?> </td>
					<td> <?=$data['retracoes_sub_intercostais']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr>
					<td > Retrações supra-claviculares </td>
					<td> <?=$data['retracoes_supra_claviculares']['total']?> </td>
					<td> <?=$data['retracoes_supra_claviculares']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Clavículas</td>
                </tr>

                <tr>
					<td > Ausência de clavículas </td>
					<td> <?=$data['ausencia_claviculas']['total']?> </td>
					<td> <?=$data['ausencia_claviculas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Disostose cleido craniana (cleidocrâniodisostose) </td>
					<td> <?=$data['disostose_cleido']['total']?> </td>
					<td> <?=$data['disostose_cleido']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Fraturas </td>
					<td> <?=$data['fraturas']['total']?> </td>
					<td> <?=$data['fraturas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Mamas</td>
                </tr>

                <tr>
					<td> Assimetria </td>
					<td> <?=$data['assimetria']['total']?> </td>
					<td> <?=$data['assimetria']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td> Distância intermamilar </td>
					<td> <?=$data['distancia_intermamilar']['total']?> </td>
					<td> <?=$data['distancia_intermamilar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td > Presença de mamilos extranumerários </td>
					<td> <?=$data['presencao_de_mamilos']['total']?> </td>
					<td> <?=$data['presencao_de_mamilos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame cardiovascular</td>
                </tr>

                
			    <tr>
					<td > Pulsos com sincronia, ritmo e intensidade nos quatro membros </td>
					<td> <?=$data['presencao_de_mamilos']['total']?> </td>
					<td> <?=$data['presencao_de_mamilos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Pulsos equivalentes em comparação dos superiores com os inferiores </td>
					<td> <?=$data['pulsos_equivalentes']['total']?> </td>
					<td> <?=$data['pulsos_equivalentes']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Palpação do precórdio adequada</td>
					<td> <?=$data['palpacao_precordio']['total']?> </td>
					<td> <?=$data['palpacao_precordio']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Pressão pulsátil</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Normal</td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Normal']['tot']?> </td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Normal']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Estreitada</td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Estreitada']['tot']?> </td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Estreitada']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Alargada</td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Alargada']['tot']?> </td>
					<td> <?=$data['ex_cardio_pressao_pulsatil']['Alargada']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Desdobramento de  B1 em bordo esternal esquerdo superior</td>
					<td> <?=$data['desdobramento_de_b1']['total']?> </td>
					<td> <?=$data['desdobramento_de_b1']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Redução de intensidade de B1 em bordo esternal esquerdo superior</td>
					<td> <?=$data['reducao_intensidade']['total']?> </td>
					<td> <?=$data['reducao_intensidade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Aumento de intensidade de B1 em bordo esternal esquerdo inferior</td>
					<td> <?=$data['aumento_intensidade_b1']['total']?> </td>
					<td> <?=$data['aumento_intensidade_b1']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Desdobramento amplo de  B2 em bordo esternal esquerdo superior</td>
					<td> <?=$data['desdobramento_amplo_b2']['total']?> </td>
					<td> <?=$data['desdobramento_amplo_b2']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Hiperfonese de B2 em bordo esternal esquerdo superior</td>
					<td> <?=$data['hiperfonese_b2']['total']?> </td>
					<td> <?=$data['hiperfonese_b2']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de B3 </td>
					<td> <?=$data['presenca_de_b3']['total']?> </td>
					<td> <?=$data['presenca_de_b3']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de B4  </td>
					<td> <?=$data['presenca_de_b4']['total']?> </td>
					<td> <?=$data['presenca_de_b4']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de Estalido de abertura </td>
					<td> <?=$data['presenca_de_estalido_abertura']['total']?> </td>
					<td> <?=$data['presenca_de_estalido_abertura']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de Sopro</td>
					<td> <?=$data['presenca_de_sopro']['total']?> </td>
					<td> <?=$data['presenca_de_sopro']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame Pulmonar </td>
                </tr>

                <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Gemência</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Ausente</td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Ausente']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Ausente']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Audível com esteto</td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Audível com esteto']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Audível com esteto']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Audível sem esteto</td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Audível sem esteto']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_gemencia']['Audível sem esteto']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Batimento de asa de nariz </td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Ausente</td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Ausente']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Ausente']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Discreto</td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Discreto']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Discreto']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Acentuado</td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Acentuado']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_batimento']['Acentuado']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Tiragem intercostal </td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Ausente</td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['Ausente']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['Ausente']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; 3 últimas intercostais</td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['tres_ultimas']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['tres_ultimas']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Mais de 3 intercostais</td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['mais_de_tres']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_tiragem']['mais_de_tres']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Retração esternal</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Ausente</td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Ausente']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Ausente']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Discreto</td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Discreto']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Discreto']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Acentuado</td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Acentuado']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_retracao']['Acentuado']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Balancim</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Ausente</td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Ausente']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Ausente']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Discreto</td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Discreto']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Discreto']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Acentuado</td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Acentuado']['tot']?> </td>
					<td> <?=$data['ex_cardio_pulmonar_balancim']['Acentuado']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Sinal da “dançarina do ventre” </td>
					<td> <?=$data['sinal_dancarina_ventre']['total']?> </td>
					<td> <?=$data['sinal_dancarina_ventre']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de crepitação pulmonar</td>
					<td> <?=$data['presenca_cripitacao_pulmonar']['total']?> </td>
					<td> <?=$data['presenca_cripitacao_pulmonar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de roncos</td>
					<td> <?=$data['presenca_de_roncos']['total']?> </td>
					<td> <?=$data['presenca_de_roncos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Diminuição de murmúrio vesicular</td>
					<td> <?=$data['diminuicao_murmurio_vesicular']['total']?> </td>
					<td> <?=$data['diminuicao_murmurio_vesicular']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de Abdome</td>
                </tr>

                <tr>
					<td >Abdome escavado</td>
					<td> <?=$data['abdome_escavado']['total']?> </td>
					<td> <?=$data['abdome_escavado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Abdome abaulado</td>
					<td> <?=$data['abdome_abaulado']['total']?> </td>
					<td> <?=$data['abdome_abaulado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Adbomen com abaulamento infra-umbilical</td>
					<td> <?=$data['abdomen_abaulamento']['total']?> </td>
					<td> <?=$data['abdomen_abaulamento']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de circulação colateral</td>
					<td> <?=$data['presenca_circulacao_colateral']['total']?> </td>
					<td> <?=$data['presenca_circulacao_colateral']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de ondas peristálticas</td>
					<td> <?=$data['presenca_ondas_peristalticas']['total']?> </td>
					<td> <?=$data['presenca_ondas_peristalticas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Diastáse de músculos reto abdominais</td>
					<td> <?=$data['diastase']['total']?> </td>
					<td> <?=$data['diastase']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Ascite</td>
					<td> <?=$data['ascite']['total']?> </td>
					<td> <?=$data['ascite']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Visceromegalias</td>
					<td> <?=$data['visceromegalias']['total']?> </td>
					<td> <?=$data['visceromegalias']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Distensão gasosa </td>
					<td> <?=$data['distencao_gasosa']['total']?> </td>
					<td> <?=$data['distencao_gasosa']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de massa palpável</td>
					<td> <?=$data['presenca_de_massa_palpavel']['total']?> </td>
					<td> <?=$data['presenca_de_massa_palpavel']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Ausência de ruídos hidroaéreos - íleo paralítico</td>
					<td> <?=$data['ausencia_de_ruidos']['total']?> </td>
					<td> <?=$data['ausencia_de_ruidos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de genitália</td>
                </tr>

                <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Anomalias </td>
                </tr>
                <tr class="tr-indent">
					<td >&#8226; Estenose anal</td>
					<td> <?=$data['anomalia']['1']['tot']?> </td>
					<td> <?=$data['anomalia']['1']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Ânus perineal anterior</td>
					<td> <?=$data['anomalia']['2']['tot']?> </td>
					<td> <?=$data['anomalia']['2']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Fístula anocutânea</td>
					<td> <?=$data['anomalia']['3']['tot']?> </td>
					<td> <?=$data['anomalia']['3']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Ânus vulvar</td>
					<td> <?=$data['anomalia']['4']['tot']?> </td>
					<td> <?=$data['anomalia']['4']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; Fístula anovulvar</td>
					<td> <?=$data['anomalia']['5']['tot']?> </td>
					<td> <?=$data['anomalia']['5']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>


			    <tr class="tr-indent">
					<td >&#8226; Fístula anovestibular</td>
					<td> <?=$data['anomalia']['6']['tot']?> </td>
					<td> <?=$data['anomalia']['6']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr class="tr-indent">
					<td >&#8226; fístula retrovestibular</td>
					<td> <?=$data['anomalia']['7']['tot']?> </td>
					<td> <?=$data['anomalia']['7']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr class="tr-indent">
					<td >&#8226; Atresia retal</td>
					<td> <?=$data['anomalia']['8']['tot']?> </td>
					<td> <?=$data['anomalia']['8']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr class="tr-indent">
					<td >&#8226; Imperfuração anal</td>
					<td> <?=$data['anomalia']['9']['tot']?> </td>
					<td> <?=$data['anomalia']['9']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			     <tr class="tr-indent">
					<td >&#8226; Estenose anal membranosa</td>
					<td> <?=$data['anomalia']['10']['tot']?> </td>
					<td> <?=$data['anomalia']['10']['percen']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Genitália ambígua</td>
					<td> <?=$data['genitalia_ambigua']['total']?> </td>
					<td> <?=$data['genitalia_ambigua']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Sexo masculino</td>
                </tr>

                <tr>
					<td >Comprimento do pênis adequado</td>
					<td> <?=$data['comprimento_do_penis_adequado']['total']?> </td>
					<td> <?=$data['comprimento_do_penis_adequado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Orifício uretral </td>
                </tr>
                <tr class="tr-indent">
					<td >&#8226; Normal</td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Normal']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Normal']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Hipospádia</td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Hipospádia']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Hipospádia']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Epispádia</td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Epispádia']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_orificio']['Epispádia']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Prepúcio sem restrição</td>
					<td> <?=$data['prepucio_sem_restricao']['total']?> </td>
					<td> <?=$data['prepucio_sem_restricao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Testículos</td>
                </tr>
                <tr class="tr-indent">
					<td >&#8226; Na bolsa escrotal</td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['bolsa_escrotal']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['bolsa_escrotal']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; No canal inguinal</td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['canal']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['canal']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Não encontrado</td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['nao_encontrado']['tot']?> </td>
					<td> <?=$data['ex_cardio_genitalia_testiculo']['nao_encontrado']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de hérnias</td>
					<td> <?=$data['presenca_de_hemias']['total']?> </td>
					<td> <?=$data['presenca_de_hemias']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Presença de hidroceles (transiluminação)</td>
					<td> <?=$data['presenca_de_hidroceles']['total']?> </td>
					<td> <?=$data['presenca_de_hidroceles']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Sexo Feminino</td>
                </tr>
                <tr>
					<td >Tamanho do clitóris adequado</td>
					<td> <?=$data['tamanho_do_clitoris_adequado']['total']?> </td>
					<td> <?=$data['tamanho_do_clitoris_adequado']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Fusão dos grandes lábios</td>
					<td> <?=$data['fusao_dos_grandes_labios']['total']?> </td>
					<td> <?=$data['fusao_dos_grandes_labios']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Orifício da vagina e uretra patentes</td>
					<td> <?=$data['orificio_da_vagina_e_uretra']['total']?> </td>
					<td> <?=$data['orificio_da_vagina_e_uretra']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Distância anovulvar adequada</td>
					<td> <?=$data['distancia_anovulvar']['total']?> </td>
					<td> <?=$data['distancia_anovulvar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Presença de fístulas perineais</td>
					<td> <?=$data['presenca_de_fistulas']['total']?> </td>
					<td> <?=$data['presenca_de_fistulas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de Coluna</td>
                </tr>

                <tr>
					<td >Presença de tumores</td>
					<td> <?=$data['presenca_de_tumores']['total']?> </td>
					<td> <?=$data['presenca_de_tumores']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Fossetas ou hipertricose</td>
					<td> <?=$data['fossetas_hipertricose']['total']?> </td>
					<td> <?=$data['fossetas_hipertricose']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Manchas hipercrômicas</td>
					<td> <?=$data['manchas']['total']?> </td>
					<td> <?=$data['manchas']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Seio pilonidal</td>
					<td> <?=$data['seio_pilonidal']['total']?> </td>
					<td> <?=$data['seio_pilonidal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Meningomielocele e mielocele</td>
					<td> <?=$data['meningomielocele']['total']?> </td>
					<td> <?=$data['meningomielocele']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Teratoma sacrococcígeo</td>
					<td> <?=$data['teratoma_sacroroccigeo']['total']?> </td>
					<td> <?=$data['teratoma_sacroroccigeo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de Membros</td>
                </tr>

                <tr>
					<td >Simetria e proporções dos membros </td>
					<td> <?=$data['simetira_proprocoes']['total']?> </td>
					<td> <?=$data['simetira_proprocoes']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Paralisia de membros superiores (total, Duchenne ou Klumke) </td>
					<td> <?=$data['paralisia_membros_superiores']['total']?> </td>
					<td> <?=$data['paralisia_membros_superiores']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Paralisia de membros inferiores </td>
					<td> <?=$data['paralisia_membros_inferiores']['total']?> </td>
					<td> <?=$data['paralisia_membros_inferiores']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Artrogripose </td>
					<td> <?=$data['artogripose']['total']?> </td>
					<td> <?=$data['artogripose']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Pé torto congênito </td>
					<td> <?=$data['pe_torto_congenito']['total']?> </td>
					<td> <?=$data['pe_torto_congenito']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Prega palmar única </td>
					<td> <?=$data['prega_palmar_unica']['total']?> </td>
					<td> <?=$data['prega_palmar_unica']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Osteocondrodisplasia </td>
					<td> <?=$data['osteocondrodisplasia']['total']?> </td>
					<td> <?=$data['osteocondrodisplasia']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Luxação congênita do quadril </td>
					<td> <?=$data['luxacao_congenita']['total']?> </td>
					<td> <?=$data['luxacao_congenita']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Manobra de Ortolani positiva </td>
					<td> <?=$data['manobra_ortolani']['total']?> </td>
					<td> <?=$data['manobra_ortolani']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr>
					<td >Manobra de Barlow com deslocamento da articulação </td>
					<td> <?=$data['manobra_barlow']['total']?> </td>
					<td> <?=$data['manobra_barlow']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de Mecônio e Avaliação de Urina</td>
                </tr>

                <!-- <tr>
					<td >Urina nas primeiras horas de vida</td>
					<td> <?=$data['urina_nas_primeiras']['total']?> </td>
					<td> <?=$data['urina_nas_primeiras']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr> -->
			    <tr>
					<td >Ausência de eliminação intestinal nas primeiras horas de vida </td>
					<td> <?=$data['ausencia_eleminacao_intestinal']['total']?> </td>
					<td> <?=$data['ausencia_eleminacao_intestinal']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame neurológico:</td>
                </tr>               			

                <tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=6>Estado de sono e vigília:</td>
                </tr>

                <tr class="tr-indent">
					<td >&#8226; Olhos fechados</td>
					<td> <?=$data['ex_neuro_estado_sono']['total']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
                			
			    <tr class="tr-indent">
					<td >&#8226; Respiração regular sem movimentos (sono quieto)</td>
					<td> <?=$data['ex_neuro_estado_sono']['respiracao_reg_sem_mov']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['respiracao_reg_sem_mov']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Olhos fechados, respiração irregular e sem movimentos grosseiros (sono ativo)</td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_fechados_resp_irr']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_fechados_resp_irr']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Olhos abertos sem movimentos grosseiros (despertar quieto) </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_sem_mov']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_sem_mov']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
				<tr class="tr-indent">
					<td >&#8226; Olhos abertos com movimentos grosseiros e sem choro (despertar ativo) </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_com_mov']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_com_mov']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Olhos abertos ou fechados e chorando </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_ou_fecha_chorando']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['olhos_abertos_ou_fecha_chorando']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr class="tr-indent">
					<td >&#8226; Coma </td>
					<td> <?=$data['ex_neuro_estado_sono']['coma']['tot']?> </td>
					<td> <?=$data['ex_neuro_estado_sono']['coma']['percentual']?>% </td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

                <tr>
					<td >Postura em flexão generalizada e lateralização da cabeça </td>
					<td> <?=$data['postura_em_flexao']['total']?> </td>
					<td> <?=$data['postura_em_flexao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Movimentação espontânea sem sincronia </td>
					<td> <?=$data['movimentacao_espontanea']['total']?> </td>
					<td> <?=$data['movimentacao_espontanea']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Emissão de sons com choro inarticulado </td>
					<td> <?=$data['emissao_de_sons']['total']?> </td>
					<td> <?=$data['emissao_de_sons']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Tônus passivo e ativo adequado e estado de semiflexão generalizada </td>
					<td> <?=$data['tonus_passivo_e_ativo']['total']?> </td>
					<td> <?=$data['tonus_passivo_e_ativo']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Manobra do arrasto </td>
					<td> <?=$data['manobra_do_arrasto']['total']?> </td>
					<td> <?=$data['manobra_do_arrasto']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Manobra de Tobler </td>
					<td> <?=$data['manobra_de_tobler']['total']?> </td>
					<td> <?=$data['manobra_de_tobler']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Manobras do cachecol, propulsão dos membros inferiores e rechaço dos membros inferiores </td>
					<td> <?=$data['manobras_do_cachecol']['total']?> </td>
					<td> <?=$data['manobras_do_cachecol']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Reflexos superficiais – cutâneo plantar </td>
					<td> <?=$data['reflexos_superficiais']['total']?> </td>
					<td> <?=$data['reflexos_superficiais']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Reflexos arcaicos </td>
					<td> <?=$data['reflexos_arcaicos']['total']?> </td>
					<td> <?=$data['reflexos_arcaicos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Teste de voracidade (PIPER) </td>
					<td> <?=$data['teste_de_voracidade']['total']?> </td>
					<td> <?=$data['teste_de_voracidade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Teste de sucção </td>
					<td> <?=$data['teste_de_succao']['total']?> </td>
					<td> <?=$data['teste_de_succao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Preensão reflexa dos artelhos </td>
					<td> <?=$data['preensao_reflexa_artelhos']['total']?> </td>
					<td> <?=$data['preensao_reflexa_artelhos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Piscamento </td>
					<td> <?=$data['piscamento']['total']?> </td>
					<td> <?=$data['piscamento']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Retirada à estimulação dolorosa </td>
					<td> <?=$data['retirada_a_estimulacao']['total']?> </td>
					<td> <?=$data['retirada_a_estimulacao']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Cutâneo plantar </td>
					<td> <?=$data['cutaneo_plantar']['total']?> </td>
					<td> <?=$data['cutaneo_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Extensão cruzada </td>
					<td> <?=$data['extensao_cruzada']['total']?> </td>
					<td> <?=$data['extensao_cruzada']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Preensão palmar </td>
					<td> <?=$data['preensao_palmar']['total']?> </td>
					<td> <?=$data['preensao_palmar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Manobra do rasto </td>
					<td> <?=$data['manobra_do_rasto']['total']?> </td>
					<td> <?=$data['manobra_do_rasto']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr><tr>
					<td >Urina </td>
					<td> <?=$data['urina_nas_primeiras']['total']?> </td>
					<td> <?=$data['urina_nas_primeiras']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo de Moro </td>
					<td> <?=$data['reflexo_de_moro']['total']?> </td>
					<td> <?=$data['reflexo_de_moro']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo tônico cervical assimétrico (magnus de kleijn) </td>
					<td> <?=$data['reflexo_tonico_cervical_assimetrico']['total']?> </td>
					<td> <?=$data['reflexo_tonico_cervical_assimetrico']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Apoio plantar </td>
					<td> <?=$data['apoio_plantar']['total']?> </td>
					<td> <?=$data['apoio_plantar']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Marcha reflexa </td>
					<td> <?=$data['marcha_reflexa']['total']?> </td>
					<td> <?=$data['marcha_reflexa']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo de Galant </td>
					<td> <?=$data['reflexo_de_galant']['total']?> </td>
					<td> <?=$data['reflexo_de_galant']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Urina </td>
					<td> <?=$data['urina_nas_primeiras']['total']?> </td>
					<td> <?=$data['urina_nas_primeiras']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexos de Landau I e II </td>
					<td> <?=$data['reflexos_de_landau']['total']?> </td>
					<td> <?=$data['reflexos_de_landau']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=6>Exame de pares crânianos:</td>
                </tr>
                <tr>
					<td >Teste do nervo óptico</td>
					<td> <?=$data['teste_do_nervo_optico']['total']?> </td>
					<td> <?=$data['teste_do_nervo_optico']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo vestíbulo-coclear</td>
					<td> <?=$data['reflexo_vestibulo_coclear']['total']?> </td>
					<td> <?=$data['reflexo_vestibulo_coclear']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo cócleo-palpebral</td>
					<td> <?=$data['reflexo_cocleo_palpebral']['total']?> </td>
					<td> <?=$data['reflexo_cocleo_palpebral']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Reflexo miotáticos: naso-palpebral, bicipital,tricipital,patelar e aquileu</td>
					<td> <?=$data['reflexos_miotaticos']['total']?> </td>
					<td> <?=$data['reflexos_miotaticos']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>
			    <tr>
					<td >Teste de sensibilidade</td>
					<td> <?=$data['teste_de_sensibilidade']['total']?> </td>
					<td> <?=$data['teste_de_sensibilidade']['percentual']?>%</td>
					<td>-</td>
					<td>-</td>
					<td>-</td>
			    </tr>

			</tbody>
		</table>
	</div>
</body>
</html>