<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>
	<style type="text/css">
        table {
            border-collapse: collapse;
        }


        tbody tr td, .border th {
          border-right: solid 1px #ccc;
          border-left: solid 1px #ccc;
        }

         .border th {
          border-top: solid 1px #ccc;
        }

        tbody tr td {
            text-align: center;
        }

        tbody tr td:first-child {
            text-align: left;
        }
    </style>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório de Checklist Cirúrgico'] ); ?>
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
				<tr class="border">
                    <th rowspan="2" class="title  th-left">Item</th>
                    <?php foreach ($data['dates'] as $key => $month): ?>
                         <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                     <?php endforeach;?>
                </tr>
                <tr class="border">
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <th class="title  th-left">VA</th>
                        <th class="title  th-left">%</th>
                    <?php endforeach;?>
                </tr>
			</thead>		 
			<tbody>
				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >  Cirurgias na Unidade  Durante o Período </td>
                </tr>

				<tr>
					<td >Total de cirurgias na unidade no período</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td><?=$month['total_de_registros']?></td>
                        <td>--</td>
                    <?php endforeach;?>
			    </tr>

			    <tr class="yolo">
					<td>Total de pacientes submetidos a cirurgia no período</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td><?=$month['tot_pacientes_com_cirurgia']?></td>
                        <td>--</td>
                    <?php endforeach;?>
			  	</tr>

				<tr >
                    <td class="line-separator title" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?>> Avaliações do Checklist </td>
                </tr>

                <tr>
					<td >Total avaliações pelo checklist cirúrgico</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
                    <?php endforeach;?>
			    </tr>

			    <tr>
					<td >Valor percentual de avaliações de checklist pelo total de cirurgias na unidade no período</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> - </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
                    <?php endforeach;?>

			    </tr>

			    <tr>
					<td >Avaliações de checklist por tipo de cirurgia (n, %)</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			  	<tr class="yolo">
                    <td class="line-separator title yolo" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >  Pacientes com Avaliação Incompleta do Checklist </td>
                </tr>
                <tr>
					<td >Total de pacientes com checklists incompletos no período (n)</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>
			    <tr>
					<td >Valor percentual de avaliações de checklist incompleto pelo total de cirurgias na unidade no período (%)</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>
			    <tr>
					<td >Avaliações de checklist inconpletas por tipo de internação (n, %)</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			  	<tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >  Time in - entrada no centro cirúrgico </td>
                </tr>

                <tr>
					<td >Checado dois identificadores do paciente</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checado_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checado_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Checado paciente e cirurgia agendada</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checado_paciente_e_cirurgia_agendada']['total']?> </td>
						<td> <?=$month['checado_paciente_e_cirurgia_agendada']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Avaliação pré-anestésica realizada</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['avaliacao_pre_anestesica_realizada']['total']?> </td>
						<td> <?=$month['avaliacao_pre_anestesica_realizada']['percentual']?></td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Anestésico preenchido</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['termo_de_consentimento_anestesico_preenchido']['total']?> </td>
						<td> <?=$month['termo_de_consentimento_anestesico_preenchido']['percentual']?></td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Cirúrgico preenchido</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['total']?> </td>
						<td> <?=$month['checar_dois_identificadores_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Sítio Demarcado</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['sitio_demarcado']['total']?> </td>
						<td> <?=$month['sitio_demarcado']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Conferência de Lateralidade</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['conferencia_de_lateralidade']['total']?> </td>
						<td> <?=$month['conferencia_de_lateralidade']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Realizado anamnese e exame físico do paciente</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['realizado_anamnese_e_exame_fisico_do_paciente']['total']?> </td>
						<td> <?=$month['realizado_anamnese_e_exame_fisico_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Se Transplante, anexaro impresso do cheklist de recepção do orgâo</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['se_transplante_anexaro_impresso_do_cheklist_de_recepcao_do_orgao']['total']?> </td>
						<td> <?=$month['se_transplante_anexaro_impresso_do_cheklist_de_recepcao_do_orgao']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >Time out - antes da indução anestésica</td>
                </tr>

			    <tr>
					<td>As informações do paciente foram confirmadas</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['informacoes_do_paciente_foram_confirmadas']['total']?> </td>
						<td> <?=$month['informacoes_do_paciente_foram_confirmadas']['percentual']?></td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >O antibiótico profilático foi adminsitrado 60 minutos antes da cirurgia</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['realizado_antibiotico_profilatico_60_minutos_antes_da_cirurgia']['total']?> </td>
						<td> <?=$month['realizado_antibiotico_profilatico_60_minutos_antes_da_cirurgia']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Materiais / Implantes estão funcionantes e disponíveis</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['materiais_implantes_estao_funcionantes_e_disponiveis']['total']?> </td>
						<td> <?=$month['materiais_implantes_estao_funcionantes_e_disponiveis']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Equipamentos cirúrgicos estão checados pela engenharia clínica</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['equipamentos_cirurgicos_estao_checados_pela_engenharia_clinica']['total']?> </td>
						<td> <?=$month['equipamentos_cirurgicos_estao_checados_pela_engenharia_clinica']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Anestésico preenchido</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['termo_de_consentimento_anestesico_preenchido']['total']?> </td>
						<td> <?=$month['termo_de_consentimento_anestesico_preenchido']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Termo de Consentimento Cirúrgico preenchido</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['termo_de_consentimento_cirurgico_preenchido_antes_inducao']['total']?> </td>
						<td> <?=$month['termo_de_consentimento_cirurgico_preenchido_antes_inducao']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Sítio Demarcado</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['sitio_demarcado_antes_inducao']['total']?> </td>
						<td> <?=$month['sitio_demarcado_antes_inducao']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Conferência de lateralidade</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['conferencia_de_lateralidade_antes_inducao']['total']?> </td>
						<td> <?=$month['conferencia_de_lateralidade_antes_inducao']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Laringoscópio adequado, testado e disponível</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['laringoscopio_adequado_testado_disponivel']['total']?> </td>
						<td> <?=$month['laringoscopio_adequado_testado_disponivel']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Máscara de oxigenação e máscara de ventilação adequadas, testadas e disponíveis</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['mascara_de_oxigenacao_e_mascara_de_ventilacao_adequadas']['total']?> </td>
						<td> <?=$month['mascara_de_oxigenacao_e_mascara_de_ventilacao_adequadas']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Aspirador adequado, testado e disponível</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['aspirador_adequado']['total']?> </td>
						<td> <?=$month['aspirador_adequado']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Seringas estão identificadas?</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['seringas_estao_identificadas']['total']?> </td>
						<td> <?=$month['seringas_estao_identificadas']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Monitorização do paciente está funcionando </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['monitorizacao_do_paciente_esta_funcionando']['total']?> </td>
						<td> <?=$month['monitorizacao_do_paciente_esta_funcionando']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Paciente com via aérea difícil ou risco presumido </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['paciente_com_via_aerea_dificil_ou_risco_presumido']['total']?> </td>
						<td> <?=$month['paciente_com_via_aerea_dificil_ou_risco_presumido']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Kit de via aérea difícil está disponível </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['kit_de_via_aerea_dificil_esta_disponivel']['total']?> </td>
						<td> <?=$month['kit_de_via_aerea_dificil_esta_disponivel']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Paciente tem alergia ou suspeita </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['paciente_tem_alergia_ou_suspeita']['total']?> </td>
						<td> <?=$month['paciente_tem_alergia_ou_suspeita']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Profilaxia para Tromboembolismo Venoso </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['profilaxia_para_tromboembolismo_venoso']['total']?> </td>
						<td> <?=$month['profilaxia_para_tromboembolismo_venoso']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Perda sanguínea estimada em até 500ml em adulto ou 7ml/kg de peso em crianças </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['perda_sanguinea_estimada']['total']?> </td>
						<td> <?=$month['perda_sanguinea_estimada']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Solicitado reserva de sangue </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['solicitado_reserva_de_sangue']['total']?> </td>
						<td> <?=$month['solicitado_reserva_de_sangue']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >A reserva de sangue está disponível </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['a_reserva_de_sangue_esta_disponivel']['total']?> </td>
						<td> <?=$month['a_reserva_de_sangue_esta_disponivel']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Paciente está com acesso venoso central </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['paciente_esta_com_acesso_venoso_central']['total']?> </td>
						<td> <?=$month['paciente_esta_com_acesso_venoso_central']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Há dois acessos venosos calibrosos disponíveis </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['ha_dois_acessos_venosos_calibrosos_disponiveis']['total']?> </td>
						<td> <?=$month['ha_dois_acessos_venosos_calibrosos_disponiveis']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			     <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >Time out - antes da incisão cirúrgica</td>
                </tr>

			    <tr>
					<td >Checar paciente e cirurgia agendada </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checar_paciente_e_cirurgia_agendada']['total']?> </td>
						<td> <?=$month['checar_paciente_e_cirurgia_agendada']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Checagem da Equipe em sala operatória </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['checagem_da_equipe_em_sala_operatoria']['total']?> </td>
						<td> <?=$month['checagem_da_equipe_em_sala_operatoria']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Todos os Materiais , Implantes e Equipamentos estão funcionantes e disponíveis </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['todos_materiais_implantes_equipamentos_funcionantes_disponiveis']['total']?> </td>
						<td> <?=$month['todos_materiais_implantes_equipamentos_funcionantes_disponiveis']['percentual']?></td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Realizado antibiótico profilático  </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['realizado_antibiotico_profilatico']['total']?> </td>
						<td> <?=$month['realizado_antibiotico_profilatico']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Equipe e material para exame de imagem e laboratoriais estão em sala </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['equipe_material_exame_imagem_laboratoriais_estao_em_sala']['total']?> </td>
						<td> <?=$month['equipe_material_exame_imagem_laboratoriais_estao_em_sala']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Há necessidade de congelação / patologista </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['ha_necessidade_de_congelacao_patologista']['total']?> </td>
						<td> <?=$month['ha_necessidade_de_congelacao_patologista']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Os frascos estão disponíveis </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['os_frascos_estao_disponiveis']['total']?> </td>
						<td> <?=$month['os_frascos_estao_disponiveis']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Solicitado reserva de sangue </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['solicitado_reserva_de_sangue_incisao_cirurgica']['total']?> </td>
						<td> <?=$month['solicitado_reserva_de_sangue_incisao_cirurgica']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >A reserva de sangue está disponível </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['a_reserva_de_sangue_esta_disponivel_incisao_cirurgica']['total']?> </td>
						<td> <?=$month['a_reserva_de_sangue_esta_disponivel_incisao_cirurgica']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >A condição clinica do paciente está adequada para realizar a cirurgia </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['condicao_clinica_paciente_adequada_para_realizar_cirurgia']['total']?> </td>
						<td> <?=$month['condicao_clinica_paciente_adequada_para_realizar_cirurgia']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Materiais de instrumentação cirúrgica estão estéreis e disponíveis </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['materiais_instrumentacao_cirurgica_estao_estereis_disponiveis']['total']?> </td>
						<td> <?=$month['materiais_instrumentacao_cirurgica_estao_estereis_disponiveis']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr >
                    <td class="line-separator title t-center" style="font-weight: bold" colspan=<?= ($count_mes * 2) + 1 ?> >Check out</td>
                </tr>

			    <tr>
					<td >Contagem de Compressas </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['contagem_de_compressas']['total']?> </td>
						<td> <?=$month['contagem_de_compressas']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Realizado congelação </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['realizado_congelacao']['total']?> </td>
						<td> <?=$month['realizado_congelacao']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Peça cirúrgica encaminhada para anatomia patológica </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['peca_cirurgica_encaminhada_para_anatomia_patologica']['total']?> </td>
						<td> <?=$month['peca_cirurgica_encaminhada_para_anatomia_patologica']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Identificado a peça com etiqueta ou dados do paciente </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['identificado_a_peça_com_etiqueta_ou_dados_do_paciente']['total']?> </td>
						<td> <?=$month['identificado_a_peça_com_etiqueta_ou_dados_do_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Amostras biológicas / material para estudo compatível com etiqueta do paciente </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']['total']?> </td>
						<td> <?=$month['amostras_biologicas_material_estudo_compativel_etiqueta_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Soros, infusões, medicamentos e fluidos administrados ao paciente estão devidamente identificados?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['soros_infusoes_medicamentos_paciente_devidamente_identificados']['total']?> </td>
						<td> <?=$month['soros_infusoes_medicamentos_paciente_devidamente_identificados']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Pulseira de identificação devidamente instalada no paciente?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['pulseira_de_identificacao_devidamente_instalada_no_paciente']['total']?> </td>
						<td> <?=$month['pulseira_de_identificacao_devidamente_instalada_no_paciente']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Há algum evento previnido com o TME OUT?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['ha_algum_evento_previnido_com_o_tmeout']['total']?> </td>
						<td> <?=$month['ha_algum_evento_previnido_com_o_tmeout']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr >
					<td >Nível de Consciência?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['aspirador_adequado']['total']?> </td>
						<td> <?=$month['aspirador_adequado']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Sonda vesical de demora ?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['sonda_vesical_de_demora']['total']?> </td>
						<td> <?=$month['sonda_vesical_de_demora']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Sonda nasogástrica ?  (n, %) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['sonda_nasogastrica']['total']?> </td>
						<td> <?=$month['sonda_nasogastrica']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Houve instalação de Dreno? </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['houve_instalacao_de_dreno']['total']?> </td>
						<td> <?=$month['houve_instalacao_de_dreno']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Cateter venoso periférico funcionante </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['cateter_venoso_periferico_funcionante']['total']?> </td>
						<td> <?=$month['cateter_venoso_periferico_funcionante']['percentual']?></td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Cateter venoso central </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['cateter_venoso_central']['total']?> </td>
						<td> <?=$month['cateter_venoso_central']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>
			    <tr>
					<td >Cateter arterial </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['cateter_arterial']['total']?> </td>
						<td> <?=$month['cateter_arterial']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>

			    <tr>
					<td >Envio do prontuário completo ( relatório de cirurgia, ficha anatomo patológica, ficha de recuperação anestésica, ficha de monitorização anestésica e integradores) </td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td> <?=$month['anestesica_integradores']['total']?> </td>
						<td> <?=$month['anestesica_integradores']['percentual']?> </td>
					<?php endforeach;?>
			    </tr>
			</tbody>
		</table>
	</div>
</body>
</html>