<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<?=$this->Html->css('pdf', ['fullBase' => true]);?>
	<?=$this->fetch('css')?>

	<style type="text/css">
		table {
		    border-collapse: collapse;
		}


		tbody tr td, .border th {
		  border-right: solid 1px #ccc;
		  border-left: solid 1px #ccc;
		}

		 .border th {
		  border-top: solid 1px #ccc;
		}

		tbody tr td {
		    text-align: center;
		}

		tbody tr td:first-child {
		    text-align: left;
		}	
	</style>
</head>
<body>
	<?= $this->element( 'header-logo', ['report_title'=>'Relatório do Checklist Cirurgia Cardíaca'] ); ?>	
	<div class="container">
		<table class="aileron_thin" style="width:100%; border-collapse: collapse;">
			<thead>
                <tr class="border">
                     <th rowspan="2" class="title  th-left">Item</th>
                     <?php foreach ($data['dates'] as $key => $month): ?>
                         <th colspan="2" class="title th-spread"> <?=$month_name[$key];?>  </th>
                     <?php endforeach;?>
                </tr>
                <tr class="border">
                    <?php foreach ($data['dates'] as $key => $month): ?>
                        <th class="title  th-left">VA</th>
                        <th class="title  th-left">%</th>
                     <?php endforeach;?>
                </tr>
            </thead>
			<tbody>
				<tr>
					<td class="line-separator"  style="font-weight: bold; text-align: left;">Antes da indução anestésica</td>
					<?php foreach ($data['dates'] as $key => $month): ?>     
						<td class="centralizar_table">-</td>
						<td class="centralizar_table">-</td>
					<?php endforeach; ?>     
				</tr>
				<tr>
					<td >Confirmação das informações do paciente</td>
					
					<?php foreach ($data['dates'] as $key => $month): ?>     
						<td class="centralizar_table"> <?=$month['as_informacoes_do_paciente_foram_confirmadas']['total']?> </td>
						<td class="centralizar_table"> <?=$month['as_informacoes_do_paciente_foram_confirmadas']['percentual']?></td>
					<?php endforeach; ?>     
			  	</tr>

				<tr>
					<td>Os consentimentos de cirurgia e anestesia foram assindados</td>
					<?php foreach ($data['dates'] as $key => $month): ?>
						<td class="centralizar_table"><?=$month['o_consentimento_cirurgico_anestesico_foi_assinado']['total']?></td>
						<td class="centralizar_table"><?=$month['o_consentimento_cirurgico_anestesico_foi_assinado']['percentual']?></td>
					<?php endforeach; ?> 
				</tr>

				<tr>
					<td>Marcado o local da cirurgia</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel']['total']?> </td>
						<td class="centralizar_table"> <?=$month['visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel']['percentual']?> </td>
					<?php endforeach; ?>    
				</tr>

				<tr>
					<td>A ficha anestésica foi completada</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['a_ficha_anestesica_esta_completa']['total']?> </td>
						<td class="centralizar_table"> <?=$month['a_ficha_anestesica_esta_completa']['percentual']?> </td>
					<?php endforeach; ?>    
				</tr>

				<tr>
					<td>Os recursos humanos necessários estavam disponíveis</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['os_recursos_humanos_estao_disponiveis']['total']?> </td>
						<td class="centralizar_table"> <?=$month['os_recursos_humanos_estao_disponiveis']['percentual']?> </td>
					<?php endforeach; ?>    
				</tr>

				<tr>
					<td>Os equipamentos foram verificados</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['os_equipamentos_foram_verificados']['total']?> </td>
						<td class="centralizar_table"> <?=$month['os_equipamentos_foram_verificados']['percentual']?> </td>
					<?php endforeach; ?>    
				</tr>
		
				<tr>
					<td>A monitorização ideal foi colocada e estava funcionante</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['monitorizacao_standard_colocada_e_funcionante']['total']?> </td>
						<td class="centralizar_table"> <?=$month['monitorizacao_standard_colocada_e_funcionante']['percentual']?> </td>
					<?php endforeach; ?>    
			     </tr>

				<tr>
					<td>Acesso venoso adequado</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['acesso_venoso_adequado']['total']?> </td>
						<td class="centralizar_table"> <?=$month['acesso_venoso_adequado']['percentual']?> </td>
					<?php endforeach; ?>    
		        </tr>

				<tr>
					<td>Havia relato de alergia</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['alguma_alergia_conhecida']['total']?> </td>
						<td class="centralizar_table"> <?=$month['alguma_alergia_conhecida']['percentual']?> </td>
					<?php endforeach; ?>    
			     </tr>

				<tr>
					<td>Reconhecido via aérea difícil ou risco de aspiração</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['via_aerea_dificil_risco_de_aspiracao']['total']?> </td>
						<td class="centralizar_table"> <?=$month['via_aerea_dificil_risco_de_aspiracao']['percentual']?> </td>
					<?php endforeach; ?>    
			    </tr>

				<tr>
					<td>Fluidoterapia / sangue estava disponível de acordo com o protocolo</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']['total']?> </td>
						<td class="centralizar_table"> <?=$month['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']['percentual']?> </td>
					<?php endforeach; ?>    
			    </tr>


				<tr>
					<td class="line-separator" style="font-weight: bold; text-align: left;">Antes da incisão da pele</td>
					<?php foreach ($data['dates'] as $key => $month): ?>     
						<td class="centralizar_table">-</td>
						<td class="centralizar_table">-</td>
					<?php endforeach; ?>   
				</tr>

				<tr>
					<td>Nome e função das pessoas não habituais na sala foram confirmadas</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']['total']?> </td>
						<td class="centralizar_table"> <?=$month['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']['percentual']?> </td>
					<?php endforeach; ?>    
			     </tr>
				<tr>
					<td class="line-separator" style="font-weight: bold; text-align: left;">Antes de sair da sala de operações</td>
					<?php foreach ($data['dates'] as $key => $month): ?>     
						<td class="centralizar_table">-</td>
						<td class="centralizar_table">-</td>
					<?php endforeach; ?>   
				</tr>
				<tr>
					<td>Procedimento cirúrgico realizado</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['procedimento_cirurgico_realizado']['total']?> </td>
						<td class="centralizar_table"> <?=$month['procedimento_cirurgico_realizado']['percentual']?> </td>
					<?php endforeach; ?>    
		        </tr> 

				<tr>
					<td>Contagem correta de compressa, instrumentos e materiais corto-perfurantes</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['contagem_correta_de_compressas']['total']?> </td>
						<td class="centralizar_table"> <?=$month['contagem_correta_de_compressas']['percentual']?> </td>
					<?php endforeach; ?>    
			     </tr>

				<tr>
					<td>Peças anatômicas e produtos para análise corretamente identificadas</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['pecas_anatomicas_e_produtos']['total']?> </td>
						<td class="centralizar_table"> <?=$month['pecas_anatomicas_e_produtos']['percentual']?> </td>
					<?php endforeach; ?>    
			    </tr>

				<tr>
					<td>Anestesista, cirurgião e enfermeiro reveem as necessidades pós operatórias</td>
					<?php foreach ($data['dates'] as $key => $month): ?>   
						<td class="centralizar_table"> <?=$month['necessidades_pos_operatorias_revistas']['total']?> </td>
						<td class="centralizar_table"> <?=$month['necessidades_pos_operatorias_revistas']['percentual']?> </td>
					<?php endforeach; ?>    
			    </tr>
			</tbody>

		</table>
	</div>
</body>
</html>