<?php

if ($current_state == 'internacao')
{
    echo $this->element('internacao-menu');
}
else
{
    echo $this->element('screening-menu');
}

if (!isset($numberOfMedications))
{
    $numberOfMedications = 0;
}

//$via = ['IV'=>'IV', 'SC'=>'SC'];
$via = ['VO' => 'VO', 'CNE' => 'CNE', 'CNG' => 'CNG', 'GTT' => 'GTT', 'IV' => 'IV', 'IM' => 'IM', 'SC' => 'SC', 'Tópico' => 'Tópico', 'Retal' => 'Retal', 'Nasal' => 'Nasal', 'Ocular' => 'Ocular', 'NBZ' => 'NBZ'];

//$frequencies = ['1X DIA'=>'1X DIA','BI'=>'BI','12/12 H'=>'12/12 H','6/6 H'=>'6/6 H','SOS'=>'SOS'];
$frequencies = ['1X SEM' => '1X SEM', 'SEG QUA SEX' => 'SEG QUA SEX', 'TER QUI SAB' => 'TER QUI SAB', '1X DIA' => '1X DIA', '12/12 H' => '12/12 H', '8/8 H' => '8/8 H', '6/6 H' => '6/6 H', '4/4 H' => '4/4 H', '3/3 H' => '3/3 H', '2/2 H' => '2/2 H', '1/1 H' => '1/1 H', 'ACM' => 'ACM', 'SOS' => 'SOS', 'BI' => 'BI', 'DIA ALTERNADO' => 'DIA ALTERNADO'];

$signs_opt = [];

foreach ($signs as $key => $value)
{
    $signs_opt[$value['id']] = $this->Html->imageurl('uploads/' . $value['filename'], ['fullBase' => true]);
}

?>


<div  class="prescriptions form col-md-9 columns content">
    <?=$this->Form->create($prescription, ['id' => 'prescription-form'])?>
    <fieldset>

        <?php
// echo $this->Form->input('precaution', [ 'empty'=>true, 'label'=>['text'=>'Precaução:', 'class'=>'form-input'] ]);
// echo $this->Form->input('germs', [ 'empty'=>true, 'label'=>['text'=>'Germe:', 'class'=>'form-input'] ]);
// echo $this->Form->input('nutrition', [ 'empty'=>true, 'label'=>['text'=>'Nutrição:', 'class'=>'form-input'] ]);
// echo $this->Form->input('allergy', [ 'empty'=>true, 'label'=>['text'=>'Alergias:', 'class'=>'form-input'] ]);
// echo $this->Form->input('speech_therapy', [ 'empty'=>true, 'label'=>['text'=>'Fonoaudiologia:', 'class'=>'form-input'] ]);
// echo $this->Form->input('odontology', [ 'empty'=>true, 'label'=>['text'=>'Odontologia:', 'class'=>'form-input'] ]);

if ($current_state == "internacao")
{
    echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);
}
else
{
    echo $this->Form->hidden('screening_id', ['value' => $screening_id]);
}

?>

        <br>
        <button type="button" class="btn link-bt" data-toggle="modal" data-target="#myModal">Adicionar Medicamento / Procedimento</button>
        <br><br>

        <table class="table table-striped table-hover" id="medications-table">
            <thead>
                <tr>
                    <th>Medicamento / Procedimento</th>
                    <th>Dosagem</th>
                    <th>Via de Administração</th>
                    <th>Frequência</th>
                    <th>Data de ínicio</th>
                    <th>Data de término</th>
                    <th class="actions"><?=__('Ações')?></th>
                </tr>
            </thead>
            <tbody id='tbody'>
                <?php

foreach ($lastPrescription as $key => $medication): ?>
                <tr class="medication-data-<?=$key?>">
                    <td class="medication-name"><?=h($medication->name)?></td>
                    <td class="medication-dosage"><?=h($medication->dosage)?></td>
                    <td class="medication-channel"><?=h($medication->channel)?></td>
                    <td class="medication-frequency"><?=h($medication->frequency)?></td>
                    <td class="med-start-date"><?=h($medication->start_date)?></td>
                    <td class="med-end-date"><?=h($medication->end_date)?></td>

                    <td class="actions" style="white-space:nowrap">
                        <a href="#" class="btn btn-danger btn-xs" onclick="deleteMedication('<?=$key?>')">Deletar</a>
                    </td>
                </tr>

                <div class="medication-data-<?=$key?>" style="display:none">
                    <input value="<?=$medication->name?>" name="medications[<?=$key?>][name]">
                    <input value="<?=$medication->dosage?>" name="medications[<?=$key?>][dosage]">
                    <input value="<?=$medication->channel?>" name="medications[<?=$key?>][channel]">
                    <input value="<?=$medication->frequency?>" name="medications[<?=$key?>][frequency]">
                    <input value="<?=$medication->start_date?>" name="medications[<?=$key?>][start_date]">
                    <input value="<?=$medication->end_date?>" name="medications[<?=$key?>][end_date]">
                </div>
            <?php endforeach?>
            </tbody>
        </table>

        <button type="button" class="btn btn-danger" onclick="goBack()">Cancelar</button>
        <?=$this->Form->button(__('Salvar'))?>
        <?=$this->Form->end()?>
    </fieldset>



</div>

<!-- Modal -->
        <div id="myModal" class="modal fade" role="dialog">
          <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
              <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Adicionar Medicamento / Procedimento</h4>
              </div>

              <div class="modal-body">
                <form id='dummy-form'>
                <div class="content">

                <div class="form-group select">
                    <select id="medications-0-sign-id" name='medications[][sign_id]'>
                        <?php

foreach ($signs as $key => $value): ?>
                            <option name="medications[<?=$key;?>][sign_id]" value=<?=$value['id'];?> data-imagesrc= <?=$this->Html->imageurl('uploads/' . $value['filename'], ['fullBase' => true]);?>> <?=$value['description'];?></option>
                        <?php endforeach?>
                    </select>
                </div>
                <div id="medication-fields">
                    <?php

echo $this->Form->hidden('medications.0.professional_id', ['value' => 1, 'empty' => true, 'label' => false]);

echo $this->Form->input('medications.0.name', ['class' => 'medication-name', 'required' => true, 'empty' => true, 'label' => ['text' => 'Medicamento / Procedimento:', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.dosage', ['class' => 'medication-dosage', 'required' => true, 'empty' => true, 'label' => ['text' => 'Dosagem:', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.frequency', ['class' => 'medication-frequency', 'options' => $frequencies, 'required' => true, 'empty' => true, 'label' => ['text' => 'Frequência:', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.channel', ['options' => $via, 'empty' => true, 'class' => 'medication-channel', 'label' => ['text' => 'Via de Administração:', 'class' => 'form-input']]);

echo '<div class="funkyradio imediato">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('medications.0.imediato', ['id' => 'imediato']);
echo '<label for="imediato">Imediato</label>';
echo "</div>";
echo "</div>";

echo "<div class='start_time'><br>";

echo $this->Form->input('medications.0.start_date', ['type' => 'text', 'class' => 'date time_inputs med-start-date', 'label' => ['text' => 'Data de Inicio:', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.end_date', ['type' => 'hidden', 'class' => 'date time_inputs med-end-date', 'label' => ['text' => 'Data de Inicio:', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.start_time', ['type' => 'text', 'class' => 'time time_inputs', 'label' => ['text' => 'Hora de Inicio:', 'class' => 'form-input']]);

echo "</div>";

echo $this->Form->input('medications.0.using_time', ['type' => 'number', 'min' => 0, 'required' => true, 'class' => 'number', 'label' => ['text' => 'Tempo de uso (dias):', 'class' => 'form-input']]);

echo $this->Form->input('medications.0.observation', ['type' => 'textarea', 'label' => ['text' => 'Observação:', 'class' => 'form-input']]);

echo '<div class="funkyradio">';
    echo '<div class="funkyradio-primary">';
        echo $this->Form->checkbox('medications.0.dispensacao_controlada', ['id'=>'dispensacao_controlada']);
        echo '<label for="dispensacao_controlada">Dispensação controlada</label>';
    echo "</div>";
echo "</div>";

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('medications.0.is_antibiotic', ['class' => "active_checked", 'id' => 'is_antibiotic']);
echo '<label for="is_antibiotic">Esse medicamento é um antibiótico?</label>';
echo "</div>";
echo "</div>";

echo "<div class='hide-element is_antibiotic'><br>";
echo $this->Form->input('medications.0.justificativa_antibiotico', ['type' => 'textarea', 'label' => ['text' => 'Justificativa para emprego de antibiótico:', 'class' => 'form-input']]);

echo '<div class="funkyradio">';
echo '<div class="funkyradio-primary">';
echo $this->Form->checkbox('medications.0.cultura', ['onchange' => "javascript:toggleElement('.cultura_resultado');", 'id' => 'cultura']);
echo '<label for="cultura">Cultura</label>';
echo "</div>";
echo "</div>";

echo "<div class='hide-element cultura_resultado'><br>";

echo "  <label>Resultado de cultura</label>";

echo $this->Form->input('medications.0.cultures._ids', ['button'=>['class'=>'bt-margin '],'class'=>'multiselect', 'options'=>$cultures_with_germs, 'label'=>['text'=>'','class'=>'form-input '],'type' => 'select', 'multiple' => true]);

// echo '<div class="funkyradio">';

// foreach ($cultures_with_germs as $key => $cultura)
// {
//     echo '<div class="funkyradio-primary">';
//     echo $this->Form->checkbox('medications.0.cultures._ids[]', ['id' => 'germe-' . $key, 'value' => $key]);
//     echo "<label for='germe-$key'>";
//     echo $cultura;
//     echo '</label>';
//     echo "</div>";
// }

// echo "</div>";

echo "</div>";
echo "</br>";

?>
                </div>
                </div>
                </form>
              </div>
              <br>
              <div class="modal-footer">
                <button id="close-modal" type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-default" id="save-modal">Salvar</button>
              </div>
            </div>

          </div>
        </div>



<script>

function getEndDate(date, days) {
    var dias = days;
    console.log('String do campo end date '+date);

    date              = date.split('/');
    var dataFormatada = date[1] + '-' + date[0] + '-' + date[2];

    console.log('String formatada ISO americana '+ dataFormatada);

    var dataAtual = new Date(dataFormatada);
    var previsao  = new Date();

    console.log('Objeto date ' + dataAtual);


    previsao.setDate(dataAtual.getDate() + dias);
    endDate = previsao.getDate()  +"/" + (previsao.getMonth() + 1)+ "/" + previsao.getFullYear();
    console.log(endDate);
    return endDate;

}


function getStartDate(){

    Date.prototype.toMysqlFormat = function () {
        function pad(n) { return n < 10 ? '0' + n : n }
        return pad(this.getDate()) +"/" + pad(1 + this.getMonth()) + "/" + this.getFullYear();
    };
    var TimeNow = new Date().toMysqlFormat();
    console.log('Data agora '+TimeNow);
    return TimeNow;
}

$("#medications-0-using-time").change(function() {

    var diasDeUso       = parseInt($("#medications-0-using-time").val());
    //console.log('dias->'+diasDeUso);
    var startDate       = $("#medications-0-start-date").val();
    var endDate         = getEndDate(startDate,diasDeUso);
    $("#medications-0-end-date").attr("value",endDate);

    console.log('No change using time '+endDate);
});

$("#imediato").change(function() {
    if ( $(this).is(":checked"))  {
        var date = new Date;

        var minutes = date.getMinutes();
        if (minutes < 10){
                minutes = "0" + minutes;
        }
        var hour        = date.getHours();
        var startTime  = hour+":"+minutes;
        var startDate   = getStartDate();
        //console.log(getStartDate());

        $(".start_time").slideUp();

         $("#medications-0-start-time").attr("value",startTime);
         $("#medications-0-start-date").attr("value",startDate);

        $('.imediato').css("margin-bottom","25px");

        $(this).val(1);

    } else {

        $(".start_time").slideDown();

        $('.imediato').css("margin-bottom","");

        $(this).val(0);

    }

});

var tot_of_medications =0;

// $("#dummy-form").validate({
//         rules: {
//             email: {
//                 required: true,
//                 minlength: 8
//             },
//             //'medications-0-name': "required"
//         },
//         messages: {
//             email: {
//                 required: "Please provide your Login",
//                 minlength: "Your Login must be at least 8 characters"
//             },
//             pass: "Please provide your password"
//         }
//     });


  $('#dummy-form').on('submit', function(e) {
    console.log('yoo');
    var medications_name = $('#medications-0-name');

    // Check if there is an entered value
    if(!medications_name.val()) {
      // Add errors highlight
      medications_name.closest('.form-group').removeClass('has-success').addClass('has-error');

      // Stop submission of the form
      e.preventDefault();
    } else {
      // Remove the errors highlight
      medications_name.closest('.form-group').removeClass('has-error').addClass('has-success');
    }
  });




window.setTimeout(function() {
   $('#medications-0-sign-id').ddslick();

}, 1000);



var previousMedications = parseInt(<?=$numberOfMedications?>);

console.log(previousMedications);

if( previousMedications > 0){
    tot_of_medications = previousMedications-1;
}

$("#save-modal").click(function(){

    var html_table ='';
    var html_form ='';
    tot_of_medications++;

    // console.log("modal save clicked");

    var $inputs = $('#dummy-form :input');

    var values = {};
    var iteration = 0;
    var name = null;

    $inputs.each(function() {

        if($(this).attr("name") != undefined || $(this).attr("name") == 'undefined') {

            // image selection seleção de opcões

            if ($(this).hasClass('dd-option-value'))
            {
                return;
            }
            else if ($(this).hasClass('dd-selected-value'))
            {

                $(this).attr('name', 'medications['+tot_of_medications+'][sign_id]');
                 //console.log($(this));
            }
            else
            {



                 if ($(this).hasClass("medication-name")) {
                    html_table += '<td class="medication-name">'+$(this).val()+'</td>';
                 }

                 if ($(this).hasClass("medication-dosage")) {
                    html_table += '<td class="medication-name">'+$(this).val()+'</td>';
                 }

                 if ($(this).hasClass("medication-channel")) {
                    html_table += '<td class="medication-channel">'+$(this).val()+'</td>';
                 }

                 if ($(this).hasClass("medication-frequency")) {
                    html_table += '<td class="medication-frequency">'+$(this).val()+'</td>';
                 }

                 if ($(this).hasClass("med-start-date")) {
                    html_table += '<td class="med-start-date">'+$(this).val()+'</td>';
                 }

                 if ($(this).hasClass("med-end-date")) {
                    html_table += '<td class="med-end-date">'+$(this).val()+'</td>';
                 }

                 console.log($(this).attr('name'));
                 console.log($(this).val());
                 console.log($(this));
            }
            
            name = $(this).attr("name").replace("[0]", '['+tot_of_medications+']');

            if( $(this).hasClass("multiselect") ) {
                
                var arrayIds = $(this).val();
                
                if(arrayIds != null && arrayIds != undefined && arrayIds != 'undefined'){

                    for (var i = 0 ; i < arrayIds.length; i++) {

                      html_form += '<input value="'+arrayIds[i]+'" name="' + name + '" multiple="multiple">';
                    
                    }
                }
                
            }else {

                html_form += '<input value="'+$(this).val()+'" name="' + name + '">';

            }
           
                
        }
        
    });

    var deleteButton = '<td><a href="#" class="btn btn-danger btn-xs" onclick="deleteMedication('+tot_of_medications+')">Deletar</a></td>';

    $("#tbody").append('<tr class="medication-data-'+tot_of_medications+'">' + html_table + deleteButton +'</tr>');

    $("#prescription-form").append('<div class="medication-data-'+tot_of_medications+'" style="display:none">' + html_form + '</div>');

    //
    $("#dummy-form").trigger("reset");  //limpa os campos do form
    $("#close-modal").trigger('click');
    $(".justificativa_antibiotico").hide();
    $(".cultura_resultado").hide();
    //$("#dummy-form").reset();
    //$("#close-modal").click();
    $('.start_time').show();
    $('.time_inputs').each(function(){
        $(this).val("");
    });
    var ul_container = $('.multiselect-container li');
    ul_container.each(function(){
        $(this).removeClass("active");
    });
    $('.bt-multiselect').attr('title','Nenhum item selecionado');
    $('.multiselect-selected-text').text('Nenhum item selecionado');
    

});

function deleteMedication(elem)
{
    console.log('deleteMedication' + elem);
    $('.medication-data-'+elem).remove();
}

</script>

<style >
    td, th {
        padding: 8px;
        text-align: center;
    }

</style>



<?php

if ($current_state == "internacao"): ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here

           var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

           var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

           var link3 =' <?=$this->Html->link('Internação', ['controller' => 'hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= link4;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>

<?php else: ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here

           var link1 =' <?=$this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
    ['controller' => 'Users', 'action' => 'login'], ['class' => 'btn btn-default ', 'escape' => false])?> ';

           var link2 =' <?=$this->Html->link('Pacientes', ['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

           var link3 =' <?=$this->Html->link('Triagem', ['controller' => 'hospitalizations', 'action' => 'edit', $screening_id, '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var link4 =' <?=$this->Html->link('Prescrições', ['controller' => 'Prescriptions', 'action' => 'index', '_full' => true], ['class' => 'btn btn-default ']);?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= link4;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Novo</a>';
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>
<?php endif;?>