<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age = null;
  $age = $from->diff($to)->y;
?>

<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Boletim Médico</h1>
        </div>
     
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="medicalBulletins form col-md-9 columns content">
   
        <?php

           $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

           $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);


            $consciencia                = ['Lúcido', 'Confuso', 'Sonolento', 'Coma', 'Sedado'];
            $respiracao                 = ['Espontânea', 'Máscara de Ventilação', 'Entubado'];
            $alimentacao                = ['Oral', 'Sonda/Cateter', 'Zero'];
            $exames_laboratoriais       = ['Melhor', 'Sem mudança', 'Piorou'];
            $estado_geral               = ['Melhor', 'Estável', 'Mantido', 'Grave', 'Gravíssimo'];


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Consciência:</b>'.$consciencia[$medicalBulletin['consciencia']];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Respiração:</b>'.$respiracao[$medicalBulletin['respiracao']];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<b>Alimentação:</b>'.$alimentacao[$medicalBulletin['alimentacao']];
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
              if($medicalBulletin['febra']){
                echo $checked_img.'<b>Febre</b>';
              }else{
                echo $not_checked_img.'<b>Febre</b>';
              }
            echo '</div>'; 


            echo '<div class="col-sm-12 data-field">';
              if($medicalBulletin['exame_de_imagem']){
                echo $checked_img.'<b>Exame de imagem</b>';
              }else{
                echo $not_checked_img.'<b>Exame de imagem</b>';
              }
            echo '</div>'; 


            echo '<div class="col-sm-6 data-field">';
              if($medicalBulletin['previsao_de_alta']){
                echo $checked_img.'<b>Previsão de alta</b>';
              }else{
                echo $not_checked_img.'<b>Previsão de alta</b>';
              }
            echo '</div>'; 


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Exames laboratoriais:</b>'.$exames_laboratoriais[$medicalBulletin['exames_laboratoriais']];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Estado geral:</b>'.$estado_geral[$medicalBulletin['estado_geral']];
            echo '</div>';


            echo '<div class="col-sm-12 data-field">';
               echo '<b>Observação:</b>';
            echo '</div>';

            echo '<div class="col-sm-12 data-field">';
               echo '<div class="textos">'.$medicalBulletin['observacao'].'</div>';
            echo '</div>';       

        ?>

</div>


<script>
(function(){
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');
    window.print();
    setTimeout(function () { window.close(); },300);

})();
</script>