<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Itu Prevention Bundle']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Screenings']), ['controller' => 'Screenings', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Screening']), ['controller' => 'Screenings', 'action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Daily Itu Prevention Bundles']), ['controller' => 'DailyItuPreventionBundles', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Daily Itu Prevention Bundle']), ['controller' => 'DailyItuPreventionBundles', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="ituPreventionBundles index col-md-10 columns content">
    <h3>Itu Prevention Bundles</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('date_instalation') ?></th>
                <th><?= $this->Paginator->sort('type_of_device') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('emergency') ?></th>
                <th><?= $this->Paginator->sort('is_risk_of_bleeding_verified') ?></th>
                <th><?= $this->Paginator->sort('is_the_procedure_prescribed') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($ituPreventionBundles as $ituPreventionBundle): ?>
            <tr>
                <td><?= $this->Number->format($ituPreventionBundle->id) ?></td>
                <td><?= h($ituPreventionBundle->date_instalation) ?></td>
                <td><?= h($ituPreventionBundle->type_of_device) ?></td>
                <td><?= h($ituPreventionBundle->created) ?></td>
                <td><?= h($ituPreventionBundle->emergency) ?></td>
                <td><?= h($ituPreventionBundle->is_risk_of_bleeding_verified) ?></td>
                <td><?= h($ituPreventionBundle->is_the_procedure_prescribed) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $ituPreventionBundle->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $ituPreventionBundle->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $ituPreventionBundle->id], ['confirm' => __('Are you sure you want to delete # {0}?', $ituPreventionBundle->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>