<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Evolution']), ['action' => 'edit', $evolution->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Evolution']), ['action' => 'delete', $evolution->id], ['confirm' => __('Are you sure you want to delete # {0}?', $evolution->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Evolutions']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Evolution']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Professionals']), ['controller' => 'Professionals', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Professional']), ['controller' => 'Professionals', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="evolutions view col-lg-10 col-md-9">
    <h3><?= h($evolution->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Professional</th>
            <td><?= $evolution->has('professional') ? $this->Html->link($evolution->professional->id, ['controller' => 'Professionals', 'action' => 'view', $evolution->professional->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Status</th>
            <td><?= h($evolution->status) ?></td>
        </tr>
        <tr>
            <th>Hospitalization</th>
            <td><?= $evolution->has('hospitalization') ? $this->Html->link($evolution->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $evolution->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($evolution->id) ?></td>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($evolution->created) ?></tr>
        </tr>
        <tr>
            <th>Date Of Completion</th>
            <td><?= h($evolution->date_of_completion) ?></tr>
        </tr>
        <tr>
            <th>Hour Of Completion</th>
            <td><?= h($evolution->hour_of_completion) ?></tr>
        </tr>
    </table>
    <div class="row">
        <h4>Evolution Text</h4>
        <?= $this->Text->autoParagraph(h($evolution->evolution_text)); ?>
    </div>
</div>
