<nav class="col-lg-2 col-md-3">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a href=""><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('Edit {0}', ['Discharge']), ['action' => 'edit', $discharge->id]) ?> </li>
        <li><?= $this->Form->postLink(__('Delete {0}', ['Discharge']), ['action' => 'delete', $discharge->id], ['confirm' => __('Are you sure you want to delete # {0}?', $discharge->id)]) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Discharges']), ['action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Discharge']), ['action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?> </li>
        <li><?= $this->Html->link(__('List {0}', ['Specialties']), ['controller' => 'Specialties', 'action' => 'index']) ?> </li>
        <li><?= $this->Html->link(__('New {0}', ['Specialty']), ['controller' => 'Specialties', 'action' => 'add']) ?> </li>
    </ul>
</nav>
<div class="discharges view col-lg-10 col-md-9">
    <h3><?= h($discharge->id) ?></h3>
    <table class="table table-striped table-hover">
        <tr>
            <th>Hospitalization</th>
            <td><?= $discharge->has('hospitalization') ? $this->Html->link($discharge->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $discharge->hospitalization->id]) : '' ?></td>
        </tr>
        <tr>
            <th>Destino Apos Alta</th>
            <td><?= h($discharge->destino_apos_alta) ?></td>
        </tr>
        <tr>
            <th>Nome Do Destino Apos Alta</th>
            <td><?= h($discharge->nome_do_destino_apos_alta) ?></td>
        </tr>
        <tr>
            <th>Condicao Clinica</th>
            <td><?= h($discharge->condicao_clinica) ?></td>
        </tr>
        <tr>
            <th>Resultado Pps</th>
            <td><?= h($discharge->resultado_pps) ?></td>
        </tr>
        <tr>
            <th>'Id</th>
            <td><?= $this->Number->format($discharge->id) ?></td>
        </tr>
        <tr>
            <th>Data Previsao Alta Unidade</th>
            <td><?= h($discharge->data_previsao_alta_unidade) ?></tr>
        </tr>
        <tr>
            <th>Hora Previsao Alta Unidade</th>
            <td><?= h($discharge->hora_previsao_alta_unidade) ?></tr>
        </tr>
        <tr>
            <th>Data Decisao Alta Unidade</th>
            <td><?= h($discharge->data_decisao_alta_unidade) ?></tr>
        </tr>
        <tr>
            <th>Hora Decisao Alta Unidade</th>
            <td><?= h($discharge->hora_decisao_alta_unidade) ?></tr>
        </tr>
        <tr>
            <th>Data Saida Unidade</th>
            <td><?= h($discharge->data_saida_unidade) ?></tr>
        </tr>
        <tr>
            <th>Hora Saida Unidade</th>
            <td><?= h($discharge->hora_saida_unidade) ?></tr>
        </tr>
        <tr>
            <th>Data Decisao Para Cuidados</th>
            <td><?= h($discharge->data_decisao_para_cuidados) ?></tr>
        </tr>
        <tr>
            <th>Created</th>
            <td><?= h($discharge->created) ?></tr>
        </tr>
        <tr>
            <th>Atendimento Ambulatorial</th>
            <td><?= $discharge->atendimento_ambulatorial ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Entregue O Resumo</th>
            <td><?= $discharge->entregue_o_resumo ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Entregue Prescricao Domiciliar</th>
            <td><?= $discharge->entregue_prescricao_domiciliar ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Entregue As Orientacoes</th>
            <td><?= $discharge->entregue_as_orientacoes ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Houve Decisao Para Cuidados</th>
            <td><?= $discharge->houve_decisao_para_cuidados ? __('Yes') : __('No'); ?></td>
         </tr>
        <tr>
            <th>Realizado Pps2</th>
            <td><?= $discharge->realizado_pps2 ? __('Yes') : __('No'); ?></td>
         </tr>
    </table>
    <div class="related">
        <h4><?= __('Related {0}', ['Specialties']) ?></h4>
        <?php if (!empty($discharge->specialties)): ?>
        <table class="table table-striped table-hover">
            <tr>
                <th>Id</th>
                <th>Name</th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php foreach ($discharge->specialties as $specialties): ?>
            <tr>
                <td><?= h($specialties->id) ?></td>
                <td><?= h($specialties->name) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['controller' => 'Specialties', 'action' => 'view', $specialties->id]) ?>

                    <?= $this->Html->link(__('Edit'), ['controller' => 'Specialties', 'action' => 'edit', $specialties->id]) ?>

                    <?= $this->Form->postLink(__('Delete'), ['controller' => 'Specialties', 'action' => 'delete', $specialties->id], ['confirm' => __('Are you sure you want to delete # {0}?', $specialties->id)]) ?>

                </td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
    </div>
</div>
