<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">

            <?=
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>
        <div class="col-sm-8">
            <h1>Checklist Segurança</h1>
        </div>

</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="dailySafetyChecklists form col-md-8 columns content">

        <?php

        $profilaxia_de_tev = [
          0=>'Heparina Baixo Peso Molecular', 
          1=>'Heparina Não Fracionada', 
          2=>'Compressor Pneumático Intermitente', 
          3=>'Fondaparinux', 
          4=>'Rivaroxaban', 
          5=>'Não'
        ];

        $via_de_nutricao = [
          0=>'Oral', 
          1=>'Enteral', 
          2=>'Parenteral', 
          3=>'Conjugada Oral e Enteral', 
          4=>'Conjugada Enteral e Parenteral', 
          5=>'Zero'
        ];

        $checked_img = $this->Html->image('checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);

        $not_checked_img = $this->Html->image('not-checked.png', ['class' => 'tick-box','alt' => 'GH', 'height'=>'22px', 'style'=>""]);


        echo '<div class="col-sm-12 no-padding">';

            echo '<legend class="big-title">Profilaxias:</legend>';

            echo '<div class="col-sm-6 data-field">';
             if($dailySafetyChecklist['cabeceira_de_leito_elevado']){
              echo $checked_img.'<b>Cabeceira de leito elevada</b>';
             }else{
              echo $not_checked_img.'<b>Cabeceira de leito elevada</b>';
             }
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
             if($dailySafetyChecklist['protocolo_higienico_oral']){
              echo $checked_img.'<b>Protocolo de higiene oral com clorexidina</b>';
             }else{
              echo $not_checked_img.'<b>Protocolo de higiene oral com clorexidina</b>';
             }
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
             if($dailySafetyChecklist['aspiracao_da_secrecao']){
              echo $checked_img.'<b>Aspiração da secreção subglótica</b>';
             }else{
              echo $not_checked_img.'<b>Aspiração da secreção subglótica</b>';
             }
            echo '</div>';

            echo '<div class="col-sm-6 data-field">';
             if($dailySafetyChecklist['necessidade_de_profilaxia']){
              echo $checked_img.'<b>Necessita de profilaxia lesão aguda de mucosa gástrica</b>';
             }else{
              echo $not_checked_img.'<b>Necessita de profilaxia lesão aguda de mucosa gástrica</b>';
             }
            echo '</div>';

            if($dailySafetyChecklist['necessidade_de_profilaxia'] != 0 && $dailySafetyChecklist['necessidade_de_profilaxia'] != '' ){
                echo '<div class="col-sm-6 data-field">';
                 if($dailySafetyChecklist['bloq_bloqueador']){
                  echo $checked_img.'<b>Bloqueador de H2</b>';
                 }else{
                  echo $not_checked_img.'<b>Bloqueador de H2</b>';
                 }
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                 if($dailySafetyChecklist['incluir_outro_item_protetor']){
                  echo $checked_img.'<b>Inibidor de H2</b>';
                 }else{
                  echo $not_checked_img.'<b>Inibidor de H2</b>';
                 }
                echo '</div>';
            }  


            echo '<div class="col-sm-6 data-field">';
              echo '<b>Profilaxia para TEV:</b>'.$profilaxia_de_tev[$dailySafetyChecklist['profilaxia_de_tev']];
            echo '</div>';

        echo '</div>';


            //suporte nutricional
        echo '<div class="col-sm-12 no-padding">';

            echo '<legend class="big-title">Suporte Nutricional:</legend>';

            echo '<div class="col-sm-6 data-field">';
             if($dailySafetyChecklist['atingiu_vet_pleno']){
              echo $checked_img.'<b>Atingiu VET pleno</b>';
             }else{
              echo $not_checked_img.'<b>Atingiu VET pleno</b>';
             }
            echo '</div>';


            if(isset($dailySafetyChecklist['via_de_nutricao'])){
              echo '<div class="col-sm-6 data-field">';
                echo '<b>Via de nutrição:</b>'.$via_de_nutricao[$dailySafetyChecklist['via_de_nutricao']];
              echo '</div>';
            }else{
              echo '<div class="col-sm-6 data-field">';
                 echo '<b>Via de nutrição:</b>';
              echo '</div>';
            }
            
            

        echo '</div>';

            //dispositivos invasivos
        echo '<div class="col-sm-12 no-padding">';

            echo '<legend class="big-title">Dispositivos Invasivos:</legend>';

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['cateter_venoso_central']){
               echo $checked_img.'<b>Uso cateter venoso central</b>';
              }else{
               echo $not_checked_img.'<b>Uso cateter venoso central</b>';
              }
            echo '</div>';

            if($dailySafetyChecklist['cateter_venoso_central'] != 0 && $dailySafetyChecklist['cateter_venoso_central'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['cateter_venoso_central_can_be_removed']){
                 echo $checked_img.'<b>O cateter venoso central pode ser removido</b>';
                }else{
                 echo $not_checked_img.'<b>O cateter venoso central pode ser removido</b>';
                }
              echo '</div>';
            }    

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['cateter_arterial']){
               echo $checked_img.'<b>Uso de cateter arterial</b>';
              }else{
               echo $not_checked_img.'<b>Uso de cateter arterial</b>';
              }
            echo '</div>';


            if($dailySafetyChecklist['cateter_arterial'] != 0 && $dailySafetyChecklist['cateter_arterial'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['cateter_arterial_can_be_removed']){
                 echo $checked_img.'<b>O cateter arterial pode ser removido</b>';
                }else{
                 echo $not_checked_img.'<b>O cateter arterial pode ser removido</b>';
                }
              echo '</div>';
            }  


            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['cateter_vesical_de_demora']){
               echo $checked_img.'<b>Uso de cateter vesical de demora</b>';
              }else{
               echo $not_checked_img.'<b>Uso de cateter vesical de demora</b>';
              }
            echo '</div>';

            if($dailySafetyChecklist['cateter_vesical_de_demora'] != 0 && $dailySafetyChecklist['cateter_vesical_de_demora'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['cateter_vesical_de_demora_can_be_removed']){
                 echo $checked_img.'<b>Cateter vesical de demora pode ser removido</b>';
                }else{
                 echo $not_checked_img.'<b>Cateter vesical de demora pode ser removido</b>';
                }
              echo '</div>';
            }  

        echo '</div>';


            //uso de medicações
        echo '<div class="col-sm-12 no-padding">';

           echo '<legend class="big-title">Uso de Medicações:</legend>';

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['antibioticos']){
               echo $checked_img.'<b>Antibióticos</b>';
              }else{
               echo $not_checked_img.'<b>Antibióticos</b>';
              }
            echo '</div>';

            if($dailySafetyChecklist['antibioticos'] != 0 && $dailySafetyChecklist['antibioticos'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['antibioticos_can_be_removed']){
                 echo $checked_img.'<b>O tratamento pode ser suspenso</b>';
                }else{
                 echo $not_checked_img.'<b>O tratamento pode ser suspenso</b>';
                }
              echo '</div>';
            }  

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['corticoesteroides']){
               echo $checked_img.'<b>Corticoesteroides</b>';
              }else{
               echo $not_checked_img.'<b>Corticoesteroides</b>';
              }
            echo '</div>';

            if($dailySafetyChecklist['corticoesteroides'] != 0 && $dailySafetyChecklist['corticoesteroides'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['corticoesteroides_can_be_removed']){
                 echo $checked_img.'<b>O uso de  corticoesteróides pode ser suspenso</b>';
                }else{
                 echo $not_checked_img.'<b>O uso de  corticoesteróides pode ser suspenso</b>';
                }
              echo '</div>';
            }  

        echo '</div>';


            //itens do checklist
        echo '<div class="col-sm-12 no-padding">';

            echo '<legend class="big-title">Itens do Checklist Avaliados – Controle Glicêmico:</legend>';

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['protocolo_glicemico']){
               echo $checked_img.'<b>Protocolo glicêmico</b>';
              }else{
               echo $not_checked_img.'<b>Protocolo glicêmico</b>';
              }
            echo '<br></div>';
            
            if($dailySafetyChecklist['protocolo_glicemico'] != 0 && $dailySafetyChecklist['protocolo_glicemico'] != '' ){

              echo '<div class="col-sm-12 data-field">';
                echo '<b>Número total de aferições de glicemias no período:</b>'.$dailySafetyChecklist['total_afericoes_glicemicas_por_periodo'];
              echo '</div>';

               echo '<div class="col-sm-12 data-field">';
                echo '<b>Número total de aferições  com glicemias < 60 mg/dl:</b>'.$dailySafetyChecklist['total_glicemias_menor_que_60'];
              echo '</div>';

              echo '<div class="col-sm-12 data-field">';
                echo '<b>Número total de aferições  com glicemias > 180 mg/dl:</b>'.$dailySafetyChecklist['total_glicemias_maior_que_180'];
              echo '</div>';
            }  


            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['fez_insulina_ultimas_24_h']){
               echo $checked_img.'<b>Fez uso de insulina nas 24 horas</b>';
              }else{
               echo $not_checked_img.'<b>Fez uso de insulina nas 24 horas</b>';
              }
            echo '<br></div>';

            if($dailySafetyChecklist['fez_insulina_ultimas_24_h'] != 0 && $dailySafetyChecklist['fez_insulina_ultimas_24_h'] != '' ){

              echo '<div class="col-sm-12 data-field">';
                echo '<b>Dose total de insulina em 24h:</b>'.$dailySafetyChecklist['total_insulina_ultimas_24_h'];
              echo '</div>';

              echo '<div class="col-sm-12 data-field">';
                echo '<b>Valor total de insulina sub cutânea em 24h:</b>'.$dailySafetyChecklist['insulina_sub_cutanea_em_24h'];
              echo '</div>';

              echo '<div class="col-sm-12 data-field page-break">';
                echo '<b>Valor total de insulina venosa em 24h:</b>'.$dailySafetyChecklist['insulina_sub_venosa_em_24h'];
              echo '</div>';
            }
              
        echo '</div>';


            //sedação analgesia
        echo '<div class="col-sm-12 no-padding">';
            echo '<legend class="big-title">Sedação Analgesia Delirium:</legend>';

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['sedacao']){
               echo $checked_img.'<b>Uso de sedação</b>';
              }else{
               echo $not_checked_img.'<b>Uso de sedação</b>';
              }
            echo '</div>';

            if($dailySafetyChecklist['sedacao'] != 0 && $dailySafetyChecklist['sedacao'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['sedacao_dentro_da_meta']){
                 echo $checked_img.'<b>Nível de sedação dentro da meta esperada</b>';
                }else{
                 echo $not_checked_img.'<b>Nível de sedação dentro da meta esperada</b>';
                }
              echo '</div>';

              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['interrupcao_sedacao']){
                 echo $checked_img.'<b>Interrupção da sedação</b>';
                }else{
                 echo $not_checked_img.'<b>Interrupção da sedação</b>';
                }
              echo '</div>';
            }  

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['sob_analgesia']){
               echo $checked_img.'<b>Sob analgesia</b>';
              }else{
               echo $not_checked_img.'<b>Sob analgesia</b>';
              }
            echo '</div>'; 

            if($dailySafetyChecklist['sob_analgesia'] != 0 && $dailySafetyChecklist['sob_analgesia'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['apresentou_dor']){
                 echo $checked_img.'<b>Presença de dor</b>';
                }else{
                 echo $not_checked_img.'<b>Presença de dor</b>';
                }
              echo '</div>';
            }  

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['avaliacao_delirium_pelo_camicu']){
               echo $checked_img.'<b>Avaliação de delirium pelo CAM-ICU</b>';
              }else{
               echo $not_checked_img.'<b>Avaliação de delirium pelo CAM-ICU</b>';
              }
            echo '</div>';


            if($dailySafetyChecklist['avaliacao_delirium_pelo_camicu'] != 0 && $dailySafetyChecklist['avaliacao_delirium_pelo_camicu'] != '' ){
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['delirium']){
                 echo $checked_img.'<b>Presença de delirium</b>';
                }else{
                 echo $not_checked_img.'<b>Presença de delirium</b>';
                }
              echo '</div>';
            }  

        echo '</div>';



                //ventilacao
        echo '<div class="col-sm-12 no-padding">';

            echo '<legend class="big-title">Ventilação Mecânica:</legend>';

            echo '<div class="col-sm-6 data-field">';
              if($dailySafetyChecklist['ventilacao_mecanica_invasiva']){
               echo $checked_img.'<b>Uso de ventilação mecânica invasiva</b>';
              }else{
               echo $not_checked_img.'<b>Uso de ventilação mecânica invasiva</b>';
              }
            echo '</div>';


            if($dailySafetyChecklist['ventilacao_mecanica_invasiva'] != 0 && $dailySafetyChecklist['ventilacao_mecanica_invasiva'] != '' ){
            
              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['pa2_fio2_menor_que_300']){
                 echo $checked_img.'<b>PaO2/FiO2</b>';
                }else{
                 echo $not_checked_img.'<b>PaO2/FiO2 </b>';
                }
              echo '</div>';

              if($dailySafetyChecklist['pa2_fio2_menor_que_300'] != 0 && $dailySafetyChecklist['pa2_fio2_menor_que_300'] != '' ){
                echo '<div class="col-sm-6 data-field">';
                  if($dailySafetyChecklist['volume_corrente_menor_que_8']){
                   echo $checked_img.'<b>Volume corrente < 6ml/Kg</b>';
                  }else{
                   echo $not_checked_img.'<b>Volume corrente < 6ml/Kg</b>';
                  }
                echo '</div>';

                echo '<div class="col-sm-6 data-field">';
                  if($dailySafetyChecklist['pressao_de_plato_menor_que_30']){
                   echo $checked_img.'<b>Pressão de plateau < 30 cmH2O</b>';
                  }else{
                   echo $not_checked_img.'<b>Pressão de plateau < 30 cmH2O</b>';
                  }
                echo '</div>';
              }  


              echo '<div class="col-sm-6 data-field">';
                if($dailySafetyChecklist['iniciar_desmane']){
                 echo $checked_img.'<b>Pode iniciar desmame de ventilação mecânica</b>';
                }else{
                 echo $not_checked_img.'<b>Pode iniciar desmame de ventilação mecânica</b>';
                }
              echo '</div>';

              if($dailySafetyChecklist['iniciar_desmane'] != 0 && $dailySafetyChecklist['iniciar_desmane'] != '' ){
                echo '<div class="col-sm-6 data-field">';
                  if($dailySafetyChecklist['paciente_sob_ventilacao_espontanea']){
                   echo $checked_img.'<b>Paciente sob ventilação espontânea</b>';
                  }else{
                   echo $not_checked_img.'<b>Paciente sob ventilação espontânea</b>';
                  }
                echo '</div>';

                echo '<div class="col-sm-12 data-field">';
                  if($dailySafetyChecklist['iniciar_peca_t']){
                   echo $checked_img.'<b>Pode iniciar teste de respiração espontânea em peça T ou similar</b>';
                  }else{
                   echo $not_checked_img.'<b>Pode iniciar teste de respiração espontânea em peça T ou similar</b>';
                  }
                echo '</div>';
              }
            }

            echo "</div>";

        ?>
</div>

<script >
  window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
  
  (function(){
    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    //chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();
</script>