<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<style type="text/css">
  table th,td{
    text-align:left!important;
  }
</style>
<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>CRIB</h1>
        </div>
     
</div>
<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>
<div class="cribScores form col-md-9 columns content">
	<?= $this->Form->create($cribScore) ?>
	<fieldset>
		<?php
		 if(isset($cribScore['data_realizacao'])){$cribScore['data_realizacao']=$cribScore['data_realizacao']->format('d/m/Y');}

		  $peso_nascimento_opt = ['> 1.350' => '> 1.350', '851 - 1.350'=>'851 - 1.350', '701 - 850'=>'701 - 850', '<= 700'=> '<= 700'];
		  $idade_gestacional_opt = ['> 24' => '> 24', '<= 24'=>'<= 24'];
		  $malformacao_opt = ['Ausente' => 'Ausente', 'Sem risco de vida imediato'=>'Sem risco de Vida Imediato', 'Com risco de vida imediato'=>'Com Risco de Vida Imediato'];
		  $be_max_opt = ['> -7,0' => '> -7,0', '-7,0 a -9,9'=>'-7,0 a -9,9', '-10,0 a -14,9'=>'-10,0 a -14,9', '<= -15,0'=>'<= -15,0'];
		  $be_min_opt = ['<= 0,40' => '<= 0,40','0,41 - 0,60'=>'0,41 - 0,60', '0,61 - 0,90'=>'0,61 - 0,90', '0,91 - 1,00'=> '0,91 - 1,00'];
		  $fio_min_opt = ['<= 0,40' => '<= 0,40','0,41 - 0,60'=>'0,41 - 0,60', '0,61 - 0,90'=>'0,61 - 0,90', '0,91 - 1,00'=> '0,91 - 1,00'];
		  $fio_max_opt = ['<= 0,40' => '<= 0,40','0,41 - 0,80'=>'0,41 - 0,80', '0,81 - 0,90'=>'0,81 - 0,90', '0,91 - 1,00'=> '0,91 - 1,00'];


			echo $this->Form->input('peso_nascimento', ['class'=>'item1 hidden ','onchange' => "javascript:calculatePt(this, 1);", 'empty'=>true,'options'=>$peso_nascimento_opt, 'label'=>['text'=>'Peso de nascimento:', 'class'=>'form-input hidden'] ]);

			echo $this->Form->input('idade_gestacional', ['class'=>'item2 hidden','onchange' => "javascript:calculatePt(this, 2);", 'empty'=>true,'options'=>$idade_gestacional_opt, 'label'=>['text'=>'Idade gestacional:', 'class'=>'form-input hidden'] ]);

			echo $this->Form->input('malfomacao_congenita', ['class'=>'item3 hidden','onchange' => "javascript:calculatePt(this, 3);", 'empty'=>true,'options'=>$malformacao_opt, 'label'=>['text'=>'Malformação congênita:', 'class'=>'form-input hidden'] ]);

			echo $this->Form->input('be_maximo_nas_primeiros_12h_de_vida', ['class'=>'item4 hidden','onchange' => "javascript:calculatePt(this, 4);", 'empty'=>true,'options'=>$be_max_opt, 'label'=>['text'=>'BE máximo nas primeiras 2h de vida(mmol/l):', 'class'=>'form-input hidden'] ]);

			echo $this->Form->input('fio2_minima_apropriada_nas_primeiras_12h_de_vida', ['class'=>'item5 hidden','onchange' => "javascript:calculatePt(this, 5);", 'empty'=>true,'options'=>$fio_min_opt, 'label'=>['text'=>'FiO2 mínima apropriada nas primeiras 12h de vida:', 'class'=>'form-input hidden'] ]);

			echo $this->Form->input('fio2_maxima_apropriada_nas_primeiras_12h_de_vida', ['class'=>'item6 hidden','onchange' => "javascript:calculatePt(this, 6);", 'empty'=>true,'options'=>$fio_max_opt, 'label'=>['text'=>'FiO2 máxima apropriada nas primeiras 12h de vida:', 'class'=>'form-input hidden'] ]);


			echo $this->Form->input('data_realizacao', ['class'=>'date hidden', 'type'=>'text','label'=>['text'=>'Data de realização:', 'class'=>' form-input hidden'],'empty' => true, 'default' => '']);

			echo $this->Form->input('pontuation', ['class'=>"hide hidden", 'label'=>false, 'id'=>'pontuation-id']);
			echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]); 
		?>



		<table class="table table-striped table-hover">
	        <tr>
	            <th>Peso de nascimento</th>
	            <td><?= $cribScore['peso_nascimento'] ?></td>
	        </tr>


	        <tr>
               <th>Idade gestacional</th>
               <td><?= $cribScore['idade_gestacional']; ?></td>
	        </tr>

	        <tr>
	            <th>Malformação congênita</th>
	            <td><?= $cribScore['malfomacao_congenita']; ?></td>
	        </tr>


	        <tr>
	            <th>BE máximo nas primeiras 2h de vida(mmol/l)</th>
	            <td><?= $cribScore['be_maximo_nas_primeiros_12h_de_vida']; ?></td>
	        </tr>


	        <tr>
	            <th>FiO2 mínima apropriada nas primeiras 12h de vida:</th>
	            <td><?= $cribScore['fio2_minima_apropriada_nas_primeiras_12h_de_vida']; ?></td>
	        </tr>


	        <tr>
	            <th>FiO2 máxima apropriada nas primeiras 12h de vida</th>
	            <td><?= $cribScore['fio2_maxima_apropriada_nas_primeiras_12h_de_vida']; ?></td>
	        </tr>

	        <tr>
	            <th>Data de realização</th>
	            <td><?= $cribScore['data_realizacao']; ?></td>
	        </tr>


	        <tr>
	            <th>Pontuação</th>
	            <td><span id="pontuation"></span></td>
	        </tr>

	        <tr>
	            <th>Probabilidade de óbito</th>
	            <td><span id="probabilidade_obito_td"></span></td>
	        </tr>

	    </table> 

	</fieldset>
	<?= $this->Form->end() ?>
</div>


<script>

  
$(document).ready(function(){
	calculatePt();
});


var pontuation = 0;
var probabilidade_obito = 0;

function calculatePt(elem, item)
{
		pontuation = 0;
	//console.log($(elem).val());

	$( "select" ).each(function( index ) 
	{
		console.log($(this).val());

			if ($( this ).hasClass( "item1" ))
			{
				switch($(this).val()) 
					{
						case '851 - 1.350':
								pontuation += 1;
								break;
						case '701 - 850':
								pontuation += 4;
								break;
						case '<= 700':
								pontuation += 7;
								break;
					}
			}
			else if ($( this ).hasClass( "item2" ))
			{
					switch($(this).val()) 
					{
						case '<= 24':
							pontuation += 1;
							break;
					}
			}
			else if ($( this ).hasClass( "item3" ))
			{
					switch($(this).val()) 
					{
						 case 'Sem risco de vida imediato':
							pontuation += 1;
							break;   
						case 'Com risco de vida imediato':
							pontuation += 3;
							break;
					}
			}
			else if ($( this ).hasClass( "item4" ))
			{
					switch($(this).val()) 
					{
						case '-7,0 a -9,9':
							pontuation += 1;
							break;                                     
						case '-10,0 a -14,9':
							pontuation += 2;
							break;   
						case '<= -15,0':
							pontuation += 3;
							break;                                             
					}
			}
			else if ($( this ).hasClass( "item5" ))
			{
					switch($(this).val()) 
					{
						 case '0,41 - 0,60':
							pontuation += 2;
							break;                                     
						case '0,61 - 0,90':
							pontuation += 3;
							break;          
						case '0,91 - 1,00':
							pontuation += 4;
							break; 
					}
			}
			else if ($( this ).hasClass( "item6" ))
			{
					switch($(this).val()) 
					{
						case '0,41 - 0,80':
							pontuation += 1;
							break;   
						case '0,81 - 0,90':
							pontuation += 3;
							break;                                     
						case '0,91 - 1,00':
							pontuation += 5;
							break; 
					}
			}
 });


	probabilidade_obito = -6.476 + (0.45 * pontuation);
	probabilidade_obito = Math.exp(probabilidade_obito)  / (1 + Math.exp(probabilidade_obito));
	probabilidade_obito = 100 * probabilidade_obito;
	probabilidade_obito = (probabilidade_obito.toFixed(2));
  	console.log("pontuation = "+pontuation);

	$('#pontuation-id').val(pontuation);
	$('#pontuation').text(pontuation);

	$('#probabilidade_obito').val(probabilidade_obito);
	$('#probabilidade_obito_td').text(probabilidade_obito+'%');
}


(function(){
    window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');

    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    //chamando a função de imprimir
    setTimeout(function(){
  		PrintPage();
    },600);

  })();


</script>