<?php
  $from = new DateTime($patient['birthday']->i18nFormat('dd-MM-yyyy'));
  $to   = new DateTime('today');
  $age  = null;
  $age  = $from->diff($to)->y;
?>
<style>
    .sub-th{
        background-color:#337ab7!important;
        color:#fff!important;
        text-align:center!important;
    }
    .sub-th strong{
        text-align:center!important;
    }
    .table td,th{
      text-align:left;
    }
</style>

<div class="container unit-header">
        <div class="bundles form col-sm-4 columns content">
            
            <?= 
             $this->Html->image('uploads/'. $unit_logo, ['alt' => 'GH', 'height'=>'50px', 'style'=>"margin-top: 7px;"])
            ?>
            <br><br>
            <p class="unit-data"><b><?= $unit->name ?></b></p>
            <p class="unit-data"><b><?= $unit->telephone ?></b></p>
            <p class="unit-data"><b><?= $unit->street ?></b></p>
            <p class="unit-data"><b><?= $unit->city ?></b></p>
            <br>
        </div>   
        <div class="col-sm-8">
            <h1>Protocolo de TEV clínico</h1>
        </div>
        
</div>

<div class="col-sm-12 data-field">
  <table class="table table-bordered">
    <tr>
      <td><span class="inline-data"><b>Paciente:</b>&nbsp;<?= $patient->nome ?></span></td>
      <td><span class="inline-data"><b>Idade:</b>&nbsp;<?= $age ?></span></td>
      <td><span class="inline-data"><b>Setor:</b>&nbsp;<?= $hospitalization->sector['name'] ?></span></td>
      <td><span class="inline-data"><b>Leito:</b>&nbsp;<?= $hospitalization->roomName($hospitalization['id'])?></span></td>
      <td><span class="inline-data"><b>Prontuário:</b>&nbsp;<?= $hospitalization->numero_do_prontuario ?></span></td>
    </tr>
  </table>
  <br><br>
</div>

<div class="clinicTevProtocols view col-lg-9 col-md-9">
    <table class="table table-striped table-hover">
        
        <tr style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong> Avaliação do risco de TEV em paciente cirúrgico  </strong></th>
        </tr>    
        
        <tr>
            <th>Idade</th>
            <td>
                <?= $age ?>
            </td>
        </tr>
        <tr>
            <th>Data de preenchimento</th>
            <td>
                <?php 
                  if(isset($clinicTevProtocol->created)):
                    echo $clinicTevProtocol->created->format('d/m/Y'); 
                  endif;
                ?> 
            </td>
        </tr>


        <tr>
            <th>Mobilidade Reduzida</th>
            <td><?= $clinicTevProtocol->mobilidade_reduzida ? __('Sim') : __('Não'); ?></td>
        </tr>


        <!--correto -->
        <tr style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Contraindicação impede profilaxia medicamentosa</strong></th>
        </tr>
        
        <tr>
            <th>Sangramento Ativo</th>
            <td><?= $clinicTevProtocol->sangramento_ativo ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Ulcera péptica</th>
            <td><?= $clinicTevProtocol->ulcera_peptica ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>HAS não controlado (> 180 x 110mmHG)/th>
            <td><?= $clinicTevProtocol->has_nao_controlada ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Coagulopatia (plaquetopenia ou INR > 1,5)</th>
            <td><?= $clinicTevProtocol->cagulopatia ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Alergia ou plaquetopenia por heparina</th>
            <td><?= $clinicTevProtocol->alergia_ou_plaquetopenia ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Insuficiência renal (Cr* < 30mL/min)</th>
            <td><?= $clinicTevProtocol->insuficiencia_renal ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Coleta de LCR < 24h</th>
            <td><?= $clinicTevProtocol->coleta_de_lcr ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Raquinaelose</th>
            <td><?= $clinicTevProtocol->raquinaelose ? __('Sim') : __('Não'); ?></td>
        </tr>
        

        <tr>
            <th>Paciente Em Anticuagulante</th>
            <td><?= $clinicTevProtocol->paciente_em_anticuagulante ? __('Sim') : __('Não'); ?></td>
        </tr>

        <!--correto -->


        <!-- correto -->

        <tr class="profilaxia-mecanica-tr" style="background-color:#337ab7;color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia mecânica indicada</strong></th>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Meias elásticas de compressão gradual</th>
            <td class="profilaxia-mecanica-td"><?= $clinicTevProtocol->meias_elasticas ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Compressão pneumática intermitente</th>
            <td class="profilaxia-mecanica-td"><?= $clinicTevProtocol->compressao_pneumatica ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-mecanica-tr">
            <th>Nenhum</th>
            <td class="profilaxia-mecanica-td"><?= $clinicTevProtocol->nenhum ? __('Sim') : __('Não'); ?></td>
        </tr>


        <tr class="profilaxia-mecanica-tr">
            <th>Data de inicio</th>
            <td class="profilaxia-mecanica-td">
                <?php 
                  if(isset($clinicTevProtocol->metodo_mecanico_inicio)):
                    echo $clinicTevProtocol->metodo_mecanico_inicio->format('d/m/Y'); 
                  endif;
                ?> 
            </td>
        </tr>


        <tr class="profilaxia-mecanica-tr">
            <th>Data de retirada</th>
            <td class="profilaxia-mecanica-td">
                <?php 
                  if(isset($clinicTevProtocol->metodo_mecanico_fim)):
                    echo $clinicTevProtocol->metodo_mecanico_fim->format('d/m/Y'); 
                  endif;
                ?> 
            </td>
        </tr>
        <!-- correto -->


        <!-- correto -->

        <tr class="profilaxia-medicamentosa-tr" style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Profilaxia medicamentosa</strong></th>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Enoxaparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $clinicTevProtocol->enoxaparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Dalteparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $clinicTevProtocol->dalteparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Fondaparinux</th>
            <td class="profilaxia-medicamentosa-td"><?= $clinicTevProtocol->fondaparinux ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Nadroparina</th>
            <td class="profilaxia-medicamentosa-td"><?= $clinicTevProtocol->nadroparina ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Heparina não funciona</th>
            <td class="profilaxia-medicamentosa-td"><?= $clinicTevProtocol->heparina_nao_funciona ? __('Sim') : __('Não'); ?></td>
        </tr>


        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de inicio</th>
            <td class="profilaxia-medicamentosa-td">
               <?php 
                  if(isset($clinicTevProtocol->profilaxia_medicamentosa_inicio)):
                    echo $clinicTevProtocol->profilaxia_medicamentosa_inicio->format('d/m/Y'); 
                  endif;
                ?>  
            </td>
        </tr>

        <tr class="profilaxia-medicamentosa-tr">
            <th>Data de término</th>
            <td class="profilaxia-medicamentosa-td">
                <?php 
                  if(isset($clinicTevProtocol->profilaxia_medicamentosa_termino)):
                    echo $clinicTevProtocol->profilaxia_medicamentosa_termino->format('d/m/Y'); 
                  endif;
                ?>  
            </td>
        </tr>
       
        <!-- correto -->


        <!-- correto -->

        <tr style="background-color:#337ab7; color:#fff!important;">
            <th class='sub-th' colspan="2"><strong>Ajuste posológico</strong></th>
        </tr>

        <tr>
            <th>Idade</th>
            <td><?= $clinicTevProtocol->idade_5 ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr>
            <th>Insuficiência renal</th>
            <td><?= $clinicTevProtocol->insuficiencia_renal_5 ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr>
            <th>Obesidade (IMC 40-50)</th>
            <td><?= $clinicTevProtocol->obesidade_imc_40_a_50_5 ? __('Sim') : __('Não'); ?></td>
        </tr>

        <tr>
            <th>Obesidade (IMC > 50)</th>
            <td><?= $clinicTevProtocol->obesidade_imc_maior_50_5 ? __('Sim') : __('Não'); ?></td>
        </tr>
       
        <!-- correto -->
      
    </table>
    <br><br>


    <div style="min-width:100%;" class="related no-break">
        <?php if (!empty($clinicTevProtocol->risk_factors)): ?>
            <table style="min-width:100%;" class="table table-striped table-hover">
                <tr style="min-width:100%; background-color:#337ab7; color:#fff!important;">
                   <th class='sub-th' colspan="2"><strong>Fatores de risco</strong></th>
                </tr>
                <tr style="min-width:100%;">
                    <td>
                        
                        <?php
                            $r='';

                            foreach ($clinicTevProtocol->risk_factors as $key => $riskFactors) {
                                   $r.= $riskFactors->nome.', ';
                            }

                            $r = trim($r,", ");


                            echo '<div style="min-width:100%;" class="col-sm-12 data-field">';
                              echo '<div style="min-width:100%;" class="textos">'.$r.'</div>';
                            echo '</div>';
                        ?>

                    </td>
                </tr>
            </table>
        <?php endif; ?>
    </div>
</div>


<script>

   
  
  (function(){
    window.onload = setTimeout(function(){$.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});},1);

    //checando os campos preenchidos de Profilaxia Mecanica

    var preenchidosProfilaxiaMecanica = 0;

    $('.profilaxia-mecanica-td').each(function(){
        //console.log($(this).text());
        if( $(this).text() == "Sim" && $(this).text() != '' && $(this).text() != 'Não' ){
            preenchidosProfilaxiaMecanica++;
        }
    });
    
    if(preenchidosProfilaxiaMecanica == 0){
        $('.profilaxia-mecanica-td').remove();
        $('.profilaxia-mecanica-tr').remove();
    }

    //checando os campos preenchidos de Profilaxia Medicamentosa

    var preenchidosProfilaxiaMedicamentosa = 0;

    $('.profilaxia-medicamentosa-td').each(function(){
        console.log($(this).text());
        if( $(this).text() == "Sim" && $(this).text() != '' && $(this).text() != 'Não' ){
            preenchidosProfilaxiaMedicamentosa++;
        }
    });
    console.log("counter>"+preenchidosProfilaxiaMedicamentosa);
    
    if(preenchidosProfilaxiaMedicamentosa == 0){
        $('.profilaxia-medicamentosa-td').remove();
        $('.profilaxia-medicamentosa-tr').remove();
    }

    
    $("form :input").prop('readonly', true);
    $("form :input").css('readonly', true);
    $('nav').css('display','none');



    // definindo a função de Print
    function PrintPage() {
        window.print();
        setTimeout(function () {
          $.LoadingOverlay("show",{'color':'rgba(255,255,255,255)'});
          window.close();
        },900);
    }

    //chamando a função de imprimir
    setTimeout(function(){ 
      PrintPage();
    },600);

  })();

</script>


