
<?php
    if ($current_state == 'internacao')    {
        echo $this->element( 'internacao-menu' );
    } else {
        echo $this->element( 'screening-menu' );
    }

    $pacient = $pacient->first();

    $from = new DateTime($pacient['birthday']->i18nFormat('dd-MM-yyyy'));
    $to   = new DateTime('today');
    $age = null;
    $age = $from->diff($to)->y;

?>

<div class="clinicTevProtocols form col-md-8 columns content">
    <?= $this->Form->create($clinicTevProtocol) ?>
    <fieldset>

        <?php
            if ($current_state == 'internacao')    {
                echo $this->Form->hidden('hospitalization_id', ['value' => $hospitalization_id]);
            } else {
                echo $this->Form->hidden('screening_id', ['value' => $screening_id]);
            }
        ?>

        <div class="panel panel-primary" id="quiz-1">
            <div class="panel-heading">
             <h4>Avaliação do risco de TEV em paciente clínico</h4>
            </div>
            <div class="panel-body" >
                     <p>Idade: <?= $age ?></p>
                     <?php

                        echo "<div class='funkyradio' id='quiz_1' >";
                            echo '<div class="funkyradio-primary">';
                            echo $this->Form->checkbox('mobilidade_reduzida', ['id'=>'mobilidade_reduzida']);
                            echo '<label for="mobilidade_reduzida">Mobilidade reduzida</label>';
                            echo "</div>";
                        echo "</div>";
                     ?>
                </div>
            <div class="panel-footer">
                <a href="#"  class="btn btn-primary" id="next-statement-1" onclick="nextQuiz(1)">Próximo</a>
            </div>
        </div>


        <div class="panel panel-primary" id="quiz-2" style="display:none">
            <div class="panel-heading">
                <h4>Algum fator de risco?</h4>
            </div>
            <div class="panel-body" >
                <?= $this->Form->input('risk_factors._ids', ['button'=>['class'=>'bt-margin'],'label'=>['text'=>'Fatores de risco:','class'=>'form-input'],'type' => 'select', 'multiple' => true]);     ?>
            </div>

            <div class="panel-footer">
                <a href="#"  class="btn btn-primary" onclick="nextQuiz(2)">Próximo</a>
            </div>
        </div>

        <div class="panel panel-primary" id="quiz-3" style="display:none">
            <div class="panel-heading">
             <h4>Contraindicação impede profilaxia medicamentosa?</h4>
            </div>
            <div class="panel-body" >

                 <?php
                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('sangramento_ativo', ['id'=>'sangramento_ativo', 'class'=>'contraindicacao']);
                        echo '<label for="sangramento_ativo">Sangramento ativo</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('ulcera_peptica', ['id'=>'ulcera_peptica', 'class'=>'contraindicacao']);
                        echo '<label for="ulcera_peptica">Ulcera péptica</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('has_nao_controlada', ['id'=>'has_nao_controlada', 'class'=>'contraindicacao']);
                        echo '<label for="has_nao_controlada">HAS não controlado (> 180 x 110mmHG)</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('cagulopatia', ['id'=>'cagulopatia', 'class'=>'contraindicacao']);
                        echo '<label for="cagulopatia">Coagulopatia (plaquetopenia ou INR > 1,5)</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('alergia_ou_plaquetopenia', ['id'=>'alergia_ou_plaquetopenia', 'class'=>'contraindicacao']);
                        echo '<label for="alergia_ou_plaquetopenia">Alergia ou plaquetopenia por heparina</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('insuficiencia_renal', ['id'=>'insuficiencia_renal', 'class'=>'contraindicacao']);
                        echo '<label for="insuficiencia_renal">Insuficiência renal (Cr* < 30mL/min)</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('coleta_de_lcr', ['id'=>'coleta_de_lcr', 'class'=>'contraindicacao']);
                        echo '<label for="coleta_de_lcr">Coleta de LCR < 24h</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('raquinaelose', ['id'=>'raquinaelose', 'class'=>'contraindicacao']);
                        echo '<label for="raquinaelose">Raquianestesia</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('paciente_em_anticuagulante', ['id'=>'paciente_em_anticuagulante', 'class'=>'contraindicacao']);
                        echo '<label for="paciente_em_anticuagulante">Paciente em uso de anticoagulante</label>';
                        echo "</div>";
                    echo "</div>";
                 ?>


            </div>
            <div class="panel-footer" >
                <a href="#" class="btn btn-primary" onclick="nextQuiz(3)">Próximo</a>
            </div>
        </div>


        <div class="panel panel-primary" id="quiz-4" style="display:none">
            <div class="panel-heading">
             <h4>Profilaxia medicamentosa</h4>
            </div>
            <div class="panel-body" >
                 <?php
                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('enoxaparina', ['id'=>'enoxaparina', 'class'=>'enoxaparina']);
                        echo '<label for="enoxaparina">Enoxaparina</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('dalteparina', ['id'=>'dalteparina', 'class'=>'dalteparina']);
                        echo '<label for="dalteparina">Dalteparina</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('fondaparinux', ['id'=>'fondaparinux', 'class'=>'fondaparinux']);
                        echo '<label for="fondaparinux">Fondaparinux</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('nadroparina', ['id'=>'nadroparina', 'class'=>'nadroparina']);
                        echo '<label for="nadroparina">Nadroparina</label>';
                        echo "</div>";
                    echo "</div>";

                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('heparina_nao_funciona', ['id'=>'heparina_nao_funciona', 'class'=>'nadroparina']);
                        echo '<label for="heparina_nao_funciona">Heparina não funciona</label>';
                        echo "</div>";
                    echo "</div><br>";

                    echo $this->Form->input('profilaxia_medicamentosa_inicio', ['type'=>'text','label'=>['text'=>'Data de inicio:', 'class'=>'form-input date'],'empty' => true,'class'=>'date','default' => '']);
                    echo $this->Form->input('profilaxia_medicamentosa_termino', ['type'=>'text','label'=>['text'=>'Data de término:', 'class'=>'form-input date'],'empty' => true,'class'=>'date','default' => '']);

                 ?>
            </div>
            <div class="panel-footer"  >
                <!-- <a href="#" class="btn btn-primary" onclick="nextQuiz(3)">Próximo</a> -->
                <a href="#" class="btn btn-primary" onclick="nextQuiz(4)">Próximo</a>
            </div>
        </div>

        <div class="panel panel-primary" id="quiz-5" style="display:none">
            <div class="panel-heading">
             <h4>Métodos mecânicos</h4>
            </div>
            <div class="panel-body" >

                 <?php
                    echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('meias_elastica', ['id'=>'meias_elastica', 'class'=>'contraindicacao_2']);
                        echo '<label for="meias_elastica">Meias elásticas de compressão gradual</label>';
                        echo "</div>";

                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('compressao_pneumatica', ['id'=>'compressao_pneumatica', 'class'=>'contraindicacao_2']);
                        echo '<label for="compressao_pneumatica">Compressão pneumática intermitente</label>';
                        echo "</div>";

                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('nenhum', ['id'=>'nenhum', 'class'=>'nenhum']);
                        echo '<label for="nenhum">Nenhum</label>';
                        echo "</div>";
                    echo "</div><br>";

                    echo $this->Form->input('metodo_mecanico_inicio', ['type'=>'text','label'=>['text'=>'Data de inicio:', 'class'=>'form-input'],'empty' => true, 'default' => '', 'class'=>'date']);
                    echo $this->Form->input('metodo_mecanico_fim', ['type'=>'text','label'=>['text'=>'Data de retirada:', 'class'=>'form-input'],'empty' => true, 'default' => '', 'class'=>'date']);
                 ?>
                 <p>Obs: quando em uso de profilaxia mecânica, reavaliar em dois dias.</p>                
            </div>
            <div class="panel-footer"  >
                <!-- <a href="#" class="btn btn-primary" onclick="nextQuiz(3)">Próximo</a> -->
                <?= $this->Form->button(__('Salvar')) ?>
            </div>
        </div>


        <div class="panel panel-primary" id="quiz-6" style="display:none">
            <div class="panel-heading">
             <h4>Avaliação do risco de TEV em paciente clínico</h4>
            </div>
            <div class="panel-body" >
                <p>Deambulação e reavaliar em 2 dias.</p>
                 <?php

                 ?>
            </div>
            <div class="panel-footer"  >
                <?= $this->Form->button(__('Salvar')) ?>
            </div>
        </div>

        <div class="panel panel-primary" id="quiz-7" style="display:none">
            <div class="panel-heading">
             <h4>Ajuste posológico</h4>
            </div>
            <div class="panel-body" >
                 <?php
                     echo "<div class='funkyradio' >";
                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('idade_5', ['id'=>'idade_5', 'class'=>'']);
                        echo '<label for="idade_5">Idade</label>';
                        echo "</div>";

                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('insuficiencia_renal_5', ['id'=>'insuficiencia_renal_5', 'class'=>'']);
                        echo '<label for="insuficiencia_renal_5">Insuficiência renal</label>';
                        echo "</div>";

                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('obesidade_imc_40_a_50_5', ['id'=>'obesidade_imc_40_a_50_5', 'class'=>'']);
                        echo '<label for="obesidade_imc_40_a_50_5">Obesidade (IMC 40-50)</label>';
                        echo "</div>";

                        echo '<div class="funkyradio-primary">';
                        echo $this->Form->checkbox('obesidade_imc_maior_50_5', ['id'=>'obesidade_imc_maior_50_5', 'class'=>'']);
                        echo '<label for="obesidade_imc_maior_50_5">Obesidade (IMC > 50)</label>';
                        echo "</div>";
                    echo "</div>";
                 ?>
            </div>
            <div class="panel-footer"  >
                <?= $this->Form->button(__('Salvar')) ?>
            </div>
        </div>


        <?php //echo $this->Form->button(__('Salvar')) ?>
        <?= $this->Form->end() ?>
    </fieldset>

</div>


<script>
var age = 0;

<?= " age =". $age  .";";  ?>

function nextQuiz(param){

    if ( param == 1 )
    {
         $("#quiz-1").hide();

        if ( $("#mobilidade_reduzida").is(":checked") || age >= 40) {
            $("#quiz-2").fadeIn();
        }
        else {
            $("#quiz-6").fadeIn();

        }

    }
    else if ( param == 2 )
    {
        $("#quiz-2").hide();

        var len = $("select[name='risk_factors[_ids][]'] option:selected").length;

        if (len > 0) {
            $("#quiz-3").fadeIn();
        }
        else {
            $("#quiz-6").fadeIn();
        }
        console.log("len = "+len);


    }
    else if ( param == 3 ) {
        var is_checked = false;
        $("#quiz-3").hide();

        $(".contraindicacao").each(function()
        {
            if ( $(this).is(':checked') ) {
                is_checked = true;
                return false;
            }
        });

        if (is_checked) {
            $("#quiz-5").fadeIn();
        }
        else {
            $("#quiz-4").fadeIn();
        }

    }
    else if ( param == 4) {

        $("#quiz-4").hide();

        $("#quiz-7").fadeIn();

    }
}
//console.log("age = "+age);
<?php if ($current_state == "internacao") : ?>
    (function () {
       // your page initialization code here
       // the DOM will be available here
        var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
            array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

        var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var link3 =' <?= $this->Html->link('Internação',['controller' => 'Hospitalizations', 'action' => 'edit', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var link4 =' <?= $this->Html->link('Protocolos',['controller' => 'SepseProtocols', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var html = '';
            html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
            html+= link1;
            html+= link2;
            html+= link3;
            html+= link4;
            html+= '<a href="#" class="breadcumb-active btn btn-default">TEV clínico</a>';
            html+= '</div>';
                document.getElementById("breadcumb").innerHTML =html;
    })();
</script>

<?php else : ?>
    (function() {
       // your page initialization code here
       // the DOM will be available here
       var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>&nbsp;Unidade(s)',
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

       var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

       var link3 =' <?= $this->Html->link('Triagem',['controller' => 'Screenings', 'action' => 'edit', $screening_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var link4 =' <?= $this->Html->link('Protocolos',['controller' => 'SepseProtocols', 'action' => 'index', $screening_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

        var html = '';
            html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
            html+= link1;
            html+= link2;
            html+= link3;
            html+= link4;
            html+= '<a href="#" class="breadcumb-active btn btn-default">TEV clínico</a>';
            html+= '</div>';
                document.getElementById("breadcumb").innerHTML =html;
    })();
</script>
<?php endif; ?>
