<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalTevProtocolsTevOption;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalTevProtocolsTevOptions Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SurgicalTevProtocols
 * @property \Cake\ORM\Association\BelongsTo $TevOptions
 */
class SurgicalTevProtocolsTevOptionsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_tev_protocols_tev_options');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('SurgicalTevProtocols', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('TevOptions', [
            'foreignKey' => 'tev_option_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('surgical_tev_protocols_tev_optionscol');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['surgical_tev_protocol_id'], 'SurgicalTevProtocols'));
        $rules->add($rules->existsIn(['tev_option_id'], 'TevOptions'));
        return $rules;
    }
}
