<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalTevProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";
/**
 * SurgicalTevProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $Contraindications
 * @property \Cake\ORM\Association\BelongsToMany $TevOptions
 */
class SurgicalTevProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_tev_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsToMany('Contraindications', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'targetForeignKey' => 'contraindication_id',
            'joinTable' => 'surgical_tev_protocols_contraindications'
        ]);
        $this->belongsToMany('TevOptions', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'targetForeignKey' => 'tev_option_id',
            'joinTable' => 'surgical_tev_protocols_tev_options'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('risco_da_cirurgica');

        $validator
            ->allowEmpty('duracao_da_cirurgia');

        $validator
            ->boolean('fatores_de_risco_tev')
            ->allowEmpty('fatores_de_risco_tev');

        $validator
            ->allowEmpty('risco_alto_opcoes');

        $validator
            ->allowEmpty('justificativa_medica');

        $validator
            ->boolean('medicacao')
            ->allowEmpty('medicacao');

        $validator
            ->boolean('risco_alto')
            ->allowEmpty('risco_alto');

        $validator
            ->boolean('risco_intermediario')
            ->allowEmpty('risco_intermediario');

        $validator
            ->boolean('meias_elasticas')
            ->allowEmpty('meias_elasticas');

        $validator
            ->boolean('compressao_pneumatica')
            ->allowEmpty('compressao_pneumatica');

        $validator
            ->boolean('fisioterapia_motora')
            ->allowEmpty('fisioterapia_motora');

        $validator
            ->boolean('sangramento_ativo')
            ->allowEmpty('sangramento_ativo');

        $validator
            ->boolean('ulcera_peptica')
            ->allowEmpty('ulcera_peptica');

        $validator
            ->boolean('has_nao_controlada')
            ->allowEmpty('has_nao_controlada');

        $validator
            ->boolean('cagulopatia')
            ->allowEmpty('cagulopatia');

        $validator
            ->boolean('alergia_ou_plaquetopenia')
            ->allowEmpty('alergia_ou_plaquetopenia');

        $validator
            ->boolean('insuficiencia_renal')
            ->allowEmpty('insuficiencia_renal');

        $validator
            ->boolean('coleta_de_lcr')
            ->allowEmpty('coleta_de_lcr');

        $validator
            ->boolean('raquinaelose')
            ->allowEmpty('raquinaelose');

        $validator
            ->boolean('paciente_em_anticuagulante')
            ->allowEmpty('paciente_em_anticuagulante');

        $validator
            ->boolean('artopressia_quadril')
            ->allowEmpty('artopressia_quadril');

        $validator
            ->boolean('artopressa_joelho')
            ->allowEmpty('artopressa_joelho');

        $validator
            ->boolean('trauma_requimedular')
            ->allowEmpty('trauma_requimedular');

        $validator
            ->boolean('fratura_de_quadril')
            ->allowEmpty('fratura_de_quadril');

        $validator
            ->boolean('oncologia_curativa')
            ->allowEmpty('oncologia_curativa');

        $validator
            ->boolean('poltrauma')
            ->allowEmpty('poltrauma');

        $validator
            ->boolean('endoscopia')
            ->allowEmpty('endoscopia');

        $validator
            ->boolean('resseccao')
            ->allowEmpty('resseccao');

        $validator
            ->boolean('laparoscopica')
            ->allowEmpty('laparoscopica');

        $validator
            ->boolean('superficial')
            ->allowEmpty('superficial');

        $validator
            ->boolean('oftamologica')
            ->allowEmpty('oftamologica');

        $validator
            ->boolean('otominrigologica')
            ->allowEmpty('otominrigologica');

        $validator
            ->allowEmpty('outras');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $start_date, $end_date)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'arr_pacientes' => [],
            'tot_pacientes' => 0,

            'arr_pacientes_tev' => [],
            'tot_pacientes_tev' => 0,
            'percen_pacientes_tev' => 0,


            //TAXA DE USO DE PROFILAXIA MEDICAMENTOSA ( PACIENTES COM RISCO DE TEV QUE FIZERAM PROFILAXIA MEDICAMENTOSA / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_profi_medi'=>[
                'tot'=>0,
                'percen'=>0,
                'arr'=>[],
            ],

            //TAXA DE USO DE PROFILAXIA MECANICA ( PACIENTES COM RISCO DE TEV QUE FIZERAM PROFILAXIA MECANICA / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_profi_meca'=>[
                'tot'=>0,
                'percen'=>0,
                'arr' => [],
            ],

            //TAXA DE USO DE NÃO USO DE PROFILAXIA EM PACIENTES COM RISCO ( PACIENTES COM RISCO DE TEV QUE NÃO FIZERAM PROFILAXIA  / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_nao_usou_profilaxia'=>[
                'tot'=>0,
                'percen'=>0,
                'arr' => [],
            ],

            'temp_prof_medi' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'temp_prof_meca' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'temp_prof' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'arr_paciente_risco_obito' => [], //OBITOS DOS PCTES COM RISCO QUE NÃO RECEBERAM PROFILAXIA
            'tot_paciente_risco_obito' => 0,
            'percen_paciente_risco_obito' => 0,
            'data_principais' => [],
            'arr_paciente_tev' => [],
            'total_pacientes_periodo' => 0,
            'tot_paciente_tev' => 0,
            'dates' => [],
            'surgical_tev_protocols' => null,
            'risco_baixo' => ['arr', "tot" => 0, 'percen' => 0],
            'risco_intermediario' => ['arr', "tot" => 0, 'percen' => 0],
            'risco_alto' => ['arr', "tot" => 0, 'percen' => 0],
            'totalRiscoTev' => 0,
            'riscoTevPercentual' => 0,
            'percentualContraIndicacaoParaProfilaxiaTev' => 0,
            'countContraIndicacaoParaProfilaxiaTev' => 0,
            'totalSetorUnidadeInternacao' => 0,
            'totalSetorUnidadeIntensiva' => 0,

            'setorUnidadeInternacaoPercentual' => 0,
            'setorUnidadeIntensivaPercentual' => 0,

             'taxa_adesao_protocolo_tev' => 0,
             'paciente_protocolo_tev' => [
                 'count_pacientes_protocolo_tev' => 0,
                 'setor' => []
             ],
        ];

        $riscoTev = 0;
        $countContraIndicacaoParaProfilaxiaTev = 0;
        $arr_risk_factors = [];
        $arr_risk_factors_novo = [];

        $total_pacientes_periodo = count($hospitalizations);

        $total_hospitalizations_protocols_tev = $data['paciente_protocolo_tev']['count_pacientes_protocolo_tev'];
        $data['tot_paciente_tev'] = $total_hospitalizations_protocols_tev;
        $data['taxa_adesao_protocolo_tev'] = ($total_hospitalizations_protocols_tev * 100) / $total_pacientes_periodo;
        $data['taxa_adesao_protocolo_tev'] = round($data['taxa_adesao_protocolo_tev'], 2);

        $data = $this->patientSector($data, $hospitalizations);

        foreach ($data['paciente_protocolo_tev']['setor'] as $key => $setor)
        {
            $data['paciente_protocolo_tev']['setor'][$key]['percentual'] = ($setor['count'] * 100) / $total_pacientes_periodo;
            $data['paciente_protocolo_tev']['setor'][$key]['percentual'] = round($data['paciente_protocolo_tev']['setor'][$key]['percentual'], 2);
        }

        $principais_contra_indicacaoes = ['sangramento_ativo', 'ulcera_peptica', 'has_nao_controlada', 'cagulopatia', 'alergia_ou_plaquetopenia', 'insuficiencia_renal', 'coleta_de_lcr', 'raquinaelose', 'paciente_em_anticuagulante'];

        foreach ($hospitalizations as $hospitalization)
        {
            //tot pacientes
             if (in_array($hospitalization['id'], $data['arr_pacientes']) == false)
            {
                array_push($data['arr_pacientes'], $hospitalization['id']);
                $data['tot_pacientes']++;
            }

            $active_risck = 0;

            //verifica pra ve se tem algum risco
            if (isset($hospitalization['surgical_tev_protocols']['0']))
            {
                //cria um array com os fatores de risco de tev clinico
                foreach ($hospitalization['surgical_tev_protocols'] as $key => $surgical_tev_protocol)
                {
                    foreach ($surgical_tev_protocol['tev_options'] as $key => $risk_factors)
                    {
                        if (isset($arr_risk_factors[$risk_factors['id']]))
                        {
                            $arr_risk_factors[$risk_factors['id']]['count'] += 1;
                        }
                        else
                        {
                            $arr_risk_factors[$risk_factors['id']]['nome'] = $risk_factors['nome'];
                            $arr_risk_factors[$risk_factors['id']]['count'] = 1;
                            $arr_risk_factors[$risk_factors['id']]['percentual'] = 0;
                        }
                    }

                    switch ($surgical_tev_protocol['risco_de_tev'])
                    {
                        case 'Baixo':
                            $data['risco_baixo']['tot']++;
                            break;

                        case 'Intermediário':
                            $data['risco_intermediario']['tot']++;
                            break;

                        case 'Alto':
                            $data['risco_alto']['tot']++;
                            break;
                    }
                }
                //verifica pra ve se tem algum risco
                if (isset($hospitalization['surgical_tev_protocols']['0']['tev_options']))
                {
                    $active_risck = 1;
                    $riscoTev++;
                }
            }

            //DISTRIBUIÇÃO EM VA DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTERNAÇÃO
            if (($hospitalization['sector']['type_id'] == '7' || $hospitalization['sector']['type_id'] == '8') && $active_risck == 1)
            {
                $data['totalSetorUnidadeInternacao'] += 1;
            }
            //DISTRIBUIÇÃO EM VA DE PACIENTES COM RISCO NOS SETORES : UNIDADES INTENSIVAS
            if (($hospitalization['sector']['type_id'] == '12' || $hospitalization['sector']['type_id'] == '13' || $hospitalization['sector']['type_id'] == '14') && $active_risck == 1)
            {
                $data['totalSetorUnidadeIntensiva'] += 1;
            }

            if (isset($hospitalization['surgical_tev_protocols']))
            {
                foreach ($hospitalization['surgical_tev_protocols'] as $key => $surgical_tev_protocol)
                {
                    if ($surgical_tev_protocol['sangramento_ativo'] == true)
                    {
                        $countContraIndicacaoParaProfilaxiaTev++;
                        break;
                    }
                }
            }

            foreach ($hospitalization["surgical_tev_protocols"] as $key_1 => $neonatal)
            {
                $profilaxia = false;
                $profilaxia_meca = false;

                //calc paciente obito
                if ($hospitalization['status'] == 'obito')
                {
                    if (in_array($hospitalization['id'], $data['arr_paciente_risco_obito']) == false)
                    {
                        array_push($data['arr_paciente_risco_obito'], $hospitalization['id']);
                        $data['tot_paciente_risco_obito']++;
                    }
                }

                //calc tempo de uso Profilaxia medicamentosa
                if (isset($neonatal['profilaxia_medicamentosa_inicio']) &&
                    isset($neonatal['profilaxia_medicamentosa_termino']))
                {
                    $date_init = new \DateTime($neonatal['profilaxia_medicamentosa_inicio']->format('Y-m-d'));
                    $date_end = new \DateTime($neonatal['profilaxia_medicamentosa_termino']->format('Y-m-d'));
                    $days = $date_init->diff($date_end)->days;

                    array_push($data['temp_prof_medi']['arr'], $days);
                    array_push($data['temp_prof']['arr'], $days);
                }

                //calc tempo de uso Profilaxia mecanica
                if (isset($neonatal['metodo_mecanico_inicio']) &&
                    isset($neonatal['metodo_mecanico_fim']))
                {
                    $date_init = new \DateTime($neonatal['metodo_mecanico_inicio']->format('Y-m-d'));
                    $date_end = new \DateTime($neonatal['metodo_mecanico_fim']->format('Y-m-d'));
                    $days = $date_init->diff($date_end)->days;

                    array_push($data['temp_prof_meca']['arr'], $days);
                    array_push($data['temp_prof']['arr'], $days);
                }

                //calc pac com tev
                if (in_array($hospitalization['id'], $data['arr_pacientes_tev']) == false)
                {
                    array_push($data['arr_pacientes_tev'], $hospitalization['id']);
                    $data['tot_pacientes_tev']++;
                }

                if ($neonatal['enoxaparina'])
                {
                    $profilaxia = true;
                }

                 if ($neonatal['dalteparina'])
                {
                    $profilaxia = true;
                }

                 if ($neonatal['fondaparinux'])
                {
                    $profilaxia = true;
                }

                 if ($neonatal['nadroparina'])
                {
                    $profilaxia = true;
                }

                 if ($neonatal['heparina_nao_funciona'])
                {
                    $profilaxia = true;
                }

                if ($profilaxia)
                {
                    if (in_array($hospitalization['id'], $data['paciente_profi_medi']['arr']) == false)
                    {
                        array_push($data['paciente_profi_medi']['arr'], $hospitalization['id']);
                        $data['paciente_profi_medi']['tot']++;
                    }
                }

                if ($neonatal['meias_elasticas'])
                {
                    $profilaxia_meca = true;
                }

                if ($neonatal['compressao_pneumatica'])
                {
                    $profilaxia_meca = true;
                }

                if ($neonatal['fisioterapia_motora'])
                {
                    $profilaxia_meca = true;
                }

                if ($profilaxia_meca)
                {
                    if (in_array($hospitalization['id'], $data['paciente_profi_meca']['arr']) == false)
                    {
                        array_push($data['paciente_profi_meca']['arr'], $hospitalization['id']);
                        $data['paciente_profi_meca']['tot']++;
                    }
                }

                if (!$profilaxia_meca && !$profilaxia)
                {
                    if (in_array($hospitalization['id'], $data['paciente_nao_usou_profilaxia']['arr']) == false)
                    {
                        array_push($data['paciente_nao_usou_profilaxia']['arr'], $hospitalization['id']);
                        $data['paciente_nao_usou_profilaxia']['tot']++;
                    }
                }

                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);
                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }


        //cria array com com fatores de risco, que vai ser usado na view
        foreach ($arr_risk_factors as $key => $value)
        {
            if($data['total_de_registros'] > 0){
                $arr_risk_factors[$key]['percentual'] = ($value['count'] * 100) / $data['total_de_registros'];
                $arr_risk_factors[$key]['percentual'] = round($arr_risk_factors[$key]['percentual'], 2);
            }

        }

        usort($arr_risk_factors, function ($a, $b)
        {
           return $a['count'] < $b['count'];
        });

        $count_risk_factor = 0;
        foreach ($arr_risk_factors as $key => $value)
        {
            if($count_risk_factor > 9){
                unset($arr_risk_factors[$key]);
            }
        }

        $data['fator_risco'] = $arr_risk_factors;

        $data['totalRiscoTev'] = $riscoTev;

        if($total_hospitalizations_protocols_tev > 0){

            //DISTRIBUIÇÃO EM % DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTERNAÇÃO
            $data['setorUnidadeInternacaoPercentual'] = ($data['totalSetorUnidadeInternacao'] * 100) / $total_hospitalizations_protocols_tev;
            $data['setorUnidadeInternacaoPercentual'] = round($data['setorUnidadeInternacaoPercentual'], 2);
            //DISTRIBUIÇÃO EM % DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTENSIVAS
            $data['setorUnidadeIntensivaPercentual'] = ($data['totalSetorUnidadeIntensiva'] * 100) / $total_hospitalizations_protocols_tev;

            $data['riscoTevPercentual'] = number_format(($riscoTev * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');

            if ($data['risco_alto']['tot'] > 0)
            {
                //$data['risco_alto']['percen']
                $data['risco_alto']['percen'] = number_format(($data['risco_alto']['tot'] * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');
            }

            if ($data['risco_baixo']['tot'] > 0)
            {
                //$data['risco_alto']['percen']
                $data['risco_baixo']['percen'] = number_format(($data['risco_baixo']['tot'] * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');
            }

            if ($data['risco_intermediario']['tot'] > 0)
            {
                //$data['risco_alto']['percen']
                $data['risco_intermediario']['percen'] = number_format(($data['risco_intermediario']['tot'] * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');
            }

            //$quantidade de contra indicação para tev
            $data['countContraIndicacaoParaProfilaxiaTev'] = $countContraIndicacaoParaProfilaxiaTev;
            if (isset($total_hospitalizations_protocols_tev))
            {
                $data['percentualContraIndicacaoParaProfilaxiaTev'] = number_format(($countContraIndicacaoParaProfilaxiaTev * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');
            }
        }

        if ($data['paciente_profi_medi']['tot'] > 0)
        {
            $data['paciente_profi_medi']['percen'] = ($data['paciente_profi_medi']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_profi_medi']['percen'] = round($data['paciente_profi_medi']['percen'], 2);
        }

        if ($data['paciente_profi_meca']['tot'] > 0)
        {
            $data['paciente_profi_meca']['percen'] = ($data['paciente_profi_meca']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_profi_meca']['percen'] = round($data['paciente_profi_meca']['percen'], 2);
        }

        if ($data['paciente_nao_usou_profilaxia']['tot'] > 0)
        {
            $data['paciente_nao_usou_profilaxia']['percen'] = ($data['paciente_nao_usou_profilaxia']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_nao_usou_profilaxia']['percen'] = round($data['paciente_nao_usou_profilaxia']['percen'], 2);
        }

        if (count($data['temp_prof_medi']['arr']) > 0)
        {
            $data['temp_prof_medi']['tot'] = $calc_obj->calc_average($data['temp_prof_medi']['arr']);
        }

        if (count($data['temp_prof_meca']['arr']) > 0)
        {
            $data['temp_prof_meca']['tot'] = $calc_obj->calc_average($data['temp_prof_meca']['arr']);
        }

        if (count($data['temp_prof']['arr']) > 0)
        {
            $data['temp_prof']['tot'] = $calc_obj->calc_average($data['temp_prof']['arr']);
        }

        if ($data['tot_paciente_risco_obito'] > 0)
        {
            $data['percen_paciente_risco_obito'] = ($data['tot_paciente_risco_obito']*100) / $data['tot_pacientes_tev'];
            $data['percen_paciente_risco_obito'] = round($data['percen_paciente_risco_obito'], 2);
        }

        if ($data['tot_pacientes_tev'] > 0)
        {
            $data['percen_pacientes_tev'] = ($data['tot_pacientes_tev'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_tev'] = round($data['percen_pacientes_tev'], 2);
        }

        $data_principais = [];
        // cria um array com os contra indicacoes
        foreach ($data as $key => $value) {
           if(in_array($key, $principais_contra_indicacaoes)){
            //echo $key . "<br>";
                $data_principais[$value['total']][$key]['total'] = $value['total'];
                $data_principais[$value['total']][$key]['percentual'] = round($value['percentual'], 2);;
                switch ($key) {
                    case "sangramento_ativo":
                        $data_principais[$value['total']][$key]['nome'] = 'Sangramento Ativo';
                        break;
                    case "ulcera_peptica":
                        $data_principais[$value['total']][$key]['nome'] = 'Ulcera péptica';
                        break;
                    case "has_nao_controlada":
                        $data_principais[$value['total']][$key]['nome'] = 'HAS não controlado (> 180 x 110mmHG)';
                        break;
                    case "cagulopatia":
                        $data_principais[$value['total']][$key]['nome'] = 'Cagulopatia';
                        break;
                    case "alergia_ou_plaquetopenia":
                        $data_principais[$value['total']][$key]['nome'] = 'Alergia ou plaquetopenia por heparina';
                        break;
                    case "insuficiencia_renal":
                        $data_principais[$value['total']][$key]['nome'] = 'Insuficiência renal (Cr* < 30mL/min)';
                        break;
                    case "coleta_de_lcr":
                        $data_principais[$value['total']][$key]['nome'] = 'Coleta de LCR < 24h';
                        break;
                    case "raquinaelose":
                        $data_principais[$value['total']][$key]['nome'] = 'Raquianestesia';
                        break;
                    case "paciente_em_anticuagulante":
                        $data_principais[$value['total']][$key]['nome'] = 'Paciente em uso de anticoagulante';
                        break;
                }
            }
        }

        krsort($data_principais);
        $data['data_principais'] = $data_principais;
        return $data;
    }

    public function patientSector($data, $hospitalizationsProtocolsTev){
        foreach ($hospitalizationsProtocolsTev as $key => $value)
        {
            if (!empty($value['surgical_tev_protocols']))
            {
                $count_surgical_protocolo = count($value['surgical_tev_protocols']);

                foreach ($value['surgical_tev_protocols'] as $key => $surgical_protocols)
                {
                    if ($key == ($count_surgical_protocolo - 1))
                    {
                        $data['paciente_protocolo_tev']['count_pacientes_protocolo_tev']++;

                        if (isset($data['paciente_protocolo_tev']['setor'][$value['sector_id']]['name']))
                        {
                            $data['paciente_protocolo_tev']['setor'][$value['sector_id']]['count'] += 1;
                        }
                        else
                        {
                            $data['paciente_protocolo_tev']['setor'][$value['sector_id']]['name'] = $value['sector']['name'];
                            $data['paciente_protocolo_tev']['setor'][$value['sector_id']]['count'] = 1;
                        }
                    }
                }
            }
        }
        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
