<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalRisk;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalRisks Model
 *
 */
class SurgicalRisksTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->addBehavior('Timestamp');
        $this->table('surgical_risks');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('exame_fisico');

        $validator
            ->allowEmpty('exames_laboratoriais');

        $validator
            ->allowEmpty('observacoes');

        $validator
            ->boolean('tci_preenchido')
            ->allowEmpty('tci_preenchido');

        $validator
            ->allowEmpty('restricoes');

        return $validator;
    }

    // public function buildRules(RulesChecker $rules)
    // {
    //     $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
    //     return $rules;
    // }
}
