<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";
/**
 * SurgicalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class SurgicalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('checar_dois_identificadores_do_paciente')
            ->allowEmpty('checar_dois_identificadores_do_paciente');

        $validator
            ->boolean('anexar_impresso_checklist_de_recepcao_de_orgao')
            ->allowEmpty('anexar_impresso_checklist_de_recepcao_de_orgao');

        $validator
            ->boolean('anamnese_e_exame_fisico')
            ->allowEmpty('anamnese_e_exame_fisico');

        $validator
            ->boolean('algoritmo_tromboembolismo_venoso')
            ->allowEmpty('algoritmo_tromboembolismo_venoso');

        $validator
            ->boolean('avaliacao_pre_anestesica')
            ->allowEmpty('avaliacao_pre_anestesica');

        $validator
            ->boolean('consentimento_cirurgico_sitio_lateralidade')
            ->allowEmpty('consentimento_cirurgico_sitio_lateralidade');

        $validator
            ->boolean('sitio_demarcado')
            ->allowEmpty('sitio_demarcado');

        $validator
            ->boolean('conferencia_paciente_agendamento')
            ->allowEmpty('conferencia_paciente_agendamento');

        $validator
            ->boolean('checar_identificadores_do_paciente')
            ->allowEmpty('checar_identificadores_do_paciente');

        $validator
            ->boolean('atb_profilatico_60_minutos_antes_da_incisao_cirurgica')
            ->allowEmpty('atb_profilatico_60_minutos_antes_da_incisao_cirurgica');

        $validator
            ->time('atb_horario')
            ->allowEmpty('atb_horario');

        $validator
            ->boolean('atb_terapeutico')
            ->allowEmpty('atb_terapeutico');

        $validator
            ->boolean('materiais_implantes_estao_funcionando_e_disponiveis')
            ->allowEmpty('materiais_implantes_estao_funcionando_e_disponiveis');

        $validator
            ->boolean('equipamentos_checados_pela_engenharia_clinica')
            ->allowEmpty('equipamentos_checados_pela_engenharia_clinica');

        $validator
            ->boolean('consentimento_anestesico')
            ->allowEmpty('consentimento_anestesico');

        $validator
            ->boolean('consentimento_cirurgico_com_lateralidade_se_aplicavel')
            ->allowEmpty('consentimento_cirurgico_com_lateralidade_se_aplicavel');

        $validator
            ->boolean('laringoscopio')
            ->allowEmpty('laringoscopio');

        $validator
            ->boolean('kts_ambu')
            ->allowEmpty('kts_ambu');

        $validator
            ->boolean('Aspirador')
            ->allowEmpty('Aspirador');

        $validator
            ->boolean('seringas_identificadoras')
            ->allowEmpty('seringas_identificadoras');

        $validator
            ->boolean('monitor_oximetro_de_pylso_no_paciente_e_funcionando')
            ->allowEmpty('monitor_oximetro_de_pylso_no_paciente_e_funcionando');

        $validator
            ->boolean('via_aerea_dificil')
            ->allowEmpty('via_aerea_dificil');

        $validator
            ->boolean('equipamento_vad_disponivel')
            ->allowEmpty('equipamento_vad_disponivel');

        $validator
            ->boolean('alergia')
            ->allowEmpty('alergia');

        $validator
            ->boolean('profilaxia_para_tev')
            ->allowEmpty('profilaxia_para_tev');

        $validator
            ->boolean('meias_elasticas')
            ->allowEmpty('meias_elasticas');

        $validator
            ->boolean('massageador_intermitente')
            ->allowEmpty('massageador_intermitente');

        $validator
            ->boolean('profilaxia_medicamentosa')
            ->allowEmpty('profilaxia_medicamentosa');

        $validator
            ->boolean('esperado_perda_sanguinea')
            ->allowEmpty('esperado_perda_sanguinea');

        $validator
            ->boolean('acesso_venoso_central')
            ->allowEmpty('acesso_venoso_central');

        $validator
            ->boolean('dois_acessos_disponiveis')
            ->allowEmpty('dois_acessos_disponiveis');

        $validator
            ->boolean('confirmacao_paciente_cirurgia_a_ser_realizado')
            ->allowEmpty('confirmacao_paciente_cirurgia_a_ser_realizado');

        $validator
            ->boolean('checagem_da_equipe_que_esta_em_saia')
            ->allowEmpty('checagem_da_equipe_que_esta_em_saia');

        $validator
            ->boolean('todos_os_materais_uncionando_e_disponiveis')
            ->allowEmpty('todos_os_materais_uncionando_e_disponiveis');

        $validator
            ->boolean('atb_profilático_realizado')
            ->allowEmpty('atb_profilático_realizado');

        $validator
            ->boolean('exames_de_imagens_e_laboratoriais_essenciais_em_saia')
            ->allowEmpty('exames_de_imagens_e_laboratoriais_essenciais_em_saia');

        $validator
            ->boolean('necessidades_de_congelacao_patologista')
            ->allowEmpty('necessidades_de_congelacao_patologista');

        $validator
            ->boolean('informacoes_do_paciente_foram_confirmadas')
            ->allowEmpty('informacoes_do_paciente_foram_confirmadas');

        $validator
            ->boolean('consentimentos_cirurgico_anestesico_foi_assinado')
            ->allowEmpty('consentimentos_cirurgico_anestesico_foi_assinado');

        $validator
            ->boolean('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel')
            ->allowEmpty('visualizacao_o_local_da_cirurgica_marcado_nao_aplicavel');

        $validator
            ->boolean('checklist_da_anestesia_foi_executado')
            ->allowEmpty('checklist_da_anestesia_foi_executado');

        $validator
            ->boolean('ficha_anestesica_esta_completa')
            ->allowEmpty('ficha_anestesica_esta_completa');

        $validator
            ->boolean('recursos_humanos_estao_disponiveis')
            ->allowEmpty('recursos_humanos_estao_disponiveis');

        $validator
            ->boolean('equipamentos_foram_verificados')
            ->allowEmpty('equipamentos_foram_verificados');

        $validator
            ->boolean('monitorizacao_standard_colocada_e_funcionante')
            ->allowEmpty('monitorizacao_standard_colocada_e_funcionante');

        $validator
            ->boolean('acesso_venoso_adequado')
            ->allowEmpty('acesso_venoso_adequado');

        $validator
            ->boolean('alguma_alergia_conhecida')
            ->allowEmpty('alguma_alergia_conhecida');

        $validator
            ->boolean('via_aerea_difícil_risco_de_aspiracao')
            ->allowEmpty('via_aerea_difícil_risco_de_aspiracao');

        $validator
            ->boolean('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo')
            ->allowEmpty('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo');

        $validator
            ->boolean('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado')
            ->allowEmpty('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado');

        $validator
            ->boolean('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente')
            ->allowEmpty('cirurgiao_anestesista_e_enfermeiro_confirmaram_verbalmente');

        $validator
            ->boolean('procedimento_cirurgico_realizado')
            ->allowEmpty('procedimento_cirurgico_realizado');

        $validator
            ->boolean('contagem_correta_de_instrumentos')
            ->allowEmpty('contagem_correta_de_instrumentos');

        $validator
            ->boolean('pecas_anatomicas_produtos_para_analie_corretamente_identificados')
            ->allowEmpty('pecas_anatomicas_produtos_para_analie_corretamente_identificados');

        $validator
            ->boolean('todos_revem_necessidades_pos_operatorias')
            ->allowEmpty('todos_revem_necessidades_pos_operatorias');

        return $validator;
    }

    public function getRelatorioData($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'percen_avaliacao_por_cirurgia' => 0,

            'total_de_avaliacoes' => 0,
            'tot_patient_suspeita_me' => [
                'arr' => [],
            ],

            'arr_pacientes_checklist_cirurgico' => [], //total de pacientes que fizeram o checklist cirugico
            'tot_pacientes_checklist_cirurgico' => 0,

            'arr_pacientes_amostr_enviada' => [], //total de pacientes com amostra biológica enviada
            'tot_pacientes_amostr_enviada' => 0,
            'percen_pacientes_amostr_enviada' => 0,

            'tot_pacientes_com_cirurgia' => 0, //total de pacientes que fizeram cirurgia
            'arr_pacientes_com_cirurgia' => [],

            'compressas' => [
                'arr_compressao_nao_houve_diferen' => [],
                'tot_compressao_nao_houve_diferen' => 0,
                'percen_compressao_nao_houve_diferen' => 0,

                'arr_compressao_teve_houve_diferen' => [],
                'tot_compressao_teve_houve_diferen' => 0,
                'percen_compressao_teve_houve_diferen' => 0,

                'arr_diferenca_entregue_devolvido' => [], //array com a diferenca entre as compressas entregas e devolvidas
                'media_diferenca_entregue_devolvido' => 0,
                'mediana_diferenca_entregue_devolvido' => 0,
                'desvio_padrao_diferenca_entregue_devolvido' => 0,
            ],


            'suplementacao_oxig' =>
            [
                'nao'=>['tot'=>0, 'percen'=>0],
                'cateter_o2'=>['tot'=>0, 'percen'=>0],
                'macronebulizador'=>['tot'=>0, 'percen'=>0],
                'mascara_lari'=>['tot'=>0, 'percen'=>0],
                'tubo_oro'=>['tot'=>0, 'percen'=>0],
                'canula_traque'=>['tot'=>0, 'percen'=>0],
            ],

            'nivel_de_conscie' =>
            [
                'acordado'=>['tot'=>0, 'percen'=>0],
                'adormecido'=>['tot'=>0, 'percen'=>0],
                'sonolento'=>['tot'=>0, 'percen'=>0],
                'coma'=>['tot'=>0, 'percen'=>0],
            ],

            'metodo_profilaxia' =>
            [
                '0'=>['nome' => 'Farmacológica', 'tot'=>0, 'percen'=>0],
                '1' =>['nome' => 'Compressor Intermitente', 'tot'=>0, 'percen'=>0],
                '2'=>['nome' => 'Meias Elásticas', 'tot'=>0, 'percen'=>0],
                '3'=>['nome' => 'Outro', 'tot'=>0, 'percen'=>0],
            ],
            'tipo_cirurgia' => [],
        ];

          $columns = $this->schema()->columns();
          foreach ($columns as $key => $column)
          {
              $data[$column]['total'] = 0;
              $data[$column]['percentual'] = 0;
              $data[$column]['media'] = 0;
              $data[$column]['mediana'] = 0;
              $data[$column]['desvio_padrao'] = 0;
              $data[$column]['soma'] = 0;
          }

        foreach ($hospitalizations as $hospitalization)
        {
            foreach ($hospitalization['surgeries'] as $key => $surgery)
            {
                $data['total_de_registros']++;
                if (!in_array($hospitalization['patient_id'], $data['arr_pacientes_com_cirurgia']))
                {
                    array_push($data['arr_pacientes_com_cirurgia'], $hospitalization['patient_id']);
                    $data['tot_pacientes_com_cirurgia']++;
                }

                foreach ($surgery['specialties'] as $key => $specialties) {
                    if(isset($data['tipo_cirurgia'][$specialties['name']])){
                        $data['tipo_cirurgia'][$specialties['name']]['total'] += 1;
                    }
                    else{
                        $data['tipo_cirurgia'][$specialties['name']]['name'] = $specialties['name'];
                        $data['tipo_cirurgia'][$specialties['name']]['total'] = 1;

                    }

                }
            }


            //$data = $hospitalization["neonatal_checklists"];
            foreach ($hospitalization["surgical_checklists"] as $key_1 => $protocol)
            {
                //calc pacientes que fizeram o checklist
                if (!in_array($hospitalization['patient_id'], $data['arr_pacientes_checklist_cirurgico']))
                {
                    array_push($data['arr_pacientes_checklist_cirurgico'], $hospitalization['patient_id']);
                    $data['tot_pacientes_checklist_cirurgico']++;
                }

                //calcula os pacientes que enviaram  amostra de material
                if ($protocol['tot_amostra_material_enviada'] &&
                    $protocol['tot_amostra_material_enviada'] > 0 &&
                    !in_array($hospitalization['patient_id'], $data['arr_pacientes_com_cirurgia']))
                {
                    array_push($data['arr_pacientes_com_cirurgia'], $hospitalization['patient_id']);
                    $data['tot_pacientes_com_cirurgia']++;
                }

                if ($protocol['contagem_de_compressas'])
                {
                    if ($data['tot_compressas_entregues'] == $data['tot_compressas_devolvidas'])
                    {
                        if (!in_array($hospitalization['patient_id'], $data['compressas']['arr_compressao_nao_houve_diferen']))
                        {
                            array_push($data['compressas']['arr_compressao_nao_houve_diferen'], $hospitalization['patient_id']);
                            $data['compressas']['tot_compressao_nao_houve_diferen']++;
                        }
                    }
                    else
                    {
                        if (!in_array($hospitalization['patient_id'], $data['compressas']['arr_compressao_teve_houve_diferen']))
                        {
                            array_push($data['compressas']['arr_compressao_teve_houve_diferen'], $hospitalization['patient_id']);
                            $data['compressas']['tot_compressao_teve_houve_diferen']++;
                            //$diferenca = $data['tot_compressas_entregues'] / $data['compressas']['arr_compressao_teve_houve_diferen'];
                            $diferenca =  1;
                            array_push($data['compressas']['arr_diferenca_entregue_devolvido'], $diferenca);
                        }
                    }
                }




                switch ($protocol['qual_metodo_de_profilaxia_utilizada'])
                {
                    case '0':
                        $data['metodo_profilaxia']['0']['tot']++;
                        break;

                    case '1':
                        $data['metodo_profilaxia']['1']['tot']++;
                        break;

                    case '2':
                        $data['metodo_profilaxia']['2']['tot']++;
                        break;

                    case '2':
                        $data['metodo_profilaxia']['2']['tot']++;
                        break;
                }

                switch ($protocol['nivel_de_consciencia'])
                {
                    case 'Acordado':
                        $data['nivel_de_conscie']['acordado']['tot']++;
                        break;

                    case 'Adormecido':
                        $data['nivel_de_conscie']['adormecido']['tot']++;
                        break;

                    case 'Sonolento':
                        $data['nivel_de_conscie']['sonolento']['tot']++;
                        break;

                    case 'Coma':
                        $data['nivel_de_conscie']['coma']['tot']++;
                        break;
                }

                switch ($protocol['suplementacao_oxigenio'])
                {
                    case 'Não':
                        $data['suplementacao_oxig']['nao']['tot']++;
                        break;

                    case 'Cateter de O2':
                        $data['suplementacao_oxig']['cateter_o2']['tot']++;
                        break;

                    case 'Macronebulizador':
                        $data['suplementacao_oxig']['macronebulizador']['tot']++;
                        break;

                    case 'Máscara Laríngea':
                        $data['suplementacao_oxig']['mascara_lari']['tot']++;
                        break;

                    case 'Tubo Orotraqueal':
                        $data['suplementacao_oxig']['tubo_oro']['tot']++;
                        break;

                    case 'Cânula de Traqueostomia':
                        $data['suplementacao_oxig']['canula_traque']['tot']++;
                        break;
                }

                $arr = (array) $protocol;
                $i = 0;

                $data['total_de_avaliacoes']++;

                foreach ($arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
               $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                if (isset($data[$key]['percentual']))
                {
                    $data[$key]['total'] = count($data[$key]['arr']);
                    $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_avaliacoes']);
                    $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                    $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                    $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                }
            }
        }

        foreach ($data['tipo_cirurgia'] as $key => $tipo_cirurgia) {
            //echo "<pre>";
            //print_r($tipo_cirurgia);
            $data['tipo_cirurgia'][$tipo_cirurgia['name']]['percentual'] = ($tipo_cirurgia['total'] * 100 ) /$data['total_de_registros'] ;
            $data['tipo_cirurgia'][$tipo_cirurgia['name']]['percentual'] = round($data['tipo_cirurgia'][$tipo_cirurgia['name']]['percentual'], 2);
        }

        foreach ($data['suplementacao_oxig'] as $key => $suplementacao_oxig)
        {
            if ($suplementacao_oxig['tot'] > 0 &&
                $data['total_de_avaliacoes'] > 0)
            {
                $data['suplementacao_oxig'][$key]['percen'] = ($suplementacao_oxig['tot'] *100) / $data['total_de_avaliacoes'];
                $data['suplementacao_oxig'][$key]['percen'] = round($data['suplementacao_oxig'][$key]['percen'], 2);
            }
        }

        if ($data['total_de_registros'] > 0 &&
            $data['total_de_avaliacoes'] > 0)
        {
            $data['percen_avaliacao_por_cirurgia'] = ($data['total_de_avaliacoes'] * 100) /  $data['total_de_registros'];
            $data['percen_avaliacao_por_cirurgia'] = round($data['percen_avaliacao_por_cirurgia'], 2);
        }


        if ($data['tot_pacientes_amostr_enviada'] > 0 &&
            $data['tot_pacientes_checklist_cirurgico'] > 0)
        {
            $data['percen_pacientes_amostr_enviada'] = ($data['tot_pacientes_amostr_enviada'] *100) / $data['tot_pacientes_checklist_cirurgico'];
            $data['percen_pacientes_amostr_enviada'] = round($data['percen_pacientes_amostr_enviada'], 2);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
