<?php
namespace App\Model\Table;

use App\Model\Entity\Screening;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * Screenings Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsTo $Units
 * @property \Cake\ORM\Association\BelongsTo $Professionals
 * @property \Cake\ORM\Association\HasMany $Admissions
 * @property \Cake\ORM\Association\HasMany $Bundles
 * @property \Cake\ORM\Association\HasMany $ChestPainProtocols
 * @property \Cake\ORM\Association\HasMany $ClinicTevProtocols
 * @property \Cake\ORM\Association\HasMany $Hospitalizations
 * @property \Cake\ORM\Association\HasMany $ItuPreventionBundles
 * @property \Cake\ORM\Association\HasMany $MedicalCares
 * @property \Cake\ORM\Association\HasMany $PavPreventionBundles
 * @property \Cake\ORM\Association\HasMany $SafeSurgeryBundles
 * @property \Cake\ORM\Association\HasMany $SepseProtocols
 * @property \Cake\ORM\Association\HasMany $SurgicalTevProtocols
 * @property \Cake\ORM\Association\BelongsToMany $PainCharacteristics
 */
class ScreeningsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('screenings');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Patients', [
            'foreignKey' => 'patient_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Units', [
            'foreignKey' => 'unit_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Professionals', [
            'foreignKey' => 'professional_id',
        ]);
        $this->hasMany('Admissions', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('Bundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('ChestPainProtocols', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('ClinicTevProtocols', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('Hospitalizations', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('ItuPreventionBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('MedicalCares', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('PavPreventionBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('SafeSurgeryBundles', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('SepseProtocols', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('SurgicalTevProtocols', [
            'foreignKey' => 'screening_id',
        ]);
        $this->hasMany('PediatricScreenings', [
            'foreignKey' => 'screening_id',
        ]);
        $this->belongsToMany('PainCharacteristics', [
            'foreignKey' => 'screening_id',
            'targetForeignKey' => 'pain_characteristic_id',
            'joinTable' => 'pain_characteristics_screenings',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('pas');

        $validator
            ->allowEmpty('temp');

        $validator
            ->allowEmpty('sato2');

        $validator
            ->allowEmpty('fc');

        $validator
            ->allowEmpty('fr');

        $validator
            ->allowEmpty('glicemia');

        $validator
            ->boolean('parada_cardiaca_ou_suspeita')
            ->allowEmpty('parada_cardiaca_ou_suspeita');

        $validator
            ->allowEmpty('fraquesa_muscular');

        $validator
            ->allowEmpty('fraquesa_muscular_tipo');

        $validator
            ->allowEmpty('perda_sensorial');

        $validator
            ->allowEmpty('perda_sensorial_tipo');

        $validator
            ->allowEmpty('alteracao_consciencia');

        $validator
            ->allowEmpty('queixa_principal');

        $validator
            ->boolean('tem_alergia')
            ->allowEmpty('tem_alergia');

        $validator
            ->allowEmpty('alergias');

        $validator
            ->boolean('uso_medicacao_regular')
            ->allowEmpty('uso_medicacao_regular');

        $validator
            ->allowEmpty('medicacao_regular');

        $validator
            ->allowEmpty('resumo_da_queixa');

        $validator
            ->allowEmpty('localizacao_da_dor');

        $validator
            ->allowEmpty('aparecimento_da_dor');

        $validator
            ->boolean('dor_toracica_em_aperto')
            ->allowEmpty('dor_toracica_em_aperto');

        $validator
            ->boolean('dor_toracica_dispineia')
            ->allowEmpty('dor_toracica_dispineia');

        $validator
            ->boolean('dor_toracica_assimetria_dos_pulsos')
            ->allowEmpty('dor_toracica_assimetria_dos_pulsos');

        $validator
            ->boolean('dor_toracica_historico_de_coronariopatia')
            ->allowEmpty('dor_toracica_historico_de_coronariopatia');

        $validator
            ->boolean('dor_toracica_historico_de_avc')
            ->allowEmpty('dor_toracica_historico_de_avc');

        $validator
            ->boolean('dor_toracica_trauma_toracico_antecedente')
            ->allowEmpty('dor_toracica_trauma_toracico_antecedente');

        $validator
            ->boolean('dor_abdominal_historico_de_trauma')
            ->allowEmpty('dor_abdominal_historico_de_trauma');

        $validator
            ->boolean('dor_abdominal_diarreia')
            ->allowEmpty('dor_abdominal_diarreia');

        $validator
            ->boolean('dor_abdominal_nausea')
            ->allowEmpty('dor_abdominal_nausea');

        $validator
            ->boolean('dor_abdominal_vomitos')
            ->allowEmpty('dor_abdominal_vomitos');

        $validator
            ->boolean('cefaleia_rigidez_da_nuca')
            ->allowEmpty('cefaleia_rigidez_da_nuca');

        $validator
            ->boolean('cefaleia_vomitos')
            ->allowEmpty('cefaleia_vomitos');

        $validator
            ->boolean('cefaleia_episodio_de_crise_convulsiva')
            ->allowEmpty('cefaleia_episodio_de_crise_convulsiva');

        $validator
            ->boolean('ceruicalgia_historico_progresso_calculo_renal')
            ->allowEmpty('ceruicalgia_historico_progresso_calculo_renal');

        $validator
            ->boolean('ceruicalgia_transplatandos_e_em_quimioterapia')
            ->allowEmpty('ceruicalgia_transplatandos_e_em_quimioterapia');

        $validator
            ->boolean('ceruicalgia_alteracao_de_esfincter')
            ->allowEmpty('ceruicalgia_alteracao_de_esfincter');

        $validator
            ->boolean('dispneia_desconforto')
            ->allowEmpty('dispneia_desconforto');

        $validator
            ->boolean('dispneia_cianose')
            ->allowEmpty('dispneia_cianose');

        $validator
            ->boolean('dispneia_utilizacao_da_musculatura')
            ->allowEmpty('dispneia_utilizacao_da_musculatura');

        $validator
            ->boolean('dispneia_dificuldade_para_falar')
            ->allowEmpty('dispneia_dificuldade_para_falar');

        $validator
            ->boolean('dispneia_historico_de_asma')
            ->allowEmpty('dispneia_historico_de_asma');

        $validator
            ->boolean('dispneia_alteracao_na_ausculta')
            ->allowEmpty('dispneia_alteracao_na_ausculta');

        $validator
            ->boolean('diarreia_sinais_de_desidratacao')
            ->allowEmpty('diarreia_sinais_de_desidratacao');

        $validator
            ->boolean('diarreia_dor_abdominal')
            ->allowEmpty('diarreia_dor_abdominal');

        $validator
            ->boolean('diarreia_nausea_e_vomito')
            ->allowEmpty('diarreia_nausea_e_vomito');

        $validator
            ->boolean('diarreia_sinais_vitais_normais')
            ->allowEmpty('diarreia_sinais_vitais_normais');

        $validator
            ->boolean('tosse_dispneia')
            ->allowEmpty('tosse_dispneia');

        $validator
            ->boolean('tosse_historico_de_hemoptise')
            ->allowEmpty('tosse_historico_de_hemoptise');

        $validator
            ->boolean('tosse_dor_toracica_ausente')
            ->allowEmpty('tosse_dor_toracica_ausente');

        $validator
            ->boolean('hemorragia_historico_de_enterorragia')
            ->allowEmpty('hemorragia_historico_de_enterorragia');

        $validator
            ->boolean('hemorragia_antecedente_de_cirrose')
            ->allowEmpty('hemorragia_antecedente_de_cirrose');

        $validator
            ->boolean('queixa_cronica_nao_agudizada')
            ->allowEmpty('queixa_cronica_nao_agudizada');

        $validator
            ->boolean('lesoes_de_pele_escabiose')
            ->allowEmpty('lesoes_de_pele_escabiose');

        $validator
            ->boolean('lesoes_de_pele_eczema')
            ->allowEmpty('lesoes_de_pele_eczema');

        $validator
            ->boolean('lesoes_de_pele_outras_lesoes')
            ->allowEmpty('lesoes_de_pele_outras_lesoes');

        $validator
            ->allowEmpty('intensidade_da_dor');

        $validator
            ->boolean('alt_estado_mental_ausencia_de_resposta')
            ->allowEmpty('alt_estado_mental_ausencia_de_resposta');

        $validator
            ->boolean('alt_estado_mental_alteracao_consciencia')
            ->allowEmpty('alt_estado_mental_alteracao_consciencia');

        $validator
            ->boolean('deficit_motor_inicio_subito')
            ->allowEmpty('deficit_motor_inicio_subito');

        $validator
            ->boolean('febre_alteracao_nivel_consciencia')
            ->allowEmpty('febre_alteracao_nivel_consciencia');

        $validator
            ->boolean('febre_dispneia')
            ->allowEmpty('febre_dispneia');

        $validator
            ->boolean('febre_imunossupressao')
            ->allowEmpty('febre_imunossupressao');

        $validator
            ->boolean('hiperglicemia_associada_alteracao')
            ->allowEmpty('hiperglicemia_associada_alteracao');

        $validator
            ->boolean('hipoglicemia_glicemia_capilar')
            ->allowEmpty('hipoglicemia_glicemia_capilar');

        $validator
            ->allowEmpty('glasgow');

        $validator
            ->allowEmpty('classificacao_sugerida');

        $validator
            ->allowEmpty('pad');

        $validator
            ->allowEmpty('classificacao_selecionada');

        $validator
            ->boolean('portador_necessidas_especiais')
            ->allowEmpty('portador_necessidas_especiais');

        $validator
            ->boolean('esta_gestente_ou_suspeita')
            ->allowEmpty('esta_gestente_ou_suspeita');

        $validator
            ->boolean('obstetricia')
            ->allowEmpty('obstetricia');

        $validator
            ->boolean('classificacao_obstetrica')
            ->allowEmpty('classificacao_obstetrica');

        $validator
            ->boolean('desmaio_nao_responsivo')
            ->allowEmpty('desmaio_nao_responsivo');

        $validator
            ->boolean('desmaio_choque')
            ->allowEmpty('desmaio_choque');

        $validator
            ->boolean('desmaio_saturacao')
            ->allowEmpty('desmaio_saturacao');

        $validator
            ->boolean('desmaio_nao_vermelho')
            ->allowEmpty('desmaio_nao_vermelho');

        $validator
            ->boolean('desmaio_alteracao_consciencia')
            ->allowEmpty('desmaio_alteracao_consciencia');

        $validator
            ->boolean('desmaio_padrao_respiratorio')
            ->allowEmpty('desmaio_padrao_respiratorio');

        $validator
            ->allowEmpty('desmaio_pas');

        $validator
            ->boolean('desmaio_pa')
            ->allowEmpty('desmaio_pa');

        $validator
            ->boolean('desmaio_prelatorio_diabetes')
            ->allowEmpty('desmaio_prelatorio_diabetes');

        $validator
            ->boolean('desmaio_febre')
            ->allowEmpty('desmaio_febre');

        $validator
            ->boolean('desmaio_pacientes_imunodeprimidas')
            ->allowEmpty('desmaio_pacientes_imunodeprimidas');

        $validator
            ->boolean('desmaio_encaminhamento_centro')
            ->allowEmpty('desmaio_encaminhamento_centro');

        $validator
            ->boolean('desmaio_atendimento_nao_prioritario')
            ->allowEmpty('desmaio_atendimento_nao_prioritario');

        $validator
            ->boolean('abdominal_periodo_expulsivo')
            ->allowEmpty('abdominal_periodo_expulsivo');

        $validator
            ->boolean('abdominal_prolapso')
            ->allowEmpty('abdominal_prolapso');

        $validator
            ->boolean('abdominal_exteriorizacao')
            ->allowEmpty('abdominal_exteriorizacao');

        $validator
            ->boolean('abdominal_sinais_choque')
            ->allowEmpty('abdominal_sinais_choque');

        $validator
            ->allowEmpty('abdominal_dor');

        $validator
            ->boolean('abdominal_contracoes')
            ->allowEmpty('abdominal_contracoes');

        $validator
            ->boolean('abdominal_hipertonia')
            ->allowEmpty('abdominal_hipertonia');

        $validator
            ->boolean('abdominal_pa')
            ->allowEmpty('abdominal_pa');

        $validator
            ->boolean('abdominal_perda_liquido')
            ->allowEmpty('abdominal_perda_liquido');

        $validator
            ->boolean('abdominal_portadora')
            ->allowEmpty('abdominal_portadora');

        $validator
            ->boolean('abdominal_portadora_hiv')
            ->allowEmpty('abdominal_portadora_hiv');

        $validator
            ->boolean('abdominal_pos_parto')
            ->allowEmpty('abdominal_pos_parto');

        $validator
            ->boolean('abdominal_dor_lombar')
            ->allowEmpty('abdominal_dor_lombar');

        $validator
            ->boolean('abdominal_contracoes_intervalo')
            ->allowEmpty('abdominal_contracoes_intervalo');

        $validator
            ->boolean('abdominal_ausencia')
            ->allowEmpty('abdominal_ausencia');

        $validator
            ->boolean('abdominal_vitima')
            ->allowEmpty('abdominal_vitima');

        $validator
            ->boolean('abdominal_febril')
            ->allowEmpty('abdominal_febril');

        $validator
            ->boolean('abdominal_perda_liquido_pequena')
            ->allowEmpty('abdominal_perda_liquido_pequena');

        $validator
            ->boolean('abdominal_encaminhamento')
            ->allowEmpty('abdominal_encaminhamento');

        $validator
            ->boolean('abdominal_atendimento_prioritario')
            ->allowEmpty('abdominal_atendimento_prioritario');

        $validator
            ->allowEmpty('ocular');

        $validator
            ->allowEmpty('verbal');

        $validator
            ->allowEmpty('motora');

        $validator
            ->boolean('dor_cabeca_apneia')
            ->allowEmpty('dor_cabeca_apneia');

        $validator
            ->boolean('dor_cabeca_choque')
            ->allowEmpty('dor_cabeca_choque');

        $validator
            ->allowEmpty('dor_cabeca_alteracao_consciencia');

        $validator
            ->allowEmpty('dor_cabeca_pas');

        $validator
            ->boolean('dor_cabeca_pa_maior_140')
            ->allowEmpty('dor_cabeca_pa_maior_140');

        $validator
            ->boolean('dor_cabeca_dor_intensa')
            ->allowEmpty('dor_cabeca_dor_intensa');

        $validator
            ->boolean('dor_cabeca_disturbios')
            ->allowEmpty('dor_cabeca_disturbios');

        $validator
            ->boolean('dor_cabeca_hipertermia')
            ->allowEmpty('dor_cabeca_hipertermia');

        $validator
            ->boolean('dor_cabeca_dor_forte')
            ->allowEmpty('dor_cabeca_dor_forte');

        $validator
            ->boolean('dor_cabeca_febre')
            ->allowEmpty('dor_cabeca_febre');

        $validator
            ->boolean('dor_cabeca_febril')
            ->allowEmpty('dor_cabeca_febril');

        $validator
            ->boolean('dor_cabeca_atendimento')
            ->allowEmpty('dor_cabeca_atendimento');

        $validator
            ->allowEmpty('falta_ar_saturacao');

        $validator
            ->boolean('falta_ar_estridor')
            ->allowEmpty('falta_ar_estridor');

        $validator
            ->boolean('falta_ar_choque')
            ->allowEmpty('falta_ar_choque');

        $validator
            ->boolean('falta_ar_padrao')
            ->allowEmpty('falta_ar_padrao');

        $validator
            ->allowEmpty('falta_ar_pas');

        $validator
            ->boolean('cefaleia_inicio_subito')
            ->allowEmpty('cefaleia_inicio_subito');

        $validator
            ->boolean('cefaleia_deficit_motor_agudo')
            ->allowEmpty('cefaleia_deficit_motor_agudo');

        $validator
            ->boolean('dor_toracica_dor_precordial')
            ->allowEmpty('dor_toracica_dor_precordial');

        $validator
            ->boolean('dor_toracica_irradiacao')
            ->allowEmpty('dor_toracica_irradiacao');

        $validator
            ->boolean('parada_ausecia_pulso')
            ->allowEmpty('parada_ausecia_pulso');

        $validator
            ->boolean('parada_ausecia_movimentos')
            ->allowEmpty('parada_ausecia_movimentos');

        $validator
            ->boolean('parada_inconsciencia')
            ->allowEmpty('parada_inconsciencia');

        return $validator;
    }

    public function getRelatorioData($screenings, $date_before, $date_after, $health_insurance_plans, $hospitalizations, $professionals)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'total_de_emergencias' => 0,
            'total_de_atendimento' => 0,

            'tot_pacientes_internados_da_emergencia' => 0, //pacientes que forma internados e vieram da emergência
            'media_taxa_captacao_emergencia' => 0, // total de pacientes atendidos na emergência e internados no hospital / total de pacientes atendidos
            'percen_taxa_captacao_emergencia' => 0,

            'tot_patient_suspeita_me' => [
                'arr' => [],
            ],

            'arr_tempo_entre_chegado_triagem' => [],
            'media_tempo_entre_chegado_triagem' => 0,

            'tot_emergencia_mudaram_de_cor' => 0, // total de emergencia em que se foi alterado a classificacao de risco
            'percen_emergencia_mudaram_de_cor' => 0,

            'arr_tempo_entre_triagem_atendimento' => [],
            'min_tempo_entre_triagem_atendimento' => 0,
            'media_tempo_entre_triagem_atendimento' => 0,
            'max_tempo_entre_triagem_atendimento' => 0,

            //VALOR ABSOLUTO E % DOS ATENDIMENTOS SEPARADOS POR CORES DE CLASSIFICAÇÃO NO PERÍODO
            'azul' => [
                'tot_atendimento' => 0,
                'percen_atendimento' => 0,

                'media_taxa_captacao_emergencia' => 0, // total de pacientes atendidos na emergência e internados no hospital / total de pacientes atendidos
                'percen_taxa_captacao_emergencia' => 0,

                'tot_mudaram_para_verde' => 0,
                'percen_mudaram_para_verde' => 0,
                'tot_mudaram_para_amarelo' => 0,
                'percen_mudaram_para_amarelo' => 0,
                'tot_mudaram_para_vermelho' => 0,
                'percen_mudaram_para_vermelho' => 0,

                'arr_tempo_entre_triagem_atendimento' => [],
                'min_tempo_entre_triagem_atendimento' => 0,
                'media_tempo_entre_triagem_atendimento' => 0,
                'max_tempo_entre_triagem_atendimento' => 0,

                'arr_idade_dos_pacientes' => [],
                'media_idade_dos_pacientes' => 0,

                'tempo_entre_1_e_2_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_todos_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_primeiro_ultimo_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],
            ],
            'verde' => [
                'tot_atendimento' => 0,
                'percen_atendimento' => 0,

                'media_taxa_captacao_emergencia' => 0, // total de pacientes atendidos na emergência e internados no hospital / total de pacientes atendidos
                'percen_taxa_captacao_emergencia' => 0,

                'tot_mudaram_para_azul' => 0,
                'percen_mudaram_para_azul' => 0,
                'tot_mudaram_para_amarelo' => 0,
                'percen_mudaram_para_amarelo' => 0,
                'tot_mudaram_para_vermelho' => 0,
                'percen_mudaram_para_vermelho' => 0,

                'arr_tempo_entre_triagem_atendimento' => [],
                'min_tempo_entre_triagem_atendimento' => 0,
                'media_tempo_entre_triagem_atendimento' => 0,
                'max_tempo_entre_triagem_atendimento' => 0,

                'arr_idade_dos_pacientes' => [],
                'media_idade_dos_pacientes' => 0,

                'tempo_entre_1_e_2_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_todos_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_primeiro_ultimo_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],
            ],
            'amarelo' => [
                'tot_atendimento' => 0,
                'percen_atendimento' => 0,

                'media_taxa_captacao_emergencia' => 0, // total de pacientes atendidos na emergência e internados no hospital / total de pacientes atendidos
                'percen_taxa_captacao_emergencia' => 0,

                'tot_mudaram_para_azul' => 0,
                'percen_mudaram_para_azul' => 0,
                'tot_mudaram_para_verde' => 0,
                'percen_mudaram_para_verde' => 0,
                'tot_mudaram_para_vermelho' => 0,
                'percen_mudaram_para_vermelho' => 0,

                'arr_tempo_entre_triagem_atendimento' => [],
                'min_tempo_entre_triagem_atendimento' => 0,
                'media_tempo_entre_triagem_atendimento' => 0,
                'max_tempo_entre_triagem_atendimento' => 0,

                'arr_idade_dos_pacientes' => [],
                'media_idade_dos_pacientes' => 0,

                'tempo_entre_1_e_2_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_todos_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_primeiro_ultimo_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],
            ],
            'vermelho' => [
                'tot_atendimento' => 0,
                'percen_atendimento' => 0,

                'media_taxa_captacao_emergencia' => 0, // total de pacientes atendidos na emergência e internados no hospital / total de pacientes atendidos
                'percen_taxa_captacao_emergencia' => 0,

                'tot_mudaram_para_azul' => 0,
                'percen_mudaram_para_azul' => 0,
                'tot_mudaram_para_verde' => 0,
                'percen_mudaram_para_verde' => 0,
                'tot_mudaram_para_amarelo' => 0,
                'percen_mudaram_para_amarelo' => 0,

                'arr_tempo_entre_triagem_atendimento' => [],
                'min_tempo_entre_triagem_atendimento' => 0,
                'media_tempo_entre_triagem_atendimento' => 0,
                'max_tempo_entre_triagem_atendimento' => 0,

                'arr_idade_dos_pacientes' => [],
                'media_idade_dos_pacientes' => 0,

                'tempo_entre_1_e_2_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_todos_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],

                'tempo_entre_primeiro_ultimo_atend_medico' => [
                    'arr' => [],
                    'tempo_minimo' => 0,
                    'tempo_medio' => 0,
                    'tempo_maximo' => 0,
                ],
            ],

            'convenios' => [],

            'arr_idade_dos_pacientes' => [],
            'media_idade_dos_pacientes' => 0,

            'tempo_entre_1_e_2_atend_medico' => [
                'arr' => [],
                'tempo_minimo' => 0,
                'tempo_medio' => 0,
                'tempo_maximo' => 0,
            ],

            'tempo_entre_todos_atend_medico' => [
                'arr' => [],
                'tempo_minimo' => 0,
                'tempo_medio' => 0,
                'tempo_maximo' => 0,
            ],

            'tempo_entre_primeiro_ultimo_atend_medico' => [
                'arr' => [],
                'tempo_minimo' => 0,
                'tempo_medio' => 0,
                'tempo_maximo' => 0,
            ],

            'dia_da_semana_internado' => [
                0 => ['tot' => 0],
                1 => ['tot' => 0],
                2 => ['tot' => 0],
                3 => ['tot' => 0],
                4 => ['tot' => 0],
                5 => ['tot' => 0],
                6 => ['tot' => 0],
            ],

            'dia_da_semana_emergencia' => [
                0 => ['tot' => 0, 'taxa_captacao' => 0],
                1 => ['tot' => 0, 'taxa_captacao' => 0],
                2 => ['tot' => 0, 'taxa_captacao' => 0],
                3 => ['tot' => 0, 'taxa_captacao' => 0],
                4 => ['tot' => 0, 'taxa_captacao' => 0],
                5 => ['tot' => 0, 'taxa_captacao' => 0],
                6 => ['tot' => 0, 'taxa_captacao' => 0],
            ],

            'turno_emergencia' => [
                'madrugada' => ['tot' => 0, 'taxa_captacao' => 0],
                'manha' => ['tot' => 0, 'taxa_captacao' => 0],
                'tarde' => ['tot' => 0, 'taxa_captacao' => 0],
                'noite' => ['tot' => 0, 'taxa_captacao' => 0],
            ],

            'turno_internacao' => [
                'madrugada' => ['tot' => 0],
                'manha' => ['tot' => 0],
                'tarde' => ['tot' => 0],
                'noite' => ['tot' => 0],
            ],

            'tot_pacientes_na_uti' => 0,
            'tot_pacientes_na_unidade_internacao' => 0,
            'tot_pacientes_internados' => 0,
            'taxa_captacao_unidade_intensiva' => 0, //total de pacientes internados nas utis/ total de internações
            'taxa_captacao_unidade_internacao' => 0,

            'arr_pacientes_internados_na_emergencia' => [],
            'tot_pacientes_internados_na_emergencia' => 0,

            'tot_pacientes_internados_na_emergencia_sup_24h' => 0,
            'percen_pacientes_internados_na_emergencia_sup_24h' => 0,
            'arr_pacientes_internados_na_emergencia_sup_24h' => [],
            'percen_pacientes_internados_na_emergencia_sup_24h' => 0,

            'arr_media_horas_pacientes_internados_emergencia' => [],
            'media_horas_pacientes_internados_emergencia' => 0,

            'dia_da_semana' => [
                0 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                1 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                2 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                3 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                4 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                5 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
                6 => [
                    'tot_internados' => 0,
                    'tot_atendidos' => 0,
                    'taxa' => 0,
                ],
            ],

            'hospitalizations' => [],

            'desfecho_int_na_emergencia' => [ //destino dos pacientes que estão internados na emergência
                'centro_cirurgico' => [
                    'tot_pacientes_tranferidos' => 0,
                    'percen_pacientes_tranferidos' => 0,
                ],

                'unidade_internacao' => [
                    'tot_pacientes_tranferidos' => 0,
                    'percen_pacientes_tranferidos' => 0,
                ],

                'terapia_intensiva' => [
                    'tot_pacientes_tranferidos' => 0,
                    'percen_pacientes_tranferidos' => 0,
                    //'tava_na_emergencia' => 0,
                    //'arr_tava_na_emergencia' => [],
                   // 'arr_data_tava_na_emergencia' => [],
                    //'movimentacao' => [],
                ],
            ],

            'professionals' => [],


        ];        

        foreach ($professionals as $professional)
        {
            $professional_name = $professional['user']['name'];
            $professional_id = $professional['id'];
            $data['professionals'][$professional_id] = [
                'name' => $professional_name,
                'tot_pacientes_atendidos' => 0, //total de pacientes atendidos na emergência pelo médico
                'tot_pacientes_internados' => 0, //total de pacientes internados pelo médico
                'taxa_de_captacao' => 0,
            ];
        }

        foreach ($health_insurance_plans as $convenio)
        {
            $convenio_name = $convenio['name'];
            $convenio_id = $convenio['id'];
            $data['convenios'][$convenio_id] = [
                'name' => $convenio_name,
                'tot' => 0, //total de pacientes atendidos na emergência pelo convênio/saúde complementar
                'percen' => 0,

                'tot_pacientes_internados' => 0,
                'taxa_captacao_convenio' => 0,

                'azul' => [
                    'tot_atendimento' => 0,
                    'percen_atendimento' => 0,
                ],

                'verde' => [
                    'tot_atendimento' => 0,
                    'percen_atendimento' => 0,
                ],

                'amarelo' => [
                    'tot_atendimento' => 0,
                    'percen_atendimento' => 0,
                ],

                'vermelho' => [
                    'tot_atendimento' => 0,
                    'percen_atendimento' => 0,
                ],

                'arr_idade_dos_pacientes' => [],
                'media_idade_dos_pacientes' => 0,
            ];
        }

        foreach ($hospitalizations as $hospitalization)
        {
            array_push($data['hospitalizations'], $hospitalization);

            $data['tot_pacientes_internados']++;
            $arr_unidade_intensiva = [12, 13, 14];

            if ($hospitalization['date_of_hospitalization'] >= $date_before &&
                $hospitalization['date_of_hospitalization'] <= $date_after
            )
            {
                $dia_da_semana = new \DateTime($hospitalization['date_of_hospitalization']->format('Y-m-d'));
                $data['dia_da_semana'][$dia_da_semana->format('w')]['tot_internados']++;

                // if (isset($hospitalization['historic_patient_movements'][0]))

                // {

                //     if ($hospitalization['historic_patient_movements'][0]['room']['sector']['sector_id'] <= 3) //so setores da emergencia

                //     {

                //         $data['tot_pacientes_internados_na_emergencia']++;

                //     }

                // }
                if ($hospitalization['patient']['health_insurance_plan_id'])
                {
                    $convenio_id = $hospitalization['patient']['health_insurance_plan_id'];
                    $data['convenios'][$convenio_id]['tot_pacientes_internados']++;
                }

                if ($hospitalization['professional_id'])
                {
                    $professional_id = $hospitalization['professional_id'];
                    $data['professionals'][$professional_id]['tot_pacientes_internados']++;
                }

                if (isset($hospitalization['historic_patient_movements']['room']))
                {
                    if (in_array($hospitalization['historic_patient_movements']['room'], $arr_unidade_intensiva))
                    {
                        $data['tot_pacientes_na_uti']++;
                    }
                }

                if ($hospitalization['origin']['name'] == 'Emergência')
                {
                    $data['tot_pacientes_internados_da_emergencia']++;
                }

                if ($hospitalization['created'])
                {
                    $dayofweek = new \DateTime($hospitalization['created']->format('Y-m-d'));
                    $data['dia_da_semana_internado'][$dayofweek->format('w')]['tot']++;

                    $time = $hospitalization['created']->format('H:i:s');

                    if (strtotime($time) >= strtotime('00:00:00') &&
                        strtotime($time) <= strtotime('06:00:00'))
                    {
                        $data['turno_internacao']['madrugada']['tot']++;
                    }
                    elseif (strtotime($time) >= strtotime('06:00:00') &&
                        strtotime($time) <= strtotime('11:59:00'))
                    {
                        $data['turno_internacao']['manha']['tot']++;
                    }
                    elseif (strtotime($time) >= strtotime('12:00:00') &&
                        strtotime($time) <= strtotime('17:59:00'))
                    {
                        $data['turno_internacao']['tarde']['tot']++;
                    }
                    elseif (strtotime($time) >= strtotime('18:00:00') &&
                        strtotime($time) <= strtotime('23:59:00'))
                    {
                        $data['turno_internacao']['noite']['tot']++;
                    }
                }
            }

            usort($hospitalization['historic_patient_movements'], function ($a, $b)
            {   
                if ($a['data_inicio'] && $b['data_inicio']  )
                {
                    $a['data_inicio'] = new \Datetime($a['data_inicio']->format('Y-m-d'));
                    $b['data_inicio'] = new \Datetime($b['data_inicio']->format('Y-m-d'));

                    return $a['id'] > $b['id'];
                }
                else
                {
                    return false;
                }
                
            });

            $estava_na_emergencia = false;
            $data_movimentacao_anterior = null;
            foreach ($hospitalization['historic_patient_movements'] as $movimentacao) 
            {                
                if ($estava_na_emergencia)
                {
                    $movimentacao['data_inicio'] = new \Datetime($movimentacao['data_inicio']->format('Y-m-d'));
                    $date_before = new \Datetime($date_before->format('Y-m-d'));
                    $date_after = new \Datetime($date_after->format('Y-m-d'));

                    if ($movimentacao['data_inicio'] >= $date_before &&
                        $movimentacao['data_inicio'] <= $date_after)
                    {                        
                        //centro cirurgico
                        if ($movimentacao['room']['sector']['type_id'] >= 4 && 
                            $movimentacao['room']['sector']['type_id']  <= 6)
                        {
                            $data['desfecho_int_na_emergencia']['centro_cirurgico']['tot_pacientes_tranferidos']++;
                        }
                        //unidade internacao
                        else if ($movimentacao['room']['sector']['type_id'] >= 7 && 
                            $movimentacao['room']['sector']['type_id']  <= 11)
                        {
                            $data['desfecho_int_na_emergencia']['unidade_internacao']['tot_pacientes_tranferidos']++;
                        }
                        //terapia_intensiva
                        else if ($movimentacao['room']['sector']['type_id'] >= 12 && 
                            $movimentacao['room']['sector']['type_id']  <= 17)
                        {
                            $data['desfecho_int_na_emergencia']['terapia_intensiva']['tot_pacientes_tranferidos']++;
                        }
                        
                        $estava_na_emergencia = false;
                                            
                        $interval = $movimentacao['data_inicio']->diff($data_movimentacao_anterior);
                        if ($interval->days > 1)
                        {
                            if (!in_array($hospitalization['id'], $data['arr_pacientes_internados_na_emergencia_sup_24h']))
                            {
                                $data['tot_pacientes_internados_na_emergencia_sup_24h']++;
                                array_push($data['arr_pacientes_internados_na_emergencia_sup_24h'], $hospitalization['id']);

                                $interval_hours = ($interval->days * 24) + $interval->h;
                                array_push($data['arr_media_horas_pacientes_internados_emergencia'], $interval_hours);
                            }
                        }
                        //arr_media_horas_pacientes_internados_emergencia
                        // 'media_horas_pacientes_internados_emergencia' => 0,                  
                    }
                    
                }
                
                //emergência
                if ($movimentacao['room']['sector']['type_id'] <= 3)
                {
                    $estava_na_emergencia = true;                    

                    $movimentacao['data_inicio'] = new \Datetime($movimentacao['data_inicio']->format('Y-m-d'));
                    $data_movimentacao_anterior = $movimentacao['data_inicio'];

                    $date_before = new \Datetime($date_before->format('Y-m-d'));
                    $date_after = new \Datetime($date_after->format('Y-m-d'));

                    if ($movimentacao['data_inicio'] >= $date_before &&
                        $movimentacao['data_inicio'] <= $date_after)
                    {
                        if (!in_array($hospitalization['id'], $data['arr_pacientes_internados_na_emergencia']))
                        {
                            array_push($data['arr_pacientes_internados_na_emergencia'], $hospitalization['id']);
                            $data['tot_pacientes_internados_na_emergencia']++;
                        }
                    }                                                                       
                }                                             
            }
        }

        foreach ($screenings as $screening)
        {
            $cor_da_classificacao = null;

            if ($screening['created'])
            {
                $dayofweek = new \DateTime($screening['created']->format('Y-m-d'));
                $data['dia_da_semana_emergencia'][$dayofweek->format('w')]['tot']++;
                $data['dia_da_semana'][$dayofweek->format('w')]['tot_atendidos']++;

                $time = $screening['created']->format('H:i:s');

                if (strtotime($time) >= strtotime('00:00:00') &&
                    strtotime($time) <= strtotime('06:00:00'))
                {
                    $data['turno_emergencia']['madrugada']['tot']++;
                }
                elseif (strtotime($time) >= strtotime('06:00:00') &&
                    strtotime($time) <= strtotime('11:59:00'))
                {
                    $data['turno_emergencia']['manha']['tot']++;
                }
                elseif (strtotime($time) >= strtotime('12:00:00') &&
                    strtotime($time) <= strtotime('17:59:00'))
                {
                    $data['turno_emergencia']['tarde']['tot']++;
                }
                elseif (strtotime($time) >= strtotime('18:00:00') &&
                    strtotime($time) <= strtotime('23:59:00'))
                {
                    $data['turno_emergencia']['noite']['tot']++;
                }
            }

            if ($screening['sel'])
            {
                $classificacao_anterior = strtolower($screening['classificacao_sugerida']);
                $cor_da_classificacao = strtolower($screening['classificacao_selecionada']);

                if ($classificacao_anterior && $cor_da_classificacao)
                {
                    $index_string = 'tot_mudaram_para_' . $cor_da_classificacao;
                    $data[$classificacao_anterior][$index_string]++;
                }

                $data['tot_emergencia_mudaram_de_cor']++;
            }
            else
            {
                $cor_da_classificacao = strtolower($screening['classificacao_sugerida']);
            }

            $days = null;

            if ($screening['patient']['birthday'])
            {
                $birthday = new \DateTime($screening['patient']['birthday']->format('Y-m-d'));
                $today = new \DateTime();
                $days = $birthday->diff($today)->days;
                $age = $birthday->diff($today)->y;

                if ($cor_da_classificacao)
                {
                    array_push($data[$cor_da_classificacao]['arr_idade_dos_pacientes'], $age);
                }
            }
            
            if ($screening['professional_id'])
            {
                $professional_id = $screening['professional_id'];
                $data['professionals'][$professional_id]['tot_pacientes_atendidos']++;
            }

            if ($screening['patient']['health_insurance_plan_id'])
            {

                $convenio_id = $screening['patient']['health_insurance_plan_id'];
                $data['convenios'][$convenio_id]['tot']++;

                if ($cor_da_classificacao)
                {
                    $data['convenios'][$convenio_id][$cor_da_classificacao]['tot_atendimento']++;
                }

                if ($age)
                {
                    array_push($data['convenios'][$convenio_id]['arr_idade_dos_pacientes'], $age);
                }
            }

                // foreach ($data['convenios'] as $key_convenio => $convenio)

                // {

                //     if ($convenio['name'] == $screening['patient']['medical_care'])

                //     {

                //         $data['convenios'][$key_convenio]['tot']++;

                //         if ($cor_da_classificacao)

                //         {

                //             $data['convenios'][$key_convenio][$cor_da_classificacao]['tot_atendimento']++;

                //         }

                //         if ($days)

                //         {

                //             array_push($data['convenios'][$key_convenio]['arr_idade_dos_pacientes'], $days);

                //         }

                //     }

                // }

            //calc total de  emergencias
            $data['total_de_emergencias']++;

            //$data = $screening["neonatal_checklists"];
            $count_atendimento_medico = 0;
            $data_atendiment_anterior = null;
            $data_primeiro_atendi_medico = null;
            $len = count($screening["medical_cares"]);

            foreach ($screening["medical_cares"] as $key_1 => $protocol)
            {
                $data_atendiment_atual = null;
                $count_atendimento_medico++;

                //tempo entre o primeiro e ultimo atendimento
                if ($count_atendimento_medico == $len
                    && $data_primeiro_atendi_medico
                    && $protocol['created'])
                {
                    $date_ultimo_atendimento = new \DateTime($protocol['created']->format('Y-m-d'));
                    $days = $$data_primeiro_atendi_medic->diff($date_ultimo_atendimento)->days;

                    array_push($data['tempo_entre_primeiro_ultimo_atend_medico']['arr'], $days);

                    if ($cor_da_classificacao)
                    {
                        array_push($data[$cor_da_classificacao]['tempo_entre_primeiro_ultimo_atend_medico']['arr'], $days);
                    }
                }

                //calc total de atendimento medico
                $data['total_de_atendimento']++;

                if ($cor_da_classificacao)
                {
                    $data[$cor_da_classificacao]['tot_atendimento']++;
                }

                if ($count_atendimento_medico == 1 && $protocol['created'])
                {
                    $data_atendiment_anterior = new \DateTime($protocol['created']->format('Y-m-d'));
                }
                elseif ($count_atendimento_medico == 2
                    && $data_atendiment_anterior
                    && $protocol['created'])
                {
                    $data_atendiment_atual = new \DateTime($protocol['created']->format('Y-m-d'));
                    $days = $data_atendiment_anterior->diff($data_atendiment_atual)->days;

                    array_push($data['tempo_entre_1_e_2_atend_medico']['arr'], $days);
                    array_push($data['tempo_entre_todos_atend_medico']['arr'], $days);

                    if ($cor_da_classificacao)
                    {
                        array_push($data[$cor_da_classificacao]['tempo_entre_1_e_2_atend_medico']['arr'], $days);
                        array_push($data[$cor_da_classificacao]['tempo_entre_todos_atend_medico']['arr'], $days);
                    }

                    $data_atendiment_anterior = $data_atendiment_atual;
                }
                elseif ($data_atendiment_anterior == null)
                {
                    $data_atendiment_anterior = new \DateTime($protocol['created']->format('Y-m-d'));
                }
                elseif (!$protocol['created'])
                {
                    $data_atendiment_anterior = null;
                }
                else
                {
                    $data_atendiment_atual = new \DateTime($protocol['created']->format('Y-m-d'));
                    $days = $data_atendiment_anterior->diff($data_atendiment_atual)->days;
                    array_push($data['tempo_entre_todos_atend_medico']['arr'], $days);

                    $data_atendiment_anterior = $data_atendiment_atual;
                }

                if ($count_atendimento_medico == 1 &&
                    $screening['created'] &&
                    $protocol['created'])
                {
                    $date_screening = new \DateTime($screening['created']->format('Y-m-d'));
                    $date_medical_care = new \DateTime($protocol['created']->format('Y-m-d'));
                    $days = $date_screening->diff($date_medical_care)->days;

                    array_push($data['arr_tempo_entre_triagem_atendimento'], $days);

                    if ($cor_da_classificacao)
                    {
                        array_push($data[$cor_da_classificacao]['arr_tempo_entre_triagem_atendimento'], $days);
                    }
                }

                if (!in_array($screening['patient_id'], $data['tot_patient_suspeita_me']['arr']))
                {
                    array_push($data['tot_patient_suspeita_me']['arr'], $screening['patient_id']);
                }

                $arr = (array) $protocol;
                $i = 0;

                foreach ($arr as $key_2 => $value_2)
                {
                    $i++;

                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['percentual']) &&
                isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_emergencias']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        $arr_cores = ['azul', 'verde', 'amarelo', 'vermelho'];

        foreach ($arr_cores as $cor_1)
        {
            if ($data[$cor_1]['tot_atendimento'] > 0)
            {
                //calcula a porcentagem de atendimento medico pela cor
                $data[$cor_1]['percen_atendimento'] = round(($data[$cor_1]['tot_atendimento'] * 100) / $data['total_de_atendimento'], 2);

                foreach ($arr_cores as $cor_2)
                {
                    //calcula a porcentagem de emergenias que mudaram a cor
                    $index_cor = 'tot_mudaram_para_' . $cor_2;

                    if (!isset($data[$cor_1][$index_cor]))
                    {
                        continue;
                    }

                    //if ($data[$cor_1][$index_cor] > 0)
                    if ($data['tot_emergencia_mudaram_de_cor'] > 0)
                    {
                        $percen = round(($data[$cor_1][$index_cor] * 100) / $data['tot_emergencia_mudaram_de_cor'], 2);
                        $data[$cor_1]['percen_mudaram_para_' . $cor_2] = $percen;
                    }
                }

                if (count($data[$cor_1]['tempo_entre_1_e_2_atend_medico']['arr']) > 0)
                {
                    $data[$cor_1]['tempo_entre_1_e_2_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data[$cor_1]['tempo_entre_1_e_2_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] = max($data[$cor_1]['tempo_entre_1_e_2_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] = min($data[$cor_1]['tempo_entre_1_e_2_atend_medico']['arr']);
                }

                if (count($data[$cor_1]['tempo_entre_todos_atend_medico']['arr']) > 0)
                {
                    $data[$cor_1]['tempo_entre_todos_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data[$cor_1]['tempo_entre_todos_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_todos_atend_medico']['tempo_maximo'] = max($data[$cor_1]['tempo_entre_todos_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_todos_atend_medico']['tempo_minimo'] = min($data[$cor_1]['tempo_entre_todos_atend_medico']['arr']);
                }

                if (count($data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['arr']) > 0)
                {
                    $data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] = max($data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
                    $data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] = min($data[$cor_1]['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
                }
            }

            if (count($data[$cor_1]['arr_tempo_entre_triagem_atendimento']) > 0)
            {
                $data[$cor_1]['media_tempo_entre_triagem_atendimento'] = $calc_obj->calc_average($data[$cor_1]['arr_tempo_entre_triagem_atendimento']);
                $data[$cor_1]['min_tempo_entre_triagem_atendimento'] = min($data[$cor_1]['arr_tempo_entre_triagem_atendimento']);
                $data[$cor_1]['max_tempo_entre_triagem_atendimento'] = max($data[$cor_1]['arr_tempo_entre_triagem_atendimento']);
            }

            if (count($data[$cor_1]['arr_idade_dos_pacientes']) > 0)
            {
                $data[$cor_1]['media_idade_dos_pacientes'] = $calc_obj->calc_average($data[$cor_1]['arr_idade_dos_pacientes']);
            }

            if ($data['tot_pacientes_internados_da_emergencia'] > 0 &&
                $data[$cor_1]['tot_atendimento'] > 0)
            {
                $data[$cor_1]['media_taxa_captacao_emergencia'] = round($data[$cor_1]['tot_atendimento'] / $data['tot_pacientes_internados_da_emergencia'], 2);

                $data[$cor_1]['percen_taxa_captacao_emergencia'] = ($data[$cor_1]['tot_atendimento'] * 100) / $data['tot_pacientes_internados_da_emergencia'];
                $data[$cor_1]['percen_taxa_captacao_emergencia'] = round($data[$cor_1]['percen_taxa_captacao_emergencia'], 2);
            }
        }

        if (count($data['arr_tempo_entre_triagem_atendimento']) > 0)
        {
            $data['media_tempo_entre_triagem_atendimento'] = $calc_obj->calc_average($data['arr_tempo_entre_triagem_atendimento']);
            $data['min_tempo_entre_triagem_atendimento'] = min($data['arr_tempo_entre_triagem_atendimento']);
            $data['max_tempo_entre_triagem_atendimento'] = max($data['arr_tempo_entre_triagem_atendimento']);
        }

        foreach ($data['convenios'] as $key_convenio => $convenio)
        {
            if ($convenio['tot'] > 0)
            {
                $data['convenios'][$key_convenio]['percen'] = ($convenio['tot'] * 100) / $data['total_de_emergencias'];
                $data['convenios'][$key_convenio]['percen'] = round($data['convenios'][$key_convenio]['percen'], 2);

                if ($convenio['tot_pacientes_internados'] > 0)
                {
                    $data['convenios'][$key_convenio]['taxa_captacao_convenio'] = ($convenio['tot'] * 100) / $data['tot_pacientes_internados'];
                    $data['convenios'][$key_convenio]['taxa_captacao_convenio'] = round($data['convenios'][$key_convenio]['taxa_captacao_convenio'], 2);
                }
                
            }

            if (count($convenio['arr_idade_dos_pacientes']) > 0)
            {
                $data['convenios'][$key_convenio]['media_idade_dos_pacientes'] = $calc_obj->calc_average($convenio['arr_idade_dos_pacientes']);
            }

            foreach ($arr_cores as $cor_1)
            {
                if ($convenio[$cor_1]['tot_atendimento'] > 0)
                {
                    $data['convenios'][$key_convenio][$cor_1]['percen_atendimento'] = ($convenio[$cor_1]['tot_atendimento'] * 100) / $convenio['tot'];

                    $data['convenios'][$key_convenio][$cor_1]['percen_atendimento'] = round($data['convenios'][$key_convenio][$cor_1]['percen_atendimento'], 2);
                }
            }
        }

        if (count($data['arr_idade_dos_pacientes']) > 0)
        {
            $data['media_idade_dos_pacientes'] = $calc_obj->calc_average($data['arr_idade_dos_pacientes']);
        }

        if ($data['tot_emergencia_mudaram_de_cor'] > 0 &&
            $data['total_de_emergencias'] > 0)
        {
            $data['percen_emergencia_mudaram_de_cor'] = ($data['tot_emergencia_mudaram_de_cor'] * 100) / $data['total_de_emergencias'];
            $data['percen_emergencia_mudaram_de_cor'] = round($data['percen_emergencia_mudaram_de_cor'], 2);
        }

        if (count($data['tempo_entre_1_e_2_atend_medico']['arr']) > 0)
        {
            $data['tempo_entre_1_e_2_atend_medico']['tempo_maximo'] = max($data['tempo_entre_1_e_2_atend_medico']['arr']);
            $data['tempo_entre_1_e_2_atend_medico']['tempo_minimo'] = min($data['tempo_entre_1_e_2_atend_medico']['arr']);
            $data['tempo_entre_1_e_2_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data['tempo_entre_1_e_2_atend_medico']['arr']);
        }

        if (count($data['tempo_entre_todos_atend_medico']['arr']) > 0)
        {
            $data['tempo_entre_todos_atend_medico']['tempo_maximo'] = max($data['tempo_entre_todos_atend_medico']['arr']);
            $data['tempo_entre_todos_atend_medico']['tempo_minimo'] = min($data['tempo_entre_todos_atend_medico']['arr']);
            $data['tempo_entre_todos_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data['tempo_entre_todos_atend_medico']['arr']);
        }

        if (count($data['tempo_entre_primeiro_ultimo_atend_medico']['arr']) > 0)
        {
            $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_maximo'] = max($data['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
            $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_minimo'] = min($data['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
            $data['tempo_entre_primeiro_ultimo_atend_medico']['tempo_medio'] = $calc_obj->calc_average($data['tempo_entre_primeiro_ultimo_atend_medico']['arr']);
        }

        if ($data['tot_pacientes_internados_da_emergencia'] > 0 &&
            $data['total_de_emergencias'] > 0)
        {
            $data['media_taxa_captacao_emergencia'] = round($data['tot_pacientes_internados_da_emergencia'] / $data['total_de_emergencias'], 2);

            $data['percen_taxa_captacao_emergencia'] = ($data['tot_pacientes_internados_da_emergencia'] * 100) / $data['total_de_emergencias'];
            $data['percen_taxa_captacao_emergencia'] = round($data['percen_taxa_captacao_emergencia'], 2);
        }

        foreach ($data['dia_da_semana_emergencia'] as $key => $value)
        {
            if ($value['tot'] > 0 && $data['dia_da_semana_internado'][$key]['tot'] > 0)
            {
                $data['dia_da_semana_emergencia'][$key]['taxa_captacao'] = round($value['tot'] / $data['dia_da_semana_internado'][$key]['tot'], 2);
            }
        }

        foreach ($data['turno_emergencia'] as $key => $value)
        {
            if ($value['tot'] > 0 && $data['turno_internacao'][$key]['tot'] > 0)
            {
                $data['turno_emergencia'][$key]['taxa_captacao'] = round($value['tot'] / $data['turno_internacao'][$key]['tot'], 2);
            }
        }

        if ($data['tot_pacientes_na_uti'] > 0 && $data['tot_pacientes_internados'] > 0)
        {
            $data['taxa_captacao_unidade_intensiva'] = round($data['tot_pacientes_na_uti'] / $data['tot_pacientes_internados'], 2);
        }

        if ($data['tot_pacientes_na_unidade_internacao'] > 0 && $data['tot_pacientes_internados'] > 0)
        {
            $data['tot_pacientes_na_unidade_internacao'] = round($data['tot_pacientes_na_unidade_internacao'] / $data['tot_pacientes_internados'], 2);
        }

        foreach ($data['dia_da_semana'] as $key_dia => $dia)
        {
            if ($dia['tot_internados'] > 0 && $dia['tot_atendidos'] > 0)
            {
                $data['dia_da_semana'][$key_dia]['taxa'] = round($dia['tot_internados'] / $dia['tot_atendidos'], 2);
            }
        }

        if ($data['desfecho_int_na_emergencia']['centro_cirurgico']['tot_pacientes_tranferidos'] > 0)
        {
            $data['desfecho_int_na_emergencia']['centro_cirurgico']['percen_pacientes_tranferidos']  = ($data['desfecho_int_na_emergencia']['centro_cirurgico']['tot_pacientes_tranferidos'] / $data['tot_pacientes_internados_da_emergencia']) * 100;
            $data['desfecho_int_na_emergencia']['centro_cirurgico']['percen_pacientes_tranferidos'] = round($data['desfecho_int_na_emergencia']['centro_cirurgico']['percen_pacientes_tranferidos'], 2);
        }

        if ($data['desfecho_int_na_emergencia']['unidade_internacao']['tot_pacientes_tranferidos'] > 0)
        {
            $data['desfecho_int_na_emergencia']['unidade_internacao']['percen_pacientes_tranferidos']  = ($data['desfecho_int_na_emergencia']['unidade_internacao']['tot_pacientes_tranferidos'] / $data['tot_pacientes_internados_da_emergencia']) * 100;
            $data['desfecho_int_na_emergencia']['unidade_internacao']['percen_pacientes_tranferidos'] = round($data['desfecho_int_na_emergencia']['unidade_internacao']['percen_pacientes_tranferidos'], 2);
        }

        if ($data['desfecho_int_na_emergencia']['terapia_intensiva']['tot_pacientes_tranferidos'] > 0)
        {
            $data['desfecho_int_na_emergencia']['terapia_intensiva']['percen_pacientes_tranferidos']  = ($data['desfecho_int_na_emergencia']['terapia_intensiva']['tot_pacientes_tranferidos'] / $data['tot_pacientes_internados_da_emergencia']) * 100;
            $data['desfecho_int_na_emergencia']['terapia_intensiva']['percen_pacientes_tranferidos'] = round($data['desfecho_int_na_emergencia']['terapia_intensiva']['percen_pacientes_tranferidos'], 2);
        }

        foreach ($professionals as $prof_key => $professional) 
        {
            if ($professional['tot_pacientes_atendidos'] > 0 && $professional['tot_pacientes_internados'] > 0)
            {
                $data['professionals'][$prof_key]['taxa_de_captacao'] = round($professional['tot_pacientes_internados'] / $professional['tot_pacientes_atendidos'], 2);
            }            
        }

        if ($data['tot_pacientes_internados_na_emergencia_sup_24h'] > 0 &&
            $data['tot_pacientes_internados_na_emergencia'] > 0)
        {
            $data['percen_pacientes_internados_na_emergencia_sup_24h'] = ($data['tot_pacientes_internados_na_emergencia_sup_24h'] / $data['tot_pacientes_internados_na_emergencia']) * 100;
            $data['percen_pacientes_internados_na_emergencia_sup_24h'] = round($data['percen_pacientes_internados_na_emergencia_sup_24h'], 2);
        }
        if (count($data['arr_media_horas_pacientes_internados_emergencia']) > 0)
        {
            $data['media_horas_pacientes_internados_emergencia'] = $calc_obj->calc_average($data['arr_media_horas_pacientes_internados_emergencia']);
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['patient_id'], 'Patients'));
        $rules->add($rules->existsIn(['unit_id'], 'Units'));
        $rules->add($rules->existsIn(['professional_id'], 'Professionals'));
        return $rules;
    }
}
