<?php
namespace App\Model\Table;

use Cake\ORM\Table;
/**
 * Responsibles Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Patients
 * @property \Cake\ORM\Association\BelongsToMany $Telephones
 */
class RelatoriosTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */

    public function mediana(array $a, $comparacao = null) {
        if (empty($a)) {
            return false;
        }

        // Ordenar o array
        if ($comparacao === null) {
            sort($a);
        } else {
            usort($a, $comparacao);
        }

        $tamanho = count($a);

        // Tamanho impar: obter valor mediano
        if ($tamanho % 2) {
            $mediana = $a[(($tamanho + 1) / 2) - 1];

        // Tamanho par: obter a media simples entre os dois valores medianos
        } else {
            $v1 = $a[($tamanho / 2) - 1];
            $v2 = $a[$tamanho / 2];
            $mediana = ($v1 + $v2) / 2;
        }
        return $mediana;
    }
    
}