<?php
namespace App\Model\Table;

use App\Model\Entity\NeonatalChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * NeonatalChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class NeonatalChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('neonatal_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);

        $this->belongsToMany('Anomalias', [
            'targetForeignKey' => 'anomalia_id',
            'foreignKey' => 'neonatal_checklist_id',
            'joinTable' => 'anomalias_neonatal_checklists',
        ]);

        $this->belongsToMany('Inspections', [
            'targetForeignKey' => 'inspection_id',
            'foreignKey' => 'neonatal_checklist_id',            
            'joinTable' => 'inspections_neonatal_checklists'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('paridade')
            ->allowEmpty('paridade');

        $validator
            ->boolean('enfermidades_atuais')
            ->allowEmpty('enfermidades_atuais');

        $validator
            ->boolean('intercorren_pre_parto')
            ->allowEmpty('intercorren_pre_parto');

        $validator
            ->boolean('boletim_apgar')
            ->allowEmpty('boletim_apgar');

        $validator
            ->boolean('necessidade_reanimacao')
            ->allowEmpty('necessidade_reanimacao');

        $validator
            ->boolean('apto_amamentacao')
            ->allowEmpty('apto_amamentacao');

        $validator
            ->allowEmpty('placenta_peso');

        $validator
            ->boolean('coloracao_odor_alterado')
            ->allowEmpty('coloracao_odor_alterado');

        $validator
            ->boolean('relacao_do_peso_placenta')
            ->allowEmpty('relacao_do_peso_placenta');

        $validator
            ->boolean('cordao_umbilical_presente')
            ->allowEmpty('cordao_umbilical_presente');

        $validator
            ->allowEmpty('ao_nascer_peso');

        $validator
            ->allowEmpty('ao_nascer_comprimento');

        $validator
            ->boolean('ao_nascer_classificacao_rn')
            ->allowEmpty('ao_nascer_classificacao_rn');

        $validator
            ->boolean('iluminacao_aquecimento_adequado')
            ->allowEmpty('iluminacao_aquecimento_adequado');

        $validator
            ->boolean('ictericia')
            ->allowEmpty('ictericia');

        $validator
            ->boolean('palidez')
            ->allowEmpty('palidez');

        $validator
            ->boolean('descamacao_fisiologica')
            ->allowEmpty('descamacao_fisiologica');

        $validator
            ->boolean('icitose_congenita')
            ->allowEmpty('icitose_congenita');

        $validator
            ->boolean('nevos_pgmentosus')
            ->allowEmpty('nevos_pgmentosus');

        $validator
            ->boolean('linfomas_cisticos')
            ->allowEmpty('linfomas_cisticos');

        $validator
            ->boolean('escleredema')
            ->allowEmpty('escleredema');

        $validator
            ->boolean('petequias_e_purpuras')
            ->allowEmpty('petequias_e_purpuras');

        $validator
            ->boolean('hemangioma')
            ->allowEmpty('hemangioma');

        $validator
            ->boolean('pele_espessa')
            ->allowEmpty('pele_espessa');

        $validator
            ->boolean('visibilidade_vasos_sulcos')
            ->allowEmpty('visibilidade_vasos_sulcos');

        $validator
            ->boolean('lanugem')
            ->allowEmpty('lanugem');

        $validator
            ->boolean('superficie_plantar')
            ->allowEmpty('superficie_plantar');

        $validator
            ->numeric('distancia_antero_posterior')
            ->allowEmpty('distancia_antero_posterior');

        $validator
            ->numeric('distancia_biauricular')
            ->allowEmpty('distancia_biauricular');

        $validator
            ->allowEmpty('perimetro_cefalico');

        $validator
            ->numeric('indice_cefalico')
            ->allowEmpty('indice_cefalico');

        $validator
            ->allowEmpty('cranio_classificacao');

        $validator
            ->boolean('hidrocefalia')
            ->allowEmpty('hidrocefalia');

        $validator
            ->boolean('craniossinostose')
            ->allowEmpty('craniossinostose');

        $validator
            ->boolean('cefalo_hematoma')
            ->allowEmpty('cefalo_hematoma');

        $validator
            ->boolean('bossa_serossanguinea')
            ->allowEmpty('bossa_serossanguinea');

        $validator
            ->boolean('fontanelas_adequadas')
            ->allowEmpty('fontanelas_adequadas');

        $validator
            ->boolean('cranio_tabes')
            ->allowEmpty('cranio_tabes');

        $validator
            ->boolean('ruidos_intracranianos')
            ->allowEmpty('ruidos_intracranianos');

        $validator
            ->boolean('encefalocele')
            ->allowEmpty('encefalocele');

        $validator
            ->boolean('cartilagem_da_orelha')
            ->allowEmpty('cartilagem_da_orelha');

        $validator
            ->boolean('face_simetria')
            ->allowEmpty('face_simetria');

        $validator
            ->boolean('aparencia_sindromica')
            ->allowEmpty('aparencia_sindromica');

        $validator
            ->boolean('implantacao_das_orelhas')
            ->allowEmpty('implantacao_das_orelhas');

        $validator
            ->allowEmpty('distancia_entre_os_olhos');

        $validator
            ->boolean('tamanho_do_queixo')
            ->allowEmpty('tamanho_do_queixo');

        $validator
            ->boolean('reflexo_luz_vermelha')
            ->allowEmpty('reflexo_luz_vermelha');

        $validator
            ->boolean('hemorragia_subconjuntival')
            ->allowEmpty('hemorragia_subconjuntival');

        $validator
            ->boolean('estrabismo')
            ->allowEmpty('estrabismo');

        $validator
            ->boolean('pupila_branca')
            ->allowEmpty('pupila_branca');

        $validator
            ->boolean('opacificacao_cornea')
            ->allowEmpty('opacificacao_cornea');

        $validator
            ->boolean('secrecao_ocular_presente')
            ->allowEmpty('secrecao_ocular_presente');

        $validator
            ->boolean('forma_tamanho_implantacao')
            ->allowEmpty('forma_tamanho_implantacao');

        $validator
            ->boolean('permeabilidade_nasal')
            ->allowEmpty('permeabilidade_nasal');

        $validator
            ->boolean('canal_nasolacrimal')
            ->allowEmpty('canal_nasolacrimal');

        $validator
            ->boolean('secrecao_nasal')
            ->allowEmpty('secrecao_nasal');

        $validator
            ->boolean('coloracao_dos_labios')
            ->allowEmpty('coloracao_dos_labios');

        $validator
            ->boolean('alteracao_integridade')
            ->allowEmpty('alteracao_integridade');

        $validator
            ->boolean('fenda_palatina')
            ->allowEmpty('fenda_palatina');

        $validator
            ->boolean('lingua_com_tamanho')
            ->allowEmpty('lingua_com_tamanho');

        $validator
            ->boolean('dentes_congenitos')
            ->allowEmpty('dentes_congenitos');

        $validator
            ->boolean('ranula')
            ->allowEmpty('ranula');

        $validator
            ->boolean('perolas_de_epstein')
            ->allowEmpty('perolas_de_epstein');

        $validator
            ->boolean('uvula_bifida')
            ->allowEmpty('uvula_bifida');

        $validator
            ->boolean('retrognatia')
            ->allowEmpty('retrognatia');

        $validator
            ->boolean('arqueamento_do_palato')
            ->allowEmpty('arqueamento_do_palato');

        $validator
            ->boolean('ausencia_de_massas')
            ->allowEmpty('ausencia_de_massas');

        $validator
            ->boolean('torcicolo_congenito')
            ->allowEmpty('torcicolo_congenito');

        $validator
            ->boolean('teratoma_cervical')
            ->allowEmpty('teratoma_cervical');

        $validator
            ->boolean('higroma_cistico')
            ->allowEmpty('higroma_cistico');

        $validator
            ->boolean('bocio_congenito')
            ->allowEmpty('bocio_congenito');

        $validator
            ->allowEmpty('perimetro_toracico');

        $validator
            ->boolean('torax_simetria')
            ->allowEmpty('torax_simetria');

        $validator
            ->boolean('retracoes_sub_intercostais')
            ->allowEmpty('retracoes_sub_intercostais');

        $validator
            ->boolean('retracoes_supra_claviculares')
            ->allowEmpty('retracoes_supra_claviculares');

        $validator
            ->boolean('ausencia_claviculas')
            ->allowEmpty('ausencia_claviculas');

        $validator
            ->boolean('disostose_cleido')
            ->allowEmpty('disostose_cleido');

        $validator
            ->boolean('fraturas')
            ->allowEmpty('fraturas');

        $validator
            ->boolean('assimetria')
            ->allowEmpty('assimetria');

        $validator
            ->boolean('distancia_intermamilar')
            ->allowEmpty('distancia_intermamilar');

        $validator
            ->boolean('presencao_de_mamilos')
            ->allowEmpty('presencao_de_mamilos');

        $validator
            ->allowEmpty('inspecao');

        $validator
            ->boolean('pulsos_sincronia')
            ->allowEmpty('pulsos_sincronia');

        $validator
            ->boolean('pulsos_equivalentes')
            ->allowEmpty('pulsos_equivalentes');

        $validator
            ->boolean('palpacao_precordio')
            ->allowEmpty('palpacao_precordio');

        $validator
            ->allowEmpty('pressao_pulsatil');

        $validator
            ->boolean('desdobramento_de_b1')
            ->allowEmpty('desdobramento_de_b1');

        $validator
            ->boolean('reducao_intensidade')
            ->allowEmpty('reducao_intensidade');

        $validator
            ->boolean('aumento_intensidade_b1')
            ->allowEmpty('aumento_intensidade_b1');

        $validator
            ->boolean('desdobramento_amplo_b2')
            ->allowEmpty('desdobramento_amplo_b2');

        $validator
            ->boolean('hiperfonese_b2')
            ->allowEmpty('hiperfonese_b2');

        $validator
            ->boolean('presenca_de_b3')
            ->allowEmpty('presenca_de_b3');

        $validator
            ->boolean('presenca_de_b4')
            ->allowEmpty('presenca_de_b4');

        $validator
            ->boolean('presenca_de_estalido_abertura')
            ->allowEmpty('presenca_de_estalido_abertura');

        $validator
            ->boolean('presenca_de_sopro')
            ->allowEmpty('presenca_de_sopro');

        $validator
            ->allowEmpty('gemencia');

        $validator
            ->allowEmpty('batimento_de_asa_nariz');

        $validator
            ->allowEmpty('tiragem_intercostal');

        $validator
            ->allowEmpty('retracao_esternal');

        $validator
            ->allowEmpty('balancim');

        $validator
            ->boolean('sinal_dancarina_ventre')
            ->allowEmpty('sinal_dancarina_ventre');

        $validator
            ->boolean('presenca_cripitacao_pulmonar')
            ->allowEmpty('presenca_cripitacao_pulmonar');

        $validator
            ->boolean('presenca_de_roncos')
            ->allowEmpty('presenca_de_roncos');

        $validator
            ->boolean('diminuicao_murmurio_vesicular')
            ->allowEmpty('diminuicao_murmurio_vesicular');

        $validator
            ->boolean('abdome_escavado')
            ->allowEmpty('abdome_escavado');

        $validator
            ->boolean('abdome_abaulado')
            ->allowEmpty('abdome_abaulado');

        $validator
            ->boolean('abdomen_abaulamento')
            ->allowEmpty('abdomen_abaulamento');

        $validator
            ->boolean('presenca_circulacao_colateral')
            ->allowEmpty('presenca_circulacao_colateral');

        $validator
            ->boolean('presenca_ondas_peristalticas')
            ->allowEmpty('presenca_ondas_peristalticas');

        $validator
            ->boolean('dastase_musculos_reto')
            ->allowEmpty('dastase_musculos_reto');

        $validator
            ->boolean('ascite')
            ->allowEmpty('ascite');

        $validator
            ->boolean('visceromegalias')
            ->allowEmpty('visceromegalias');

        $validator
            ->boolean('distencao_gasosa')
            ->allowEmpty('distencao_gasosa');

        $validator
            ->boolean('presenca_de_massa_palpavel')
            ->allowEmpty('presenca_de_massa_palpavel');

        $validator
            ->boolean('ausencia_de_ruidos')
            ->allowEmpty('ausencia_de_ruidos');

        $validator
            ->boolean('genitalia_ambigua')
            ->allowEmpty('genitalia_ambigua');

        $validator
            ->allowEmpty('anomalias_anonetai');

        $validator
            ->boolean('comprimento_do_penis_adequado')
            ->allowEmpty('comprimento_do_penis_adequado');

        $validator
            ->allowEmpty('orificio_uretral');

        $validator
            ->boolean('prepucio_sem_restricao')
            ->allowEmpty('prepucio_sem_restricao');

        $validator
            ->allowEmpty('testiculos');

        $validator
            ->boolean('presenca_de_hemias')
            ->allowEmpty('presenca_de_hemias');

        $validator
            ->boolean('presenca_de_hidroceles')
            ->allowEmpty('presenca_de_hidroceles');

        $validator
            ->boolean('tamanho_do_clitoris_adequado')
            ->allowEmpty('tamanho_do_clitoris_adequado');

        $validator
            ->boolean('fusao_dos_grandes_labios')
            ->allowEmpty('fusao_dos_grandes_labios');

        $validator
            ->boolean('orificio_da_vagina_e_uretra')
            ->allowEmpty('orificio_da_vagina_e_uretra');

        $validator
            ->boolean('distancia_anovulvar')
            ->allowEmpty('distancia_anovulvar');

        $validator
            ->boolean('presenca_de_fistulas')
            ->allowEmpty('presenca_de_fistulas');

        $validator
            ->boolean('presenca_de_tumores')
            ->allowEmpty('presenca_de_tumores');

        $validator
            ->boolean('fossetas_hipertricose')
            ->allowEmpty('fossetas_hipertricose');

        $validator
            ->boolean('seio_pilonidal')
            ->allowEmpty('seio_pilonidal');

        $validator
            ->boolean('meningomielocele')
            ->allowEmpty('meningomielocele');

        $validator
            ->boolean('teratoma_sacroroccigeo')
            ->allowEmpty('teratoma_sacroroccigeo');

        $validator
            ->boolean('simetira_proprocoes')
            ->allowEmpty('simetira_proprocoes');

        $validator
            ->boolean('paralisia_membros_superiores')
            ->allowEmpty('paralisia_membros_superiores');

        $validator
            ->boolean('paralisia_membros_inferiores')
            ->allowEmpty('paralisia_membros_inferiores');

        $validator
            ->boolean('artogripose')
            ->allowEmpty('artogripose');

        $validator
            ->boolean('pe_torto_congenito')
            ->allowEmpty('pe_torto_congenito');

        $validator
            ->boolean('prega_palmar_unica')
            ->allowEmpty('prega_palmar_unica');

        $validator
            ->boolean('osteocondrodisplasia')
            ->allowEmpty('osteocondrodisplasia');

        $validator
            ->boolean('luxacao_congenita')
            ->allowEmpty('luxacao_congenita');

        $validator
            ->boolean('manobra_ortolani')
            ->allowEmpty('manobra_ortolani');

        $validator
            ->boolean('manobra_barlow')
            ->allowEmpty('manobra_barlow');

        $validator
            ->boolean('urina_nas_primeiras')
            ->allowEmpty('urina_nas_primeiras');

        $validator
            ->boolean('ausencia_eleminacao_intestinal')
            ->allowEmpty('ausencia_eleminacao_intestinal');

        $validator
            ->allowEmpty('estado_de_sono');

        $validator
            ->boolean('postura_em_flexao')
            ->allowEmpty('postura_em_flexao');

        $validator
            ->boolean('movimentacao_espontanea')
            ->allowEmpty('movimentacao_espontanea');

        $validator
            ->boolean('emissao_de_sons')
            ->allowEmpty('emissao_de_sons');

        $validator
            ->boolean('tonus_passivo_e_ativo')
            ->allowEmpty('tonus_passivo_e_ativo');

        $validator
            ->boolean('manobra_do_arrasto')
            ->allowEmpty('manobra_do_arrasto');

        $validator
            ->boolean('rotacao_da_cabeca_em_prono')
            ->allowEmpty('rotacao_da_cabeca_em_prono');

        $validator
            ->boolean('manobra_de_tobler')
            ->allowEmpty('manobra_de_tobler');

        $validator
            ->boolean('manobra_do_cachecol')
            ->allowEmpty('manobra_do_cachecol');

        $validator
            ->boolean('reflexos_superficiais')
            ->allowEmpty('reflexos_superficiais');

        $validator
            ->boolean('reflexos_arcaicos')
            ->allowEmpty('reflexos_arcaicos');

        $validator
            ->boolean('teste_de_voracidade')
            ->allowEmpty('teste_de_voracidade');

        $validator
            ->boolean('teste_de_succao')
            ->allowEmpty('teste_de_succao');

        $validator
            ->boolean('preensao_reflexa_artelhos')
            ->allowEmpty('preensao_reflexa_artelhos');

        $validator
            ->boolean('piscamento')
            ->allowEmpty('piscamento');

        $validator
            ->boolean('retirada_a_estimulacao')
            ->allowEmpty('retirada_a_estimulacao');

        $validator
            ->boolean('cutaneo_plantar')
            ->allowEmpty('cutaneo_plantar');

        $validator
            ->boolean('extensao_cruzada')
            ->allowEmpty('extensao_cruzada');

        $validator
            ->boolean('preensao_palmar')
            ->allowEmpty('preensao_palmar');

        $validator
            ->boolean('manobra_do_rasto')
            ->allowEmpty('manobra_do_rasto');

        $validator
            ->boolean('reflexo_de_moro')
            ->allowEmpty('reflexo_de_moro');

        $validator
            ->boolean('reflexo_tonico_cervical_assimetrico')
            ->allowEmpty('reflexo_tonico_cervical_assimetrico');

        $validator
            ->boolean('apoio_plantar')
            ->allowEmpty('apoio_plantar');

        $validator
            ->boolean('marcha_reflexa')
            ->allowEmpty('marcha_reflexa');

        $validator
            ->boolean('rotacao_da_cabeca')
            ->allowEmpty('rotacao_da_cabeca');

        $validator
            ->boolean('reflexo_de_galant')
            ->allowEmpty('reflexo_de_galant');

        $validator
            ->boolean('reflexos_de_landau')
            ->allowEmpty('reflexos_de_landau');

        $validator
            ->boolean('teste_do_nervo_optico')
            ->allowEmpty('teste_do_nervo_optico');

        $validator
            ->boolean('teste_dos_olhos_de_boneca')
            ->allowEmpty('teste_dos_olhos_de_boneca');

        $validator
            ->boolean('reflexo_vestibulo_coclear')
            ->allowEmpty('reflexo_vestibulo_coclear');

        $validator
            ->boolean('reflexo_cocleo_palpebral')
            ->allowEmpty('reflexo_cocleo_palpebral');

        $validator
            ->boolean('reflexos_miotaticos')
            ->allowEmpty('reflexos_miotaticos');

        $validator
            ->boolean('teste_de_sensibilidade')
            ->allowEmpty('teste_de_sensibilidade');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    public function relatorioNeonatal($hospitalizations)
    {
        $calc_obj = new MedidasDispersao();

        $data_auto = [0 => 'ex_cardio_pulmonar_gemencia', 1 => 'ex_cardio_pulmonar_gemencia', 2 => 'ex_cardio_pulmonar_batimento', 3 => 'ex_cardio_pulmonar_tiragem', 4 => 'ex_cardio_pulmonar_retracao', 5 => 'ex_cardio_pulmonar_balancim', 6 => 'ex_cardio_genitalia_orificio', 7 => 'ex_cardio_genitalia_testiculo', 8 => 'ex_neuro_estado_sono'];

        $data =
            [
            'total_de_registros' => 0,

            'ex_cardio_pressao_pulsatil' => [
                'Normal' => ['tot' => 0, 'percentual' => 0],
                'Estreitada' => ['tot' => 0, 'percentual' => 0],
                'Alargada' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_pulmonar_gemencia' => [
                'Ausente' => ['tot' => 0, 'percentual' => 0],
                'Audível com esteto' => ['tot' => 0, 'percentual' => 0],
                'Audível sem esteto' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_pulmonar_batimento' => [
                'Ausente' => ['tot' => 0, 'percentual' => 0],
                'Discreto' => ['tot' => 0, 'percentual' => 0],
                'Acentuado' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_pulmonar_tiragem' => [
                'Ausente' => ['tot' => 0, 'percentual' => 0],
                'tres_ultimas' => ['tot' => 0, 'percentual' => 0],
                'mais_de_tres' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_pulmonar_retracao' => [
                'Ausente' => ['tot' => 0, 'percentual' => 0],
                'Discreto' => ['tot' => 0, 'percentual' => 0],
                'Acentuado' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_pulmonar_balancim' => [
                'Ausente' => ['tot' => 0, 'percentual' => 0],
                'Discreto' => ['tot' => 0, 'percentual' => 0],
                'Acentuado' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_genitalia_orificio' => [
                'Normal' => ['tot' => 0, 'percentual' => 0],
                'Hipospádia' => ['tot' => 0, 'percentual' => 0],
                'Epispádia' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_cardio_genitalia_testiculo' => [
                'bolsa_escrotal' => ['tot' => 0, 'percentual' => 0],
                'canal' => ['tot' => 0, 'percentual' => 0],
                'nao_encontrado' => ['tot' => 0, 'percentual' => 0],
            ],

            'ex_neuro_estado_sono' => [
                'olhos_fechados' => ['tot' => 0, 'percentual' => 0],
                'respiracao_reg_sem_mov' => ['tot' => 0, 'percentual' => 0],
                'olhos_fechados_resp_irr' => ['tot' => 0, 'percentual' => 0],
                'olhos_abertos_sem_mov' => ['tot' => 0, 'percentual' => 0],
                'olhos_abertos_com_mov' => ['tot' => 0, 'percentual' => 0],
                'olhos_abertos_ou_fecha_chorando' => ['tot' => 0, 'percentual' => 0],
                'coma' => ['tot' => 0, 'percentual' => 0],
            ],

            'anomalia' => [
                '1' => ['tot' => 0, 'percen' => 0],
                '2' => ['tot' => 0, 'percen' => 0],
                '3' => ['tot' => 0, 'percen' => 0],
                '4' => ['tot' => 0, 'percen' => 0],
                '5' => ['tot' => 0, 'percen' => 0],
                '6' => ['tot' => 0, 'percen' => 0],
                '7' => ['tot' => 0, 'percen' => 0],
                '8' => ['tot' => 0, 'percen' => 0],
                '9' => ['tot' => 0, 'percen' => 0],
                '10' => ['tot' => 0, 'percen' => 0],
            ],

            'inspection' => [
                '1' => ['tot' => 0, 'percen' => 0],
                '2' => ['tot' => 0, 'percen' => 0],
                '3' => ['tot' => 0, 'percen' => 0],
                '4' => ['tot' => 0, 'percen' => 0],
                '5' => ['tot' => 0, 'percen' => 0],
                '6' => ['tot' => 0, 'percen' => 0],
                '7' => ['tot' => 0, 'percen' => 0],
            ],
        ];

        foreach ($hospitalizations as $hospitalization)
        {
            foreach ($hospitalization["neonatal_checklists"] as $key_1 => $neonatal)
            {
                foreach ($neonatal['anomalias'] as $key => $anomalia)
                {
                    $id = $anomalia['id'];
                    $data['anomalia'][$id]['tot']++;
                }

                foreach ($neonatal['inspections'] as $key => $inspection)
                {
                    $id = $inspection['id'];
                    $data['inspection'][$id]['tot']++;
                }

                switch ($neonatal['estado_de_sono'])
                {
                    case '0':
                        $data['ex_neuro_estado_sono']['olhos_fechados']['tot']++;
                        break;

                    case '1':
                        $data['ex_neuro_estado_sono']['respiracao_reg_sem_mov']['tot']++;
                        break;

                    case '2':
                        $data['ex_neuro_estado_sono']['olhos_fechados_resp_irr']['tot']++;
                        break;
                    case '3':
                        $data['ex_neuro_estado_sono']['olhos_abertos_sem_mov']['tot']++;
                        break;
                    case '4':
                        $data['ex_neuro_estado_sono']['olhos_abertos_com_mov']['tot']++;
                        break;
                    case '5':
                        $data['ex_neuro_estado_sono']['olhos_abertos_ou_fecha_chorando']['tot']++;
                        break;
                    case '6':
                        $data['ex_neuro_estado_sono']['coma']['tot']++;
                        break;
                }

                switch ($neonatal['testiculos'])
                {
                    case '0':
                        $data['ex_cardio_genitalia_testiculo']['bolsa_escrotal']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_genitalia_testiculo']['canal']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_genitalia_testiculo']['nao_encontrado']['tot']++;
                        break;
                }

                switch ($neonatal['orificio_uretral'])
                {
                    case '0':
                        $data['ex_cardio_genitalia_orificio']['Normal']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_genitalia_orificio']['Hipospádia']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_genitalia_orificio']['Epispádia']['tot']++;
                        break;
                }

                switch ($neonatal['balancim'])
                {
                    case '0':
                        $data['ex_cardio_pulmonar_balancim']['Ausente']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pulmonar_balancim']['Discreto']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pulmonar_balancim']['Acentuado']['tot']++;
                        break;
                }

                switch ($neonatal['retracao_esternal'])
                {
                    case '0':
                        $data['ex_cardio_pulmonar_retracao']['Ausente']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pulmonar_retracao']['Discreto']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pulmonar_retracao']['Acentuado']['tot']++;
                        break;
                }

                switch ($neonatal['tiragem_intercostal'])
                {
                    case '0':
                        $data['ex_cardio_pulmonar_tiragem']['Ausente']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pulmonar_tiragem']['tres_ultimas']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pulmonar_tiragem']['mais_de_tres']['tot']++;
                        break;
                }

                switch ($neonatal['batimento_de_asa_nariz'])
                {
                    case '0':
                        $data['ex_cardio_pulmonar_batimento']['Ausente']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pulmonar_batimento']['Discreto']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pulmonar_batimento']['Acentuado']['tot']++;
                        break;
                }

                switch ($neonatal['gemencia'])
                {
                    case '0':
                        $data['ex_cardio_pulmonar_gemencia']['Ausente']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pulmonar_gemencia']['Audível com esteto']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pulmonar_gemencia']['Audível sem esteto']['tot']++;
                        break;
                }

                // switch ($neonatal['classificacao_do_cranio'])
                // {
                //     case 'Microcefalia':
                //         $data['classificacao_do_cranio']['Microcefalia']++;
                //         break;

                //     case 'Macrocefalia':
                //         $data['classificacao_do_cranio']['Macrocefalia']++;
                //         break;

                //     case 'Hidrocefalia':
                //         $data['classificacao_do_cranio']['Hidrocefalia']++;
                //         break;

                //     case 'Hidranencefalia':
                //         $data['classificacao_do_cranio']['Hidranencefalia']++;
                //         break;
                // }

                switch ($neonatal['pressao_pulsatil'])
                {
                    case '0':
                        $data['ex_cardio_pressao_pulsatil']['Normal']['tot']++;
                        break;

                    case '1':
                        $data['ex_cardio_pressao_pulsatil']['Estreitada']['tot']++;
                        break;

                    case '2':
                        $data['ex_cardio_pressao_pulsatil']['Alargada']['tot']++;
                        break;
                }

                $neonatal_arr = (array) $neonatal;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);
                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        foreach ($data_auto as $key_name)
        {
            foreach ($data[$key_name] as $key => $value)
            {
                if (isset($data[$key_name][$key]['tot']) &&
                    $data[$key_name][$key]['tot'] > 0)
                {
                    $data[$key_name][$key]['percentual'] = ($data[$key_name][$key]['tot'] * 100) / $data['total_de_registros'];
                    $data[$key_name][$key]['percentual'] = round($data[$key_name][$key]['percentual'], 2);
                }
            }
        }

        foreach ($data['anomalia'] as $key => $anomalia)
        {
            if ($anomalia['tot'] > 0)
            {
                $data['anomalia'][$key]['percen'] = ($anomalia['tot'] * 100) / $data['total_de_registros'];
                $data['anomalia'][$key]['percen'] = round($data['anomalia'][$key]['percen'], 2);
            }
        }

        return $data;
    }

/**
 * Returns a rules checker object that will be used for validating
 * application integrity.
 *
 * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
 * @return \Cake\ORM\RulesChecker
 */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
