<?php
namespace App\Model\Table;

use App\Model\Entity\HospitalizationsSystemicDiagnosi;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * HospitalizationsSystemicDiagnosis Model
 *
 * @property \Cake\ORM\Association\BelongsTo $SystemicDiagnosis
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class HospitalizationsSystemicDiagnosisTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('hospitalizations_systemic_diagnosis');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('SystemicDiagnosis', [
            'foreignKey' => 'systemic_diagnostic_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['systemic_diagnostic_id'], 'SystemicDiagnosis'));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
