<?php
namespace App\Model\Table;

use App\Model\Entity\ClinicTevProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

/**
 * ClinicTevProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $RiskFactors
 */
class ClinicTevProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('clinic_tev_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsTo('Screenings', [
            'foreignKey' => 'screening_id',
            'joinType' => 'INNER'
        ]);

        $this->belongsToMany('RiskFactors', [
            'foreignKey' => 'clinic_tev_protocol_id',
            'targetForeignKey' => 'risk_factor_id',
            'joinTable' => 'clinic_tev_protocols_risk_factors'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->date('indicacao_profilaxia_data')
            ->allowEmpty('indicacao_profilaxia_data');

        $validator
            ->time('indicacao_profilaxia_hora')
            ->allowEmpty('indicacao_profilaxia_hora');

        $validator
            ->boolean('sangramento_ativo')
            ->allowEmpty('sangramento_ativo');

        $validator
            ->boolean('ulcera')
            ->allowEmpty('ulcera');

        $validator
            ->boolean('has')
            ->allowEmpty('has');

        $validator
            ->boolean('coagulograma')
            ->allowEmpty('coagulograma');

        $validator
            ->boolean('alergia')
            ->allowEmpty('alergia');

        $validator
            ->boolean('insuficiencia_renal')
            ->allowEmpty('insuficiencia_renal');

        $validator
            ->boolean('cirurgia')
            ->allowEmpty('cirurgia');

        $validator
            ->boolean('coleta_lcr')
            ->allowEmpty('coleta_lcr');

        $validator
            ->boolean('enoxaparina_1')
            ->allowEmpty('enoxaparina_1');

        $validator
            ->boolean('enoxaparina_2')
            ->allowEmpty('enoxaparina_2');

        $validator
            ->boolean('enoxaparina_3')
            ->allowEmpty('enoxaparina_3');

        $validator
            ->boolean('enoxaparina_4')
            ->allowEmpty('enoxaparina_4');

        $validator
            ->boolean('meias_elastica')
            ->allowEmpty('meias_elastica');

        $validator
            ->boolean('compressao_pneumatica')
            ->allowEmpty('compressao_pneumatica');

        $validator
            ->boolean('nenhum')
            ->allowEmpty('nenhum');

        /*$validator
            ->date('metodo_mecanico_inicio')
            ->allowEmpty('metodo_mecanico_inicio');

        $validator
            ->date('metodo_mecanico_fim')
            ->allowEmpty('metodo_mecanico_fim');*/

        $validator
            ->allowEmpty('justificativa');

        $validator
            ->boolean('deambulacao')
            ->allowEmpty('deambulacao');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $start_date, $end_date)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'total_de_registros' => 0,

            'arr_pacientes' => [],
            'tot_pacientes' => 0,

            'arr_pacientes_tev' => [],
            'tot_pacientes_tev' => 0,
            'percen_pacientes_tev' => 0,


            //TAXA DE USO DE PROFILAXIA MEDICAMENTOSA ( PACIENTES COM RISCO DE TEV QUE FIZERAM PROFILAXIA MEDICAMENTOSA / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_profi_medi'=>[
                'tot'=>0,
                'percen'=>0,
                'arr'=>[],
            ],

            //TAXA DE USO DE PROFILAXIA MECANICA ( PACIENTES COM RISCO DE TEV QUE FIZERAM PROFILAXIA MECANICA / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_profi_meca'=>[
                'tot'=>0,
                'percen'=>0,
                'arr' => [],
            ],

            //TAXA DE USO DE NÃO USO DE PROFILAXIA EM PACIENTES COM RISCO ( PACIENTES COM RISCO DE TEV QUE NÃO FIZERAM PROFILAXIA  / TOTAL DE PACIENTES COM RISCO DE TEV)
            'paciente_nao_usou_profilaxia'=>[
                'tot'=>0,
                'percen'=>0,
                'arr' => [],
            ],


            'temp_prof_medi' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'temp_prof_meca' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'temp_prof' => [
                'arr'=>[],
                'tot'=>0,
            ],

            'arr_paciente_risco_obito' => [], //OBITOS DOS PCTES COM RISCO QUE NÃO RECEBERAM PROFILAXIA
            'tot_paciente_risco_obito' => 0,
            'percen_paciente_risco_obito' => 0,

            'totalSetorUnidadeInternacao' => 0,
            'totalSetorUnidadeIntensiva' => 0,

            'clinic_tev_protocols' => null,
            'totalRiscoTev' => 0,
            'setorUnidadeInternacaoPercentual' => 0,
            'setorUnidadeIntensivaPercentual' => 0,
            'riscoTevPercentual' => 0,
            'percentualContraIndicacaoParaProfilaxiaTev' => 0,
        ];

        $riscoTev = 0;
        $countContraIndicacaoParaProfilaxiaTev = 0;
        $arr_risk_factors = [];
        $arr_risk_factors_novo = [];

        $total_pacientes_periodo = count($hospitalizations);

        //TOTAL DE PACIENTES COM PROTOCOLO DE TEV ABERTO
        $total_hospitalizations_protocols_tev = $this->sumProtocolsTev($hospitalizations);

        //$data['taxa_adesao_protocolo_tev'] = $total_hospitalizations_protocols_tev / $total_pacientes_periodo;

        $data['taxa_adesao_protocolo_tev'] = ($total_hospitalizations_protocols_tev * 100) / $total_pacientes_periodo;
        $data['taxa_adesao_protocolo_tev'] = round($data['taxa_adesao_protocolo_tev'], 2);

        $principais_contra_indicacaoes = ['sangramento_ativo', 'ulcera_peptica', 'has_nao_controlada', 'cagulopatia', 'alergia_ou_plaquetopenia', 'insuficiencia_renal', 'coleta_de_lcr', 'raquinaelose', 'paciente_em_anticuagulante'];

        foreach ($hospitalizations as $hospitalization)
        {
            //tot pacientes
             if (in_array($hospitalization['id'], $data['arr_pacientes']) == false)
            {
                array_push($data['arr_pacientes'], $hospitalization['id']);
                $data['tot_pacientes']++;
            }

            $active_risck = 0;

            if (isset($hospitalization['clinic_tev_protocols']['0']['risk_factors']))
            {
                $active_risck = 1;
                $riscoTev++;
            }

            //DISTRIBUIÇÃO EM VA DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTERNAÇÃO
            if (($hospitalization['sector']['type_id'] == '7' || $hospitalization['sector']['type_id'] == '8') && $active_risck == 1)
            {
                $data['totalSetorUnidadeInternacao'] += 1;
            }

            //DISTRIBUIÇÃO EM VA DE PACIENTES COM RISCO NOS SETORES : UNIDADES INTENSIVAS
            if (($hospitalization['sector']['type_id'] == '12' ||
                $hospitalization['sector']['type_id'] == '13' ||
                $hospitalization['sector']['type_id'] == '14') &&
                $active_risck == 1)
            {
                $data['totalSetorUnidadeIntensiva'] += 1;
            }

            if (isset($hospitalization['clinic_tev_protocols']))
            {
                foreach ($hospitalization['clinic_tev_protocols'] as $key => $clinic_tev_protocol)
                {
                    if ($clinic_tev_protocol['sangramento_ativo'] == true)
                    {
                        $countContraIndicacaoParaProfilaxiaTev++;
                        break;
                    }
                }
            }


            foreach ($hospitalization["clinic_tev_protocols"] as $key_1 => $tev_protocol)
            {
                $profilaxia = false;
                $profilaxia_meca = false;

                //calc paciente obito
                if ($hospitalization['status'] == 'obito')
                {
                    if (in_array($hospitalization['id'], $data['arr_paciente_risco_obito']) == false)
                    {
                        array_push($data['arr_paciente_risco_obito'], $hospitalization['id']);
                        $data['tot_paciente_risco_obito']++;
                    }
                }

                //cria um array com os fatores de risco de tev clinico
                foreach ($clinic_tev_protocol['risk_factors'] as $key => $risk_factors)
                {
                    if (isset($arr_risk_factors[$risk_factors['id']]))
                    {
                        $arr_risk_factors[$risk_factors['id']]['count'] += 1;
                    }
                    else
                    {
                        $arr_risk_factors[$risk_factors['id']]['nome'] = $risk_factors['nome'];
                        $arr_risk_factors[$risk_factors['id']]['count'] = 1;
                        $arr_risk_factors[$risk_factors['id']]['percentual'] = 0;
                    }
                }

                //calc tempo de uso Profilaxia medicamentosa
                if (isset($tev_protocol['profilaxia_medicamentosa_inicio']) &&
                    isset($tev_protocol['profilaxia_medicamentosa_termino']))
                {
                    $date_init = new \DateTime($tev_protocol['profilaxia_medicamentosa_inicio']->format('Y-m-d'));
                    $date_end = new \DateTime($tev_protocol['profilaxia_medicamentosa_termino']->format('Y-m-d'));
                    $days = $date_init->diff($date_end)->days;

                    array_push($data['temp_prof_medi']['arr'], $days);
                    array_push($data['temp_prof']['arr'], $days);
                }

                //calc tempo de uso Profilaxia mecanica
                if (isset($tev_protocol['metodo_mecanico_inicio']) &&
                    isset($tev_protocol['metodo_mecanico_fim']))
                {
                    $date_init = new \DateTime($tev_protocol['metodo_mecanico_inicio']->format('Y-m-d'));
                    $date_end = new \DateTime($tev_protocol['metodo_mecanico_fim']->format('Y-m-d'));
                    $days = $date_init->diff($date_end)->days;

                    array_push($data['temp_prof_meca']['arr'], $days);
                    array_push($data['temp_prof']['arr'], $days);
                }

                //calc pac com tev
                if (in_array($hospitalization['id'], $data['arr_pacientes_tev']) == false)
                {
                    array_push($data['arr_pacientes_tev'], $hospitalization['id']);
                    $data['tot_pacientes_tev']++;
                }

                if ($tev_protocol['enoxaparina'])
                {
                    $profilaxia = true;
                }

                 if ($tev_protocol['dalteparina'])
                {
                    $profilaxia = true;
                }

                 if ($tev_protocol['fondaparinux'])
                {
                    $profilaxia = true;
                }

                 if ($tev_protocol['nadroparina'])
                {
                    $profilaxia = true;
                }

                 if ($tev_protocol['heparina_nao_funciona'])
                {
                    $profilaxia = true;
                }

                if ($profilaxia)
                {
                    if (in_array($hospitalization['id'], $data['paciente_profi_medi']['arr']) == false)
                    {
                        array_push($data['paciente_profi_medi']['arr'], $hospitalization['id']);
                        $data['paciente_profi_medi']['tot']++;
                    }
                }

                if ($tev_protocol['meias_elasticas'])
                {
                    $profilaxia_meca = true;
                }

                if ($tev_protocol['compressao_pneumatica'])
                {
                    $profilaxia_meca = true;
                }

                if ($tev_protocol['fisioterapia_motora'])
                {
                    $profilaxia_meca = true;
                }

                if ($profilaxia_meca)
                {
                    if (in_array($hospitalization['id'], $data['paciente_profi_meca']['arr']) == false)
                    {
                        array_push($data['paciente_profi_meca']['arr'], $hospitalization['id']);
                        $data['paciente_profi_meca']['tot']++;
                    }
                }

                if (!$profilaxia_meca && !$profilaxia)
                {
                    if (in_array($hospitalization['id'], $data['paciente_nao_usou_profilaxia']['arr']) == false)
                    {
                        array_push($data['paciente_nao_usou_profilaxia']['arr'], $hospitalization['id']);
                        $data['paciente_nao_usou_profilaxia']['tot']++;
                    }
                }

                $tev_protocol_arr = (array) $tev_protocol;
                $i = 0;

                $data['total_de_registros']++;

                foreach ($tev_protocol_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

        foreach ($data as $key => $value)
        {
            $marcados = 0;
            if (isset($data[$key]['arr']))
            {
                $len = count($data[$key]['arr']);
                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }
            }

            if (isset($data[$key]['percentual']))
            {
                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }


        foreach ($arr_risk_factors as $key => $value)
        {
            if($data['total_de_registros'] > 0){
                $arr_risk_factors[$key]['percentual'] = ($value['count'] * 100) / $data['total_de_registros'];
                $arr_risk_factors[$key]['percentual'] = round($arr_risk_factors[$key]['percentual'], 2);
            }
        }

        usort($arr_risk_factors, function ($a, $b)
        {
           return $a['count'] < $b['count'];
        });

        $count_risk_factor = 0;
        foreach ($arr_risk_factors as $key => $value)
        {
            if($count_risk_factor > 9){
                unset($arr_risk_factors[$key]);
            }
        }

        $data['fator_risco'] = $arr_risk_factors;

        if ($total_hospitalizations_protocols_tev > 0)
        {
            //DISTRIBUIÇÃO EM % DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTERNAÇÃO
            $data['setorUnidadeInternacaoPercentual'] = ($data['totalSetorUnidadeInternacao'] * 100) / $total_hospitalizations_protocols_tev;
            $data['setorUnidadeInternacaoPercentual'] = round($data['setorUnidadeInternacaoPercentual'], 2);
            //DISTRIBUIÇÃO EM % DE PACIENTES COM RISCO NOS SETORES : UNIDADE DE INTENSIVAS
            $data['setorUnidadeIntensivaPercentual'] = ($data['totalSetorUnidadeIntensiva'] * 100) / $total_hospitalizations_protocols_tev;

            $data['totalRiscoTev'] = $riscoTev;
            $data['riscoTevPercentual'] = number_format(($riscoTev * 100) / $total_hospitalizations_protocols_tev, 2, '.', '');
        }

        //$quantidade de contra indicação para tev
        $data['countContraIndicacaoParaProfilaxiaTev'] = $countContraIndicacaoParaProfilaxiaTev;

        if ($total_hospitalizations_protocols_tev > 0)
        {
            //percentual de contra indicação para tev
            $data['percentualContraIndicacaoParaProfilaxiaTev'] = ($countContraIndicacaoParaProfilaxiaTev * 100) / $total_hospitalizations_protocols_tev;
            $data['percentualContraIndicacaoParaProfilaxiaTev'] = round($data['percentualContraIndicacaoParaProfilaxiaTev'], 2);
        }


        if ($data['paciente_profi_medi']['tot'] > 0)
        {
            $data['paciente_profi_medi']['percen'] = ($data['paciente_profi_medi']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_profi_medi']['percen'] = round($data['paciente_profi_medi']['percen'], 2);
        }

        if ($data['paciente_profi_meca']['tot'] > 0)
        {
            $data['paciente_profi_meca']['percen'] = ($data['paciente_profi_meca']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_profi_meca']['percen'] = round($data['paciente_profi_meca']['percen'], 2);
        }

        if ($data['paciente_nao_usou_profilaxia']['tot'] > 0)
        {
            $data['paciente_nao_usou_profilaxia']['percen'] = ($data['paciente_nao_usou_profilaxia']['tot']*100) / $data['tot_pacientes_tev'];
            $data['paciente_nao_usou_profilaxia']['percen'] = round($data['paciente_nao_usou_profilaxia']['percen'], 2);
        }

        if (count($data['temp_prof_medi']['arr']) > 0)
        {
            $data['temp_prof_medi']['tot'] = $calc_obj->calc_average($data['temp_prof_medi']['arr']);
        }

        if (count($data['temp_prof_meca']['arr']) > 0)
        {
            $data['temp_prof_meca']['tot'] = $calc_obj->calc_average($data['temp_prof_meca']['arr']);
        }

        if (count($data['temp_prof']['arr']) > 0)
        {
            $data['temp_prof']['tot'] = $calc_obj->calc_average($data['temp_prof']['arr']);
        }

        if ($data['tot_paciente_risco_obito'] > 0)
        {
            $data['percen_paciente_risco_obito'] = ($data['tot_paciente_risco_obito']*100) / $data['tot_pacientes_tev'];
            $data['percen_paciente_risco_obito'] = round($data['percen_paciente_risco_obito'], 2);
        }

        if ($data['tot_pacientes_tev'] > 0)
        {
            $data['percen_pacientes_tev'] = ($data['tot_pacientes_tev'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_tev'] = round($data['percen_pacientes_tev'], 2);
        }

        $data_principais = [];
        // cria um array com os contra indicacoes
        foreach ($data as $key => $value) {
           if(in_array($key, $principais_contra_indicacaoes)){
            //echo $key . "<br>";
                $data_principais[$value['total']][$key]['total'] = $value['total'];
                $data_principais[$value['total']][$key]['percentual'] = round($value['percentual'], 2);;
                switch ($key) {
                    case "sangramento_ativo":
                        $data_principais[$value['total']][$key]['nome'] = 'Sangramento Ativo';
                        break;
                    case "ulcera_peptica":
                        $data_principais[$value['total']][$key]['nome'] = 'Ulcera péptica';
                        break;
                    case "has_nao_controlada":
                        $data_principais[$value['total']][$key]['nome'] = 'HAS não controlado (> 180 x 110mmHG)';
                        break;
                    case "cagulopatia":
                        $data_principais[$value['total']][$key]['nome'] = 'Cagulopatia';
                        break;
                    case "alergia_ou_plaquetopenia":
                        $data_principais[$value['total']][$key]['nome'] = 'Alergia ou plaquetopenia por heparina';
                        break;
                    case "insuficiencia_renal":
                        $data_principais[$value['total']][$key]['nome'] = 'Insuficiência renal (Cr* < 30mL/min)';
                        break;
                    case "coleta_de_lcr":
                        $data_principais[$value['total']][$key]['nome'] = 'Coleta de LCR < 24h';
                        break;
                    case "raquinaelose":
                        $data_principais[$value['total']][$key]['nome'] = 'Raquianestesia';
                        break;
                    case "paciente_em_anticuagulante":
                        $data_principais[$value['total']][$key]['nome'] = 'Paciente em uso de anticoagulante';
                        break;
                }
            }
        }
        //echo "<pre>";
        //print_r($data_principais);
        //ordena o array do indece maior para o menor
        krsort($data_principais);
        //echo "<pre>";
        //print_r($data_principais);
        $data['data_principais'] = $data_principais;
        return $data;
    }

    // tev clinico
    public function sumProtocolsTev($hospitalizationsProtocolsTev)
    {
        $countProtocoloTev = 0;
        foreach ($hospitalizationsProtocolsTev as $key => $value)
        {
            $countProtocoloTev += count($value['clinic_tev_protocols']);
        }

        return $countProtocoloTev;
    }


    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
