<?php
namespace App\Model\Table;

use App\Model\Entity\ChestPainProtocolsEchocardiogram;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ChestPainProtocolsEchocardiograms Model
 *
 * @property \Cake\ORM\Association\BelongsTo $ChestPainProtocols
 * @property \Cake\ORM\Association\BelongsTo $Echocardiograms
 */
class ChestPainProtocolsEchocardiogramsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('chest_pain_protocols_echocardiograms');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsTo('ChestPainProtocols', [
            'foreignKey' => 'chest_pain_protocol_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsTo('Echocardiograms', [
            'foreignKey' => 'echocardiogram_id',
            'joinType' => 'INNER'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['chest_pain_protocol_id'], 'ChestPainProtocols'));
        $rules->add($rules->existsIn(['echocardiogram_id'], 'Echocardiograms'));
        return $rules;
    }
}
