<?php
namespace App\Model\Table;

use App\Model\Entity\CardiacSurgeryChecklist;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

/**
 * CardiacSurgeryChecklists Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class CardiacSurgeryChecklistsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('cardiac_surgery_checklists');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('as_informacoes_do_paciente_foram_confirmadas')
            ->allowEmpty('as_informacoes_do_paciente_foram_confirmadas');

        $validator
            ->boolean('o_consentimento_cirurgico_anestesico_foi_assinado')
            ->allowEmpty('o_consentimento_cirurgico_anestesico_foi_assinado');

        $validator
            ->boolean('visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel')
            ->allowEmpty('visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel');

        $validator
            ->boolean('o_checklist_da_anestesia_foi_executado')
            ->allowEmpty('o_checklist_da_anestesia_foi_executado');

        $validator
            ->boolean('a_ficha_anestesica_esta_completa')
            ->allowEmpty('a_ficha_anestesica_esta_completa');

        $validator
            ->boolean('os_recursos_humanos_estao_disponiveis')
            ->allowEmpty('os_recursos_humanos_estao_disponiveis');

        $validator
            ->boolean('os_equipamentos_foram_verificados')
            ->allowEmpty('os_equipamentos_foram_verificados');

        $validator
            ->boolean('monitorizacao_standard_colocada_e_funcionante')
            ->allowEmpty('monitorizacao_standard_colocada_e_funcionante');

        $validator
            ->boolean('acesso_venoso_adequado')
            ->allowEmpty('acesso_venoso_adequado');

        $validator
            ->boolean('alguma_alergia_conhecida')
            ->allowEmpty('alguma_alergia_conhecida');

        $validator
            ->boolean('via_aerea_dificil_risco_de_aspiracao')
            ->allowEmpty('via_aerea_dificil_risco_de_aspiracao');

        $validator
            ->boolean('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo')
            ->allowEmpty('flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo');

        $validator
            ->boolean('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado')
            ->allowEmpty('nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado');

        $validator
            ->boolean('cirurgiao_anestesista_e_enfermeiro_confirmaram')
            ->allowEmpty('cirurgiao_anestesista_e_enfermeiro_confirmaram');

        $validator
            ->boolean('procedimento_cirurgico_realizado')
            ->allowEmpty('procedimento_cirurgico_realizado');

        $validator
            ->boolean('contagem_correta_de_compressas')
            ->allowEmpty('contagem_correta_de_compressas');

        $validator
            ->boolean('pecas_anatomicas_e_produtos')
            ->allowEmpty('pecas_anatomicas_e_produtos');

        $validator
            ->boolean('necessidades_pos_operatorias_revistas')
            ->allowEmpty('necessidades_pos_operatorias_revistas');

        return $validator;
    }

    public function relatorioCirurgiaCardiaca($relatorioCirurgiaCardiacas)
    {
        //$data       = [];
        $calc_obj = new MedidasDispersao();
        $percentual = [];
        $count = 0;
        $data['as_informacoes_do_paciente_foram_confirmadas']['total'] = 0;
        $data['o_consentimento_cirurgico_anestesico_foi_assinado']['total'] = 0;
        $data['visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel']['total'] = 0;
        $data['a_ficha_anestesica_esta_completa']['total'] = 0;
        $data['os_recursos_humanos_estao_disponiveis']['total'] = 0;
        $data['os_equipamentos_foram_verificados']['total'] = 0;
        $data['monitorizacao_standard_colocada_e_funcionante']['total'] = 0; 
        $data['acesso_venoso_adequado']['total'] = 0;
        $data['alguma_alergia_conhecida']['total'] = 0;
        $data['via_aerea_dificil_risco_de_aspiracao']['total'] = 0; 
        $data['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']['total'] = 0; 
        $data['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']['total'] = 0;
        $data['procedimento_cirurgico_realizado']['total'] = 0;
        $data['contagem_correta_de_compressas']['total'] = 0;
        $data['pecas_anatomicas_e_produtos']['total'] = 0;
        $data['necessidades_pos_operatorias_revistas']['total'] = 0;

        foreach ($relatorioCirurgiaCardiacas as $relatorioCirurgiaCardiaca) {
            $count++;

            if($relatorioCirurgiaCardiaca['as_informacoes_do_paciente_foram_confirmadas']){
                $data['as_informacoes_do_paciente_foram_confirmadas']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['o_consentimento_cirurgico_anestesico_foi_assinado']){
                $data['o_consentimento_cirurgico_anestesico_foi_assinado']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel']){
                $data['visualizacao_do_local_da_cirurgica_marcado_nao_aplicavel']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['a_ficha_anestesica_esta_completa']){
                $data['a_ficha_anestesica_esta_completa']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['os_recursos_humanos_estao_disponiveis']){
                $data['os_recursos_humanos_estao_disponiveis']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['os_equipamentos_foram_verificados']){
                $data['os_equipamentos_foram_verificados']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['monitorizacao_standard_colocada_e_funcionante']){
                $data['monitorizacao_standard_colocada_e_funcionante']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['acesso_venoso_adequado']){
                $data['acesso_venoso_adequado']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['alguma_alergia_conhecida']){
                $data['alguma_alergia_conhecida']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['via_aerea_dificil_risco_de_aspiracao']){
                $data['via_aerea_dificil_risco_de_aspiracao']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']){
                $data['flurdoterapia_sangue_disponivel_de_acordo_com_o_protocolo']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']){
                $data['nome_e_funcao_de_pessoas_nao_habituais_na_sala_foi_confirmado']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['procedimento_cirurgico_realizado']){
                $data['procedimento_cirurgico_realizado']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['contagem_correta_de_compressas']){
                $data['contagem_correta_de_compressas']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['pecas_anatomicas_e_produtos']){
                $data['pecas_anatomicas_e_produtos']['total'] += 1;
            }

            if($relatorioCirurgiaCardiaca['necessidades_pos_operatorias_revistas']){
                $data['necessidades_pos_operatorias_revistas']['total'] += 1;
            }     

        }
        //$data['count'] = $count;

        foreach ($data as $key => $value) {
            $data[$key]['percentual'] = $calc_obj->calculate_percentage($value['total'], $count);
        }

        
        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
