<?php
namespace App\Model\Table;

use App\Model\Entity\BradenScale;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";
/**
 * BradenScales Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class BradenScalesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('braden_scales');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('percepcao');

        $validator
            ->allowEmpty('umidade');

        $validator
            ->allowEmpty('atividade_fisica');

        $validator
            ->allowEmpty('mobilidade');

        $validator
            ->allowEmpty('nutricao_');

        $validator
            ->allowEmpty('friccao');

        $validator
            ->integer('pontuacao')
            ->allowEmpty('pontuacao');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after, $sectors)
    {
        $calc_obj = new MedidasDispersao();

        $data = [
            'tot_bradens' => 0,

            'tot_obitos' => 0,
            'tot_obitos_com_ulcera_de_pressao' => 0,

            'taxa_obito_paciente_ulcera' => 0,

            'tot_pacientes' => 0, //total de pacientes
            'arr_pacientes' => [], //arr com id de todos os pacientes

            'arr_pacientes_ulcera_pressao' => [], //arr com todos os pacientes que tem ulcera de pressao
            'tot_pacientes_ulcera_pressao' => 0,
            'percen_pacientes_ulcera_pressao' => 0,

            'arr_pacientes_ulcera_pressao_estagio_1' => [],

            'risco_leve' => [
                'tot_paciente_ulcera' => 0, //total de pacientes com risco leve e úlcera em qualquer estágio
                'percen_paciente_ulcera' => 0,

                'tot_pacientes_ulcera_1' => 0, //tot de pacientes com risco leve e ulcera estágio 1
                'percen_pacientes_ulcera_1' => 0,

                'tot_pacientes_ulcera_2' => 0, //tot de pacientes com risco leve e ulcera estágio 2
                'percen_pacientes_ulcera_2' => 0,

                'tot_pacientes_ulcera_3' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_3' => 0,

                'tot_pacientes_ulcera_4' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_4' => 0,

                'tot_paciente_progressao_ulcera_estagio_1_2' => 0,
                'percen_paciente_progressao_ulcera_estagio_1_2' => 0,

                'tot_paciente_progressao_ulcera_estagio_2_3' => 0,
                'percen_paciente_progressao_ulcera_estagio_2_3' => 0,

                'tot_paciente_progressao_ulcera_estagio_3_4' => 0,
                'percen_paciente_progressao_ulcera_estagio_3_4' => 0,
            ],

            'risco_moderado' => [
                'tot_paciente_ulcera' => 0, //total de pacientes com risco moderado e úlcera em qualquer estágio
                'percen_paciente_ulcera' => 0,

                'tot_pacientes_ulcera_1' => 0, //tot de pacientes com risco leve e ulcera estágio 1
                'percen_pacientes_ulcera_1' => 0,

                'tot_pacientes_ulcera_2' => 0, //tot de pacientes com risco leve e ulcera estágio 2
                'percen_pacientes_ulcera_2' => 0,

                'tot_pacientes_ulcera_3' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_3' => 0,

                 'tot_pacientes_ulcera_4' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_4' => 0,

                'tot_paciente_progressao_ulcera_estagio_1_2' => 0,
                'percen_paciente_progressao_ulcera_estagio_1_2' => 0,

                'tot_paciente_progressao_ulcera_estagio_2_3' => 0,
                'percen_paciente_progressao_ulcera_estagio_2_3' => 0,

                'tot_paciente_progressao_ulcera_estagio_3_4' => 0,
                'percen_paciente_progressao_ulcera_estagio_3_4' => 0,
            ],

            'risco_alto' => [
                'tot_paciente_ulcera' => 0, //total de pacientes com risco alto e úlcera em qualquer estágio
                'percen_paciente_ulcera' => 0,

                'tot_progressoes' => 0, //total de progressoes de ulcera

                'tot_pacientes_ulcera_1' => 0, //tot de pacientes com risco leve e ulcera estágio 1
                'percen_pacientes_ulcera_1' => 0,

                'tot_pacientes_ulcera_2' => 0, //tot de pacientes com risco leve e ulcera estágio 2
                'percen_pacientes_ulcera_2' => 0,

                'tot_pacientes_ulcera_3' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_3' => 0,

                 'tot_pacientes_ulcera_4' => 0, //tot de pacientes com risco leve e ulcera estágio 3
                'percen_pacientes_ulcera_4' => 0,

                'tot_paciente_progressao_ulcera_estagio_1_2' => 0,
                'percen_paciente_progressao_ulcera_estagio_1_2' => 0,

                'tot_paciente_progressao_ulcera_estagio_2_3' => 0,
                'percen_paciente_progressao_ulcera_estagio_2_3' => 0,

                'tot_paciente_progressao_ulcera_estagio_3_4' => 0,
                'percen_paciente_progressao_ulcera_estagio_3_4' => 0,
            ],

            'arr_pacientes_unica_ulcera_pressao' => [], //arr com todos os pacientes que tem uma única ulcera de pressão
            'tot_pacientes_unica_ulcera_pressao' => 0,
            'percen_pacientes_unica_ulcera_pressao' => 0,

            'arr_pacientes_varias_ulcera_pressao' => [], //arr com todos os pacientes que tem mais de uma única ulcera de pressão
            'tot_pacientes_varias_ulcera_pressao' => 0,
            'percen_pacientes_varias_ulcera_pressao' => 0,

            'tot_ulcera_pressao_risco_baixo' => 0, //total de paciente com ulcera de pressão e com risco baixo em braden
            'taxa_ulcera_pressao_risco_baixo' => 0, //PACIENTES COM ULCERA DE PRESSÃO COM BRADEN BAIXO / TOTAL DE PACIENTES COM ÚLCERA DE PRESSÃO

            'tot_ulcera_pressao_risco_moderado' => 0, //total de paciente com ulcera de pressão e com risco moderado em braden
            'taxa_ulcera_pressao_risco_moderado' => 0, //PACIENTES COM ULCERA DE PRESSÃO COM BRADEN moderado / TOTAL DE PACIENTES COM ÚLCERA DE PRESSÃO

            'tot_ulcera_pressao_risco_alto' => 0, //total de paciente com ulcera de pressão e com risco moderado em braden
            'taxa_ulcera_pressao_risco_alto' => 0, //PACIENTES COM ULCERA DE PRESSÃO COM BRADEN moderado / TOTAL DE PACIENTES COM ÚLCERA DE PRESSÃO

            'tot_paciente_risco_moderado' => 0, // total de pacientes com risco moderado em braden
            'percen_paciente_risco_moderado' => 0,
            'arr_paciente_risco_moderado' => [],

            'tot_paciente_risco_alto' => 0,
            'percen_paciente_risco_alto' => 0,
            'arr_paciente_risco_alto' => [],

            'tot_paciente_risco_baixo' => 0,
            'percen_paciente_risco_baixo' => 0,
            'arr_paciente_risco_baixo' => [],

            'clinica' => [
                'arr_pacientes' => [],
                'tot_pacientes' => 0,

                'arr_paciente_risco_moderado' => [],
                'tot_paciente_risco_moderado' => 0,
                'percen_paciente_risco_moderado' => 0,

                'tot_paciente_risco_alto' => 0,
                'percen_paciente_risco_alto' => 0,

                'tot_ulcera_pressao_risco_moderado' => 0, //total de paciente com ulcera de pressão e com risco moderado em braden
                'taxa_ulcera_pressao_risco_moderado' => 0, //PACIENTES COM ULCERA DE PRESSÃO COM BRADEN moderado / TOTAL DE PACIENTES COM ÚLCERA DE PRESSÃO
            ],

            'cirurgica' => [
                'arr_pacientes' => [],
                'tot_pacientes' => 0,

                'arr_paciente_risco_moderado' => [],
                'tot_paciente_risco_moderado' => 0,
                'percen_paciente_risco_moderado' => 0,

                'tot_paciente_risco_alto' => 0,
                'percen_paciente_risco_alto' => 0,

                'arr_paciente_risco_moderado' => [],
                'tot_ulcera_pressao_risco_moderado' => 0, //total de paciente com ulcera de pressão e com risco moderado em braden
                'taxa_ulcera_pressao_risco_moderado' => 0, //PACIENTES COM ULCERA DE PRESSÃO COM BRADEN moderado / TOTAL DE PACIENTES COM ÚLCERA DE PRESSÃO
            ],

            'arr_paciente_ulcera_estagio_1' => [],
            'tot_paciente_ulcera_estagio_1' => 0,
            'percen_paciente_ulcera_estagio_1' => 0,

            'arr_paciente_ulcera_estagio_2' => [],
            'tot_paciente_ulcera_estagio_2' => 0,
            'percen_paciente_ulcera_estagio_2' => 0,

            'arr_paciente_ulcera_estagio_3' => [],
            'tot_paciente_ulcera_estagio_3' => 0,
            'percen_paciente_ulcera_estagio_3' => 0,

            'arr_paciente_ulcera_estagio_4' => [],
            'tot_paciente_ulcera_estagio_4' => 0,
            'percen_paciente_ulcera_estagio_4' => 0,

            'arr_paciente_progressao_ulcera_estagio_1_2' => [],
            'tot_paciente_progressao_ulcera_estagio_1_2' => 0,
            'percen_paciente_progressao_ulcera_estagio_1_2' => 0,

            'arr_paciente_progressao_ulcera_estagio_2_3' => [],
            'tot_paciente_progressao_ulcera_estagio_2_3' => 0,
            'percen_paciente_progressao_ulcera_estagio_2_3' => 0,

            'arr_paciente_progressao_ulcera_estagio_3_4' => [],
            'tot_paciente_progressao_ulcera_estagio_3_4' => 0,
            'percen_paciente_progressao_ulcera_estagio_3_4' => 0,

            'sectors' => [],
        ];

        foreach ($sectors as $sector)
        {
            $sector_id = $sector['id'];
            $data['sectors'][$sector_id] = [
                'name' => $sector['name'],
                'cirurgica' => [
                    'tot_pacientes' => 0,

                    'arr_pacientes_com_risco_moderado' => [],
                    'tot_pacientes_com_risco_moderado' => 0,

                    'arr_pacientes_com_risco_alto' => [],
                    'tot_pacientes_com_risco_alto' => 0,

                    'total_de_riscos_moderado' => 0,
                    'total_de_riscos_alto' => 0,

                    'media_risco_moderado_por_paciente' => 0,
                    'media_risco_alto_por_paciente' => 0,
                ],

                'clinica' => [
                    'tot_pacientes' => 0,

                    'arr_pacientes_com_risco_moderado' => [],
                    'tot_pacientes_com_risco_moderado' => 0,

                    'arr_pacientes_com_risco_alto' => [],
                    'tot_pacientes_com_risco_alto' => 0,

                    'total_de_riscos_moderado' => 0,
                    'total_de_riscos_alto' => 0,

                    'media_risco_moderado_por_paciente' => 0,
                    'media_risco_alto_por_paciente' => 0,
                ],
            ];
        }

        foreach ($hospitalizations as $hospitalization)
        {
            $hospitalization_type = null;
            $estagio_da_ulcera = null;
            $tot_de_ulceras = 0;

            if (strpos($hospitalization['type'], 'Clínica') !== false)
            {
                $hospitalization_type = 'clinica';
            }
            elseif (strpos($hospitalization['type'], 'Cirúr') !== false)
            {
                $hospitalization_type = 'cirurgica';
            }
            if ($hospitalization_type)
            {
                if (in_array($hospitalization['id'], $data[$hospitalization_type]['arr_pacientes']) == false)
                {
                    array_push($data[$hospitalization_type]['arr_pacientes'], $hospitalization['id']);
                    $data[$hospitalization_type]['tot_pacientes']++;
                }
            }
        

            if (count($hospitalization["braden_scales"]) == 0)
            {
                $columns = $this->schema()->columns();

                foreach ($columns as $key => $column)
                {
                    $data[$column]['total'] = 0;
                    $data[$column]['percentual'] = 0;
                    $data[$column]['media'] = 0;
                    $data[$column]['mediana'] = 0;
                    $data[$column]['desvio_padrao'] = 0;
                    $data[$column]['soma'] = 0;
                }
            }

            if (count($hospitalization["skin_integrities"]) > 0)
            {
                $lastEl = array_values(array_slice($hospitalization["skin_integrities"], -1))[0];

                switch ($lastEl['lesao'])
                {
                    case '3':
                        $estagio_da_ulcera = 1;
                        break;

                    case '4':
                        $estagio_da_ulcera = 2;
                        break;

                    case '5':
                        $estagio_da_ulcera = 3;
                        break;

                    case '6':
                        $estagio_da_ulcera = 4;
                        break;
                }
            }

            foreach ($hospitalization["skin_integrities"] as $pele)
            {
                $estagio_atual = null;

                switch ($pele['lesao'])
                {
                    case '3':
                        $estagio_atual = 1;
                        $tot_de_ulceras++;
                        break;

                    case '4':
                        $estagio_atual = 2;
                        $tot_de_ulceras++;
                        break;

                    case '5':
                        $estagio_atual = 3;
                        $tot_de_ulceras++;
                        break;

                    case '6':
                        $estagio_atual = 4;
                        $tot_de_ulceras++;
                        break;
                }

                if ($estagio_da_ulcera && $estagio_atual)
                {
                    if ($estagio_da_ulcera == 1 && $estagio_atual == 2)
                    {
                        $data['tot_paciente_progressao_ulcera_estagio_1_2']++;
                        array_push($data['arr_paciente_progressao_ulcera_estagio_1_2'], $hospitalization['id']);
                    }
                    elseif ($estagio_da_ulcera == 2 && $estagio_atual == 3)
                    {
                        $data['tot_paciente_progressao_ulcera_estagio_2_3']++;
                        array_push($data['arr_paciente_progressao_ulcera_estagio_2_3'], $hospitalization['id']);
                    }
                    elseif ($estagio_da_ulcera == 3 && $estagio_atual == 4)
                    {
                        $data['tot_paciente_progressao_ulcera_estagio_3_4']++;
                        array_push($data['arr_paciente_progressao_ulcera_estagio_3_4'], $hospitalization['id']);
                    }
                }

                $estagio_da_ulcera = $estagio_atual;

                if (!in_array($hospitalization['id'], $data['arr_pacientes_ulcera_pressao']))
                {
                    array_push($data['arr_pacientes_ulcera_pressao'], $hospitalization['id']);
                    $data['tot_pacientes_ulcera_pressao']++;

                    if ($estagio_da_ulcera)
                    {
                        $array_tot_index = 'tot_paciente_ulcera_estagio_' . $estagio_da_ulcera;
                        $array_arr_index = 'arr_paciente_ulcera_estagio_' . $estagio_da_ulcera;
                        $data[$array_tot_index]++;
                        array_push($data[$array_arr_index], $hospitalization['id']);
                    }
                }

                if (in_array($hospitalization['id'], $data['arr_pacientes_varias_ulcera_pressao']) == false)
                {
                    array_push($data['arr_pacientes_varias_ulcera_pressao'], $hospitalization['id']);

                    $data['tot_pacientes_varias_ulcera_pressao']++;
                }
            }
            
            if ($hospitalization["status"] == 'obito')
            {
                $data['tot_obitos']++;

                if ($tot_de_ulceras > 0)
                {
                    $data['tot_obitos_com_ulcera_de_pressao']++;
                }
            }

            foreach ($hospitalization["braden_scales"] as $braden)
            {
                $sector_id = null;
                $braden_arr = (array) $braden;
                $i = 0;

                if (in_array($braden['hospitalization_id'], $data['arr_pacientes']) == false)
                {
                    array_push($data['arr_pacientes'], $braden['hospitalization_id']);
                    $data['tot_pacientes']++;
                }

                if ($braden['sector_id'])
                {
                    $sector_id = $braden['sector_id'];
                }

                if ($braden['pontuacao'] >= 13 && $braden['pontuacao'] <= 14)
                {
                    //calc risco por setor/tipo de internacao
                    if ($hospitalization_type && $sector_id)
                    {
                        $data['sectors'][$sector_id][$hospitalization_type]['total_de_riscos_moderado']++;

                        if (!in_array($braden['hospitalization_id'], $data['sectors'][$sector_id][$hospitalization_type]['arr_pacientes_com_risco_moderado']))
                        {
                            array_push($data['sectors'][$sector_id][$hospitalization_type]['arr_pacientes_com_risco_moderado'], $braden['hospitalization_id']);
                            $data['sectors'][$sector_id][$hospitalization_type]['tot_pacientes_com_risco_moderado']++;
                        }
                    }

                    if (in_array($braden['hospitalization_id'], $data['arr_paciente_risco_moderado']) == false)
                    {
                        array_push($data['arr_paciente_risco_moderado'], $braden['hospitalization_id']);
                        $data['tot_paciente_risco_moderado']++;

                        //contabiliza os pacientes com risco moderado por tipo de internação
                        // $tipo_internacao = null;

                        // if (strpos($hospitalization['type'], 'clínic') !== false)
                        // {
                        //     $tipo_internacao = 'clinica';
                        // }
                        // elseif (strpos($hospitalization['type'], 'cirúr') !== false)
                        // {
                        //     $tipo_internacao = 'cirurgica';
                        // }

                        if ($hospitalization_type)
                        {
                            array_push($data[$hospitalization_type]['arr_paciente_risco_moderado'], $braden['hospitalization_id']);
                            $data[$hospitalization_type]['tot_paciente_risco_moderado']++;
                        }
                    }

                    if (in_array($braden['hospitalization_id'], $data['arr_paciente_risco_moderado']) == false)
                    {
                        array_push($data['arr_paciente_risco_moderado'], $braden['hospitalization_id']);
                        $data['tot_paciente_risco_moderado']++;
                    }
                }
                elseif ($braden['pontuacao'] >= 10 && $braden['pontuacao'] <= 12)
                {

                    //calc risco por setor/tipo de internacao
                    if ($hospitalization_type && $sector_id)
                    {
                        $data['sectors'][$sector_id][$hospitalization_type]['total_de_riscos_alto']++;

                        if (!in_array($braden['hospitalization_id'], $data['sectors'][$sector_id][$hospitalization_type]['arr_pacientes_com_risco_alto']))
                        {
                            array_push($data['sectors'][$sector_id][$hospitalization_type]['arr_pacientes_com_risco_alto'], $braden['hospitalization_id']);
                            $data['sectors'][$sector_id][$hospitalization_type]['tot_pacientes_com_risco_alto']++;
                        }
                    }

                    if (in_array($braden['hospitalization_id'], $data['arr_paciente_risco_alto']) == false)
                    {
                        array_push($data['arr_paciente_risco_alto'], $braden['hospitalization_id']);
                        $data['tot_paciente_risco_alto']++;

                        if ($hospitalization_type)
                        {
                            $data[$hospitalization_type]['tot_paciente_risco_alto']++;
                        }
                    }
                }
                elseif ($braden['pontuacao'] >= 15 && $braden['pontuacao'] <= 18)
                {

                    if (in_array($braden['hospitalization_id'], $data['arr_paciente_risco_baixo']) == false)
                    {
                        array_push($data['arr_paciente_risco_baixo'], $braden['hospitalization_id']);
                        $data['tot_paciente_risco_baixo']++;
                    }
                }

                foreach ($braden_arr as $key_2 => $value_2)
                {
                    $i++;

                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }
            }
        }

//calcula os pacientes que tem risco baixo e úlcera de pressão
        foreach ($data['arr_pacientes_ulcera_pressao'] as $hospitalization_id)
        {
            if (in_array($hospitalization_id, $data['arr_paciente_risco_baixo']) == false)
            {
                $data['tot_ulcera_pressao_risco_baixo']++;
                $data['taxa_ulcera_pressao_risco_baixo'] = ($data['tot_ulcera_pressao_risco_baixo'] * 100) / $data['tot_pacientes_ulcera_pressao'];
                $data['taxa_ulcera_pressao_risco_baixo'] = round($data['taxa_ulcera_pressao_risco_baixo'], 2);
            }
        }

//calcula os pacientes que tem risco moderado e úlcera de pressão
        foreach ($data['arr_pacientes_ulcera_pressao'] as $hospitalization_id)
        {
            if (in_array($hospitalization_id, $data['arr_paciente_risco_moderado']) == false)
            {
                $data['tot_ulcera_pressao_risco_moderado']++;
                $data['taxa_ulcera_pressao_risco_moderado'] = ($data['tot_ulcera_pressao_risco_moderado'] * 100) / $data['tot_pacientes_ulcera_pressao'];
                $data['taxa_ulcera_pressao_risco_moderado'] = round($data['taxa_ulcera_pressao_risco_moderado'], 2);
            }
        }

//calcula os pacientes que tem risco alto e úlcera de pressão
        foreach ($data['arr_pacientes_ulcera_pressao'] as $hospitalization_id)
        {
            if (in_array($hospitalization_id, $data['arr_paciente_risco_alto']) == false)
            {
                $data['tot_ulcera_pressao_risco_alto']++;
                $data['taxa_ulcera_pressao_risco_alto'] = ($data['tot_ulcera_pressao_risco_alto'] * 100) / $data['tot_pacientes_ulcera_pressao'];
                $data['taxa_ulcera_pressao_risco_alto'] = round($data['taxa_ulcera_pressao_risco_alto'], 2);
            }
        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['percentual']) &&
                isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['tot_bradens']);
                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
            }
        }

        //calc porcentagem e pacientes com risco alto
        if ($data['tot_paciente_risco_alto'] > 0)
        {
            $data['percen_paciente_risco_alto'] = ($data['tot_paciente_risco_alto'] * 100) / $data['tot_pacientes'];
            $data['percen_paciente_risco_alto'] = round($data['percen_paciente_risco_alto'], 2);
        }
    
        if ($data['clinica']['tot_paciente_risco_alto'] > 0)
        {
            $data['clinica']['percen_paciente_risco_alto'] = ($data['clinica']['tot_paciente_risco_alto'] * 100) / $data['clinica']['tot_pacientes'];
            $data['clinica']['percen_paciente_risco_alto'] = round($data['clinica']['percen_paciente_risco_alto'], 2);
        }

        if ($data['cirurgica']['tot_paciente_risco_moderado'] > 0)
        {
            $data['cirurgica']['percen_paciente_risco_moderado'] = ($data['cirurgica']['tot_paciente_risco_moderado'] * 100) / $data['cirurgica']['tot_pacientes'];
            $data['cirurgica']['percen_paciente_risco_moderado'] = round($data['cirurgica']['percen_paciente_risco_moderado'], 2);
        }

        //calc porcentagemd e pacientes com risco moderado
        if ($data['tot_paciente_risco_moderado'] > 0)
        {
            $data['percen_paciente_risco_moderado'] = ($data['tot_paciente_risco_moderado'] * 100) / $data['tot_pacientes'];
            $data['percen_paciente_risco_moderado'] = round($data['percen_paciente_risco_moderado'], 2);
        }

        //calc percen pacientes com úlcera de pressão
        if ($data['tot_pacientes_ulcera_pressao'] > 0)
        {
            $data['percen_pacientes_ulcera_pressao'] = ($data['tot_pacientes_ulcera_pressao'] * 100) / $data['tot_pacientes'];
            $data['percen_pacientes_ulcera_pressao'] = round($data['percen_pacientes_ulcera_pressao'], 2);
        }

        //calc progressao
        foreach ($data['arr_paciente_progressao_ulcera_estagio_1_2'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_paciente_progressao_ulcera_estagio_1_2']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_paciente_progressao_ulcera_estagio_1_2']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_paciente_progressao_ulcera_estagio_1_2']++;
            }
        }

        foreach ($data['arr_paciente_progressao_ulcera_estagio_2_3'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_paciente_progressao_ulcera_estagio_2_3']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_paciente_progressao_ulcera_estagio_2_3']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_paciente_progressao_ulcera_estagio_2_3']++;
            }
        }

        foreach ($data['arr_paciente_progressao_ulcera_estagio_3_4'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_paciente_progressao_ulcera_estagio_3_4']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_paciente_progressao_ulcera_estagio_3_4']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_paciente_progressao_ulcera_estagio_3_4']++;
            }
        }

        $tipos_riscos = ['risco_alto', 'risco_leve', 'risco_moderado'];
        foreach ($tipos_riscos as $risco_key => $risco)
        {
            if ($data[$risco]['tot_paciente_progressao_ulcera_estagio_1_2'] > 0)
            {
                $data[$risco]['percen_paciente_progressao_ulcera_estagio_1_2'] = ($data[$risco]['tot_paciente_progressao_ulcera_estagio_1_2'] / $data['tot_paciente_progressao_ulcera_estagio_1_2']) * 100;
            }

            if ($data[$risco]['tot_paciente_progressao_ulcera_estagio_2_3'] > 0)
            {
                $data[$risco]['percen_paciente_progressao_ulcera_estagio_2_3'] = ($data[$risco]['tot_paciente_progressao_ulcera_estagio_2_3'] / $data['tot_paciente_progressao_ulcera_estagio_2_3']) * 100;
            }

            if ($data[$risco]['tot_paciente_progressao_ulcera_estagio_3_4'] > 0)
            {
                $data[$risco]['percen_paciente_progressao_ulcera_estagio_3_4'] = ($data[$risco]['tot_paciente_progressao_ulcera_estagio_3_4'] / $data['tot_paciente_progressao_ulcera_estagio_3_4']) * 100;
            }
        }

        //calc ulcera pressao
        foreach ($data['arr_pacientes_ulcera_pressao'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_paciente_ulcera']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_paciente_ulcera']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_paciente_ulcera']++;
            }
        }

        foreach ($data['arr_paciente_ulcera_estagio_1'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_pacientes_ulcera_1']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_pacientes_ulcera_1']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_pacientes_ulcera_1']++;
            }
        }

        foreach ($data['arr_paciente_ulcera_estagio_2'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_pacientes_ulcera_2']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_pacientes_ulcera_2']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_pacientes_ulcera_2']++;
            }
        }

        foreach ($data['arr_paciente_ulcera_estagio_3'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_pacientes_ulcera_3']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_pacientes_ulcera_3']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_pacientes_ulcera_3']++;
            }
        }

        foreach ($data['arr_paciente_ulcera_estagio_4'] as $paciente_id)
        {
            if (in_array($paciente_id, $data['arr_paciente_risco_baixo']))
            {
                $data['risco_leve']['tot_pacientes_ulcera_4']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_moderado']))
            {
                $data['risco_moderado']['tot_pacientes_ulcera_4']++;
            }

            if (in_array($paciente_id, $data['arr_paciente_risco_alto']))
            {
                $data['risco_alto']['tot_pacientes_ulcera_4']++;
            }
        }

        $tipos_riscos = ['risco_alto', 'risco_leve', 'risco_moderado'];
        foreach ($tipos_riscos as $risco_key => $risco)
        {
            $sum_risco = $data['risco_alto']['tot_paciente_ulcera'] + $data['risco_leve']['tot_paciente_ulcera'] + $data['risco_moderado']['tot_paciente_ulcera'];

            if ($data[$risco]['tot_paciente_ulcera'] > 0)
            {
                $data[$risco]['percen_paciente_ulcera'] = round( ($data[$risco]['tot_paciente_ulcera'] / $sum_risco) * 100, 2);
            }
            if ($data[$risco]['tot_pacientes_ulcera_1'] > 0)
            {
                $data[$risco]['percen_pacientes_ulcera_1'] = ($data[$risco]['tot_pacientes_ulcera_1'] / $data[$risco]['tot_paciente_ulcera']) * 100;
                $data[$risco]['percen_pacientes_ulcera_1'] = round($data[$risco]['percen_pacientes_ulcera_1'], 2);
            }

            if ($data[$risco]['tot_pacientes_ulcera_2'] > 0)
            {
                $data[$risco]['percen_pacientes_ulcera_2'] = ($data[$risco]['tot_pacientes_ulcera_2'] / $data[$risco]['tot_paciente_ulcera']) * 100;
                $data[$risco]['percen_pacientes_ulcera_2'] = round($data[$risco]['percen_pacientes_ulcera_2'], 2);
            }

            if ($data[$risco]['tot_pacientes_ulcera_3'] > 0)
            {
                $data[$risco]['percen_pacientes_ulcera_3'] = ($data[$risco]['tot_pacientes_ulcera_3'] / $data[$risco]['tot_paciente_ulcera']) * 100;
                $data[$risco]['percen_pacientes_ulcera_3'] = round($data[$risco]['percen_pacientes_ulcera_3'], 2);
            }

            if ($data[$risco]['tot_pacientes_ulcera_4'] > 0)
            {
                $data[$risco]['percen_pacientes_ulcera_4'] = ($data[$risco]['tot_pacientes_ulcera_4'] / $data[$risco]['tot_paciente_ulcera']) * 100;
                $data[$risco]['percen_pacientes_ulcera_4'] = round($data[$risco]['percen_pacientes_ulcera_4'], 2);
            }
        }

        //calc porcentagem de mais de uma ulcera de pressao
        if ($data['tot_pacientes_varias_ulcera_pressao'] > 0 &&
            $data['tot_pacientes_ulcera_pressao'] > 0)
        {
            $data['percen_pacientes_varias_ulcera_pressao'] = ($data['tot_pacientes_varias_ulcera_pressao'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_pacientes_varias_ulcera_pressao'] = round($data['percen_pacientes_varias_ulcera_pressao'], 2);
        }

        $data['tot_pacientes_unica_ulcera_pressao'] = $data['tot_pacientes_ulcera_pressao'] - $data['tot_pacientes_varias_ulcera_pressao'];

        if ($data['tot_paciente_ulcera_estagio_1'] > 0)
        {
            $data['percen_paciente_ulcera_estagio_1'] = ($data['tot_paciente_ulcera_estagio_1'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_ulcera_estagio_1'] = round($data['percen_paciente_ulcera_estagio_1'], 2);
        }

        if ($data['tot_paciente_ulcera_estagio_2'] > 0)
        {
            $data['percen_paciente_ulcera_estagio_2'] = ($data['tot_paciente_ulcera_estagio_2'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_ulcera_estagio_2'] = round($data['percen_paciente_ulcera_estagio_2'], 2);
        }

        if ($data['tot_paciente_ulcera_estagio_3'] > 0)
        {
            $data['percen_paciente_ulcera_estagio_3'] = ($data['tot_paciente_ulcera_estagio_3'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_ulcera_estagio_3'] = round($data['percen_paciente_ulcera_estagio_3'], 2);
        }

        if ($data['tot_paciente_ulcera_estagio_4'] > 0)
        {
            $data['percen_paciente_ulcera_estagio_4'] = ($data['tot_paciente_ulcera_estagio_4'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_ulcera_estagio_4'] = round($data['percen_paciente_ulcera_estagio_4'], 2);
        }

        if ($data['tot_paciente_progressao_ulcera_estagio_1_2'] > 0)
        {
            $data['percen_paciente_progressao_ulcera_estagio_1_2'] = ($data['tot_paciente_progressao_ulcera_estagio_1_2'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_progressao_ulcera_estagio_1_2'] = round($data['percen_paciente_progressao_ulcera_estagio_1_2'], 2);
        }

        if ($data['tot_paciente_progressao_ulcera_estagio_2_3'] > 0)
        {
            $data['percen_paciente_progressao_ulcera_estagio_2_3'] = ($data['tot_paciente_progressao_ulcera_estagio_2_3'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_progressao_ulcera_estagio_2_3'] = round($data['percen_paciente_progressao_ulcera_estagio_2_3'], 2);
        }

        if ($data['tot_paciente_progressao_ulcera_estagio_3_4'] > 0)
        {
            $data['percen_paciente_progressao_ulcera_estagio_3_4'] = ($data['tot_paciente_progressao_ulcera_estagio_3_4'] * 100) / $data['tot_pacientes_ulcera_pressao'];
            $data['percen_paciente_progressao_ulcera_estagio_3_4'] = round($data['percen_paciente_progressao_ulcera_estagio_3_4'], 2);
        }

        if ($data['tot_obitos_com_ulcera_de_pressao'] > 0 && $data['tot_obitos'] > 0)
        {
            $data['taxa_obito_paciente_ulcera'] = round($data['tot_obitos_com_ulcera_de_pressao'] / $data['tot_obitos'], 2);
        }

        foreach ($data['sectors'] as $sector_key => $sector)
        {
            foreach (['cirurgica', 'clinica'] as $tipo_internacao)
            {
                if ($sector[$tipo_internacao]['tot_pacientes_com_risco_moderado'] > 0 && $sector[$tipo_internacao]['total_de_riscos_moderado'] > 0)
                {
                    $data['sectors'][$sector_key][$tipo_internacao]['media_risco_moderado_por_paciente'] = round($sector[$tipo_internacao]['total_de_riscos_moderado'] / $sector[$tipo_internacao]['tot_pacientes_com_risco_moderado'], 2);
                }

                if ($sector[$tipo_internacao]['tot_pacientes_com_risco_alto'] > 0 && $sector[$tipo_internacao]['total_de_riscos_alto'] > 0)
                {
                    $data['sectors'][$sector_key][$tipo_internacao]['media_risco_alto_por_paciente'] = round($sector[$tipo_internacao]['total_de_riscos_alto'] / $sector[$tipo_internacao]['tot_pacientes_com_risco_alto'], 2);
                }
            }
        }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
