<?php
namespace App\Model\Table;

use App\Model\Entity\BarthelIndex;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use MedidasDispersao\MedidasDispersao;

require_once ROOT . DS . "vendor" . DS . "Zurubabel" . DS . "MedidasDispersao.php";

/**
 * BarthelIndexes Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Barthels
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 */
class BarthelIndexesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('barthel_indexes');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Barthels', [
            'foreignKey' => 'barthel_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('alimentacao');

        $validator
            ->allowEmpty('banho');

        $validator
            ->allowEmpty('atividades_rotineiras');

        $validator
            ->allowEmpty('vestir_se');

        $validator
            ->allowEmpty('intestino');

        $validator
            ->allowEmpty('sistema_urinario');

        $validator
            ->allowEmpty('uso_do_banheiro');

        $validator
            ->allowEmpty('transferencia');

        $validator
            ->allowEmpty('mobilidade');

        $validator
            ->allowEmpty('escadas');

        $validator
            ->allowEmpty('total_pontos');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('alimentacao_24');

        $validator
            ->allowEmpty('alimentacao_alta');

        $validator
            ->allowEmpty('banho_24');

        $validator
            ->allowEmpty('banho_alta');

        $validator
            ->allowEmpty('atividades_rotineiras_24');

        $validator
            ->allowEmpty('atividades_rotineiras_alta');

        $validator
            ->allowEmpty('vestir_se_24');

        $validator
            ->allowEmpty('vestir_se_alta');

        $validator
            ->allowEmpty('intestino_24');

        $validator
            ->allowEmpty('intestino_alta');

        $validator
            ->allowEmpty('uso_do_banheiro_24');

        $validator
            ->allowEmpty('uso_do_banheiro_alta');

        $validator
            ->allowEmpty('transferencia_24');

        $validator
            ->allowEmpty('transferencia_alta');

        $validator
            ->allowEmpty('mobilidade_24');

        $validator
            ->allowEmpty('mobilidade_alta');

        $validator
            ->allowEmpty('escadas_24');

        $validator
            ->allowEmpty('escadas_alta');

        return $validator;
    }

    public function getRelatorioData($hospitalizations, $date_before, $date_after)
    {
        $calc_obj = new MedidasDispersao();

        $data =
            [
            'barthel' => [
                'arr' => [],
                'media' => 0,
            ],
            'total_de_registros' => 0,
            'total_pontos_admissao' => [
                '10' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '20' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '30' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '40' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '50' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '60' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '70' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '80' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '90' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '100' => ['arr' => [], 'tot' => 0, 'media' => 0],
            ],

            'total_pontos_exturbacao' => [
                '10' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '20' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '30' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '40' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '50' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '60' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '70' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '80' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '90' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '100' => ['arr' => [], 'tot' => 0, 'media' => 0],
            ],

            'total_pontos_alta' => [
                '10' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '20' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '30' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '40' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '50' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '60' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '70' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '80' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '90' => ['arr' => [], 'tot' => 0, 'media' => 0],
                '100' => ['arr' => [], 'tot' => 0, 'media' => 0],
            ],
           'clinica' => [
                'arr' => [],
                'variacao' => 0, //Variação do MRC
                'media' => 0, //Média do MRC      

                'queda_mrc' => [ //pacientes com queda de MRC durante a internação
                    'arr' => [],
                    'tot' => 0,
                ]     
            ],

           'cirurgica' => [
                'arr' => [], 
                'variacao' => 0, //Variação do MRC
                'media' => 0, //Média do MRC

                'queda_mrc' => [ //pacientes com queda de MRC durante a internação
                    'arr' => [],
                    'tot' => 0,
                ]
           ],
        ];

        foreach ($hospitalizations as $hospitalization)
        {
            $tipo_internacao = null;
            if ( stripos($hospitalization['type'], 'clínic') !== FALSE)
            {
                
                $tipo_internacao = 'clinica';
            }
            else if ( stripos($hospitalization['type'], 'cirúr') !== FALSE)
            {
                $tipo_internacao = 'cirurgica';
            }

            foreach ($hospitalization["barthel_indexes"] as $key_1 => $neonatal)
            {   
                //verifica se o registro esta dentro do periodo
                if ($neonatal['created'] < $date_before ||
                    $neonatal['created'] > $date_after
                )
                {
                    continue;
                }

                $data['total_de_registros']++;             
                $neonatal_arr = (array) $neonatal;
                $i = 0;
            
                foreach ($neonatal_arr as $key_2 => $value_2)
                {
                    $i++;
                    if ($i == 2) //acessa as propriades do obj
                    {
                        foreach ($value_2 as $key_3 => $value_3)
                        {
                            //$data[$key_3] = $value_3;
                            formatArr($value_3, $data, $key_3);
                        }
                    }
                }

                if ($neonatal['total_pontos_admissao'])
                {
                                  
                    if ($neonatal['total_pontos_admissao'] <= 10)
                    {
                        $total_pontos_admissao = 10;      
                    }
                    if ($neonatal['total_pontos_admissao'] <= 20)
                    {
                        $total_pontos_admissao = 20;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 30)
                    {
                        $total_pontos_admissao = 30;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 40)
                    {
                        $total_pontos_admissao = 40;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 50)
                    {
                        $total_pontos_admissao = 50;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 60)
                    {
                        $total_pontos_admissao = 60;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 70)
                    {
                        $total_pontos_admissao = 70;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 80)
                    {
                        $total_pontos_admissao = 80;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 90)
                    {
                        $total_pontos_admissao = 90;
                    }
                    else if ($neonatal['total_pontos_admissao'] <= 100)
                    {
                        $total_pontos_admissao = 100;
                    }
                    $data['total_pontos_admissao'][$total_pontos_admissao]['tot']++;
                    array_push($data['barthel']['arr'], $neonatal['total_pontos_admissao']);   
                    if ($tipo_internacao)
                    {
                        array_push($data[$tipo_internacao]['arr'], $neonatal['total_pontos_admissao']);    
                    }
                }

                if ($neonatal['total_pontos_exturbacao'])
                {                                    
                    if ($neonatal['total_pontos_exturbacao'] <= 10)
                    {
                        $total_pontos_exturbacao = 10;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 20)
                    {
                        $total_pontos_exturbacao = 20;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 30)
                    {
                        $total_pontos_exturbacao = 30;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 40)
                    {
                        $total_pontos_exturbacao = 40;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 50)
                    {
                        $total_pontos_exturbacao = 50;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 60)
                    {
                        $total_pontos_exturbacao = 60;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 70)
                    {
                        $total_pontos_exturbacao = 70;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 80)
                    {
                        $total_pontos_exturbacao = 80;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 90)
                    {
                        $total_pontos_exturbacao = 90;
                    }
                    else if ($neonatal['total_pontos_exturbacao'] <= 100)
                    {
                        $total_pontos_exturbacao = 100;
                    }

                    $data['total_pontos_exturbacao'][$total_pontos_exturbacao]['tot']++;
                    array_push($data['barthel']['arr'], $neonatal['total_pontos_exturbacao']);   
                    if ($tipo_internacao)
                    {
                        array_push($data[$tipo_internacao]['arr'], $neonatal['total_pontos_exturbacao']);    
                    }    
                }

                if ($neonatal['total_pontos_alta'])
                {                    
                    if ($neonatal['total_pontos_alta'] <= 10)
                    {
                        $total_pontos_alta = 10;    
                    }
                    if ($neonatal['total_pontos_alta'] <= 20)
                    {
                        $total_pontos_alta = 20;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 30)
                    {
                        $total_pontos_alta = 30;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 40)
                    {
                        $total_pontos_alta = 40;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 50)
                    {
                        $total_pontos_alta = 50;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 60)
                    {
                        $total_pontos_alta = 60;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 70)
                    {
                        $total_pontos_alta = 70;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 80)
                    {
                        $total_pontos_alta = 80;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 90)
                    {
                        $total_pontos_alta = 90;
                    }
                    else if ($neonatal['total_pontos_alta'] <= 100)
                    {
                        $total_pontos_alta = 100;
                    }

                    $data['total_pontos_alta'][$total_pontos_alta]['tot']++;
                    array_push($data['barthel']['arr'], $neonatal['total_pontos_alta']);   
                    if ($tipo_internacao)
                    {
                        array_push($data[$tipo_internacao]['arr'], $neonatal['total_pontos_alta']);    
                    }
                }                
            }            
        }

        foreach ($data as $key => $value)
        {
            if (isset($data[$key]['arr']))
            {
                $marcados = 0;

                $len = count($data[$key]['arr']);

                for ($i = 0; $i < $len; $i++)
                {
                    if ($data[$key]['arr'][$i] || $data[$key]['arr'][$i] !== 0)
                    {
                        $marcados++;
                    }
                }

                $data[$key]['total'] = count($data[$key]['arr']);
                if (isset($data[$key]['percentual']))
                {
                    $data[$key]['percentual'] = $calc_obj->calculate_percentage($marcados, $data['total_de_registros']);
                }   

                $data[$key]['media'] = $calc_obj->calc_average($data[$key]['arr']);
                $data[$key]['mediana'] = $calc_obj->calculate_median($data[$key]['arr']);
                $data[$key]['desvio_padrao'] = $calc_obj->standard_deviation($data[$key]['arr']);
                $data[$key]['variacao'] = $calc_obj->calc_variance($data[$key]['arr']);
            }
        }

        if (!empty($data['cirurgica']['arr']))
        {
            $data['cirurgica']['media'] = $calc_obj->calc_average($data['cirurgica']['arr']);
            $data['cirurgica']['variacao'] = $calc_obj->calc_variance($data['cirurgica']['arr']);
        }

        if (!empty($data['clinica']['arr']))
        {
            $data['clinica']['media'] = $calc_obj->calc_average($data['clinica']['arr']);
            $data['clinica']['variacao'] = $calc_obj->calc_variance($data['clinica']['arr']);
        }

        foreach ($data['total_pontos_admissao'] as $pontuation => $valor)
        {
            if (empty($data['total_pontos_admissao'][$pontuation]['arr']))
            {
                continue;
            }
            $data['total_pontos_admissao'][$pontuation]['media'] = $calc_obj->calc_average($data['total_pontos_admissao'][$pontuation]['arr']);
            // $data['total_pontos_admissao'][$pontuation]['tot'] = count($data['total_pontos_admissao'][$pontuation]['arr']);
            // $data['total_pontos_admissao'][$pontuation]['tot'] = $calc_obj->calc_average($data['total_pontos_admissao'][$pontuation]['arr']);
        }

        foreach ($data['total_pontos_exturbacao'] as $pontuation => $valor)
        {
            if (empty($data['total_pontos_exturbacao'][$pontuation]['arr']))
            {
                continue;
            }
            $data['total_pontos_exturbacao'][$pontuation]['media'] = $calc_obj->calc_average($data['total_pontos_exturbacao'][$pontuation]['arr']);
            // $data['total_pontos_exturbacao'][$pontuation]['tot'] = count($data['total_pontos_exturbacao'][$pontuation]['arr']);
            // $data['total_pontos_exturbacao'][$pontuation]['tot'] = $calc_obj->calc_average($data['total_pontos_exturbacao'][$pontuation]['arr']);
        }

        foreach ($data['total_pontos_alta'] as $pontuation => $valor)
        {
            if (empty($data['total_pontos_alta'][$pontuation]['arr']))
            {
                continue;
            }
            $data['total_pontos_alta'][$pontuation]['media'] = $calc_obj->calc_average($data['total_pontos_alta'][$pontuation]['arr']);
            // $data['total_pontos_alta'][$pontuation]['tot'] = count($data['total_pontos_alta'][$pontuation]['arr']);
            // $data['total_pontos_alta'][$pontuation]['tot'] = $calc_obj->calc_average($data['total_pontos_alta'][$pontuation]['arr']);
        }

        //
        // if (count($data['barthel']['arr']) >  0)
        // {

        // }

        return $data;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['barthel_id'], 'Barthels'));
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
