<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * SurgicalTevProtocol Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $created
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property bool $is_active
 * @property string $risco_da_cirurgica
 * @property string $duracao_da_cirurgia
 * @property bool $fatores_de_risco_tev
 * @property string $risco_alto_opcoes
 * @property string $justificativa_medica
 * @property bool $medicacao
 * @property bool $risco_alto
 * @property bool $risco_intermediario
 * @property bool $meias_elasticas
 * @property bool $compressao_pneumatica
 * @property bool $fisioterapia_motora
 * @property bool $sangramento_ativo
 * @property bool $ulcera_peptica
 * @property bool $has_nao_controlada
 * @property bool $cagulopatia
 * @property bool $alergia_ou_plaquetopenia
 * @property bool $insuficiencia_renal
 * @property bool $coleta_de_lcr
 * @property bool $raquinaelose
 * @property bool $paciente_em_anticuagulante
 * @property bool $artopressia_quadril
 * @property bool $artopressa_joelho
 * @property bool $trauma_requimedular
 * @property bool $fratura_de_quadril
 * @property bool $oncologia_curativa
 * @property bool $poltrauma
 * @property bool $endoscopia
 * @property bool $resseccao
 * @property bool $laparoscopica
 * @property bool $superficial
 * @property bool $oftamologica
 * @property bool $otominrigologica
 * @property string $outras
 * @property \App\Model\Entity\TevOption[] $tev_options
 */
class SurgicalTevProtocol extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
