<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * MedicationsHistoric Entity.
 *
 * @property int $id
 * @property string $name
 * @property string $dosage
 * @property string $channel
 * @property string $frequency
 * @property \Cake\I18n\Time $start_date
 * @property \Cake\I18n\Time $end_date
 * @property \Cake\I18n\Time $created
 * @property bool $is_antibiotic
 * @property int $sign_id
 * @property \App\Model\Entity\Sign $sign
 * @property int $medication_id
 * @property \App\Model\Entity\Medication $medication
 */
class MedicationsHistoric extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
        'sign_id' => false,
    ];
}
