<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * ChestPainProtocol Entity.
 *
 * @property int $id
 * @property \Cake\I18n\Time $hora_zero
 * @property \Cake\I18n\Time $hora_ecg
 * @property string $suspeita_sca
 * @property \Cake\I18n\Time $hora_trombolitico
 * @property \Cake\I18n\Time $aas_hora
 * @property \Cake\I18n\Time $clopidogrel_hora
 * @property int $ticagrelor
 * @property string $tmp_medio_permanencia_uci
 * @property string $tmp_medio_permanencia_hospitalar
 * @property int $hospitalization_id
 * @property \App\Model\Entity\Hospitalization $hospitalization
 * @property string $aas_mg
 * @property string $has
 * @property string $disapidemia
 * @property string $sedentarismo
 * @property string $estresse
 * @property string $hf
 * @property string $tabagismo
 * @property string $ex_tabagista
 * @property string $obesidade
 * @property string $angina
 * @property string $iam
 * @property string $cat
 * @property string $avm_data
 * @property string $avm_ponte
 * @property string $icp_vasos
 * @property bool $ulcera
 * @property bool $cancer
 * @property bool $sangramento
 * @property string $sangramento_sitio
 * @property bool $outros
 * @property string $outros_text
 * @property string $pa
 * @property string $peso
 * @property string $altura
 * @property \Cake\I18n\Time $hora
 * @property string $fc
 * @property string $fr
 * @property string $sat02
 * @property string $tamp
 * @property string $av_de_enfermagem
 * @property string $anaminese
 * @property string $hipotese
 * @property bool $has_supra
 * @property \Cake\I18n\Time $ecg_hora_1
 * @property string $porta_ecg
 * @property string $supra_mm
 * @property string $supra_der
 * @property bool $has_infra
 * @property string $infra_mm
 * @property string $infra_der
 * @property bool $has_tim
 * @property string $tim_mm
 * @property string $tim_der
 * @property bool $has_q_pet
 * @property string $q_pet_mm
 * @property string $q_pet_der
 * @property bool $has_bre
 * @property string $bre_mm
 * @property bool $has_bavt
 * @property bool $has_bro
 * @property string $bro_mm
 * @property \Cake\I18n\Time $ecg_hora_2
 * @property \Cake\I18n\Time $ecg_hora_3
 * @property bool $alteracao_dinamica
 * @property string $enzima_data_1
 * @property \Cake\I18n\Time $enzima_hora_1
 * @property string $ck_mb_1
 * @property string $troponima_1
 * @property string $enzima_data_2
 * @property \Cake\I18n\Time $enzima_hora_2
 * @property string $ck_mb_2
 * @property string $troponima_2
 * @property string $enzima_data_3
 * @property \Cake\I18n\Time $enzima_hora_3
 * @property string $ck_mb_3
 * @property string $troponima
 * @property string $radiologia
 * @property string $evolucao
 * @property string $diagnostico_final
 * @property string $condicao_de_alta
 * @property string $instrucao_de_alta
 * @property string $pareceres
 * @property string $destino
 * @property string $data_saida
 * @property string $hora_saida
 * @property \Cake\I18n\Time $created
 * @property bool $is_active
 * @property string $betabloq
 * @property string $eca
 * @property string $cm
 * @property string $epidemia
 * @property int $screening_id
 * @property \App\Model\Entity\Screening $screening
 * @property \Cake\I18n\Time $rvm_data
 * @property string $rvm_pontes
 * @property \Cake\I18n\Time $icp_data
 * @property bool $rvm
 * @property int $icp
 * @property \Cake\I18n\Time $ticagrelor_hora
 */
class ChestPainProtocol extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        '*' => true,
        'id' => false,
    ];
}
