<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * SurgicalTevProtocols Controller
 *
 * @property \App\Model\Table\SurgicalTevProtocolsTable $SurgicalTevProtocols
 */
class SurgicalTevProtocolsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'TEV cirúrgico');

        $session = $this->request->session();

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $surgicalTevProtocols = $this->paginate($this->SurgicalTevProtocols);

        $this->set(compact('surgicalTevProtocols'));
        $this->set('_serialize', ['surgicalTevProtocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Surgical Tev Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');
        $pacient       = $pacient_table->findById($pacient_id);

        $surgicalTevProtocol = $this->SurgicalTevProtocols->get($id, [
            //'contain' => ['Hospitalizations', 'TevOptions'],
        ]);
        $this->set('pacient', $pacient);
        $this->set('surgicalTevProtocol', $surgicalTevProtocol);
        $this->set('_serialize', ['surgicalTevProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $pacient_table = TableRegistry::get('Patients');
        $session       = $this->request->session();
        $pacient_id    = $session->read('selected-pacient');
        $pacient       = $pacient_table->findById($pacient_id);

        $surgicalTevProtocol = $this->SurgicalTevProtocols->newEntity();
        if ($this->request->is('post')) {
            $surgicalTevProtocol = $this->SurgicalTevProtocols->patchEntity($surgicalTevProtocol, $this->request->data);
            if ($this->SurgicalTevProtocols->save($surgicalTevProtocol)) {
                $this->Flash->success(__('The surgical tev protocol has been saved.'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical tev protocol could not be saved. Please, try again.'));
            }
        }
        $hospitalizations  = $this->SurgicalTevProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $tevOptions        = $this->SurgicalTevProtocols->TevOptions->find('list', ['limit' => 200, 'fields' => ["id", 'nome']]);
        $contraindications = $this->SurgicalTevProtocols->Contraindications->find('list', ['limit' => 200, 'fields' => ["id", 'nome']]);
        $this->set(compact('surgicalTevProtocol', 'hospitalizations', 'tevOptions', 'contraindications', 'pacient'));
        $this->set('_serialize', ['surgicalTevProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Surgical Tev Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $surgicalTevProtocol = $this->SurgicalTevProtocols->get($id, [
            'contain' => ['TevOptions'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $surgicalTevProtocol = $this->SurgicalTevProtocols->patchEntity($surgicalTevProtocol, $this->request->data);
            if ($this->SurgicalTevProtocols->save($surgicalTevProtocol)) {
                $this->Flash->success(__('The surgical tev protocol has been saved.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('The surgical tev protocol could not be saved. Please, try again.'));
            }
        }
        $hospitalizations = $this->SurgicalTevProtocols->Hospitalizations->find('list', ['limit' => 200]);
        $tevOptions       = $this->SurgicalTevProtocols->TevOptions->find('list', ['limit' => 200]);
        $this->set(compact('surgicalTevProtocol', 'hospitalizations', 'tevOptions'));
        $this->set('_serialize', ['surgicalTevProtocol']);
    }

    public function printView($id = null)
    {
        $is_print_view = true;

        $session       = $this->request->session();

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);

        $surgicalTevProtocol = $this->SurgicalTevProtocols->get($id, [
            //'contain' => ['Hospitalizations', 'TevOptions'],
        ]);

        $this->set(compact('patient','hospitalization','is_print_view','unit','surgicalTevProtocol'));
        $this->set('_serialize', ['surgicalTevProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Surgical Tev Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $surgicalTevProtocol = $this->SurgicalTevProtocols->get($id);
        if ($this->SurgicalTevProtocols->delete($surgicalTevProtocol)) {
            $this->Flash->success(__('The surgical tev protocol has been deleted.'));
        } else {
            $this->Flash->error(__('The surgical tev protocol could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
