<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;


/**
 * ObstetricSurgeryChecklists Controller
 *
 * @property \App\Model\Table\ObstetricSurgeryChecklistsTable $ObstetricSurgeryChecklists
 */
class ObstetricSurgeryChecklistsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Checklist');
    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'CardiacSurgeryChecklists', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $obstetricSurgeryChecklists = $this->paginate($this->ObstetricSurgeryChecklists);

        $this->set(compact('obstetricSurgeryChecklists'));
        $this->set('_serialize', ['obstetricSurgeryChecklists']);
    }

    /**
     * View method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('obstetricSurgeryChecklist', $obstetricSurgeryChecklist);
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->newEntity();
        if ($this->request->is('post')) {
            $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->patchEntity($obstetricSurgeryChecklist, $this->request->data);
            if ($this->ObstetricSurgeryChecklists->save($obstetricSurgeryChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ObstetricSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('obstetricSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->patchEntity($obstetricSurgeryChecklist, $this->request->data);
            if ($this->ObstetricSurgeryChecklists->save($obstetricSurgeryChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ObstetricSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('obstetricSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Obstetric Surgery Checklist id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id);
        if ($this->ObstetricSurgeryChecklists->delete($obstetricSurgeryChecklist)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
    }

    public function printView($id = null)
    {
        $is_print_view = true;
       
        $session       = $this->request->session();

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');    
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);

        $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $obstetricSurgeryChecklist = $this->ObstetricSurgeryChecklists->patchEntity($obstetricSurgeryChecklist, $this->request->data);
            if ($this->ObstetricSurgeryChecklists->save($obstetricSurgeryChecklist)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['controller' => 'surgicalChecklists', 'action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->ObstetricSurgeryChecklists->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('is_print_view','unit','patient','hospitalization','obstetricSurgeryChecklist', 'hospitalizations'));
        $this->set('_serialize', ['obstetricSurgeryChecklist']);
    }
}