<?php
namespace App\Controller;

use App\Controller\AppController;

/**
 * MedicationsHistoric Controller
 *
 * @property \App\Model\Table\MedicationsHistoricTable $MedicationsHistoric
 */
class MedicationsHistoricController extends AppController
{
    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Histórico');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index($medication_id = null, $prescription_id = null)
    {
        $this->paginate = [
            'contain' => ['Signs', 'Medications'],
        ];
        $medicationsHistoric = $this->paginate($this->MedicationsHistoric);

        $this->set('prescription_id', $prescription_id);
        $this->set('medication_id', $medication_id);
        $this->set(compact('medicationsHistoric'));
        $this->set('_serialize', ['medicationsHistoric']);
    }

    /**
     * View method
     *
     * @param string|null $id Medications Historic id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null, $medication_id = null, $prescription_id = null)
    {
        $medicationsHistoric = $this->MedicationsHistoric->get($id, [
            'contain' => ['Signs', 'Medications'],
        ]);

        $this->set('prescription_id', $prescription_id);
        $this->set('medication_id', $medication_id);
        $this->set('medicationsHistoric', $medicationsHistoric);
        $this->set('_serialize', ['medicationsHistoric']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $medicationsHistoric = $this->MedicationsHistoric->newEntity();
        if ($this->request->is('post')) {
            $medicationsHistoric = $this->MedicationsHistoric->patchEntity($medicationsHistoric, $this->request->data);
            if ($this->MedicationsHistoric->save($medicationsHistoric)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo'));
            }
        }
        $signs       = $this->MedicationsHistoric->Signs->find('list', ['limit' => 200]);
        $medications = $this->MedicationsHistoric->Medications->find('list', ['limit' => 200]);
        $this->set(compact('medicationsHistoric', 'signs', 'medications'));
        $this->set('_serialize', ['medicationsHistoric']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Medications Historic id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null, $prescription_id = null)
    {
        $medicationsHistoric = $this->MedicationsHistoric->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $medicationsHistoric = $this->MedicationsHistoric->patchEntity($medicationsHistoric, $this->request->data);
            if ($this->MedicationsHistoric->save($medicationsHistoric)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não foi salvo'));
            }
        }

        $this->set('prescription_id', $prescription_id);
        $signs       = $this->MedicationsHistoric->Signs->find('list', ['limit' => 200]);
        $medications = $this->MedicationsHistoric->Medications->find('list', ['limit' => 200]);
        $this->set(compact('medicationsHistoric', 'signs', 'medications'));
        $this->set('_serialize', ['medicationsHistoric']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Medications Historic id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $medicationsHistoric = $this->MedicationsHistoric->get($id);
        if ($this->MedicationsHistoric->delete($medicationsHistoric)) {
            $this->Flash->success(__('O registro  foi deletado'));
        } else {
            $this->Flash->error(__('O registro  não foi deletado'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
