<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * InformedConsentForms Controller
 *
 * @property \App\Model\Table\InformedConsentFormsTable $InformedConsentForms
 */
class InformedConsentFormsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'TCI');

        $session = $this->request->session();

        $pacient_id = $session->read('selected-pacient');
        $this->set('pacient_id', $pacient_id);

        $unit_id = $session->read('selected-unit');
        $this->set('unit_id', $unit_id);

        $hospitalization_id = $session->read('selected-hospitalization');
        $this->set('hospitalization_id', $hospitalization_id);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $session = $this->request->session();
        $hospitalization_id = $session->read('selected-hospitalization');

        $this->paginate = [
            'contain' => ['Hospitalizations'],
            'conditions' => ['InformedConsentForms.hospitalization_id' => $hospitalization_id],
            'order' => ['created' => 'desc'],
        ];
        
        $informedConsentForms = $this->paginate($this->InformedConsentForms);

        $this->set(compact('informedConsentForms'));
        $this->set('_serialize', ['informedConsentForms']);
    }

    /**
     * View method
     *
     * @param string|null $id Informed Consent Form id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $informedConsentForm = $this->InformedConsentForms->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('informedConsentForm', $informedConsentForm);
        $this->set('_serialize', ['informedConsentForm']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tci_types_table = TableRegistry::get('TciTypes');
        $tci_types       = $tci_types_table->find();

        $informedConsentForm = $this->InformedConsentForms->newEntity();
        if ($this->request->is('post')) {
            $informedConsentForm = $this->InformedConsentForms->patchEntity($informedConsentForm, $this->request->data);
            if ($this->InformedConsentForms->save($informedConsentForm)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->InformedConsentForms->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('informedConsentForm', 'hospitalizations', 'tci_types'));
        $this->set('_serialize', ['informedConsentForm']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Informed Consent Form id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tci_types_table = TableRegistry::get('TciTypes');
        $tci_types       = $tci_types_table->find();

        $informedConsentForm = $this->InformedConsentForms->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $informedConsentForm = $this->InformedConsentForms->patchEntity($informedConsentForm, $this->request->data);
            if ($this->InformedConsentForms->save($informedConsentForm)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->InformedConsentForms->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('informedConsentForm', 'hospitalizations', 'tci_types'));
        $this->set('_serialize', ['informedConsentForm']);
    }


    public function printView($id = null)
    {

        $is_print_view = true;
       
        $session       = $this->request->session();

        $session->write('bundle_id', $id);

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');    
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);


        $tci_types_table = TableRegistry::get('TciTypes');
        $tci_types       = $tci_types_table->find();

        $informedConsentForm = $this->InformedConsentForms->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $informedConsentForm = $this->InformedConsentForms->patchEntity($informedConsentForm, $this->request->data);
            if ($this->InformedConsentForms->save($informedConsentForm)) {
                $this->Flash->success(__('O registro foi salvo.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('O registro não pode ser salvo. Por favor, tente novamente.'));
            }
        }
        $hospitalizations = $this->InformedConsentForms->Hospitalizations->find('list', ['limit' => 200]);
        $this->set(compact('is_print_view','unit','patient','hospitalization','informedConsentForm', 'hospitalizations', 'tci_types'));
        $this->set('_serialize', ['informedConsentForm']);
    }

    

    /**
     * Delete method
     *
     * @param string|null $id Informed Consent Form id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $informedConsentForm = $this->InformedConsentForms->get($id);
        if ($this->InformedConsentForms->delete($informedConsentForm)) {
            $this->Flash->success(__('O registro foi deletado.'));
        } else {
            $this->Flash->error(__('O registro não pode ser deletado. Por favor, tente novamente.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
