<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Log\Log;


/**
 * Groups Controller
 *
 * @property \App\Model\Table\GroupsTable $Groups
 */
class GroupsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Upload');
        $this->set('title', 'Grupo de Unidade');
        $this->loadComponent('Permission');
    }     

    public function isAuthorized($user)
    {               
       $action = $this->request->params['action'];
        
       return  $this->Permission->hasPermission($user['role_name'], 'groups', $action);

       //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $groups = $this->paginate($this->Groups);

        $this->set(compact('groups'));
        $this->set('_serialize', ['groups']);
    }

    /**
     * View method
     *
     * @param string|null $id Group id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $group = $this->Groups->get($id, [
            'contain' => ['Units']
        ]);

        $this->set('group', $group);
        $this->set('_serialize', ['group']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $group_db = TableRegistry::get('Groups');
        $group = $this->Groups->newEntity();

        if ($this->request->is('post')) 
        {            
            //$group = $this->Groups->patchEntity($group, $this->request->data);
            Log::write('debug', "request data init ");
            Log::write('debug', $this->request->data);
            Log::write('debug', "request data end");
            if ( $this->Upload->send($this->request->data) )
            {
                $this->Flash->success(__('O grupo foi salvo com sucesso.'));
                return $this->redirect(['action' => 'index']);
            }
            else
            {
                $this->Flash->error(__('O grupo não pode ser salvo. Por favor, tente novamente.'));
            }                    
        }

        $this->set(compact('group', 'group_db'));
        $this->set('_serialize', ['group', 'group_db']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Group id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $group = $this->Groups->get($id, [
            'contain' => []
        ]);

        //pega as unidades do grupo
        $units = $this->Groups->Units->find('all', [
            'limit' => 200
            ])
            ->where(['Units.group_id ' => $id])
        ;
        $units = $this->paginate($units);


        if ($this->request->is(['patch', 'post', 'put'])) 
        {
            $group = $this->Groups->patchEntity($group, $this->request->data);
            
            $this->request->data['id'] = $id;
            //Log::write('debug', $this->request->data);

            if ( $this->Upload->send( $this->request->data )  ) 
            {
                $this->Flash->success(__('O grupo foi salvo com sucesso.'));
                return $this->redirect(['action' => 'index']);
            } 
            else 
            {
                $this->Flash->error(__('O grupo não pode ser salvo. Por favor, tente novamente.'));
            }
        }

        $this->set(compact('group', 'units'));
        $this->set('_serialize', ['group', 'units']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Group id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $group = $this->Groups->get($id);
        if ($this->Groups->delete($group)) {
            $this->Flash->success(__('The group has been deleted.'));
        } else {
            $this->Flash->error(__('The group could not be deleted. Please, try again.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
