<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\Log\Log;
use Cake\ORM\TableRegistry;

/**
 * ChestPainProtocols Controller
 *
 * @property \App\Model\Table\ChestPainProtocolsTable $ChestPainProtocols
 */
class ChestPainProtocolsController extends AppController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Auth', [
            'authorize' => 'Controller',
        ]);
        $this->loadComponent('Permission');

        // View or Controller
        $this->set('title', 'Protocolo de dor torácica');

        $session = $this->request->session();

        $current_state = $session->read('current-state');
        $this->set('current_state', $current_state);

    }

    public function isAuthorized($user)
    {
        $action = $this->request->params['action'];

        return $this->Permission->hasPermission($user['role_name'], 'Bundles', $action);
        //return parent::isAuthorized($user);
    }

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Hospitalizations'],
        ];
        $chestPainProtocols = $this->paginate($this->ChestPainProtocols);

        $this->set(compact('chestPainProtocols'));
        $this->set('_serialize', ['chestPainProtocols']);
    }

    /**
     * View method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|null
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $chestPainProtocol = $this->ChestPainProtocols->get($id, [
            'contain' => ['Hospitalizations'],
        ]);

        $this->set('chestPainProtocol', $chestPainProtocol);
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Add method
     *
     * @return \Cake\Network\Response|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $chestPainProtocol = $this->ChestPainProtocols->newEntity();
        if ($this->request->is('post')) {
            $chestPainProtocol = $this->ChestPainProtocols->patchEntity($chestPainProtocol, $this->request->data);
            //Log::write('debug', $chestPainProtocol);
            if ($this->ChestPainProtocols->save($chestPainProtocol)) {
                $this->Flash->success(__('O registro foi salvo'));
                return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            } else {
                $x = $chestPainProtocol->errors();
                Log::write('debug', 'x');
                Log::write('debug', $x);
                $this->Flash->error(__('O registro não pode ser salvo'));
            }
        }
        $echocardiograms = $this->ChestPainProtocols->Echocardiograms->find('list', ['limit' => 200]);
        $this->set(compact('chestPainProtocol', 'echocardiograms'));
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $chestPainProtocol = $this->ChestPainProtocols->get($id, [
            'contain' => ['Echocardiograms'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            //$chestPainProtocol = $this->ChestPainProtocols->patchEntity($chestPainProtocol, $this->request->data);
            // if ($this->ChestPainProtocols->save($chestPainProtocol)) {
            //     $this->Flash->success(__('O registro foi salvo'));
            //     return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            // } else {
            //     $this->Flash->error(__('O registro não pode ser salvo'));
            // }
        }
        $echocardiograms = $this->ChestPainProtocols->Echocardiograms->find('list', ['limit' => 200]);
        $this->set(compact('chestPainProtocol', 'echocardiograms'));
        $this->set('_serialize', ['chestPainProtocol']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Chest Pain Protocol id.
     * @return \Cake\Network\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $chestPainProtocol = $this->ChestPainProtocols->get($id);
        if ($this->ChestPainProtocols->delete($chestPainProtocol)) {
            $this->Flash->success(__('O registro foi deletado'));
        } else {
            $this->Flash->error(__('O registro não foi deletado'));
        }
        return $this->redirect(['action' => 'index']);
    }

    public function printView($id = null)
    {

        $is_print_view = true;

        $session       = $this->request->session();

        $patientTable             = TableRegistry::get('Patients');
        $hospitalizations_table   = TableRegistry::get('Hospitalizations');
        $units_table              = TableRegistry::get('Units');

        $unit_id               = $session->read('selected-unit');
        $pacient_id            = $session->read('selected-pacient');
        $hospitalization_id    = $session->read('selected-hospitalization');

        $unit                    = $units_table->get($unit_id);
        $hospitalization         = $hospitalizations_table->get($hospitalization_id,['contain'=>['Discharges','Sectors']]);
        $patient                 = $patientTable->get($pacient_id);


        $chestPainProtocol = $this->ChestPainProtocols->get($id, [
            'contain' => ['Echocardiograms'],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            //$chestPainProtocol = $this->ChestPainProtocols->patchEntity($chestPainProtocol, $this->request->data);
            // if ($this->ChestPainProtocols->save($chestPainProtocol)) {
            //     $this->Flash->success(__('O registro foi salvo'));
            //     return $this->redirect(['controller' => 'SepseProtocols', 'action' => 'index']);
            // } else {
            //     $this->Flash->error(__('O registro não pode ser salvo'));
            // }
        }
        $echocardiograms = $this->ChestPainProtocols->Echocardiograms->find('list', ['limit' => 200]);
        $this->set(compact('is_print_view','hospitalization','patient','unit','chestPainProtocol', 'echocardiograms'));
        $this->set('_serialize', ['chestPainProtocol']);
    }
}
