<div class="row">
<nav class="col-md-2" id="actions-sidebar">
    <ul class="nav nav-pills nav-stacked">
        <li class="active"><a><?= __('Actions') ?></a></li>
        <li><?= $this->Html->link(__('New {0}', ['Safe Surgery Bundle']), ['action' => 'add']) ?></li>
        <li><?= $this->Html->link(__('List {0}', ['Hospitalizations']), ['controller' => 'Hospitalizations', 'action' => 'index']) ?></li>
        <li><?= $this->Html->link(__('New {0}', ['Hospitalization']), ['controller' => 'Hospitalizations', 'action' => 'add']) ?></li>
    </ul>
</nav>
<div class="safeSurgeryBundles index col-md-10 columns content">
    <h3>Safe Surgery Bundles</h3>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th><?= $this->Paginator->sort('id') ?></th>
                <th><?= $this->Paginator->sort('created') ?></th>
                <th><?= $this->Paginator->sort('is_active') ?></th>
                <th><?= $this->Paginator->sort('hospitalization_id') ?></th>
                <th><?= $this->Paginator->sort('tci_cirurgico') ?></th>
                <th><?= $this->Paginator->sort('ficha_pre_anestesica') ?></th>
                <th><?= $this->Paginator->sort('tci_anestesico') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($safeSurgeryBundles as $safeSurgeryBundle): ?>
            <tr>
                <td><?= $this->Number->format($safeSurgeryBundle->id) ?></td>
                <td><?= h($safeSurgeryBundle->created) ?></td>
                <td><?= h($safeSurgeryBundle->is_active) ?></td>
                <td><?= $safeSurgeryBundle->has('hospitalization') ? $this->Html->link($safeSurgeryBundle->hospitalization->id, ['controller' => 'Hospitalizations', 'action' => 'view', $safeSurgeryBundle->hospitalization->id]) : '' ?></td>
                <td><?= h($safeSurgeryBundle->tci_cirurgico) ?></td>
                <td><?= h($safeSurgeryBundle->ficha_pre_anestesica) ?></td>
                <td><?= h($safeSurgeryBundle->tci_anestesico) ?></td>
                <td class="actions" style="white-space:nowrap">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $safeSurgeryBundle->id], ['class'=>'btn btn-default btn-xs']) ?>
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $safeSurgeryBundle->id], ['class'=>'btn btn-primary btn-xs']) ?>
                    <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $safeSurgeryBundle->id], ['confirm' => __('Are you sure you want to delete # {0}?', $safeSurgeryBundle->id), 'class'=>'btn btn-danger btn-xs']) ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('previous'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('next') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
            <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} records out of
         {{count}} total, starting on record {{start}}, ending on {{end}}')) ?></p>
        </div>
    </center>
</div>
</div>