<?php    
    echo $this->element( 'internacao-menu' );

    $data_arr = [];

    foreach ($hospitalizations as $hospitalization) {
        foreach ($hospitalization['fugulin_braden_scales'] as $value) {
            $value["tipo_tabela"] = "fugulin_braden_scales";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {                
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }

        foreach ($hospitalization['braden_scales'] as $value) {
            $value["tipo_tabela"] = "braden_scales";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {                
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }

        foreach ($hospitalization['nas_scores'] as $value) {
            $value["tipo_tabela"] = "nas_scores";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {                
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }

        foreach ($hospitalization['skin_integrities'] as $value) {
            $value["tipo_tabela"] = "skin_integrities";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {                
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }

        foreach ($hospitalization['identification_of_risks'] as $value) {
            $value["tipo_tabela"] = "identification_of_risks";

            if ( !array_key_exists( $value->created->format("Y-m-d"), $data_arr)) {                
                $data_arr[$value->created->format("Y-m-d")] = [];
            }
            array_push($data_arr[$value->created->format("Y-m-d")], $value);
        }



        krsort($data_arr);
    }

            
?>
<div class="row">

<div class="fugulinBradenScales index col-md-8 columns content">    
    <div class="btn-group">    
      <button type="button" class="btn btn-default dropdown-toggle bt-menu-margin" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Novo Avaliação <span class="caret"></span>
      </button>
      <ul class="dropdown-menu">
        <li>
            <?php
                echo $this->Html->link(
                    'Fugullin',
                    ['controller' => 'FugulinBradenScales', 'action' => 'add', 'fugulin','_full' => true]
                );
            ?>
        </li>
        <li>
            <?php
                echo $this->Html->link(
                    'Braden',
                    ['controller' => 'BradenScales', 'action' => 'add', 'braden','_full' => true]
                );
            ?>
        </li>
        <li>
            <?php
                echo $this->Html->link(
                    'Integridade de pele',
                    ['controller' => 'SkinIntegrities', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>

         <li>
            <?php
                echo $this->Html->link(
                    'Identificação de Risco',
                    ['controller' => 'IdentificationOfRisks', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>

        <li>
            <?php
                echo $this->Html->link(
                    'NAS',
                    ['controller' => 'NasScores', 'action' => 'add', '_full' => true]
                );
            ?>
        </li>        
      </ul>
    </div>
    <br>
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>Avaliação</th>
                <th>Resultado</th>       
                <th>Data de preenchimento</th>                

<!--                 <th><?= $this->Paginator->sort('fugulin_score', ['label'=>'Fugulin']) ?></th>
                <th><?= $this->Paginator->sort('braden_score', ['label'=>'Braden']) ?></th> -->
                <th class="actions"><?= __('Ações') ?></th>
            </tr>
        </thead>
        <tbody>
        <?php

              foreach ($data_arr as $key => $data_arr_val) {
                foreach ($data_arr_val as  $value) {
                    
                    switch ($value['tipo_tabela']) {
                        case 'fugulin_braden_scales':
                            echo "<tr>";         
                            echo "<td>Fugullin</td>";
                            echo "<td>". $value["fugulin_score"] ."</td>";                              
                            echo "<td>". $value['created']->format("d/m/Y") ."</td>";
                            echo "<td class=\"actions\" style=\"white-space:nowrap\">";                                        
                            echo $this->Html->link(__('Editar'), ['action' => 'edit', $value['id']], ['class'=>'btn btn-primary btn-xs']);
                            if ( $value['is_active'] )
                            {
                                echo  '&nbsp;'. $this->Form->postLink(__('Suspender'), ['controller'=>'FugulinBradenScales', 'action' => 'desactivate', $value['id']], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            else {
                                echo  '&nbsp;'. $this->Form->postLink(__('Ativar'), ['controller'=>'FugulinBradenScales', 'action' => 'activate', $value['id']], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            echo "</td>";     
                            echo "</tr>";
                        break;
                        
                        case 'braden_scales':
                            echo "<tr>";         
                            echo "<td>Braden</td>";
                            echo "<td>". $value["pontuacao"] ."</td>";
                            echo "<td>". $value['created']->format("d/m/Y") ."</td>";                                                        
                            echo "<td class=\"actions\" style=\"white-space:nowrap\">";                                                  
                            echo $this->Html->link(__('Editar'), ['controller'=>'BradenScales', 'action' => 'edit', $value['id']], ['class'=>'btn btn-primary btn-xs']);

                            if ( $value['is_active'] )
                            {
                                echo  '&nbsp;'. $this->Form->postLink(__('Suspender'), ['controller'=>'BradenScales', 'action' => 'desactivate', $value['id']], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            else {
                                echo  '&nbsp;'. $this->Form->postLink(__('Ativar'), ['controller'=>'BradenScales', 'action' => 'activate', $value['id']], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            echo "</td>";     
                            echo "</tr>";
                        break;

                        case 'nas_scores':
                            echo "<tr>";         
                            echo "<td>NAS</td>";
                            echo "<td>". $value["pontuation"] ."</td>";
                            echo "<td>". $value['created']->format("d/m/Y") ."</td>";                                
                            echo "<td class=\"actions\" style=\"white-space:nowrap\">";                                                                              
                            echo $this->Html->link(__('Editar'), ['controller'=>'NasScores', 'action' => 'edit', $value['id']], ['class'=>'btn btn-primary btn-xs']);
                            if ( $value['is_active'] )
                            {
                                echo  '&nbsp;'. $this->Form->postLink(__('Suspender'), ['controller'=>'NasScores', 'action' => 'desactivate', $value['id']], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            else {
                                echo  '&nbsp;'. $this->Form->postLink(__('Ativar'), ['controller'=>'NasScores', 'action' => 'activate', $value['id']], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            echo "</td>";     
                            echo "</tr>";
                        break;

                        case 'skin_integrities':
                            echo "<tr>";         
                            echo "<td>Integridade da pele</td>";
                            echo "<td></td>";
                            echo "<td>". $value['created']->format("d/m/Y") ."</td>";
                            
                            echo "<td class=\"actions\" style=\"white-space:nowrap\">";
                                                  
                            echo $this->Html->link(__('Editar'), ['controller'=>'SkinIntegrities', 'action' => 'edit', $value['id']], ['class'=>'btn btn-primary btn-xs']);
                            if ( $value['is_active'] )
                            {
                                echo  '&nbsp;'. $this->Form->postLink(__('Suspender'), ['controller'=>'SkinIntegrities', 'action' => 'desactivate', $value['id']], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            else {
                                echo  '&nbsp;'. $this->Form->postLink(__('Ativar'), ['controller'=>'SkinIntegrities', 'action' => 'activate', $value['id']], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            echo "</td>";     
                            echo "</tr>";
                        break;

                        case 'identification_of_risks':
                            echo "<tr>";         
                            echo "<td>Identificação de risco</td>";
                            echo "<td>". $value["resultado"] ."</td>";
                            echo "<td>". $value['created']->format("d/m/Y") ."</td>";
                            
                            echo "<td class=\"actions\" style=\"white-space:nowrap\">";
                                                  
                            echo $this->Html->link(__('Editar'), ['controller'=>'IdentificationOfRisks', 'action' => 'edit', $value['id']], ['class'=>'btn btn-primary btn-xs']);

                            // echo '&nbsp;'. $this->Html->link(__('Suspender'), ['controller'=>'IdentificationOfRisks', 'action' => 'delete', $value['id']], ['class'=>'btn btn-primary btn-xs']);

                            if ( $value['is_active'] )
                            {
                                echo  '&nbsp;'. $this->Form->postLink(__('Suspender'), ['controller'=>'IdentificationOfRisks', 'action' => 'desactivate', $value['id']], ['confirm' => __('Tem certeza que deseja suspender o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            else {
                                echo  '&nbsp;'. $this->Form->postLink(__('Ativar'), ['controller'=>'IdentificationOfRisks', 'action' => 'activate', $value['id']], ['confirm' => __('Tem certeza que deseja ativar o registro?'), 'class'=>'btn btn-danger btn-xs bt-wi-75']);
                            }
                            echo "</td>";     
                            echo "</tr>";
                        break;
                    }
                }
            }
        ?>    


        
        </tbody>
    </table>
    <div class="paginator">
        <center>
            <ul class="pagination">
                <?= $this->Paginator->prev('&laquo; ' . __('Anterior'), ['escape'=>false]) ?>
                <?= $this->Paginator->numbers(['escape'=>false]) ?>
                <?= $this->Paginator->next(__('Próxima') . ' &raquo;', ['escape'=>false]) ?>
            </ul>
        </div>
    </center>
</div>
</div>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
    var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>', 
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

    var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link3 =' <?= $this->Html->link('Internações',['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Enfermagem</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>


<?php return; ?>


<?php foreach ($hospitalizations as $hospitalization): ?>

            <?php foreach ($hospitalization['fugulin_braden_scales'] as $fugulin_braden_scales): ?>            
                <tr>                
                    <td>Fugullin</td>
                    <td><?= h($fugulin_braden_scales->created->format('d/m/Y')) ?></td>
                    <td class="actions" style="white-space:nowrap">
                        <?= $this->Html->link(__('Editar'), ['action' => 'edit', $fugulin_braden_scales->id], ['class'=>'btn btn-primary btn-xs']) ?>                 
                    </td>
                </tr>
            <?php endforeach; ?>

            <?php foreach ($hospitalization['braden_scales'] as $braden_scales): ?>            
                <tr>                
                    <td>Braden</td>
                    <td><?= h($braden_scales->created->format('d/m/Y')) ?></td>
                    <td class="actions" style="white-space:nowrap">
                        <?= $this->Html->link(__('Editar'), ['controller'=>'BradenScales', 'action' => 'edit', $braden_scales->id], ['class'=>'btn btn-primary btn-xs']) ?>   
                                 
                    </td>

                </tr>
            <?php endforeach; ?>

            <?php foreach ($hospitalization['nas_scores'] as $nas_scores): ?>            
                <tr>                
                    <td>NAS</td>
                    <td><?= h($nas_scores->created->format('d/m/Y')) ?></td>
                    <td class="actions" style="white-space:nowrap">
                        <?= $this->Html->link(__('Editar'), ['controller'=>'NasScores', 'action' => 'edit', $nas_scores->id], ['class'=>'btn btn-primary btn-xs']) ?>                 
                    </td>
                </tr>
            <?php endforeach; ?>

            <?php foreach ($hospitalization['skin_integrities'] as $skin_integrities): ?>            
                <tr>                
                    <td>Integridade da pele</td>
                    <td><?= h($skin_integrities->created->format('d/m/Y')) ?></td>
                    <td class="actions" style="white-space:nowrap">
                        <?= $this->Html->link(__('Editar'), ['controller'=>'SkinIntegrities', 'action' => 'edit', $skin_integrities->id], ['class'=>'btn btn-primary btn-xs']) ?>                 
                    </td>
                </tr>
            <?php endforeach; ?>

            <?php foreach ($hospitalization['identification_of_risks'] as $identification_of_risks): ?>            
                <tr>                
                    <td>Identificação de riscos</td>
                    <td><?= h($identification_of_risks->created->format('d/m/Y')) ?></td>
                    <td class="actions" style="white-space:nowrap">
                        <?= $this->Html->link(__('Editar'), ['controller'=>'IdentificationOfRisks', 'action' => 'edit', $identification_of_risks->id], ['class'=>'btn btn-primary btn-xs']) ?>                 
                    </td>
                </tr>
            <?php endforeach; ?>

        <?php endforeach; ?>