
<?php
    if ($current_state == 'internacao')    {
        echo $this->element( 'internacao-menu' );
    } else {
        echo $this->element( 'screening-menu' );
    }
    
?>


<div class="component index col-md-9 columns content">
    <?php    
    if ($is_utu){

        echo $this->Html->link('Novo Bundle Diário',
            ['controller' => 'DailyBundles', 'action' => 'add',$bundle_id, 1]
            , array('class' => 'link-bt'));           
    }else{
        echo $this->Html->link('Novo Bundle Diário',
            ['controller' => 'DailyBundles', 'action' => 'add', $bundle_id]
            , array('class' => 'link-bt')); 
    }
    ?>

    <div class="content_table">
        <table class="table_1">
             <tr class="color_tr">
                <th style="color:#000;">Item</th>                
            </tr>
            <tbody> 
                <?php if($is_utu) : ?>
                    <tr>
                        <th>Higienização diária com solução dergermante da genitália</th>                
                    </tr>
                                
                    <tr>
                        <th>Manter a bolsa coletora abaixo do nível da bexiga</th>                    
                    </tr>

                    <tr>
                        <th>Manter a bolsa coletora com a capacidade máxima de 2/3 de urina</th>                    
                    </tr>

                    <tr>
                        <th>Fixação do cateter seguro para evitar qualquer movimento e tração</th>                    
                    </tr>

                    <tr>
                        <th>Revisão diária da indicação de permanência do cateter</th>                    
                    </tr>

                    <tr>
                        <th>Sinal de uretrite</th>                    
                    </tr>

                    <tr>
                        <th>Transporte realizado com clampeamento do sistema coletor</th>                    
                    </tr>

                <?php else : ?>
                    <tr>
                    <th>Curativo diário com técnica asséptica</th>                
                    </tr>
                                
                    <tr>
                        <th>Presença de sangue no curativo</th>                    
                    </tr>

                    <tr>
                        <th>Presença de secreção no curativo</th>                    
                    </tr>

                    <tr>
                        <th>Cateter devidamente fixado na pele</th>                    
                    </tr>

                    <tr>
                        <th>Conector exposto</th>                    
                    </tr>

                    <tr>
                        <th>Via de catéter sem utilização</th>                    
                    </tr>

                    <tr>
                        <th>Administração de conteúdo lipidico em via exclusiva</th>                    
                    </tr>

                    <tr>
                        <th>Avaliado a retirada do cateter</th>                    
                    </tr>
                <?php endif; ?>           
                
            
            </tbody>
        </table>

        <!-- <table class="overflow-y"> -->
        <table class="table_2">
            <thead>
                <?php
                    $curativo = '';
                    $presenca_sangue ='';
                    $presenca_secrecao ='';
                    $cateter_devidamente='';
                    $conector_exposto='';
                    $via_cateter='';
                    $administracao='';
                    $avaliado_a_retirada='';

                    foreach ($dailyBundles as $dailyBundle){
                        if ($dailyBundle->curativo){
                            $curativo .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $curativo .='<td></td>';
                        }

                        if ($dailyBundle->presenca_sangue){
                            $presenca_sangue .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $presenca_sangue .='<td></td>';
                        }

                        if ($dailyBundle->presenca_secrecao){
                            $presenca_secrecao .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $presenca_secrecao .='<td></td>';
                        }

                        if ($dailyBundle->cateter_devidamente){
                            $cateter_devidamente .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $cateter_devidamente .='<td></td>';
                        }

                        if ($dailyBundle->conector_exposto){
                            $conector_exposto .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $conector_exposto .='<td></td>';
                        }

                        if ($dailyBundle->via_cateter){
                            $via_cateter .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $via_cateter .='<td></td>';
                        }

                        if ($dailyBundle->administracao){
                            $administracao .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $administracao .='<td></td>';
                        }

                        if ($dailyBundle->avaliado_a_retirada){
                            $avaliado_a_retirada .='<td> <i class="fa fa-check" aria-hidden="true"></i></td>';
                        } else {
                            $avaliado_a_retirada .='<td></td>';
                        }

                        echo '<th>'. $dailyBundle->created->format('d/m/y') . '</th>';
                    }
                ?>            
                <!--  <tr>
                    <th>Population</th><th>Alpha</th><th>Beta</th><th>Gamma</th><th>Delta</th><th>Epsilon</th><th>Zeta</th><th>Eta</th><th>Theta</th><th>Iota</th><th>Kappa</th><th>Lambda</th><th>Mu</th><th>Nu</th><th>Xi</th><th>Omicron</th><th>Pi</th><th>Rho</th><th>Sigma</th><th>Tau</th><th>Upsilon</th>
                </tr> -->
            </thead>
            <tbody> 

            <?php if($is_utu) : ?>
                    <tr>
                        <?= $curativo ?>                                
                    </tr>
                                
                    <tr>
                        <?= $presenca_sangue ?>
                    </tr>

                    <tr>
                        <?= $presenca_secrecao ?>
                    </tr>

                    <tr>
                        <?= $cateter_devidamente ?>
                    </tr>

                    <tr>
                        <?= $conector_exposto ?>
                    </tr>

                    <tr>
                        <?= $via_cateter ?>
                    </tr>

                    <tr>
                        <?= $administracao ?>
                    </tr>

                <?php else : ?>
                    <tr>
                        <?= $curativo ?>                                
                    </tr>
                 
                    <tr>
                        <?= $presenca_sangue ?>
                    </tr>

                    <tr>
                        <?= $presenca_secrecao ?>
                    </tr>

                    <tr>
                        <?= $cateter_devidamente ?>
                    </tr>

                    <tr>
                        <?= $conector_exposto ?>
                    </tr>

                    <tr>
                        <?= $via_cateter ?>
                    </tr>

                    <tr>
                        <?= $administracao ?>
                    </tr>

                    <tr>
                        <?= $avaliado_a_retirada ?>
                    </tr>
                <?php endif; ?>              
            </tbody>
        </table>
    </div>
</div>

<?php
$pageName = 'Bundle de Cateter Vascular';
    if ($is_utu){
        $pageName = 'Bundle de Passagem de CVD e Prevenção de ITU por Cateter';
    }
?>

<?php if($current_state == "internacao") : ?>

<script >
(function() {
   // your page initialization code here
   // the DOM will be available here
    var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>', 
        array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

    var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var link3 =' <?= $this->Html->link('Internações',['controller' => 'Hospitalizations', 'action' => 'index', $hospitalization_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    
    var link4 =' <?php echo $this->Html->link($pageName,['controller' => 'Bundles', 'action' => 'edit', $bundle_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

    var html = '';
        html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
        html+= link1;
        html+= link2;
        html+= link3;
        html+= link4;
        html+= '<a href="#" class="breadcumb-active btn btn-default">Bundle Diário</a>';        
        html+= '</div>';
            document.getElementById("breadcumb").innerHTML =html;
})();
</script>

<?php else : ?>
    <script >
        (function() {
           // your page initialization code here
           // the DOM will be available here
            var link1 =' <?= $this->Html->link('<i class="glyphicon glyphicon-home"></i>', 
                array('controller' => 'Users', 'action' => 'login'), array('class'=>'btn btn-default ', 'escape' => false)) ?> ';

            var link2 =' <?= $this->Html->link('Pacientes',['controller' => 'Patients', 'action' => 'index', '_full' => true], ['class'=>'btn btn-default ']); ?> ';

            var link3 =' <?= $this->Html->link('Triagem',['controller' => 'Screenings', 'action' => 'index', $screening_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

            
            var link4 =' <?php echo $this->Html->link($pageName,['controller' => 'Bundles', 'action' => 'edit', $bundle_id, '_full' => true], ['class'=>'btn btn-default ']); ?> ';

            var html = '';
                html+= '<div class="btn-group btn-breadcrumb custom-breadcumb">';
                html+= link1;
                html+= link2;
                html+= link3;
                html+= link4;
                html+= '<a href="#" class="breadcumb-active btn btn-default">Bundle Diário</a>';        
                html+= '</div>';
                    document.getElementById("breadcumb").innerHTML =html;
        })();
    </script>
<?php endif; ?>