<?php
namespace App\Model\Table;

use App\Model\Entity\SurgicalTevProtocol;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SurgicalTevProtocols Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $Contraindications
 * @property \Cake\ORM\Association\BelongsToMany $TevOptions
 */
class SurgicalTevProtocolsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgical_tev_protocols');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType' => 'INNER'
        ]);
        $this->belongsToMany('Contraindications', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'targetForeignKey' => 'contraindication_id',
            'joinTable' => 'surgical_tev_protocols_contraindications'
        ]);
        $this->belongsToMany('TevOptions', [
            'foreignKey' => 'surgical_tev_protocol_id',
            'targetForeignKey' => 'tev_option_id',
            'joinTable' => 'surgical_tev_protocols_tev_options'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->boolean('is_active')
            ->allowEmpty('is_active');

        $validator
            ->allowEmpty('risco_da_cirurgica');

        $validator
            ->allowEmpty('duracao_da_cirurgia');

        $validator
            ->boolean('fatores_de_risco_tev')
            ->allowEmpty('fatores_de_risco_tev');

        $validator
            ->allowEmpty('risco_alto_opcoes');

        $validator
            ->allowEmpty('justificativa_medica');

        $validator
            ->boolean('medicacao')
            ->allowEmpty('medicacao');

        $validator
            ->boolean('risco_alto')
            ->allowEmpty('risco_alto');

        $validator
            ->boolean('risco_intermediario')
            ->allowEmpty('risco_intermediario');

        $validator
            ->boolean('meias_elasticas')
            ->allowEmpty('meias_elasticas');

        $validator
            ->boolean('compressao_pneumatica')
            ->allowEmpty('compressao_pneumatica');

        $validator
            ->boolean('fisioterapia_motora')
            ->allowEmpty('fisioterapia_motora');

        $validator
            ->boolean('sangramento_ativo')
            ->allowEmpty('sangramento_ativo');

        $validator
            ->boolean('ulcera_peptica')
            ->allowEmpty('ulcera_peptica');

        $validator
            ->boolean('has_nao_controlada')
            ->allowEmpty('has_nao_controlada');

        $validator
            ->boolean('cagulopatia')
            ->allowEmpty('cagulopatia');

        $validator
            ->boolean('alergia_ou_plaquetopenia')
            ->allowEmpty('alergia_ou_plaquetopenia');

        $validator
            ->boolean('insuficiencia_renal')
            ->allowEmpty('insuficiencia_renal');

        $validator
            ->boolean('coleta_de_lcr')
            ->allowEmpty('coleta_de_lcr');

        $validator
            ->boolean('raquinaelose')
            ->allowEmpty('raquinaelose');

        $validator
            ->boolean('paciente_em_anticuagulante')
            ->allowEmpty('paciente_em_anticuagulante');

        $validator
            ->boolean('artopressia_quadril')
            ->allowEmpty('artopressia_quadril');

        $validator
            ->boolean('artopressa_joelho')
            ->allowEmpty('artopressa_joelho');

        $validator
            ->boolean('trauma_requimedular')
            ->allowEmpty('trauma_requimedular');

        $validator
            ->boolean('fratura_de_quadril')
            ->allowEmpty('fratura_de_quadril');

        $validator
            ->boolean('oncologia_curativa')
            ->allowEmpty('oncologia_curativa');

        $validator
            ->boolean('poltrauma')
            ->allowEmpty('poltrauma');

        $validator
            ->boolean('endoscopia')
            ->allowEmpty('endoscopia');

        $validator
            ->boolean('resseccao')
            ->allowEmpty('resseccao');

        $validator
            ->boolean('laparoscopica')
            ->allowEmpty('laparoscopica');

        $validator
            ->boolean('superficial')
            ->allowEmpty('superficial');

        $validator
            ->boolean('oftamologica')
            ->allowEmpty('oftamologica');

        $validator
            ->boolean('otominrigologica')
            ->allowEmpty('otominrigologica');

        $validator
            ->allowEmpty('outras');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
