<?php
namespace App\Model\Table;

use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Surgeries Model
 *
 * @property \Cake\ORM\Association\BelongsTo $Hospitalizations
 * @property \Cake\ORM\Association\BelongsToMany $Professionals
 * @property \Cake\ORM\Association\BelongsToMany $Specialties
 * @property \Cake\ORM\Association\BelongsToMany $SurgicalComplications
 * @property \Cake\ORM\Association\BelongsToMany $SurgicalMaterials
 * @property \Cake\ORM\Association\BelongsToMany $TypeOfAnesthesias
 */
class SurgeriesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('surgeries');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Hospitalizations', [
            'foreignKey' => 'hospitalization_id',
            'joinType'   => 'INNER',
        ]);
        $this->belongsTo('Rooms', [
            'foreignKey' => 'room_id',
            'joinType'   => 'LEFT',
        ]);
        $this->belongsToMany('Professionals', [
            'foreignKey'       => 'surgery_id',
            'targetForeignKey' => 'professional_id',
            'joinTable'        => 'professionals_surgeries',
        ]);
        $this->belongsToMany('Specialties', [
            'foreignKey'       => 'surgery_id',
            'targetForeignKey' => 'specialty_id',
            'joinTable'        => 'specialties_surgeries',
        ]);
        $this->belongsToMany('SurgicalComplications', [
            'foreignKey'       => 'surgery_id',
            'targetForeignKey' => 'surgical_complication_id',
            'joinTable'        => 'surgeries_surgical_complications',
        ]);
        $this->belongsToMany('SurgicalMaterials', [
            'foreignKey'       => 'surgery_id',
            'targetForeignKey' => 'surgical_material_id',
            'joinTable'        => 'surgical_materials_surgeries',
        ]);
        $this->belongsToMany('TypeOfAnesthesias', [
            'foreignKey'       => 'surgery_id',
            'targetForeignKey' => 'type_of_anesthesia_id',
            'joinTable'        => 'type_of_anesthesias_surgeries',
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->allowEmpty('nome');

        $validator
            ->allowEmpty('especialidade');

        $validator
            ->boolean('outra_especialidade_cirurgica_em_apoio')
            ->allowEmpty('outra_especialidade_cirurgica_em_apoio');

        $validator
            ->allowEmpty('especialidade_cirurgica_auxiliar');

        $validator
            ->allowEmpty('porte_da_cirurgia');

        $validator
            ->allowEmpty('caracteristica_da_cirurgia');

        $validator
            ->allowEmpty('cirurgia_contaminada');

        $validator
            ->boolean('anestesia_adequada_foi_confirmada')
            ->allowEmpty('anestesia_adequada_foi_confirmada');

        $validator
        //->date('data_da_solicitacao')
        ->allowEmpty('data_da_solicitacao');

        $validator
        //->date('data_da_cirurgia')
        ->allowEmpty('data_da_cirurgia');

        $validator
        //->date('data_da_liberacao')
        ->allowEmpty('data_da_liberacao');

        $validator
            ->time('tempo_de_cirurgia_estimado')
            ->allowEmpty('tempo_de_cirurgia_estimado');

        $validator
            ->time('hora_da_cirurgia')
            ->allowEmpty('hora_da_cirurgia');

        $validator
            ->boolean('internacao_previa_a_cirurgia')
            ->allowEmpty('internacao_previa_a_cirurgia');

        $validator
            ->boolean('deseja_reservar_leito')
            ->allowEmpty('deseja_reservar_leito');

        $validator
            ->integer('total_dias_do_leito_reservado')
            ->allowEmpty('total_dias_do_leito_reservado');

        $validator
            ->boolean('pos_operatorio_em_uti')
            ->allowEmpty('pos_operatorio_em_uti');

        $validator
            ->boolean('conversao_da_caracteristica_da_cirurgia')
            ->allowEmpty('conversao_da_caracteristica_da_cirurgia');

        $validator
            ->allowEmpty('conversao_para');

        $validator
            ->boolean('adiar_cirurgia')
            ->allowEmpty('adiar_cirurgia');

        $validator
        //->date('aidar_cirurgia_para_data')
        ->allowEmpty('aidar_cirurgia_para_data');

        $validator
            ->time('aidar_cirurgia_para_hora')
            ->allowEmpty('aidar_cirurgia_para_hora');

        $validator
            ->allowEmpty('adiar_cirurgia_motivo');

        $validator
            ->boolean('suspender_cirurgia')
            ->allowEmpty('suspender_cirurgia');

        $validator
        //->date('suspender_cirurgia_para_data')
        ->allowEmpty('suspender_cirurgia_para_data');

        $validator
            ->time('suspender_cirurgia_para_hora')
            ->allowEmpty('suspender_cirurgia_para_hora');

        $validator
            ->allowEmpty('suspender_cirurgia_motiv');

        $validator
            ->boolean('cancelar_cirurgia')
            ->allowEmpty('cancelar_cirurgia');

        $validator
            ->allowEmpty('cancelar_cirurgia_motivo');

        $validator
            ->boolean('visita_pre_anestesica')
            ->allowEmpty('visita_pre_anestesica');

        $validator
        //->date('visita_pre_anestesica_data')
        ->allowEmpty('visita_pre_anestesica_data');

        $validator
            ->time('visita_pre_anestesica_hora')
            ->allowEmpty('visita_pre_anestesica_hora');

        $validator
            ->boolean('entrada_na_sala_cirurgica')
            ->allowEmpty('entrada_na_sala_cirurgica');

        $validator
        //->date('entrada_na_sala_cirurgica_data')
        ->allowEmpty('entrada_na_sala_cirurgica_data');

        $validator
            ->time('entrada_na_sala_cirurgica_hora')
            ->allowEmpty('entrada_na_sala_cirurgica_hora');

        $validator
            ->boolean('realizado_antibiotico_profilaxia')
            ->allowEmpty('realizado_antibiotico_profilaxia');

        $validator
        //->date('realizado_antibiotico_profilaxia_data')
        ->allowEmpty('realizado_antibiotico_profilaxia_data');

        $validator
            ->time('realizado_antibiotico_profilaxia_hora')
            ->allowEmpty('realizado_antibiotico_profilaxia_hora');

        $validator
            ->time('inicio_da_anestesia_hora')
            ->allowEmpty('inicio_da_anestesia_hora');

        $validator
            ->time('termino_da_anestesia_hora')
            ->allowEmpty('termino_da_anestesia_hora');

        $validator
            ->time('inicio_da_cirurgia_hora')
            ->allowEmpty('inicio_da_cirurgia_hora');

        $validator
            ->time('termino_da_cirurgia_hora')
            ->allowEmpty('termino_da_cirurgia_hora');

        $validator
            ->boolean('houve_mudanca_na_cirurgia')
            ->allowEmpty('houve_mudanca_na_cirurgia');

        $validator
            ->allowEmpty('mudanca_na_cirurgia');

        $validator
            ->boolean('houve_mudanca_na_anestesia')
            ->allowEmpty('houve_mudanca_na_anestesia');

        $validator
            ->allowEmpty('mudanca_na_anestesia');

        $validator
            ->allowEmpty('houve_complicacao_durante_cirurgia');

        $validator
            ->boolean('uso_de_compressa_cirurgica')
            ->allowEmpty('uso_de_compressa_cirurgica');

        $validator
            ->integer('total_de_compressa_cirurgica_usada')
            ->allowEmpty('total_de_compressa_cirurgica_usada');

        $validator
            ->boolean('uso_de_pinca_extra')
            ->allowEmpty('uso_de_pinca_extra');

        $validator
            ->integer('total_de_pinca_extra_usada')
            ->allowEmpty('total_de_pinca_extra_usada');

        $validator
            ->boolean('uso_de_caixa_extra')
            ->allowEmpty('uso_de_caixa_extra');

        $validator
            ->integer('total_de_caixa_extra')
            ->allowEmpty('total_de_caixa_extra');

        $validator
            ->boolean('encaminhado_para_setor_de_destino_programado')
            ->allowEmpty('encaminhado_para_setor_de_destino_programado');

        $validator
            ->allowEmpty('setor_nao_programado');

        $validator
            ->allowEmpty('encaminhado_para_setor_nao_programado_motivo');

        $validator
            ->boolean('houve_reabordagem_cirurgica')
            ->allowEmpty('houve_reabordagem_cirurgica');

        $validator
            ->allowEmpty('reabordagem_programada');

        $validator
            ->boolean('retirada_de_ortese_ou_protese')
            ->allowEmpty('retirada_de_ortese_ou_protese');

        $validator
            ->allowEmpty('retirada_de_ortese_ou_protese_motivo');

        $validator
        //->date('data_da_instalacao_ortese_ou_protese')
        ->allowEmpty('data_da_instalacao_ortese_ou_protese');

        $validator
            ->allowEmpty('status');

        $validator
            ->boolean('risco_cirurgico')
            ->allowEmpty('risco_cirurgico');

        $validator
        //->date('data_risco_cirurgico')
        ->allowEmpty('data_risco_cirurgico');

        $validator
            ->allowEmpty('complicacao_durante_cirurgia');

        $validator
            ->time('hora_encaminhamento_rpa')
            ->allowEmpty('hora_encaminhamento_rpa');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->existsIn(['hospitalization_id'], 'Hospitalizations'));
        return $rules;
    }
}
