<?php
namespace App\Model\Table;

use App\Model\Entity\PainCharacteristic;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PainCharacteristics Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Screenings
 */
class PainCharacteristicsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('pain_characteristics');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('Screenings', [
            'foreignKey' => 'pain_characteristic_id',
            'targetForeignKey' => 'screening_id',
            'joinTable' => 'pain_characteristics_screenings'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
