<?php
namespace App\Model\Table;

use App\Model\Entity\ListAntibiotic;
use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ListAntibiotics Model
 *
 * @property \Cake\ORM\Association\BelongsToMany $Cultures
 */
class ListAntibioticsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->table('list_antibiotics');
        $this->displayField('id');
        $this->primaryKey('id');

        $this->belongsToMany('Cultures', [
            'foreignKey' => 'list_antibiotic_id',
            'targetForeignKey' => 'culture_id',
            'joinTable' => 'list_antibiotics_cultures'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
